/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.bulk;

import com.jumpmind.symmetric.console.impl.hh;
import com.jumpmind.symmetric.db.bulk.d;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.AbstractSymmetricEngine;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.AbstractBulkDatabaseWriter;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class f
extends AbstractBulkDatabaseWriter {
    private static final Logger m = LoggerFactory.getLogger((String)new hh(new long[]{-6138172944693368749L, -2561771138655566338L, 545828147914690323L, 8595184721616749612L, -5489411134031859128L, 7832358817224421127L, 4752037057984546892L}).toString());
    protected IStagingManager a;
    protected IStagedResource b;
    protected IStagedResource c;
    protected int d = 0;
    protected boolean e;
    protected boolean f;
    protected Table g;
    protected Table h;
    protected List<String> i;
    protected d j;
    protected boolean k;
    protected boolean l;

    public f(IDatabasePlatform symmetricPlatform, IDatabasePlatform platform, String tablePrefix, IStagingManager stagingManager, List<IDatabaseWriterFilter> filters, int maxRowsBeforeFlush, DatabaseWriterSettings writerSettings, boolean useSourceStaging) {
        super(symmetricPlatform, platform, tablePrefix, writerSettings);
        this.a = stagingManager;
        this.writerSettings.setDatabaseWriterFilters(filters);
        this.k = useSourceStaging;
    }

    public void start(Batch batch) {
        ISymmetricEngine sourceEngine;
        super.start(batch);
        this.l = false;
        if (this.k && batch.isBulkLoaderFlag() && (sourceEngine = AbstractSymmetricEngine.findEngineByNodeId((String)batch.getSourceNodeId())) != null && (sourceEngine.getParameterService().is("mssql.bulk.extract.use.bcp") && sourceEngine.getSymmetricDialect().getTargetPlatform().getName().startsWith("mssql") || sourceEngine.getParameterService().is("ase.bulk.extract.use.bcp") && sourceEngine.getSymmetricDialect().getTargetPlatform().getName().startsWith("ase"))) {
            m.debug("Found source engine for node {}", (Object)batch.getSourceNodeId());
            Batch outgoingBatch = new Batch(Batch.BatchType.EXTRACT, batch.getBatchId(), batch.getChannelId(), batch.getBinaryEncoding(), batch.getSourceNodeId(), batch.getTargetNodeId(), batch.isCommon());
            String name = StringUtils.leftPad((String)String.valueOf(batch.getBatchId()), (int)10, (String)"0");
            this.b = sourceEngine.getStagingManager().find(new Object[]{"bulkextract", outgoingBatch.getStagedLocation(), name + ".dat"});
            if (this.b != null) {
                this.l = true;
                m.debug("Using source engine staging files");
            } else {
                m.debug("Using target engine staging files");
            }
        }
    }

    public boolean start(Table table) {
        this.g = table;
        if (super.start(table) && this.targetTable != null) {
            this.e = false;
            if (this.batch.getBinaryEncoding() != BinaryEncoding.NONE) {
                for (Column column : this.targetTable.getColumns()) {
                    if (!column.isOfBinaryType()) continue;
                    this.e = true;
                    break;
                }
            }
            if (this.sourceTable != null) {
                this.h = this.getPlatform(table).getTableFromCache(this.sourceTable.getCatalog(), this.sourceTable.getSchema(), this.sourceTable.getName(), false);
                String[] csvNames = this.sourceTable.getColumnNames();
                String[] columnNames = this.h.getColumnNames();
                boolean bl2 = this.f = this.sourceTable.getColumnCount() != this.h.getColumnCount();
                if (!this.f) {
                    for (int i2 = 0; i2 < csvNames.length; ++i2) {
                        if (csvNames[i2].equals(columnNames[i2])) continue;
                        this.f = true;
                        break;
                    }
                }
                if (this.f) {
                    String[] sourceColumnNames = this.sourceTable.getColumnNames();
                    List<String> targetColumnNames = Arrays.asList(this.h.getColumnNames());
                    this.i = new ArrayList<String>();
                    for (String columnName : sourceColumnNames) {
                        if (!targetColumnNames.stream().anyMatch(name -> name.equalsIgnoreCase(columnName))) continue;
                        this.i.add(columnName);
                    }
                }
            }
            if (this.b == null && this.batch.isBulkLoaderFlag()) {
                this.b = this.a.create(new Object[]{"bulkloaddir", StringUtils.leftPad((String)(this.getBatch().getBatchId() + ".dat"), (int)14, (String)"0")});
            }
            return true;
        }
        return false;
    }

    public void end(Table table) {
        try {
            this.a();
        }
        finally {
            super.end(table);
        }
    }

    protected void bulkWrite(CsvData data) {
        if (this.filterBefore(data)) {
            DataEventType dataEventType = data.getDataEventType();
            switch (dataEventType) {
                case INSERT: {
                    if (this.b == null) {
                        this.b = this.a.create(new Object[]{"bulkloaddir", StringUtils.leftPad((String)(this.getBatch().getBatchId() + ".dat"), (int)14, (String)"0")});
                    }
                    ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
                    try {
                        OutputStream out = this.b.getOutputStream();
                        if (this.f) {
                            Map mapData = data.toColumnNameValuePairs(this.sourceTable.getColumnNames(), "rowData");
                            for (int i2 = 0; i2 < this.i.size(); ++i2) {
                                String columnName = this.i.get(i2);
                                this.a((String)mapData.get(columnName), out, this.h.getColumnWithName(columnName), i2 + 1 < this.i.size());
                            }
                        } else {
                            String[] parsedData = data.getParsedData("rowData");
                            Column[] columns = this.targetTable.getColumns();
                            for (int i3 = 0; i3 < columns.length; ++i3) {
                                this.a(parsedData[i3], out, columns[i3], i3 + 1 < parsedData.length);
                            }
                        }
                        out.write(this.j.b().getBytes(Charset.defaultCharset()));
                        ++this.d;
                        break;
                    }
                    catch (Exception ex2) {
                        throw this.getPlatform().getSqlTemplate().translate((Throwable)ex2);
                    }
                    finally {
                        ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
                        ((Statistics)this.statistics.get(this.batch)).increment("STATEMENTCOUNT");
                        ((Statistics)this.statistics.get(this.batch)).increment("LINENUMBER");
                    }
                }
                default: {
                    this.a();
                    this.writeDefault(data);
                }
            }
            this.filterAfter(data);
        }
    }

    protected void a(String data, OutputStream out, Column column, boolean writeFieldTerminator) throws IOException {
        if (data != null) {
            if (data.equals("")) {
                out.write("\u0000".getBytes(Charset.defaultCharset()));
            } else if (this.e && column.isOfBinaryType()) {
                if (this.batch.getBinaryEncoding() == BinaryEncoding.BASE64) {
                    out.write(new String(Hex.encodeHex((byte[])Base64.decodeBase64((byte[])data.getBytes(Charset.defaultCharset())))).getBytes(Charset.defaultCharset()));
                } else if (this.batch.getBinaryEncoding() == BinaryEncoding.HEX) {
                    out.write(data.getBytes(Charset.defaultCharset()));
                }
            } else if (column.getMappedTypeCode() == 93 || column.getMappedTypeCode() == 92) {
                int index = data.indexOf(".");
                if (index != -1 && data.length() - index - 1 > column.getSizeAsInt()) {
                    data = data.substring(0, index + 1 + column.getSizeAsInt());
                }
                out.write(data.getBytes(Charset.defaultCharset()));
            } else {
                out.write(data.getBytes(Charset.defaultCharset()));
            }
        }
        if (writeFieldTerminator) {
            out.write(this.j.c().getBytes(Charset.defaultCharset()));
        }
    }

    protected void a() {
        if (this.d > 0 || this.l) {
            try {
                ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
                if (!this.l) {
                    this.b.close();
                }
                this.c = this.a.create(new Object[]{"bulkloaddir", StringUtils.leftPad((String)(this.batch.getBatchId() + ".fmt"), (int)14, (String)"0")});
                m.info("About to bulk copy table {} from {}", (Object)this.targetTable.getFullyQualifiedTableName(), (Object)this.b.getFile().getPath());
                this.j.a(this.b, this.c, this.targetTable, this.h);
                this.b();
            }
            finally {
                this.d = 0;
                long count = this.batch.getStatistics().get("DATA_ROW_COUNT");
                ((Statistics)this.statistics.get(this.batch)).set("STATEMENTCOUNT", count);
                ((Statistics)this.statistics.get(this.batch)).set("LINENUMBER", count);
                ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
            }
        } else {
            this.b();
        }
    }

    protected void b() {
        if (!this.writerSettings.isKeepBulkStagingFiles()) {
            if (this.b != null) {
                this.b.delete();
                this.b = null;
            }
            if (this.c != null) {
                this.c.delete();
                this.c = null;
            }
        }
    }
}

