/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.bulk;

import com.jumpmind.symmetric.db.bulk.v;
import java.util.List;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterErrorHandler;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.io.data.writer.ResolvedData;
import org.jumpmind.symmetric.io.data.writer.TransformWriter;
import org.jumpmind.symmetric.load.DefaultDataLoaderFactory;
import org.jumpmind.symmetric.model.Channel;

public class PostgresBulkDataLoaderFactory
extends DefaultDataLoaderFactory {
    public PostgresBulkDataLoaderFactory(ISymmetricEngine engine) {
        super(engine);
    }

    public String getTypeName() {
        return "postgres_bulk";
    }

    public IDataWriter getDataWriter(String sourceNodeId, Channel channel, ISymmetricDialect symmetricDialect, TransformWriter transformWriter, List<IDatabaseWriterFilter> filters, List<IDatabaseWriterErrorHandler> errorHandlers, List<? extends Conflict> conflictSettings, List<ResolvedData> resolvedData) {
        boolean binaryCopyModeEnabled = Boolean.parseBoolean(this.parameterService.getString("postgres.bulk.copy.binary", "false"));
        return new v(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), symmetricDialect.getTablePrefix(), this.buildDatabaseWriterSettings(filters, errorHandlers, conflictSettings, resolvedData), channel.getMaxBatchSize(), filters, binaryCopyModeEnabled);
    }

    public boolean isPlatformSupported(IDatabasePlatform platform) {
        return "postgres".equals(platform.getName()) || "postgres95".equals(platform.getName()) || "greenplum".equals(platform.getName());
    }
}

