/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.bulk;

import com.jumpmind.symmetric.db.bulk.i;
import java.util.List;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterErrorHandler;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.io.data.writer.ResolvedData;
import org.jumpmind.symmetric.io.data.writer.TransformWriter;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.symmetric.load.AbstractDataLoaderFactory;
import org.jumpmind.symmetric.load.IDataLoaderFactory;
import org.jumpmind.symmetric.model.Channel;

public class ExasolBulkDataLoaderFactory
extends AbstractDataLoaderFactory
implements IDataLoaderFactory {
    private IStagingManager stagingManager;

    public ExasolBulkDataLoaderFactory(ISymmetricEngine engine) {
        this.stagingManager = engine.getStagingManager();
        this.parameterService = engine.getParameterService();
    }

    public String getTypeName() {
        return "exasol_bulk";
    }

    public IDataWriter getDataWriter(String sourceNodeId, Channel channel, ISymmetricDialect symmetricDialect, TransformWriter transformWriter, List<IDatabaseWriterFilter> filters, List<IDatabaseWriterErrorHandler> errorHandlers, List<? extends Conflict> conflictSettings, List<ResolvedData> resolvedData) {
        long maxBytesBeforeFlush = this.parameterService.getLong("bulk.load.max.bytes.before.flush", 1000000000L);
        return new i(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), symmetricDialect.getTablePrefix(), this.stagingManager, channel.getMaxBatchSize(), maxBytesBeforeFlush, this.buildParameterDatabaseWriterSettings(conflictSettings), filters);
    }

    public boolean isPlatformSupported(IDatabasePlatform platform) {
        return "exasol".equals(platform.getName());
    }
}

