/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.graph;

import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang3.time.DateUtils;
import org.jumpmind.symmetric.statistic.HostStats;
import org.vaadin.addons.chartjs.ChartJs;
import org.vaadin.addons.chartjs.config.ChartConfig;
import org.vaadin.addons.chartjs.config.LineChartConfig;
import org.vaadin.addons.chartjs.data.Dataset;
import org.vaadin.addons.chartjs.data.LineDataset;
import org.vaadin.addons.chartjs.options.InteractionMode;
import org.vaadin.addons.chartjs.options.Position;
import org.vaadin.addons.chartjs.options.Tooltips;
import org.vaadin.addons.chartjs.options.scale.Axis;
import org.vaadin.addons.chartjs.options.scale.CategoryScale;
import org.vaadin.addons.chartjs.options.scale.LinearScale;
import org.vaadin.addons.chartjs.options.types.LineChartOptions;

public class HostStatsGraph
extends HorizontalLayout {
    private static final long g = 1L;
    protected I a;
    protected ChartJs b;
    protected LineChartConfig c;
    protected List<String> d = new ArrayList<String>();
    protected int e = 60;
    protected String f;

    public HostStatsGraph(I controller) {
        this.a = controller;
        this.setSizeFull();
        this.c = new LineChartConfig();
        this.c.data().labelsAsList(this.d);
        ((LineChartOptions)((LineChartOptions)((LineChartOptions)((LineChartOptions)((LineChartOptions)((Tooltips)((LineChartOptions)this.c.options().animation().duration(0).and()).tooltips().mode(InteractionMode.NEAREST).callbacks().label("tooltipItem.yLabel").and()).and()).hover().mode(InteractionMode.DATASET).and()).legend().display(false).and()).scales().add(Axis.X, ((CategoryScale)((CategoryScale)new CategoryScale().display(true).ticks().fontSize(9).and()).scaleLabel().display(false).and()).position(Position.BOTTOM)).add(Axis.Y, ((LinearScale)((LinearScale)new LinearScale().display(true).scaleLabel().display(false).and()).ticks().beginAtZero(true).fontSize(9).and()).position(Position.LEFT)).and()).maintainAspectRatio(false)).done();
        this.b = new ChartJs((ChartConfig)this.c);
        this.b.setSizeFull();
        this.b.getElement().getStyle().set("margin-left", "15px");
        this.addAndExpand(new Component[]{this.b});
    }

    public void refresh(TreeMap<Date, HostStats> orderedMap) {
        LineDataset dataset = new LineDataset();
        dataset.lineTension(0.0);
        dataset.pointRadius(new Integer[]{0});
        dataset.borderColor("#1676F3");
        dataset.backgroundColor("#1676F3");
        dataset.fill(true);
        dataset.borderWidth(1);
        if (orderedMap != null) {
            for (Date time : orderedMap.keySet()) {
                HostStats stats = orderedMap.get(time);
                dataset.addData(Double.valueOf(this.a(stats)));
                if (this.d.size() >= orderedMap.size()) continue;
                this.d.add(as.formatDate(this.a, time, true));
            }
            HostStats stats = this.a.getSymmetricEngine().getStatisticManager().getWorkingHostStats();
            dataset.addData(Double.valueOf(this.a(stats)));
            if (this.d.size() <= orderedMap.size()) {
                this.d.add(as.formatDate(this.a, new Date(), true));
            }
        } else {
            Date end = new Date();
            Calendar startCal = Calendar.getInstance();
            startCal.add(12, -this.e);
            startCal.set(13, 0);
            startCal.set(14, 0);
            startCal.set(12, this.a(startCal.get(12)));
            int interval = this.e / 120 * 5;
            interval = interval < 5 ? 5 : interval;
            Date periodStart = startCal.getTime();
            while (periodStart.before(end)) {
                dataset.addData(Integer.valueOf(0));
                this.d.add(as.formatDate(this.a, periodStart, true));
                periodStart = DateUtils.addMinutes((Date)periodStart, (int)interval);
            }
        }
        this.c.data().clear();
        this.c.data().addDataset((Dataset)dataset);
        this.b.update();
    }

    protected int a(int value) {
        return 5 * new BigDecimal((double)value / 5.0).setScale(2, RoundingMode.HALF_DOWN).intValue();
    }

    protected double a(HostStats stats) {
        if (stats != null && this.f != null) {
            switch (this.f) {
                case "Nodes Pushed": {
                    return stats.getNodesPushed();
                }
                case "Total Nodes Push Time": {
                    return stats.getTotalNodesPushTime();
                }
                case "Nodes Pulled": {
                    return stats.getNodesPulled();
                }
                case "Total Nodes Pull Time": {
                    return stats.getTotalNodesPullTime();
                }
                case "Outgoing Batch Rows Purged": {
                    return stats.getPurgedBatchOutgoingRows();
                }
                case "Incoming Batch Rows Purged": {
                    return stats.getPurgedBatchIncomingRows();
                }
                case "Table Capture Created": {
                    return stats.getTriggersCreatedCount();
                }
                case "Table Capture Rebuilt": {
                    return stats.getTriggersRebuiltCount();
                }
                case "Table Capture Removed": {
                    return stats.getTriggersRemovedCount();
                }
                case "Nodes Disabled": {
                    return stats.getNodesDisabled();
                }
                case "Purged Data Rows": {
                    return stats.getPurgedDataRows();
                }
                case "Purged Data Event Rows": {
                    return stats.getPurgedDataEventRows();
                }
                case "Nodes Loaded": {
                    return stats.getNodesLoaded();
                }
            }
        }
        return 0.0;
    }

    public void setPeriodsInMinutes(int periodsInMinutes) {
        this.e = periodsInMinutes;
    }

    public void setDataTypeToDisplay(String dataTypeToDisplay) {
        this.f = dataTypeToDisplay;
    }
}

