/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;

public class n
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    protected I controller;
    protected Span subject = new Span();
    protected Span issuer = new Span();
    protected Span keyType = new Span();
    protected Span effective = new Span();
    protected Span expiration = new Span();
    protected boolean isValid;

    public n(I controller) {
        this.controller = controller;
        this.setSpacing(true);
        this.setMargin(true);
        this.add(new Component[]{new HorizontalLayout(new Component[]{this.boldSpan(controller.getMessage("Subject:", new Object[0])), this.subject})});
        this.add(new Component[]{new HorizontalLayout(new Component[]{this.boldSpan(controller.getMessage("Issuer:", new Object[0])), this.issuer})});
        this.add(new Component[]{new HorizontalLayout(new Component[]{this.boldSpan(controller.getMessage("Key Type:", new Object[0])), this.keyType})});
        this.add(new Component[]{new HorizontalLayout(new Component[]{this.boldSpan(controller.getMessage("Effective Date:", new Object[0])), this.effective})});
        this.add(new Component[]{new HorizontalLayout(new Component[]{this.boldSpan(controller.getMessage("Expiration Date:", new Object[0])), this.expiration})});
    }

    protected Span boldSpan(String text) {
        Span span = new Span(text);
        span.setClassName("bold");
        span.setWidth("128px");
        return span;
    }

    public void setValues(Certificate cert) {
        if (cert instanceof X509Certificate) {
            X509Certificate x509 = (X509Certificate)cert;
            this.subject.setText(x509.getSubjectX500Principal().getName().replace(",", ", "));
            this.issuer.setText(x509.getIssuerX500Principal().getName().replace(",", ", "));
            this.effective.setText(as.formatDate(this.controller, x509.getNotBefore()));
            this.expiration.setText(as.formatDate(this.controller, x509.getNotAfter()));
            Date now = new Date();
            this.isValid = now.compareTo(x509.getNotBefore()) >= 0 && now.compareTo(x509.getNotAfter()) <= 0;
            PublicKey pubKey = x509.getPublicKey();
            if (pubKey instanceof RSAPublicKey) {
                RSAPublicKey rsaPk = (RSAPublicKey)pubKey;
                this.keyType.setText("RSA " + rsaPk.getModulus().bitLength() + "-bit");
            } else if (pubKey instanceof DSAPublicKey) {
                DSAPublicKey dsaPk = (DSAPublicKey)pubKey;
                this.keyType.setText("DSA " + dsaPk.getParams().getP().bitLength() + "-bit");
            }
        }
    }

    public String getSubject() {
        return this.subject.getText();
    }

    public boolean isValid() {
        return this.isValid;
    }
}

