/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.jumpmind.symmetric.console.impl.F;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.as;
import com.jumpmind.symmetric.console.ui.common.w;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Hr;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.radiobutton.RadioGroupVariant;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.tabs.TabsVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.BindingValidationStatusHandler;
import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.StringToIntegerConverter;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.properties.DefaultParameterParser;
import org.jumpmind.symmetric.common.ParameterConstants;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.Label;
import org.jumpmind.vaadin.ui.common.TabSheet;
import org.springframework.scheduling.support.CronExpression;

public class P
extends Dialog {
    private static final long serialVersionUID = 1L;
    private I controller;
    private w formField;
    private String externalId;
    private String nodeGroupId;
    private DefaultParameterParser.ParameterMetaData param;
    private float baseHeight = 300.0f;
    private TabSheet tabs;
    private VerticalLayout periodicTab;
    private TextField periodicField;
    private Binder<Integer> periodicBinder;
    private Select<String> periodicUnits;
    private VerticalLayout scheduleTab;
    private Binder<String> scheduleBinder;
    private RadioButtonGroup<String> secondsGroup;
    private TextField onSecondsField;
    private Checkbox repeatSecondsCheckbox;
    private TextField repeatSecondsField;
    private RadioButtonGroup<String> minutesGroup;
    private TextField onMinutesField;
    private Checkbox repeatMinutesCheckbox;
    private TextField repeatMinutesField;
    private RadioButtonGroup<String> hoursGroup;
    private TextField onHoursField;
    private Checkbox repeatHoursCheckbox;
    private TextField repeatHoursField;
    private VerticalLayout advancedLayout;
    private RadioButtonGroup<String> daysOfMonthGroup;
    private TextField onDaysOfMonthField;
    private Checkbox repeatDaysOfMonthCheckbox;
    private TextField repeatDaysOfMonthField;
    private RadioButtonGroup<String> monthsGroup;
    private List<Checkbox> monthsCheckboxes;
    private RadioButtonGroup<String> daysOfWeekGroup;
    private List<Checkbox> daysOfWeekCheckboxes;
    private VerticalLayout cronTab;
    private Binder<String> cronBinder;
    private TextField cronField;
    private Button cancelButton;
    private ShortcutRegistration cancelShortcutRegistration;

    public P(I controller, w formField, boolean showPeriodicTab, boolean showCronTabs, boolean showRestoreButton) {
        this(controller, formField, showPeriodicTab, showCronTabs, showRestoreButton, null, null, null, null);
    }

    public P(I controller, boolean showPeriodicTab, boolean showCronTabs, String externalId, String nodeGroupId, DefaultParameterParser.ParameterMetaData param, String paramValue) {
        this(controller, null, showPeriodicTab, showCronTabs, true, externalId, nodeGroupId, param, paramValue);
    }

    public P(I controller, w formField, boolean showPeriodicTab, boolean showCronTabs, boolean showRestoreButton, String externalId, String nodeGroupId, DefaultParameterParser.ParameterMetaData param, String paramValue) {
        boolean showAdvancedLayout;
        this.controller = controller;
        this.formField = formField;
        this.externalId = externalId;
        this.nodeGroupId = nodeGroupId;
        this.param = param;
        this.setWidth(850.0f, Unit.PIXELS);
        this.setModal(true);
        this.setResizable(false);
        this.setCloseOnOutsideClick(false);
        VerticalLayout outerLayout = new VerticalLayout();
        outerLayout.setSizeFull();
        outerLayout.getThemeList().remove((Object)"padding");
        boolean isCron = true;
        String currentValue = null;
        if (formField != null) {
            this.setHeaderTitle(controller.getMessage("Job Schedule Editor", new Object[0]));
            currentValue = formField.getValue();
        } else {
            this.setHeaderTitle(controller.getMessage("Edit Parameter : %s", param.getKey()));
            if (StringUtils.isNotBlank((CharSequence)param.getDescription())) {
                Span description = new Span(param.getDescription());
                description.setWidthFull();
                outerLayout.add(new Component[]{description});
                this.baseHeight += 50.0f;
            }
            currentValue = paramValue;
        }
        try {
            if (currentValue != null && currentValue != "Default" && currentValue.length() > 3) {
                Integer.parseInt(currentValue.substring(0, currentValue.length() - 3));
                isCron = false;
            }
        }
        catch (NumberFormatException description) {
            // empty catch block
        }
        boolean bl2 = showAdvancedLayout = isCron && currentValue != null && !currentValue.equals("Default") && !currentValue.endsWith("* * *");
        if (showPeriodicTab) {
            this.setHeight(this.baseHeight, Unit.PIXELS);
        } else if (showCronTabs) {
            if (showAdvancedLayout) {
                this.setHeight(this.baseHeight + 600.0f, Unit.PIXELS);
            } else {
                this.setHeight(this.baseHeight + 330.0f, Unit.PIXELS);
            }
        }
        this.tabs = new TabSheet();
        this.tabs.addThemeVariants(new TabsVariant[]{TabsVariant.LUMO_SMALL});
        this.tabs.setWidthFull();
        if (showPeriodicTab) {
            this.periodicTab = new VerticalLayout();
            Span spacer = new Span();
            spacer.setHeight(50.0f, Unit.PERCENTAGE);
            this.periodicTab.add(new Component[]{spacer});
            HorizontalLayout periodicLayout = new HorizontalLayout();
            Span everySpan = new Span(controller.getMessage("Every", new Object[0]));
            periodicLayout.add(new Component[]{everySpan});
            periodicLayout.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{everySpan});
            this.periodicBinder = new Binder();
            this.periodicField = new TextField();
            this.periodicField.setWidth(6.0f, Unit.EM);
            Span periodicFieldSpan = as.getErrorSpan();
            this.periodicBinder.forField((HasValue)this.periodicField).withConverter((Converter)new StringToIntegerConverter(controller.getMessage("This field must be an integer.", new Object[0]))).withValidator((SerializablePredicate & Serializable)value -> value != null, controller.getMessage("This field is required.", new Object[0])).withValidator((SerializablePredicate & Serializable)value -> value > 0, controller.getMessage("The period must be greater than 0.", new Object[0])).withValidator((SerializablePredicate & Serializable)value -> !((String)this.periodicUnits.getValue()).equals(controller.getMessage("days", new Object[0])) || value < 25, controller.getMessage("The period cannot exceed 24 days.", new Object[0])).withValidator((SerializablePredicate & Serializable)value -> !((String)this.periodicUnits.getValue()).equals(controller.getMessage("hours", new Object[0])) || value < 597, controller.getMessage("The period cannot exceed 596 hours.", new Object[0])).withValidator((SerializablePredicate & Serializable)value -> !((String)this.periodicUnits.getValue()).equals(controller.getMessage("minutes", new Object[0])) || value < 35792, controller.getMessage("The period cannot exceed 35,791 minutes.", new Object[0])).withValidator((SerializablePredicate & Serializable)value -> value < 2147484, controller.getMessage("The period cannot exceed 2,147,483 seconds.", new Object[0])).withValidationStatusHandler(as.getValidationHandler((Component)this.periodicField, periodicFieldSpan)).bind((ValueProvider & Serializable)value -> value, (Setter & Serializable)(value, newValue) -> {
                value = newValue;
            });
            periodicLayout.add(new Component[]{this.periodicField});
            ArrayList<String> units = new ArrayList<String>();
            units.add(controller.getMessage("seconds", new Object[0]));
            units.add(controller.getMessage("minutes", new Object[0]));
            units.add(controller.getMessage("hours", new Object[0]));
            units.add(controller.getMessage("days", new Object[0]));
            this.periodicUnits = new Select();
            this.periodicUnits.setItems(units);
            this.periodicUnits.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                if (!this.periodicField.isEmpty()) {
                    this.periodicBinder.validate();
                }
            });
            this.periodicUnits.setEmptySelectionAllowed(false);
            periodicLayout.add(new Component[]{this.periodicUnits});
            periodicLayout.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{this.periodicUnits});
            this.periodicUnits.setValue((Object)controller.getMessage("seconds", new Object[0]));
            if (!isCron) {
                int seconds = Integer.parseInt(currentValue.substring(0, currentValue.length() - 3));
                if (seconds >= 86400 && seconds % 86400 == 0) {
                    this.periodicUnits.setValue((Object)controller.getMessage("days", new Object[0]));
                    this.periodicField.setValue(String.valueOf(seconds / 86400));
                } else if (seconds >= 3600 && seconds % 3600 == 0) {
                    this.periodicUnits.setValue((Object)controller.getMessage("hours", new Object[0]));
                    this.periodicField.setValue(String.valueOf(seconds / 3600));
                } else if (seconds >= 60 && seconds % 60 == 0) {
                    this.periodicUnits.setValue((Object)controller.getMessage("minutes", new Object[0]));
                    this.periodicField.setValue(String.valueOf(seconds / 60));
                } else {
                    this.periodicField.setValue(String.valueOf(seconds));
                }
            }
            this.periodicTab.add(new Component[]{periodicLayout});
            this.periodicTab.add(new Component[]{periodicFieldSpan});
            this.tabs.add((Component)this.periodicTab, controller.getMessage("Periodic", new Object[0]));
        }
        if (showCronTabs) {
            this.scheduleTab = new VerticalLayout();
            Label scheduleDescriptionLabel = new Label(controller.getMessage("Use X-Y for ranges.  Separate multiple entries with a comma.<br><hr>", new Object[0]));
            scheduleDescriptionLabel.setWidth(772.0f, Unit.PIXELS);
            this.scheduleTab.add(new Component[]{scheduleDescriptionLabel});
            HorizontalLayout secondsLayout = new HorizontalLayout();
            secondsLayout.setWidthFull();
            this.secondsGroup = new RadioButtonGroup();
            this.secondsGroup.getStyle().set("width", "140px");
            this.secondsGroup.addThemeVariants((ThemeVariant[])new RadioGroupVariant[]{RadioGroupVariant.LUMO_VERTICAL});
            this.secondsGroup.setItems((Object[])new String[]{controller.getMessage("Every Second", new Object[0]), controller.getMessage("On Seconds", new Object[0])});
            this.secondsGroup.setValue((Object)controller.getMessage("Every Second", new Object[0]));
            secondsLayout.add(new Component[]{this.secondsGroup});
            this.scheduleBinder = new Binder();
            this.onSecondsField = new TextField();
            this.onSecondsField.setWidth(8.0f, Unit.EM);
            this.onSecondsField.getStyle().set("margin-bottom", "4px");
            this.onSecondsField.setEnabled(false);
            this.scheduleBinder.forField((HasValue)this.onSecondsField).withValidator((SerializablePredicate & Serializable)value -> this.validateScheduleField(this.onSecondsField, 0, 59, false), "").withValidationStatusHandler(this.getValidationHandler(this.onSecondsField, 0, 59, false)).bind((ValueProvider & Serializable)value -> value, (Setter & Serializable)(value, newValue) -> {
                value = newValue;
            });
            this.secondsGroup.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                if (((String)event.getValue()).equals(controller.getMessage("On Seconds", new Object[0]))) {
                    this.onSecondsField.setEnabled(true);
                } else {
                    this.onSecondsField.setEnabled(false);
                    this.onSecondsField.setValue(" ");
                    this.onSecondsField.setValue("");
                }
            });
            secondsLayout.add(new Component[]{this.onSecondsField});
            secondsLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.onSecondsField});
            HorizontalLayout repeatSecondsLayout = new HorizontalLayout();
            repeatSecondsLayout.getStyle().set("margin-bottom", "4px");
            this.repeatSecondsCheckbox = new Checkbox(controller.getMessage("Repeat each", new Object[0]));
            repeatSecondsLayout.add(new Component[]{this.repeatSecondsCheckbox});
            repeatSecondsLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.repeatSecondsCheckbox});
            this.repeatSecondsField = new TextField();
            this.repeatSecondsField.setWidth(6.0f, Unit.EM);
            this.repeatSecondsField.getStyle().set("margin", "0");
            this.repeatSecondsField.setEnabled(false);
            this.scheduleBinder.forField((HasValue)this.repeatSecondsField).withValidator((SerializablePredicate & Serializable)value -> this.validateScheduleField(this.repeatSecondsField, 1, 59, true), "").withValidationStatusHandler(this.getValidationHandler(this.repeatSecondsField, 1, 59, true)).bind((ValueProvider & Serializable)value -> value, (Setter & Serializable)(value, newValue) -> {
                value = newValue;
            });
            this.repeatSecondsCheckbox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                if (((Boolean)event.getValue()).booleanValue()) {
                    this.repeatSecondsField.setEnabled(true);
                } else {
                    this.repeatSecondsField.setEnabled(false);
                    this.repeatSecondsField.setValue(" ");
                    this.repeatSecondsField.setValue("");
                }
            });
            repeatSecondsLayout.add(new Component[]{this.repeatSecondsField});
            Span repeatSecondsSpan = new Span(controller.getMessage("seconds", new Object[0]));
            repeatSecondsLayout.add(new Component[]{repeatSecondsSpan});
            repeatSecondsLayout.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{repeatSecondsSpan});
            secondsLayout.add(new Component[]{repeatSecondsLayout});
            secondsLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{repeatSecondsLayout});
            this.scheduleTab.add(new Component[]{secondsLayout});
            this.addDivider(this.scheduleTab);
            HorizontalLayout minutesLayout = new HorizontalLayout();
            minutesLayout.setWidthFull();
            this.minutesGroup = new RadioButtonGroup();
            this.minutesGroup.getStyle().set("width", "140px");
            this.minutesGroup.addThemeVariants((ThemeVariant[])new RadioGroupVariant[]{RadioGroupVariant.LUMO_VERTICAL});
            this.minutesGroup.setItems((Object[])new String[]{controller.getMessage("Every Minute", new Object[0]), controller.getMessage("On Minutes", new Object[0])});
            this.minutesGroup.setValue((Object)controller.getMessage("Every Minute", new Object[0]));
            minutesLayout.add(new Component[]{this.minutesGroup});
            this.onMinutesField = new TextField();
            this.onMinutesField.setWidth(8.0f, Unit.EM);
            this.onMinutesField.getStyle().set("margin-bottom", "4px");
            this.onMinutesField.setEnabled(false);
            this.scheduleBinder.forField((HasValue)this.onMinutesField).withValidator((SerializablePredicate & Serializable)value -> this.validateScheduleField(this.onMinutesField, 0, 59, false), "").withValidationStatusHandler(this.getValidationHandler(this.onMinutesField, 0, 59, false)).bind((ValueProvider & Serializable)value -> value, (Setter & Serializable)(value, newValue) -> {
                value = newValue;
            });
            this.minutesGroup.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                if (((String)event.getValue()).equals(controller.getMessage("On Minutes", new Object[0]))) {
                    this.onMinutesField.setEnabled(true);
                } else {
                    this.onMinutesField.setEnabled(false);
                    this.onMinutesField.setValue(" ");
                    this.onMinutesField.setValue("");
                }
            });
            minutesLayout.add(new Component[]{this.onMinutesField});
            minutesLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.onMinutesField});
            HorizontalLayout repeatMinutesLayout = new HorizontalLayout();
            repeatMinutesLayout.getStyle().set("margin-bottom", "4px");
            this.repeatMinutesCheckbox = new Checkbox(controller.getMessage("Repeat each", new Object[0]));
            repeatMinutesLayout.add(new Component[]{this.repeatMinutesCheckbox});
            repeatMinutesLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.repeatMinutesCheckbox});
            this.repeatMinutesField = new TextField();
            this.repeatMinutesField.setWidth(6.0f, Unit.EM);
            this.repeatMinutesField.getStyle().set("margin", "0");
            this.repeatMinutesField.setEnabled(false);
            this.scheduleBinder.forField((HasValue)this.repeatMinutesField).withValidator((SerializablePredicate & Serializable)value -> this.validateScheduleField(this.repeatMinutesField, 1, 59, true), "").withValidationStatusHandler(this.getValidationHandler(this.repeatMinutesField, 1, 59, true)).bind((ValueProvider & Serializable)value -> value, (Setter & Serializable)(value, newValue) -> {
                value = newValue;
            });
            this.repeatMinutesCheckbox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                if (((Boolean)event.getValue()).booleanValue()) {
                    this.repeatMinutesField.setEnabled(true);
                } else {
                    this.repeatMinutesField.setEnabled(false);
                    this.repeatMinutesField.setValue(" ");
                    this.repeatMinutesField.setValue("");
                }
            });
            repeatMinutesLayout.add(new Component[]{this.repeatMinutesField});
            Span repeatMinutesSpan = new Span(controller.getMessage("minutes", new Object[0]));
            repeatMinutesLayout.add(new Component[]{repeatMinutesSpan});
            repeatMinutesLayout.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{repeatMinutesSpan});
            minutesLayout.add(new Component[]{repeatMinutesLayout});
            minutesLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{repeatMinutesLayout});
            this.scheduleTab.add(new Component[]{minutesLayout});
            this.addDivider(this.scheduleTab);
            HorizontalLayout hoursLayout = new HorizontalLayout();
            hoursLayout.setWidthFull();
            this.hoursGroup = new RadioButtonGroup();
            this.hoursGroup.getStyle().set("width", "140px");
            this.hoursGroup.addThemeVariants((ThemeVariant[])new RadioGroupVariant[]{RadioGroupVariant.LUMO_VERTICAL});
            this.hoursGroup.setItems((Object[])new String[]{controller.getMessage("Every Hour", new Object[0]), controller.getMessage("On Hours", new Object[0])});
            this.hoursGroup.setValue((Object)controller.getMessage("Every Hour", new Object[0]));
            hoursLayout.add(new Component[]{this.hoursGroup});
            this.onHoursField = new TextField();
            this.onHoursField.setWidth(8.0f, Unit.EM);
            this.onHoursField.getStyle().set("margin-bottom", "4px");
            this.onHoursField.setEnabled(false);
            this.scheduleBinder.forField((HasValue)this.onHoursField).withValidator((SerializablePredicate & Serializable)value -> this.validateScheduleField(this.onHoursField, 0, 23, false), "").withValidationStatusHandler(this.getValidationHandler(this.onHoursField, 0, 23, false)).bind((ValueProvider & Serializable)value -> value, (Setter & Serializable)(value, newValue) -> {
                value = newValue;
            });
            this.hoursGroup.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                if (((String)event.getValue()).equals(controller.getMessage("On Hours", new Object[0]))) {
                    this.onHoursField.setEnabled(true);
                } else {
                    this.onHoursField.setEnabled(false);
                    this.onHoursField.setValue(" ");
                    this.onHoursField.setValue("");
                }
            });
            hoursLayout.add(new Component[]{this.onHoursField});
            hoursLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.onHoursField});
            HorizontalLayout repeatHoursLayout = new HorizontalLayout();
            repeatHoursLayout.getStyle().set("margin-bottom", "4px");
            this.repeatHoursCheckbox = new Checkbox(controller.getMessage("Repeat each", new Object[0]));
            repeatHoursLayout.add(new Component[]{this.repeatHoursCheckbox});
            repeatHoursLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.repeatHoursCheckbox});
            this.repeatHoursField = new TextField();
            this.repeatHoursField.setWidth(6.0f, Unit.EM);
            this.repeatHoursField.getStyle().set("margin", "0");
            this.repeatHoursField.setEnabled(false);
            this.scheduleBinder.forField((HasValue)this.repeatHoursField).withValidator((SerializablePredicate & Serializable)value -> this.validateScheduleField(this.repeatHoursField, 1, 23, true), "").withValidationStatusHandler(this.getValidationHandler(this.repeatHoursField, 1, 23, true)).bind((ValueProvider & Serializable)value -> value, (Setter & Serializable)(value, newValue) -> {
                value = newValue;
            });
            this.repeatHoursCheckbox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                if (((Boolean)event.getValue()).booleanValue()) {
                    this.repeatHoursField.setEnabled(true);
                } else {
                    this.repeatHoursField.setEnabled(false);
                    this.repeatHoursField.setValue(" ");
                    this.repeatHoursField.setValue("");
                }
            });
            repeatHoursLayout.add(new Component[]{this.repeatHoursField});
            Span repeatHoursSpan = new Span(controller.getMessage("hours", new Object[0]));
            repeatHoursLayout.add(new Component[]{repeatHoursSpan});
            repeatHoursLayout.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{repeatHoursSpan});
            hoursLayout.add(new Component[]{repeatHoursLayout});
            hoursLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{repeatHoursLayout});
            this.scheduleTab.add(new Component[]{hoursLayout});
            this.addDivider(this.scheduleTab);
            this.advancedLayout = new VerticalLayout();
            this.advancedLayout.setVisible(showAdvancedLayout);
            this.advancedLayout.setMargin(false);
            this.advancedLayout.getThemeList().remove((Object)"padding");
            Button advancedButton = as.createLinkButton(showAdvancedLayout ? controller.getMessage("Hide Advanced", new Object[0]) : controller.getMessage("Show Advanced", new Object[0]));
            this.scheduleTab.add(new Component[]{advancedButton});
            advancedButton.addClickListener((ComponentEventListener & Serializable)event -> {
                if (this.advancedLayout.isVisible()) {
                    this.setHeight(this.baseHeight + 330.0f, Unit.PIXELS);
                    this.advancedLayout.setVisible(false);
                    advancedButton.setText(controller.getMessage("Show Advanced", new Object[0]));
                } else {
                    this.setHeight(this.baseHeight + 600.0f, Unit.PIXELS);
                    this.advancedLayout.setVisible(true);
                    advancedButton.setText(controller.getMessage("Hide Advanced", new Object[0]));
                }
            });
            HorizontalLayout daysOfMonthLayout = new HorizontalLayout();
            daysOfMonthLayout.setWidthFull();
            this.daysOfMonthGroup = new RadioButtonGroup();
            this.daysOfMonthGroup.getStyle().set("width", "185px");
            this.daysOfMonthGroup.addThemeVariants((ThemeVariant[])new RadioGroupVariant[]{RadioGroupVariant.LUMO_VERTICAL});
            this.daysOfMonthGroup.setItems((Object[])new String[]{controller.getMessage("Every Day of Month", new Object[0]), controller.getMessage("On Days", new Object[0])});
            this.daysOfMonthGroup.setValue((Object)controller.getMessage("Every Day of Month", new Object[0]));
            daysOfMonthLayout.add(new Component[]{this.daysOfMonthGroup});
            this.onDaysOfMonthField = new TextField();
            this.onDaysOfMonthField.setWidth(8.0f, Unit.EM);
            this.onDaysOfMonthField.getStyle().set("margin-bottom", "4px");
            this.onDaysOfMonthField.setEnabled(false);
            this.scheduleBinder.forField((HasValue)this.onDaysOfMonthField).withValidator((SerializablePredicate & Serializable)value -> this.validateScheduleField(this.onDaysOfMonthField, 1, 31, false), "").withValidationStatusHandler(this.getValidationHandler(this.onDaysOfMonthField, 1, 31, false)).bind((ValueProvider & Serializable)value -> value, (Setter & Serializable)(value, newValue) -> {
                value = newValue;
            });
            this.daysOfMonthGroup.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                if (((String)event.getValue()).equals(controller.getMessage("On Days", new Object[0]))) {
                    this.onDaysOfMonthField.setEnabled(true);
                } else {
                    this.onDaysOfMonthField.setEnabled(false);
                    this.onDaysOfMonthField.setValue(" ");
                    this.onDaysOfMonthField.setValue("");
                }
            });
            daysOfMonthLayout.add(new Component[]{this.onDaysOfMonthField});
            daysOfMonthLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.onDaysOfMonthField});
            HorizontalLayout repeatDaysOfMonthLayout = new HorizontalLayout();
            repeatDaysOfMonthLayout.getStyle().set("margin-bottom", "4px");
            this.repeatDaysOfMonthCheckbox = new Checkbox(controller.getMessage("Repeat each", new Object[0]));
            repeatDaysOfMonthLayout.add(new Component[]{this.repeatDaysOfMonthCheckbox});
            repeatDaysOfMonthLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.repeatDaysOfMonthCheckbox});
            this.repeatDaysOfMonthField = new TextField();
            this.repeatDaysOfMonthField.setWidth(6.0f, Unit.EM);
            this.repeatDaysOfMonthField.getStyle().set("margin", "0");
            this.repeatDaysOfMonthField.setEnabled(false);
            this.scheduleBinder.forField((HasValue)this.repeatDaysOfMonthField).withValidator((SerializablePredicate & Serializable)value -> this.validateScheduleField(this.repeatDaysOfMonthField, 1, 31, true), "").withValidationStatusHandler(this.getValidationHandler(this.repeatDaysOfMonthField, 1, 31, true)).bind((ValueProvider & Serializable)value -> value, (Setter & Serializable)(value, newValue) -> {
                value = newValue;
            });
            this.repeatDaysOfMonthCheckbox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                if (((Boolean)event.getValue()).booleanValue()) {
                    this.repeatDaysOfMonthField.setEnabled(true);
                } else {
                    this.repeatDaysOfMonthField.setEnabled(false);
                    this.repeatDaysOfMonthField.setValue(" ");
                    this.repeatDaysOfMonthField.setValue("");
                }
            });
            repeatDaysOfMonthLayout.add(new Component[]{this.repeatDaysOfMonthField});
            Span repeatDaysOfMonthSpan = new Span(controller.getMessage("days", new Object[0]));
            repeatDaysOfMonthLayout.add(new Component[]{repeatDaysOfMonthSpan});
            repeatDaysOfMonthLayout.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{repeatDaysOfMonthSpan});
            daysOfMonthLayout.add(new Component[]{repeatDaysOfMonthLayout});
            daysOfMonthLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{repeatDaysOfMonthLayout});
            this.advancedLayout.add(new Component[]{daysOfMonthLayout});
            this.addDivider(this.advancedLayout);
            HorizontalLayout monthsLayout = new HorizontalLayout();
            monthsLayout.setWidthFull();
            monthsLayout.setPadding(false);
            this.monthsGroup = new RadioButtonGroup();
            this.monthsGroup.getStyle().set("width", "230px");
            this.monthsGroup.addThemeVariants((ThemeVariant[])new RadioGroupVariant[]{RadioGroupVariant.LUMO_VERTICAL});
            this.monthsGroup.setItems((Object[])new String[]{controller.getMessage("Every Month", new Object[0]), controller.getMessage("On Months", new Object[0])});
            this.monthsGroup.setValue((Object)controller.getMessage("Every Month", new Object[0]));
            monthsLayout.add(new Component[]{this.monthsGroup});
            VerticalLayout monthsCheckboxLayout = new VerticalLayout();
            monthsCheckboxLayout.setWidthFull();
            this.monthsCheckboxes = new ArrayList<Checkbox>();
            Checkbox janCheckbox = new Checkbox(controller.getMessage("Jan", new Object[0]));
            this.monthsCheckboxes.add(janCheckbox);
            Checkbox febCheckbox = new Checkbox(controller.getMessage("Feb", new Object[0]));
            this.monthsCheckboxes.add(febCheckbox);
            Checkbox marCheckbox = new Checkbox(controller.getMessage("Mar", new Object[0]));
            this.monthsCheckboxes.add(marCheckbox);
            Checkbox aprCheckbox = new Checkbox(controller.getMessage("Apr", new Object[0]));
            this.monthsCheckboxes.add(aprCheckbox);
            Checkbox mayCheckbox = new Checkbox(controller.getMessage("May", new Object[0]));
            this.monthsCheckboxes.add(mayCheckbox);
            Checkbox junCheckbox = new Checkbox(controller.getMessage("Jun", new Object[0]));
            this.monthsCheckboxes.add(junCheckbox);
            Checkbox julCheckbox = new Checkbox(controller.getMessage("Jul", new Object[0]));
            this.monthsCheckboxes.add(julCheckbox);
            Checkbox augCheckbox = new Checkbox(controller.getMessage("Aug", new Object[0]));
            this.monthsCheckboxes.add(augCheckbox);
            Checkbox sepCheckbox = new Checkbox(controller.getMessage("Sep", new Object[0]));
            this.monthsCheckboxes.add(sepCheckbox);
            Checkbox octCheckbox = new Checkbox(controller.getMessage("Oct", new Object[0]));
            this.monthsCheckboxes.add(octCheckbox);
            Checkbox novCheckbox = new Checkbox(controller.getMessage("Nov", new Object[0]));
            this.monthsCheckboxes.add(novCheckbox);
            Checkbox decCheckbox = new Checkbox(controller.getMessage("Dec", new Object[0]));
            this.monthsCheckboxes.add(decCheckbox);
            for (Checkbox checkbox : this.monthsCheckboxes) {
                checkbox.setEnabled(false);
                checkbox.setWidth("80px");
            }
            monthsCheckboxLayout.add(new Component[]{new HorizontalLayout(new Component[]{janCheckbox, febCheckbox, marCheckbox, aprCheckbox, mayCheckbox, junCheckbox})});
            monthsCheckboxLayout.add(new Component[]{new HorizontalLayout(new Component[]{julCheckbox, augCheckbox, sepCheckbox, octCheckbox, novCheckbox, decCheckbox})});
            this.monthsGroup.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                for (Checkbox checkbox : this.monthsCheckboxes) {
                    checkbox.setEnabled(((String)event.getValue()).equals(controller.getMessage("On Months", new Object[0])));
                    checkbox.setValue((Object)false);
                }
            });
            monthsLayout.add(new Component[]{monthsCheckboxLayout});
            this.advancedLayout.add(new Component[]{monthsLayout});
            this.addDivider(this.advancedLayout);
            this.scheduleTab.add(new Component[]{this.advancedLayout});
            HorizontalLayout daysOfWeekLayout = new HorizontalLayout();
            daysOfWeekLayout.setWidthFull();
            daysOfWeekLayout.setPadding(false);
            this.daysOfWeekGroup = new RadioButtonGroup();
            this.daysOfWeekGroup.getStyle().set("width", "230px");
            this.daysOfWeekGroup.addThemeVariants((ThemeVariant[])new RadioGroupVariant[]{RadioGroupVariant.LUMO_VERTICAL});
            this.daysOfWeekGroup.setItems((Object[])new String[]{controller.getMessage("Every Day of Week", new Object[0]), controller.getMessage("On Days", new Object[0])});
            this.daysOfWeekGroup.setValue((Object)controller.getMessage("Every Day of Week", new Object[0]));
            daysOfWeekLayout.add(new Component[]{this.daysOfWeekGroup});
            VerticalLayout daysOfWeekCheckboxLayout = new VerticalLayout();
            daysOfWeekCheckboxLayout.setWidthFull();
            this.daysOfWeekCheckboxes = new ArrayList<Checkbox>();
            Checkbox monCheckbox = new Checkbox(controller.getMessage("Mon", new Object[0]));
            this.daysOfWeekCheckboxes.add(monCheckbox);
            Checkbox tueCheckbox = new Checkbox(controller.getMessage("Tue", new Object[0]));
            this.daysOfWeekCheckboxes.add(tueCheckbox);
            Checkbox wedCheckbox = new Checkbox(controller.getMessage("Wed", new Object[0]));
            this.daysOfWeekCheckboxes.add(wedCheckbox);
            Checkbox thrCheckbox = new Checkbox(controller.getMessage("Thu", new Object[0]));
            this.daysOfWeekCheckboxes.add(thrCheckbox);
            Checkbox friCheckbox = new Checkbox(controller.getMessage("Fri", new Object[0]));
            this.daysOfWeekCheckboxes.add(friCheckbox);
            Checkbox satCheckbox = new Checkbox(controller.getMessage("Sat", new Object[0]));
            this.daysOfWeekCheckboxes.add(satCheckbox);
            Checkbox sunCheckbox = new Checkbox(controller.getMessage("Sun", new Object[0]));
            this.daysOfWeekCheckboxes.add(sunCheckbox);
            for (Checkbox checkbox : this.daysOfWeekCheckboxes) {
                checkbox.setEnabled(false);
                checkbox.setWidth("80px");
            }
            daysOfWeekCheckboxLayout.add(new Component[]{new HorizontalLayout(new Component[]{monCheckbox, tueCheckbox, wedCheckbox, thrCheckbox, friCheckbox})});
            daysOfWeekCheckboxLayout.add(new Component[]{new HorizontalLayout(new Component[]{satCheckbox, sunCheckbox})});
            this.daysOfWeekGroup.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                for (Checkbox checkbox : this.daysOfWeekCheckboxes) {
                    checkbox.setEnabled(((String)event.getValue()).equals(controller.getMessage("On Days", new Object[0])));
                    checkbox.setValue((Object)false);
                }
            });
            daysOfWeekLayout.add(new Component[]{daysOfWeekCheckboxLayout});
            this.advancedLayout.add(new Component[]{daysOfWeekLayout});
            this.tabs.add((Component)this.scheduleTab, controller.getMessage("Schedule", new Object[0]));
            this.cronTab = new VerticalLayout();
            Label cronDescriptionLabel = new Label(controller.getMessage("Fields are seconds (0-59), minutes (0-59), hours (0-23), day of month (1-12), month (1-12), and day of week (0-6) (Sunday to Saturday).<br><br>Use * to match any. Use /X for every X. Use X-Y for ranges.<br><br><hr><br><b>Example:</b>    0/5 * 0-3,8-17 * * *<br>Runs every 5 seconds during 8 AM to 5 PM and between midnight and 3 AM", new Object[0]));
            cronDescriptionLabel.setWidth(772.0f, Unit.PIXELS);
            cronDescriptionLabel.setHeight(220.0f, Unit.PIXELS);
            this.cronTab.add(new Component[]{cronDescriptionLabel});
            this.cronBinder = new Binder();
            this.cronField = new TextField(controller.getMessage("Cron", new Object[0]));
            this.cronField.setWidth(20.0f, Unit.EM);
            this.cronBinder.forField((HasValue)this.cronField).withValidator((SerializablePredicate & Serializable)value -> CronExpression.isValidExpression((String)value), controller.getMessage("Please enter a valid cron expression.", new Object[0])).bind((ValueProvider & Serializable)value -> value, (Setter & Serializable)(value, newValue) -> {
                value = newValue;
            });
            this.cronTab.add(new Component[]{this.cronField});
            this.tabs.add((Component)this.cronTab, controller.getMessage("Cron Expression", new Object[0]));
        }
        this.tabs.addSelectedTabChangeListener((ComponentEventListener & Serializable)event -> {
            Component selectedTab = this.tabs.getSelectedTab().getComponent();
            if (selectedTab.equals(this.periodicTab)) {
                this.setHeight(this.baseHeight, Unit.PIXELS);
            } else if (selectedTab.equals(this.scheduleTab)) {
                if (this.advancedLayout.isVisible()) {
                    this.setHeight(this.baseHeight + 600.0f, Unit.PIXELS);
                } else {
                    this.setHeight(this.baseHeight + 330.0f, Unit.PIXELS);
                }
                this.updateScheduleTab(this.cronField.getValue());
            } else if (selectedTab.equals(this.cronTab)) {
                this.setHeight(this.baseHeight + 240.0f, Unit.PIXELS);
                if (this.scheduleBinder.isValid()) {
                    this.cronField.setValue(this.generateCronExpression());
                }
            }
        });
        outerLayout.addAndExpand(new Component[]{this.tabs});
        DefaultParameterParser.ParameterMetaData paramMetaData = null;
        if (param != null) {
            Map paramMap = ParameterConstants.getParameterMetaData();
            paramMap.putAll(F.a());
            paramMetaData = (DefaultParameterParser.ParameterMetaData)paramMap.get(param.getKey());
        }
        if (showRestoreButton && (formField != null || paramMetaData == null || !currentValue.equals(paramMetaData.getDefaultValue()))) {
            Button restoreButton = new Button(controller.getMessage("Restore", new Object[0]), (ComponentEventListener & Serializable)event -> {
                if (formField != null) {
                    formField.setValue("Default");
                    formField.update();
                } else {
                    this.saveValue(null);
                }
                this.close();
            });
            this.getFooter().add(new Component[]{restoreButton});
        }
        this.cancelButton = new Button(controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)event -> this.close());
        this.cancelShortcutRegistration = this.cancelButton.addClickShortcut(Key.ESCAPE, new KeyModifier[0]);
        Button saveButton = as.createPrimaryButton(controller.getMessage("Save", new Object[0]), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
            if (this.save()) {
                if (formField != null) {
                    formField.update();
                }
                this.close();
            } else {
                Component selectedTab = this.tabs.getSelectedTab().getComponent();
                if (selectedTab.equals(this.periodicTab)) {
                    CommonUiUtils.notify((String)controller.getMessage("Please enter a valid period.", new Object[0]), opened -> this.toggleCancelShortcut((boolean)opened));
                } else if (selectedTab.equals(this.scheduleTab)) {
                    CommonUiUtils.notify((String)controller.getMessage("Please enter a valid schedule.", new Object[0]), opened -> this.toggleCancelShortcut((boolean)opened));
                } else if (selectedTab.equals(this.cronTab)) {
                    CommonUiUtils.notify((String)controller.getMessage("Please enter a valid cron expression.", new Object[0]), opened -> this.toggleCancelShortcut((boolean)opened));
                }
            }
        });
        this.getFooter().add(new Component[]{this.cancelButton, saveButton});
        this.add(new Component[]{outerLayout});
        if (currentValue != null && !currentValue.equals("Default") && isCron && showCronTabs) {
            this.updateScheduleTab(currentValue);
            this.cronField.setValue(currentValue);
            this.tabs.setSelectedTab(controller.getMessage("Schedule", new Object[0]));
        }
    }

    private void addDivider(VerticalLayout layout) {
        Hr divider = new Hr();
        divider.setWidth("772px");
        divider.setHeight("1px");
        divider.getStyle().set("margin", "0");
        layout.add(new Component[]{divider});
    }

    private boolean validateScheduleField(TextField field, int lowerLimit, int upperLimit, boolean digitsOnly) {
        if (!field.isEnabled()) {
            return true;
        }
        String value = field.getValue();
        if (!digitsOnly && value.matches("^\\d{1,2}(?:-\\d{1,2})?(?:,\\d{1,2}(?:-\\d{1,2})?)*$") || !value.matches(".*[-,].*")) {
            for (String numberString : value.split(",")) {
                if (numberString.contains("-")) {
                    String[] numbers = numberString.split("-");
                    int firstNumber = Integer.parseInt(numbers[0]);
                    int secondNumber = Integer.parseInt(numbers[1]);
                    if (firstNumber >= lowerLimit && firstNumber <= upperLimit && secondNumber >= lowerLimit && secondNumber <= upperLimit && firstNumber < secondNumber) continue;
                    return false;
                }
                try {
                    int number = Integer.parseInt(numberString);
                    if (number >= lowerLimit && number <= upperLimit) continue;
                    return false;
                }
                catch (NumberFormatException e2) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private BindingValidationStatusHandler getValidationHandler(TextField field, int lowerLimit, int upperLimit, boolean repeat) {
        return (BindingValidationStatusHandler & Serializable)status -> {
            boolean isError = status.isError();
            if (isError) {
                if (repeat) {
                    CommonUiUtils.notifyError((String)this.controller.getMessage("This field can only contain commas, hyphens, and integers from %s to %s. All commas and hyphens must be in valid positions.", "" + lowerLimit, "" + upperLimit), opened -> this.toggleCancelShortcut((boolean)opened));
                } else {
                    CommonUiUtils.notifyError((String)this.controller.getMessage("This field can only contain integers from %s to %s.", "" + lowerLimit, "" + upperLimit), opened -> this.toggleCancelShortcut((boolean)opened));
                }
            }
            field.getElement().setAttribute("invalid", isError);
        };
    }

    private void updateScheduleTab(String cronExpression) {
        if (!CronExpression.isValidExpression((String)cronExpression)) {
            return;
        }
        String[] cronFields = cronExpression.split(" ");
        String seconds = cronFields[0];
        if (seconds.contains("/")) {
            String[] secondsStrings = seconds.split("/");
            if (secondsStrings[0].equals("*")) {
                this.secondsGroup.setValue((Object)this.controller.getMessage("Every Second", new Object[0]));
            } else {
                this.secondsGroup.setValue((Object)this.controller.getMessage("On Seconds", new Object[0]));
                this.onSecondsField.setValue(secondsStrings[0]);
            }
            this.repeatSecondsCheckbox.setValue((Object)true);
            this.repeatSecondsField.setValue(secondsStrings[1]);
        } else {
            if (seconds.equals("*")) {
                this.secondsGroup.setValue((Object)this.controller.getMessage("Every Second", new Object[0]));
            } else {
                this.secondsGroup.setValue((Object)this.controller.getMessage("On Seconds", new Object[0]));
                this.onSecondsField.setValue(seconds);
            }
            this.repeatSecondsCheckbox.setValue((Object)false);
        }
        String minutes = cronFields[1];
        if (minutes.contains("/")) {
            String[] minutesStrings = minutes.split("/");
            if (minutesStrings[0].equals("*")) {
                this.minutesGroup.setValue((Object)this.controller.getMessage("Every Minute", new Object[0]));
            } else {
                this.minutesGroup.setValue((Object)this.controller.getMessage("On Minutes", new Object[0]));
                this.onMinutesField.setValue(minutesStrings[0]);
            }
            this.repeatMinutesCheckbox.setValue((Object)true);
            this.repeatMinutesField.setValue(minutesStrings[1]);
        } else {
            if (minutes.equals("*")) {
                this.minutesGroup.setValue((Object)this.controller.getMessage("Every Minute", new Object[0]));
            } else {
                this.minutesGroup.setValue((Object)this.controller.getMessage("On Minutes", new Object[0]));
                this.onMinutesField.setValue(minutes);
            }
            this.repeatMinutesCheckbox.setValue((Object)false);
        }
        String hours = cronFields[2];
        if (hours.contains("/")) {
            String[] hoursStrings = hours.split("/");
            if (hoursStrings[0].equals("*")) {
                this.hoursGroup.setValue((Object)this.controller.getMessage("Every Hour", new Object[0]));
            } else {
                this.hoursGroup.setValue((Object)this.controller.getMessage("On Hours", new Object[0]));
                this.onHoursField.setValue(hoursStrings[0]);
            }
            this.repeatHoursCheckbox.setValue((Object)true);
            this.repeatHoursField.setValue(hoursStrings[1]);
        } else {
            if (hours.equals("*")) {
                this.hoursGroup.setValue((Object)this.controller.getMessage("Every Hour", new Object[0]));
            } else {
                this.hoursGroup.setValue((Object)this.controller.getMessage("On Hours", new Object[0]));
                this.onHoursField.setValue(hours);
            }
            this.repeatHoursCheckbox.setValue((Object)false);
        }
        String daysOfMonth = cronFields[3];
        if (daysOfMonth.contains("/")) {
            String[] daysOfMonthStrings = daysOfMonth.split("/");
            if (daysOfMonthStrings[0].equals("*")) {
                this.daysOfMonthGroup.setValue((Object)this.controller.getMessage("Every Day of Month", new Object[0]));
            } else {
                this.daysOfMonthGroup.setValue((Object)this.controller.getMessage("On Days", new Object[0]));
                this.onDaysOfMonthField.setValue(daysOfMonthStrings[0]);
            }
            this.repeatDaysOfMonthCheckbox.setValue((Object)true);
            this.repeatDaysOfMonthField.setValue(daysOfMonthStrings[1]);
        } else {
            if (daysOfMonth.equals("*") || daysOfMonth.equals("?")) {
                this.daysOfMonthGroup.setValue((Object)this.controller.getMessage("Every Day of Month", new Object[0]));
            } else {
                this.daysOfMonthGroup.setValue((Object)this.controller.getMessage("On Days", new Object[0]));
                this.onDaysOfMonthField.setValue(daysOfMonth);
            }
            this.repeatDaysOfMonthCheckbox.setValue((Object)false);
        }
        String months = cronFields[4];
        this.monthsGroup.setValue((Object)this.controller.getMessage("Every Month", new Object[0]));
        if (!months.equals("*")) {
            this.monthsGroup.setValue((Object)this.controller.getMessage("On Months", new Object[0]));
            for (String monthString : months.split(",")) {
                if (monthString.contains("-")) {
                    String[] monthStrings = monthString.split("-");
                    int firstMonth = this.convertMonthStringToInt(monthStrings[0]);
                    int lastMonth = this.convertMonthStringToInt(monthStrings[1]);
                    for (int i2 = firstMonth; i2 <= lastMonth; ++i2) {
                        this.monthsCheckboxes.get(i2).setValue((Object)true);
                    }
                    continue;
                }
                int month = this.convertMonthStringToInt(monthString);
                this.monthsCheckboxes.get(month).setValue((Object)true);
            }
        }
        String daysOfWeek = cronFields[5];
        this.daysOfWeekGroup.setValue((Object)this.controller.getMessage("Every Day of Week", new Object[0]));
        if (!daysOfWeek.equals("*") && !daysOfWeek.equals("?")) {
            this.daysOfWeekGroup.setValue((Object)this.controller.getMessage("On Days", new Object[0]));
            for (String dayOfWeekString : daysOfWeek.split(",")) {
                if (dayOfWeekString.contains("-")) {
                    String[] dayOfWeekStrings = dayOfWeekString.split("-");
                    int firstDayOfWeek = this.convertDayOfWeekStringToInt(dayOfWeekStrings[0]);
                    int lastDayOfWeek = this.convertDayOfWeekStringToInt(dayOfWeekStrings[1]);
                    for (int i3 = firstDayOfWeek; i3 <= lastDayOfWeek; ++i3) {
                        this.daysOfWeekCheckboxes.get(i3).setValue((Object)true);
                    }
                    continue;
                }
                int dayOfWeek = this.convertDayOfWeekStringToInt(dayOfWeekString);
                this.daysOfWeekCheckboxes.get(dayOfWeek).setValue((Object)true);
            }
        }
    }

    private int convertMonthStringToInt(String month) {
        if (month.length() > 2) {
            DateTimeFormatter parser = DateTimeFormatter.ofPattern("MMM").withLocale(Locale.ENGLISH);
            TemporalAccessor accessor = parser.parse(StringUtils.capitalize((String)month.toLowerCase()));
            return accessor.get(ChronoField.MONTH_OF_YEAR) - 1;
        }
        return Integer.parseInt(month) - 1;
    }

    private int convertDayOfWeekStringToInt(String dayOfWeek) {
        if (dayOfWeek.length() > 1) {
            DateTimeFormatter parser = DateTimeFormatter.ofPattern("EEE").withLocale(Locale.ENGLISH);
            TemporalAccessor accessor = parser.parse(StringUtils.capitalize((String)dayOfWeek.toLowerCase()));
            return accessor.get(ChronoField.DAY_OF_WEEK) - 1;
        }
        return Integer.parseInt(dayOfWeek);
    }

    private String generateCronExpression() {
        Object seconds = "*";
        if (this.onSecondsField.isEnabled()) {
            seconds = this.onSecondsField.getValue();
        }
        if (this.repeatSecondsField.isEnabled()) {
            seconds = (String)seconds + "/" + this.repeatSecondsField.getValue();
        }
        Object minutes = "*";
        if (this.onMinutesField.isEnabled()) {
            minutes = this.onMinutesField.getValue();
        }
        if (this.repeatMinutesField.isEnabled()) {
            minutes = (String)minutes + "/" + this.repeatMinutesField.getValue();
        }
        Object hours = "*";
        if (this.onHoursField.isEnabled()) {
            hours = this.onHoursField.getValue();
        }
        if (this.repeatHoursField.isEnabled()) {
            hours = (String)hours + "/" + this.repeatHoursField.getValue();
        }
        Object daysOfMonth = "*";
        String months = "*";
        String daysOfWeek = "*";
        if (this.advancedLayout.isVisible()) {
            if (this.onDaysOfMonthField.isEnabled()) {
                daysOfMonth = this.onDaysOfMonthField.getValue();
                daysOfWeek = "?";
            }
            if (this.repeatDaysOfMonthField.isEnabled()) {
                daysOfMonth = (String)daysOfMonth + "/" + this.repeatDaysOfMonthField.getValue();
            }
            ArrayList<Integer> selectedMonths = new ArrayList<Integer>();
            for (Checkbox monthCheckbox : this.monthsCheckboxes) {
                if (!((Boolean)monthCheckbox.getValue()).booleanValue()) continue;
                selectedMonths.add(this.monthsCheckboxes.indexOf(monthCheckbox) + 1);
            }
            months = this.getListOfRangesString(selectedMonths);
            if (months.equals("")) {
                months = "*";
            }
            ArrayList<Integer> selectedDaysOfWeek = new ArrayList<Integer>();
            for (Checkbox dayOfWeekCheckbox : this.daysOfWeekCheckboxes) {
                if (!((Boolean)dayOfWeekCheckbox.getValue()).booleanValue()) continue;
                if (daysOfWeek.contains("?")) {
                    daysOfWeek = "";
                }
                selectedDaysOfWeek.add(this.daysOfWeekCheckboxes.indexOf(dayOfWeekCheckbox));
            }
            daysOfWeek = this.getListOfRangesString(selectedDaysOfWeek);
            if (daysOfWeek.equals("")) {
                daysOfWeek = "*";
            } else if (daysOfWeek.length() > 1 && ((String)daysOfMonth).contains("*")) {
                daysOfMonth = "?";
            }
        }
        return (String)seconds + " " + (String)minutes + " " + (String)hours + " " + (String)daysOfMonth + " " + months + " " + daysOfWeek;
    }

    private String getListOfRangesString(List<Integer> selection) {
        Object list = "";
        boolean isRange = false;
        for (int i2 = 0; i2 < selection.size(); ++i2) {
            int selectedInt = selection.get(i2);
            if (i2 == selection.size() - 1) {
                list = (String)list + selectedInt;
                continue;
            }
            if (selectedInt == selection.get(i2 + 1) - 1) {
                if (isRange) continue;
                list = (String)list + selectedInt + "-";
                isRange = true;
                continue;
            }
            list = (String)list + selectedInt + ",";
            isRange = false;
        }
        return list;
    }

    private boolean save() {
        Component selectedTab = this.tabs.getSelectedTab().getComponent();
        if (selectedTab.equals(this.periodicTab) && this.periodicBinder.validate().isOk()) {
            int valueInMs = Integer.parseInt(this.periodicField.getValue()) * 1000;
            String units = (String)this.periodicUnits.getValue();
            if (units.equals(this.controller.getMessage("minutes", new Object[0]))) {
                valueInMs *= 60;
            } else if (units.equals(this.controller.getMessage("hours", new Object[0]))) {
                valueInMs *= 3600;
            } else if (units.equals(this.controller.getMessage("days", new Object[0]))) {
                valueInMs *= 86400;
            }
            this.saveValue(String.valueOf(valueInMs));
            return true;
        }
        if (selectedTab.equals(this.scheduleTab) && this.scheduleBinder.validate().isOk()) {
            String cronExpression = this.generateCronExpression();
            if (CronExpression.isValidExpression((String)cronExpression)) {
                this.saveValue(cronExpression);
                return true;
            }
            return false;
        }
        if (selectedTab.equals(this.cronTab) && this.cronBinder.validate().isOk()) {
            this.saveValue(this.cronField.getValue());
            return true;
        }
        return false;
    }

    private void saveValue(String value) {
        if (this.formField != null) {
            this.formField.setValue(value);
        } else {
            IParameterService parameterService = this.controller.getSymmetricEngine().getParameterService();
            String key = this.param.getKey();
            if (value != null) {
                parameterService.saveParameter(this.externalId, this.nodeGroupId, key, (Object)value, this.controller.getConsoleUser().getUserId());
            } else {
                parameterService.deleteParameterWithUpdate(this.externalId, this.nodeGroupId, key);
            }
            String nodeId = this.controller.getSymmetricEngine().getNodeId();
            this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Edit Parameter", nodeId, nodeId, null, key));
            this.refresh(value);
        }
    }

    private void toggleCancelShortcut(boolean opened) {
        if (opened && this.cancelShortcutRegistration != null) {
            this.cancelShortcutRegistration.remove();
            this.cancelShortcutRegistration = null;
        } else if (!opened && this.cancelShortcutRegistration == null) {
            this.cancelShortcutRegistration = this.cancelButton.addClickShortcut(Key.ESCAPE, new KeyModifier[0]);
        }
    }

    public void refresh(String value) {
    }
}

