/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.canvas;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.jumpmind.symmetric.console.ui.canvas.TransformDataScreen;
import com.jumpmind.symmetric.console.ui.canvas.TransformDiagramDetail;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.internal.AllowInert;
import com.vaadin.flow.component.page.Page;
import elemental.json.JsonObject;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CssImport(value="./transform-diagram.css")
@JsModule.Container(value={@JsModule(value="./jsplumb.min.js"), @JsModule(value="./transform-diagram.js")})
@JavaScript(value="./transform-diagram.js")
public class TransformDiagram
extends Div {
    private static final Logger log = LoggerFactory.getLogger(TransformDiagram.class);
    private static final long serialVersionUID = 1L;
    private TransformDiagramDetail detail;
    private TransformDataScreen.TransformDialog dialog;

    public TransformDiagram(TransformDataScreen.TransformDialog dialog, TransformDiagramDetail detail) {
        this.dialog = dialog;
        this.detail = detail != null ? detail : new TransformDiagramDetail();
        this.setId("transform-diagram");
        this.addClassName("transform-diagram");
    }

    protected void onAttach(AttachEvent attachEvent) {
        Page page = UI.getCurrent().getPage();
        page.executeJs("window.com_jumpmind_symmetric_console_ui_screen_configure_TransformDiagram($0)", new Serializable[]{this.getElement()});
    }

    @ClientCallable
    private void onSelection(JsonObject json) {
        String sourceTableName = null;
        String targetTableName = null;
        if (json.hasKey("source")) {
            sourceTableName = json.getString("source").substring(7);
        }
        if (json.hasKey("target")) {
            targetTableName = json.getString("target").substring(7);
        }
        this.dialog.selectionEvent(sourceTableName, targetTableName);
    }

    @ClientCallable
    private void onConnection(JsonObject json) {
        this.dialog.linkCreatedEvent(json.getString("source").substring(7), json.getString("target").substring(7));
    }

    @ClientCallable
    private void onEditOverlayClick(JsonObject json) {
        this.dialog.editEvent(json.getString("source").substring(7), json.getString("target").substring(7));
    }

    @ClientCallable
    private void onMapColumnsOverlayClick(JsonObject json) {
        this.dialog.mapColumnsEvent(json.getString("source").substring(7), json.getString("target").substring(7));
    }

    @ClientCallable
    private void onDeleteOverlayClick(JsonObject json) {
        this.dialog.deleteEvent(json.getString("source").substring(7), json.getString("target").substring(7));
    }

    @AllowInert
    @ClientCallable
    public String getCurState() {
        ObjectMapper om = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true)).build();
        try {
            return om.writeValueAsString((Object)this.detail);
        }
        catch (JsonProcessingException e2) {
            log.warn("Failed to convert transform diagram state to JSON", (Throwable)e2);
            return null;
        }
    }

    public TransformDiagramDetail getDetail() {
        return this.detail;
    }
}

