/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.canvas;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.Strings;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;

public class TransformColumnsDiagramDetail {
    private Set<String> sourceColumnSet = new HashSet<String>();
    private Set<String> targetColumnSet = new HashSet<String>();
    private Set<String> sourcePkSet = new HashSet<String>();
    private Set<String> targetPkSet = new HashSet<String>();
    private String selectedSourceColumn;
    private String selectedTargetColumn;
    private Set<DiagramTransformColumn> transformColumnSet = new HashSet<DiagramTransformColumn>();
    private boolean autoMap;
    private boolean readOnly;

    public Set<String> getSourceColumnSet() {
        return this.sourceColumnSet;
    }

    public void setSourceColumnSet(Set<String> sourceColumnSet) {
        this.sourceColumnSet = sourceColumnSet;
    }

    public Set<String> getTargetColumnSet() {
        return this.targetColumnSet;
    }

    public void setTargetColumnSet(Set<String> targetColumnSet) {
        this.targetColumnSet = targetColumnSet;
    }

    public Set<String> getSourcePkSet() {
        return this.sourcePkSet;
    }

    public void setSourcePkSet(Set<String> sourcePkSet) {
        this.sourcePkSet = sourcePkSet;
    }

    public Set<String> getTargetPkSet() {
        return this.targetPkSet;
    }

    public void setTargetPkSet(Set<String> targetPkSet) {
        this.targetPkSet = targetPkSet;
    }

    public String getSelectedSourceColumn() {
        return this.selectedSourceColumn;
    }

    public void setSelectedSourceColumn(String selectedSourceColumn) {
        this.selectedSourceColumn = selectedSourceColumn;
    }

    public String getSelectedTargetColumn() {
        return this.selectedTargetColumn;
    }

    public void setSelectedTargetColumn(String selectedTargetColumn) {
        this.selectedTargetColumn = selectedTargetColumn;
    }

    public Set<DiagramTransformColumn> getTransformColumnSet() {
        return this.transformColumnSet;
    }

    public void addTransformColumn(String sourceColumn, String targetColumn, String transformType, boolean pk, TransformColumn.IncludeOnType includeOn) {
        for (DiagramTransformColumn transformColumn : this.transformColumnSet) {
            if (!Strings.CS.equals(sourceColumn, transformColumn.getSourceColumn()) || !Strings.CS.equals(targetColumn, transformColumn.getTargetColumn())) continue;
            switch (includeOn) {
                case ALL: {
                    transformColumn.setAllTransformType(transformType);
                    break;
                }
                case INSERT: {
                    transformColumn.setInsertTransformType(transformType);
                    break;
                }
                case UPDATE: {
                    transformColumn.setUpdateTransformType(transformType);
                    break;
                }
                case DELETE: {
                    transformColumn.setDeleteTransformType(transformType);
                }
            }
            if (pk) {
                transformColumn.setPk(pk);
            }
            return;
        }
        this.transformColumnSet.add(new DiagramTransformColumn(sourceColumn, targetColumn, transformType, pk, includeOn));
    }

    public boolean isAutoMap() {
        return this.autoMap;
    }

    public void setAutoMap(boolean autoMap) {
        this.autoMap = autoMap;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public class DiagramTransformColumn {
        private String sourceColumn;
        private String targetColumn;
        private transient String allTransformType;
        private transient String insertTransformType;
        private transient String updateTransformType;
        private transient String deleteTransformType;
        private boolean pk;

        public DiagramTransformColumn(String sourceColumn, String targetColumn, String transformType, boolean pk, TransformColumn.IncludeOnType includeOn) {
            this.sourceColumn = sourceColumn;
            this.targetColumn = targetColumn;
            this.pk = pk;
            switch (includeOn) {
                case ALL: {
                    this.allTransformType = transformType;
                    break;
                }
                case INSERT: {
                    this.insertTransformType = transformType;
                    break;
                }
                case UPDATE: {
                    this.updateTransformType = transformType;
                    break;
                }
                case DELETE: {
                    this.deleteTransformType = transformType;
                }
            }
        }

        public String getLabel() {
            boolean includeOnAll;
            boolean bl2 = includeOnAll = this.insertTransformType == null && this.updateTransformType == null && this.deleteTransformType == null;
            if ((this.allTransformType == null || this.allTransformType.equals("copy")) && (includeOnAll || "copy".equals(this.insertTransformType) && "copy".equals(this.updateTransformType) && "copy".equals(this.deleteTransformType))) {
                return null;
            }
            if (includeOnAll) {
                return this.allTransformType;
            }
            StringBuilder labelBuilder = new StringBuilder();
            this.addTransformTypeToLabel(labelBuilder, this.insertTransformType, "I");
            this.addTransformTypeToLabel(labelBuilder, this.updateTransformType, "U");
            this.addTransformTypeToLabel(labelBuilder, this.deleteTransformType, "D");
            return labelBuilder.toString();
        }

        private void addTransformTypeToLabel(StringBuilder labelBuilder, String transformType, String dmlType) {
            if (transformType != null) {
                if (!labelBuilder.isEmpty()) {
                    labelBuilder.append(", ");
                }
                labelBuilder.append(transformType + " (" + dmlType + ")");
            }
        }

        public String getSourceColumn() {
            return this.sourceColumn;
        }

        public String getTargetColumn() {
            return this.targetColumn;
        }

        public void setAllTransformType(String allTransformType) {
            this.allTransformType = allTransformType;
        }

        public void setInsertTransformType(String insertTransformType) {
            this.insertTransformType = insertTransformType;
        }

        public void setUpdateTransformType(String updateTransformType) {
            this.updateTransformType = updateTransformType;
        }

        public void setDeleteTransformType(String deleteTransformType) {
            this.deleteTransformType = deleteTransformType;
        }

        public boolean isPk() {
            return this.pk;
        }

        public void setPk(boolean pk) {
            this.pk = pk;
        }
    }
}

