/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.canvas;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jumpmind.symmetric.console.model.AbstractSubsetRule;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasTable;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasTransformTable;
import com.jumpmind.symmetric.console.ui.canvas.HasConfigCanvasTableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.symmetric.io.data.transform.TransformPoint;
import org.jumpmind.symmetric.io.data.transform.TransformTable;
import org.jumpmind.symmetric.service.impl.TransformService;

public class ConfigCanvasLink {
    private String targetEndpointGuid;
    private String targetEndpointId;
    private String sourceDiagramEndpointUuid;
    private String targetDiagramEndpointUuid;
    @JsonIgnore
    private List<ConfigCanvasTableGroup> tableGroupList = new ArrayList<ConfigCanvasTableGroup>();
    @JsonIgnore
    private List<AbstractSubsetRule> subsetRuleList = new ArrayList<AbstractSubsetRule>();
    @JsonIgnore
    private List<Set<ConfigCanvasTransformTable>> transformList = new ArrayList<Set<ConfigCanvasTransformTable>>();
    private boolean userCreated;
    private transient boolean isNew;
    private transient boolean removed;
    private int outgoingTableCount = 0;
    private int incomingTableCount = 0;
    private boolean outgoingTransformed;
    private boolean incomingTransformed;

    public ConfigCanvasLink(String targetEndpointGuid, String targetEndpointId, String sourceDiagramEndpointUuid, String targetDiagramEndpointUuid) {
        this(targetEndpointGuid, targetEndpointId, 0, 0);
        this.sourceDiagramEndpointUuid = sourceDiagramEndpointUuid;
        this.targetDiagramEndpointUuid = targetDiagramEndpointUuid;
    }

    public ConfigCanvasLink(String targetEndpointGuid, String targetEndpointId, int outgoingTableCount, int incomingTableCount) {
        this.targetEndpointGuid = targetEndpointGuid;
        this.targetEndpointId = targetEndpointId;
        this.outgoingTableCount = outgoingTableCount;
        this.incomingTableCount = incomingTableCount;
    }

    public void addTables(Set<ConfigCanvasTable> tableSet, String channelId, String triggerIdPrefix, String targetCatalog, String targetSchema, boolean useSourceCatalogSchema, String defaultTargetCatalog, String defaultTargetSchema) {
        triggerIdPrefix = StringUtils.trimToNull((String)triggerIdPrefix);
        String newTargetCatalog = (String)StringUtils.defaultIfBlank((CharSequence)targetCatalog, (CharSequence)defaultTargetCatalog);
        String newTargetSchema = (String)StringUtils.defaultIfBlank((CharSequence)targetSchema, (CharSequence)defaultTargetSchema);
        boolean mergedTables = false;
        for (ConfigCanvasTableGroup tableGroup : this.tableGroupList) {
            String tableGroupTargetCatalog = (String)StringUtils.defaultIfBlank((CharSequence)tableGroup.getTargetCatalog(), (CharSequence)defaultTargetCatalog);
            String tableGroupTargetSchema = (String)StringUtils.defaultIfBlank((CharSequence)tableGroup.getTargetSchema(), (CharSequence)defaultTargetSchema);
            if (!Strings.CS.equals(channelId, tableGroup.getChannelId()) || !Strings.CS.equals(triggerIdPrefix, tableGroup.getTriggerIdPrefix()) || !Strings.CS.equals(newTargetCatalog, tableGroupTargetCatalog) || !Strings.CS.equals(newTargetSchema, tableGroupTargetSchema) || useSourceCatalogSchema != tableGroup.isUseSourceCatalogSchema()) continue;
            tableGroup.addTables(tableSet);
            mergedTables = true;
            break;
        }
        if (!mergedTables) {
            this.tableGroupList.add(new ConfigCanvasTableGroup(tableSet, channelId, triggerIdPrefix, targetCatalog, targetSchema, useSourceCatalogSchema));
        }
        this.outgoingTableCount = this.getTableCount();
    }

    public void removeTables(int tableGroupIndex) {
        if (tableGroupIndex >= 0 && tableGroupIndex < this.tableGroupList.size()) {
            Set<ConfigCanvasTable> removedTableSet = this.tableGroupList.remove(tableGroupIndex).getTableSet();
            this.removeTablesFromSubsetRulesAndTransforms(removedTableSet);
            this.resetChecks(removedTableSet);
            this.outgoingTableCount = this.getTableCount();
        }
    }

    public void removeTables(Collection<ConfigCanvasTable> tablesToRemove) {
        ArrayList<ConfigCanvasTableGroup> newTableGroupList = new ArrayList<ConfigCanvasTableGroup>();
        for (ConfigCanvasTableGroup group : this.tableGroupList) {
            group.removeTables(tablesToRemove);
            if (group.getTableSet().isEmpty()) continue;
            newTableGroupList.add(group);
        }
        this.tableGroupList = newTableGroupList;
        this.removeTablesFromSubsetRulesAndTransforms(tablesToRemove);
        this.resetChecks(tablesToRemove);
        this.outgoingTableCount = this.getTableCount();
    }

    private void removeTablesFromSubsetRulesAndTransforms(Collection<ConfigCanvasTable> tablesToRemove) {
        ArrayList<AbstractSubsetRule> newSubsetRuleList = new ArrayList<AbstractSubsetRule>();
        for (AbstractSubsetRule rule : this.subsetRuleList) {
            rule.removeTables(tablesToRemove);
            if (rule.getTableSet().isEmpty()) continue;
            newSubsetRuleList.add(rule);
        }
        this.subsetRuleList = newSubsetRuleList;
        ArrayList<Set<ConfigCanvasTransformTable>> newTransformList = new ArrayList<Set<ConfigCanvasTransformTable>>();
        for (Set<ConfigCanvasTransformTable> transformSet : this.transformList) {
            HashSet<ConfigCanvasTransformTable> newTransformSet = new HashSet<ConfigCanvasTransformTable>();
            for (ConfigCanvasTransformTable transform : transformSet) {
                boolean removeEntry = false;
                String fullyQualifiedTableName = transform.getFullyQualifiedSourceTableName();
                for (ConfigCanvasTable tableToRemove : tablesToRemove) {
                    if (!fullyQualifiedTableName.equals(tableToRemove.getFullyQualifiedTargetTableName())) continue;
                    removeEntry = true;
                    break;
                }
                if (removeEntry) continue;
                newTransformSet.add(transform);
            }
            if (newTransformSet.isEmpty()) continue;
            newTransformList.add(newTransformSet);
        }
        this.transformList = newTransformList;
        this.outgoingTransformed = !this.transformList.isEmpty();
    }

    private void resetChecks(Collection<ConfigCanvasTable> tables) {
        for (ConfigCanvasTable table : tables) {
            table.setSkippedForeignKeyCheck(false);
            table.setSourceTableExists(null);
        }
    }

    public boolean hasTableBeenAdded(ConfigCanvasTable table, String defaultCatalog, String defaultSchema) {
        return this.tableGroupList.stream().anyMatch(g2 -> g2.containsByName(table.getCatalog(), table.getSchema(), table.getName(), defaultCatalog, defaultSchema));
    }

    @JsonIgnore
    public Set<ConfigCanvasTable> getAllTables() {
        HashSet<ConfigCanvasTable> tableSet = new HashSet<ConfigCanvasTable>();
        for (ConfigCanvasTableGroup tableGroup : this.tableGroupList) {
            tableSet.addAll(tableGroup.getTableSet());
        }
        return tableSet;
    }

    @JsonIgnore
    private int getTableCount() {
        int tableCount = 0;
        for (ConfigCanvasTableGroup tableGroup : this.tableGroupList) {
            tableCount += tableGroup.getTableSet().size();
        }
        return tableCount;
    }

    public ConfigCanvasTableGroup getTableGroup(String channelId, String triggerIdPrefix, String targetCatalog, String targetSchema, boolean useSourceCatalogSchema, String defaultTargetCatalog, String defaultTargetSchema) {
        String searchTargetCatalog = (String)StringUtils.defaultIfBlank((CharSequence)targetCatalog, (CharSequence)defaultTargetCatalog);
        String searchTargetSchema = (String)StringUtils.defaultIfBlank((CharSequence)targetSchema, (CharSequence)defaultTargetSchema);
        for (ConfigCanvasTableGroup tableGroup : this.tableGroupList) {
            String tableGroupTargetCatalog = (String)StringUtils.defaultIfBlank((CharSequence)tableGroup.getTargetCatalog(), (CharSequence)defaultTargetCatalog);
            String tableGroupTargetSchema = (String)StringUtils.defaultIfBlank((CharSequence)tableGroup.getTargetSchema(), (CharSequence)defaultTargetSchema);
            if (!Strings.CS.equals(channelId, tableGroup.getChannelId()) || !Strings.CS.equals(triggerIdPrefix, tableGroup.getTriggerIdPrefix()) || !Strings.CS.equals(searchTargetCatalog, tableGroupTargetCatalog) || !Strings.CS.equals(searchTargetSchema, tableGroupTargetSchema) || useSourceCatalogSchema != tableGroup.isUseSourceCatalogSchema()) continue;
            return tableGroup;
        }
        return null;
    }

    public AbstractSubsetRule getSubsetRule(String subsetRuleName) {
        for (AbstractSubsetRule subsetRule : this.subsetRuleList) {
            if (!subsetRule.getName().equals(subsetRuleName)) continue;
            return subsetRule;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addTransformIfInUse(TransformService.TransformTableNodeGroupLink newTransform, String defaultSourceCatalog, String defaultSourceSchema) {
        void var10_15;
        String originalSourceCatalog = null;
        String originalSourceSchema = null;
        boolean inUse = false;
        String sourceCatalog = newTransform.getSourceCatalogName();
        String sourceSchema = newTransform.getSourceSchemaName();
        for (ConfigCanvasTableGroup configCanvasTableGroup : this.tableGroupList) {
            if (Strings.CS.equals(sourceCatalog, configCanvasTableGroup.getTargetCatalog()) && Strings.CS.equals(sourceSchema, configCanvasTableGroup.getTargetSchema())) {
                for (ConfigCanvasTable table : configCanvasTableGroup.getTableSet()) {
                    if (!table.getName().equals(newTransform.getSourceTableName())) continue;
                    originalSourceCatalog = table.getCatalog();
                    originalSourceSchema = table.getSchema();
                    inUse = true;
                    break;
                }
            }
            if (!inUse) continue;
            break;
        }
        TransformPoint transformPoint = newTransform.getTransformPoint();
        if (!inUse) {
            if (TransformPoint.LOAD.equals((Object)transformPoint)) {
                block2: for (Set<ConfigCanvasTransformTable> set : this.transformList) {
                    if (!TransformPoint.EXTRACT.equals((Object)set.iterator().next().getTransformPoint())) continue;
                    for (ConfigCanvasTransformTable extractTransform : set) {
                        if (!Strings.CS.equals(sourceCatalog, extractTransform.getTargetCatalogName()) || !Strings.CS.equals(sourceSchema, extractTransform.getTargetSchemaName()) || !newTransform.getSourceTableName().equals(extractTransform.getTargetTableName())) continue;
                        originalSourceCatalog = extractTransform.getOriginalSourceCatalogName();
                        originalSourceSchema = extractTransform.getOriginalSourceSchemaName();
                        inUse = true;
                        continue block2;
                    }
                }
            }
            if (!inUse) {
                return false;
            }
        }
        if (newTransform.getTargetTableName() == null) {
            newTransform.setTargetTableName(newTransform.getSourceTableName());
        }
        this.outgoingTransformed = true;
        Set<ConfigCanvasTransformTable> set = this.getTransformSet(transformPoint, originalSourceCatalog, originalSourceSchema, defaultSourceCatalog, defaultSourceSchema);
        if (set == null) {
            HashSet hashSet = new HashSet();
            this.transformList.add(hashSet);
        }
        return var10_15.add(new ConfigCanvasTransformTable((TransformTable)newTransform, originalSourceCatalog, originalSourceSchema));
    }

    public void addTransforms(Set<ConfigCanvasTransformTable> newTransformSet, String defaultSourceCatalog, String defaultSourceSchema, int index) {
        if (index > -1) {
            this.transformList.add(index, newTransformSet);
        } else {
            ConfigCanvasTransformTable firstTransform = newTransformSet.iterator().next();
            Set<ConfigCanvasTransformTable> existingTransformSet = this.getTransformSet(firstTransform.getTransformPoint(), firstTransform.getOriginalSourceCatalogName(), firstTransform.getOriginalSourceSchemaName(), defaultSourceCatalog, defaultSourceSchema);
            if (existingTransformSet != null) {
                existingTransformSet.addAll(newTransformSet);
            } else {
                this.transformList.add(newTransformSet);
            }
        }
        this.outgoingTransformed = true;
    }

    public void removeTransforms(int index) {
        this.transformList.remove(index);
        if (this.transformList.isEmpty()) {
            this.outgoingTransformed = false;
        }
    }

    public Set<ConfigCanvasTransformTable> getTransformSet(TransformPoint transformPoint, String originalSourceCatalog, String originalSourceSchema, String defaultSourceCatalog, String defaultSourceSchema) {
        String searchSourceCatalog = (String)StringUtils.defaultIfBlank((CharSequence)originalSourceCatalog, (CharSequence)defaultSourceCatalog);
        String searchSourceSchema = (String)StringUtils.defaultIfBlank((CharSequence)originalSourceSchema, (CharSequence)defaultSourceSchema);
        for (Set<ConfigCanvasTransformTable> transformSet : this.transformList) {
            ConfigCanvasTransformTable firstTransform = transformSet.iterator().next();
            String transformSourceCatalog = (String)StringUtils.defaultIfBlank((CharSequence)firstTransform.getOriginalSourceCatalogName(), (CharSequence)defaultSourceCatalog);
            String transformSourceSchema = (String)StringUtils.defaultIfBlank((CharSequence)firstTransform.getOriginalSourceSchemaName(), (CharSequence)defaultSourceSchema);
            if (!transformPoint.equals((Object)firstTransform.getTransformPoint()) || !Strings.CS.equals(searchSourceCatalog, transformSourceCatalog) || !Strings.CS.equals(searchSourceSchema, transformSourceSchema)) continue;
            return transformSet;
        }
        return null;
    }

    public void checkForConfigChanges(boolean endpointRemoved, Collection<String> addedTableNames, Collection<String> addedSubsetRuleNames, Collection<String> addedTransformNames, Collection<String> removedTableNames, Collection<String> removedSubsetRuleNames, Collection<String> removedTransformNames) {
        if (endpointRemoved || this.removed) {
            for (ConfigCanvasTableGroup configCanvasTableGroup : this.tableGroupList) {
                removedTableNames.addAll(configCanvasTableGroup.getTableSet().stream().map(t2 -> t2.getName()).collect(Collectors.toList()));
            }
            removedSubsetRuleNames.addAll(this.subsetRuleList.stream().map(r2 -> r2.getName()).collect(Collectors.toList()));
            for (Set set : this.transformList) {
                removedTransformNames.addAll(set.stream().map(t2 -> t2.getSourceTableName() + " to " + t2.getTargetTableName()).collect(Collectors.toList()));
            }
        } else {
            for (ConfigCanvasTableGroup configCanvasTableGroup : this.tableGroupList) {
                if (configCanvasTableGroup.isRemoved()) {
                    removedTableNames.addAll(configCanvasTableGroup.getTableSet().stream().map(t2 -> t2.getName()).collect(Collectors.toList()));
                    continue;
                }
                addedTableNames.addAll(configCanvasTableGroup.getTableSet().stream().filter(t2 -> !t2.isRemoved()).map(t2 -> t2.getName()).collect(Collectors.toList()));
                removedTableNames.addAll(configCanvasTableGroup.getTableSet().stream().filter(t2 -> t2.isRemoved()).map(t2 -> t2.getName()).collect(Collectors.toList()));
            }
            addedSubsetRuleNames.addAll(this.subsetRuleList.stream().filter(r2 -> !r2.isRemoved()).map(r2 -> r2.getName()).collect(Collectors.toList()));
            removedSubsetRuleNames.addAll(this.subsetRuleList.stream().filter(r2 -> r2.isRemoved()).map(r2 -> r2.getName()).collect(Collectors.toList()));
            for (Set set : this.transformList) {
                addedTransformNames.addAll(set.stream().filter(t2 -> !t2.isRemoved()).map(t2 -> t2.getSourceTableName() + " to " + t2.getTargetTableName()).collect(Collectors.toList()));
                removedTransformNames.addAll(set.stream().filter(t2 -> t2.isRemoved()).map(t2 -> t2.getSourceTableName() + " to " + t2.getTargetTableName()).collect(Collectors.toList()));
            }
        }
    }

    public void clear() {
        this.tableGroupList.clear();
        this.subsetRuleList.clear();
        this.transformList.clear();
        this.outgoingTableCount = 0;
        this.incomingTableCount = 0;
        this.outgoingTransformed = false;
        this.incomingTransformed = false;
    }

    public String getTargetEndpointGuid() {
        return this.targetEndpointGuid;
    }

    public String getTargetEndpointId() {
        return this.targetEndpointId;
    }

    public void setTargetEndpointId(String targetEndpointId) {
        this.targetEndpointId = targetEndpointId;
    }

    public String getSourceDiagramEndpointUuid() {
        return this.sourceDiagramEndpointUuid;
    }

    public String getTargetDiagramEndpointUuid() {
        return this.targetDiagramEndpointUuid;
    }

    public List<ConfigCanvasTableGroup> getTableGroupList() {
        return this.tableGroupList;
    }

    public List<AbstractSubsetRule> getSubsetRuleList() {
        return this.subsetRuleList;
    }

    public List<Set<ConfigCanvasTransformTable>> getTransformList() {
        return this.transformList;
    }

    public boolean isUserCreated() {
        return this.userCreated;
    }

    public void setUserCreated(boolean userCreated) {
        this.userCreated = userCreated;
    }

    @JsonIgnore
    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
        if (isNew) {
            this.setTransformsNew(true);
            this.removed = false;
        }
    }

    public void setTransformsNew(boolean isNew) {
        for (Set<ConfigCanvasTransformTable> transformSet : this.transformList) {
            for (ConfigCanvasTransformTable transform : transformSet) {
                transform.setNew(isNew);
            }
        }
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
        if (removed) {
            this.setNew(false);
            this.setTransformsNew(false);
        }
    }

    public int getOutgoingTableCount() {
        return this.outgoingTableCount;
    }

    public void setOutgoingTableCount(int outgoingTableCount) {
        this.outgoingTableCount = outgoingTableCount;
    }

    public int getIncomingTableCount() {
        return this.incomingTableCount;
    }

    public void setIncomingTableCount(int incomingTableCount) {
        this.incomingTableCount = incomingTableCount;
    }

    public boolean isOutgoingTransformed() {
        return this.outgoingTransformed;
    }

    public void setOutgoingTransformed(boolean outgoingTransformed) {
        this.outgoingTransformed = outgoingTransformed;
    }

    public boolean isIncomingTransformed() {
        return this.incomingTransformed;
    }

    public void setIncomingTransformed(boolean incomingTransformed) {
        this.incomingTransformed = incomingTransformed;
    }

    public class ConfigCanvasTableGroup
    extends HasConfigCanvasTableSet {
        private String channelId;
        private String triggerIdPrefix;
        private String targetCatalog;
        private String targetSchema;
        private boolean useSourceCatalogSchema;
        private transient boolean removed;

        public ConfigCanvasTableGroup(Collection<ConfigCanvasTable> tableCollection, String channelId, String triggerIdPrefix, String targetCatalog, String targetSchema, boolean useSourceCatalogSchema) {
            this.channelId = channelId;
            this.triggerIdPrefix = triggerIdPrefix;
            this.targetCatalog = targetCatalog;
            this.targetSchema = targetSchema;
            this.useSourceCatalogSchema = useSourceCatalogSchema;
            this.addTables(tableCollection);
        }

        public void addTables(Collection<ConfigCanvasTable> tablesToAdd) {
            this.tableSet.addAll(tablesToAdd);
        }

        public void removeTables(Collection<ConfigCanvasTable> tablesToRemove) {
            HashSet<ConfigCanvasTable> newTableSet = new HashSet<ConfigCanvasTable>();
            for (ConfigCanvasTable table : this.tableSet) {
                boolean removeTable = false;
                for (ConfigCanvasTable tableToRemove : tablesToRemove) {
                    if (!Strings.CS.equals(table.getCatalog(), tableToRemove.getCatalog()) || !Strings.CS.equals(table.getSchema(), tableToRemove.getSchema()) || !table.getName().equals(tableToRemove.getName())) continue;
                    removeTable = true;
                    break;
                }
                if (removeTable) continue;
                newTableSet.add(table);
            }
            this.tableSet = newTableSet;
        }

        public String getChannelId() {
            return this.channelId;
        }

        public String getTriggerIdPrefix() {
            return this.triggerIdPrefix;
        }

        public String getTargetCatalog() {
            return this.targetCatalog;
        }

        public String getTargetSchema() {
            return this.targetSchema;
        }

        public boolean isUseSourceCatalogSchema() {
            return this.useSourceCatalogSchema;
        }

        public boolean isRemoved() {
            return this.removed;
        }

        public void setRemoved(boolean removed) {
            this.removed = removed;
        }
    }
}

