/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.canvas;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.jumpmind.symmetric.console.impl.F;
import com.jumpmind.symmetric.console.impl.G;
import com.jumpmind.symmetric.console.impl.au;
import com.jumpmind.symmetric.console.impl.c;
import com.jumpmind.symmetric.console.impl.dW;
import com.jumpmind.symmetric.console.impl.eo;
import com.jumpmind.symmetric.console.model.AbstractSubsetRule;
import com.jumpmind.symmetric.console.model.ColumnRule;
import com.jumpmind.symmetric.console.model.LookupRule;
import com.jumpmind.symmetric.console.model.SubselectRule;
import com.jumpmind.symmetric.console.model.Violation;
import com.jumpmind.symmetric.console.ui.canvas.AbstractSidebarScreen;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasContext;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasDiagram;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasDiagramDetail;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasEndpoint;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasLink;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasPosition;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasTable;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasTransformTable;
import com.jumpmind.symmetric.console.ui.canvas.DefineEndpointScreen;
import com.jumpmind.symmetric.console.ui.canvas.HasConfigCanvasTableSet;
import com.jumpmind.symmetric.console.ui.canvas.ISidebarScreen;
import com.jumpmind.symmetric.console.ui.canvas.SelectTablesScreen;
import com.jumpmind.symmetric.console.ui.canvas.TransformDataScreen;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.M;
import com.jumpmind.symmetric.console.ui.common.X;
import com.jumpmind.symmetric.console.ui.common.ad;
import com.jumpmind.symmetric.console.ui.common.ae;
import com.jumpmind.symmetric.console.ui.common.as;
import com.jumpmind.symmetric.console.ui.common.o;
import com.jumpmind.symmetric.console.ui.common.s;
import com.jumpmind.symmetric.console.ui.d;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.component.Shortcuts;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.confirmdialog.ConfirmDialog;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H4;
import com.vaadin.flow.component.html.Hr;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.ListItem;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.html.UnorderedList;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.SvgIcon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.shared.Tooltip;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.db.sql.SqlScript;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.security.SecurityServiceFactory;
import org.jumpmind.symmetric.ClientSymmetricEngine;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SyntaxParsingException;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.model.ColumnMatchExpression;
import org.jumpmind.symmetric.model.FileTriggerRouter;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.LookupTableDataRouter;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.service.impl.DataLoaderService;
import org.jumpmind.symmetric.service.impl.TransformService;
import org.jumpmind.symmetric.util.PropertiesUtil;
import org.jumpmind.util.FormatUtils;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigCanvas
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private I controller;
    private String engineName;
    private boolean initialSetup;
    private boolean addingNewReplication;
    private ConfigCanvasContext context = new ConfigCanvasContext();
    private ConfigCanvasPosition position = new ConfigCanvasPosition();
    private ConfigCanvasEndpoint firstEndpoint;
    private ConfigCanvasEndpoint secondEndpoint;
    private URL url;
    private HorizontalLayout ribbon;
    private Scroller diagramScroller;
    private ConfigCanvasDiagram diagram;
    private ad navigationDiv;
    private Button newReplicationButton;
    private Div newReplicationDiv;
    private Tooltip newReplicationTooltip;
    private Button deleteButton;
    private Div deleteDiv;
    private Tooltip deleteTooltip;
    private ad diagramActionDiv;
    private ad deploymentDiv;
    private Span totalCountSpan;
    private Span endpointSpan;
    private HorizontalLayout undeployedCountLayout;
    private HorizontalLayout remoteCountLayout;
    private HorizontalLayout pendingCountLayout;
    private HorizontalLayout deployedCountLayout;
    private Button resetButton;
    private Button deployButton;
    private Tooltip deployTooltip;
    private eo deployWizard;
    private int deploymentDivHeight = 190;
    private int windowHeight;
    private int windowWidth;
    private ShortcutRegistration deleteShortcutRegistration;
    private Map<s.a, Image> endpointImageMap = new HashMap<s.a, Image>();
    private o endpointPlaceholderIcon;
    private String undeployedIconSrc;
    private String pendingIconSrc;
    private VerticalLayout sidebar;
    private HorizontalLayout sidebarHeader;
    private o sidebarCloseIcon;
    private Tooltip sidebarCloseIconTooltip;
    private ae progressStepper;
    private VerticalLayout sidebarScreenLayout;
    private HorizontalLayout sidebarErrorMessageLayout;
    private Div helpAnchorDiv;
    private HorizontalLayout sidebarFooter;
    private Button previousButton;
    private Button nextButton;
    private Div nextDiv;
    private Tooltip nextTooltip;
    private ShortcutRegistration nextButtonShortcutRegistration;
    private LinkedList<AbstractSidebarScreen> screenHistory = new LinkedList();
    private EndpointDeploymentRefresher endpointDeploymentRefresher;
    private JsonFileRefresher jsonFileRefresher;
    private boolean initializing = true;
    private boolean forceRefreshJsonFile;

    public ConfigCanvas(final I controller, au configScreen, int windowHeight, int windowWidth) {
        this.controller = controller;
        this.setSizeFull();
        this.setMargin(false);
        this.setPadding(false);
        this.setSpacing(false);
        this.reset(false, false, false);
        UI.getCurrent().getPage().fetchCurrentURL((SerializableConsumer & Serializable)url -> {
            this.url = url;
        });
        this.ribbon = new HorizontalLayout();
        this.ribbon.getStyle().set("background-color", "var(--lumo-warning-color)").set("color", "var(--lumo-warning-contrast-color)").set("padding", "5px");
        this.ribbon.addAndExpand(new Component[]{new Span()});
        Icon ribbonIcon = new Icon(VaadinIcon.WARNING);
        ribbonIcon.setSize("1em");
        this.ribbon.add(new Component[]{ribbonIcon, new Span(controller.getMessage("You're editing the Configure Canvas. Changes made here will not take effect unless deployed.", new Object[0]))});
        this.ribbon.addAndExpand(new Component[]{new Span()});
        this.ribbon.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.CENTER);
        Div sizingDiv = new Div();
        sizingDiv.setHeight("10000px");
        sizingDiv.setWidth("10000px");
        this.diagramScroller = new Scroller((Component)sizingDiv);
        this.diagramScroller.setHeightFull();
        this.diagramScroller.setWidth("45%");
        VerticalLayout navigationLayout = configScreen.a(true);
        navigationLayout.getStyle().set("padding", "8px");
        this.navigationDiv = new ad();
        this.navigationDiv.setHeight("72px");
        this.navigationDiv.setWidth("200px");
        this.navigationDiv.setLeft("20px");
        this.navigationDiv.add(new Component[]{navigationLayout});
        SvgIcon newReplicationIcon = as.createSvgIcon(controller.getContextPath(), "/icons/database_o.svg");
        newReplicationIcon.setSize("16px");
        newReplicationIcon.addClassName("svg-contrast");
        newReplicationIcon.getStyle().set("min-width", "16px").set("min-height", "16px").set("margin-bottom", "3px");
        this.newReplicationButton = new Button(controller.getMessage("New Replication", new Object[0]), (Component)newReplicationIcon, (ComponentEventListener & Serializable)event -> this.executeCallback(this.screenHistory.isEmpty() ? null : this.screenHistory.getLast(), (Command & Serializable)() -> {
            this.closeSidebarAndClearSelection(true, true);
            this.addingNewReplication = true;
            this.progressStepper.reset();
            if (this.context.getEndpointList().size() > 0) {
                this.firstEndpoint = null;
                this.progressStepper.setStepName(0, controller.getMessage("First Endpoint", new Object[0]));
            } else {
                this.firstEndpoint = this.context.addEndpoint();
                this.position.updateEndpointCoordinates(this.firstEndpoint);
                this.progressStepper.setStepName(0, this.firstEndpoint.getId());
            }
            this.secondEndpoint = null;
            this.progressStepper.setStepName(1, controller.getMessage("Second Endpoint", new Object[0]));
            this.progressStepper.setVisible(true);
            this.nextDiv.setVisible(true);
            this.newReplicationButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.newReplicationTooltip.setText(controller.getMessage("You're already adding a new replication", new Object[0]));
            this.deleteTooltip.setText(controller.getMessage("Select an undeployed endpoint or a link first", new Object[0]));
            if (this.firstEndpoint != null) {
                this.refreshEndpoints();
            }
            this.redrawDiagram();
            this.nextScreen();
            this.updateDivPositions(this.windowHeight, this.windowWidth);
        }));
        this.newReplicationButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE, ButtonVariant.LUMO_SMALL});
        this.newReplicationButton.addClassName("contrast");
        boolean readOnly = this.isReadOnly();
        this.newReplicationButton.setEnabled(!this.initialSetup && !readOnly);
        this.newReplicationDiv = new Div(new Component[]{this.newReplicationButton});
        this.newReplicationTooltip = Tooltip.forComponent((Component)this.newReplicationDiv);
        if (this.initialSetup) {
            this.newReplicationTooltip.setText(controller.getMessage("Finish initial setup first", new Object[0]));
        } else if (readOnly) {
            this.newReplicationTooltip.setText(controller.getMessage("Requires write permission", new Object[0]));
        } else {
            this.newReplicationTooltip.setText(controller.getMessage("Add a new link between new or existing endpoints", new Object[0]));
        }
        Icon deleteIcon = new Icon(VaadinIcon.TRASH);
        deleteIcon.setSize("16px");
        deleteIcon.addClassName("contrast");
        deleteIcon.getStyle().set("min-width", "16px").set("min-height", "16px").set("padding", "0").set("margin-bottom", "3px");
        this.deleteButton = new Button(controller.getMessage("Delete", new Object[0]), (Component)deleteIcon, (ComponentEventListener & Serializable)event -> this.deleteSelection());
        this.deleteButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE, ButtonVariant.LUMO_SMALL});
        this.deleteButton.addClassName("contrast");
        this.deleteButton.setEnabled(this.initialSetup);
        this.deleteDiv = new Div(new Component[]{this.deleteButton});
        this.deleteDiv.getStyle().set("margin-left", "16px");
        this.deleteTooltip = Tooltip.forComponent((Component)this.deleteDiv).withText(controller.getMessage(readOnly ? "Requires write permission" : "Select an undeployed endpoint or a link first", new Object[0]));
        HorizontalLayout diagramActionLayout = new HorizontalLayout(new Component[]{this.newReplicationDiv, this.deleteDiv});
        diagramActionLayout.getStyle().set("padding", "8px 0 0 16px");
        this.diagramActionDiv = new ad();
        this.diagramActionDiv.setHeight("40px");
        this.diagramActionDiv.setWidth("256px");
        this.diagramActionDiv.add(new Component[]{diagramActionLayout});
        this.totalCountSpan = new Span();
        this.totalCountSpan.getStyle().set("margin-bottom", "-4px").set("color", "var(--lumo-contrast)").set("font-size", "var(--lumo-font-size-xxl)");
        this.endpointSpan = new Span();
        this.endpointSpan.setClassName("less-contrast");
        this.endpointSpan.getStyle().set("font-size", "var(--lumo-font-size-s)");
        HorizontalLayout totalCountLayout = new HorizontalLayout(new Component[]{this.totalCountSpan, this.endpointSpan});
        totalCountLayout.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.END);
        totalCountLayout.getStyle().set("margin-bottom", "2px").set("gap", "var(--lumo-space-s)");
        SvgIcon undeployedIcon = as.createSvgIcon(controller.getContextPath(), "/icons/draft.svg");
        undeployedIcon.addClassName("svg-less-contrast");
        undeployedIcon.setSize("20px");
        undeployedIcon.getStyle().set("min-width", "20px").set("min-height", "20px").set("margin-left", "-2px");
        Span undeployedCountSpan = new Span();
        undeployedCountSpan.getStyle().set("padding-left", "8px").set("color", "var(--lumo-contrast)").set("font-size", "var(--lumo-font-size-s)");
        this.undeployedCountLayout = new HorizontalLayout(new Component[]{undeployedIcon, undeployedCountSpan});
        this.undeployedCountLayout.setSpacing(false);
        this.undeployedCountLayout.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.CENTER);
        this.undeployedCountLayout.getStyle().set("padding-top", "4px");
        Icon remoteIcon = new Icon(VaadinIcon.CHECK_CIRCLE_O);
        remoteIcon.addClassName("less-contrast");
        remoteIcon.setSize("16px");
        remoteIcon.getStyle().set("min-width", "16px").set("min-height", "16px");
        Span remoteCountSpan = new Span();
        remoteCountSpan.getStyle().set("padding-left", "10px").set("color", "var(--lumo-contrast)").set("font-size", "var(--lumo-font-size-s)");
        this.remoteCountLayout = new HorizontalLayout(new Component[]{remoteIcon, remoteCountSpan});
        this.remoteCountLayout.setSpacing(false);
        this.remoteCountLayout.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.CENTER);
        this.remoteCountLayout.getStyle().set("padding-top", "4px");
        SvgIcon pendingIcon = as.createSvgIcon(controller.getContextPath(), "/icons/pending.svg");
        pendingIcon.addClassName("svg-warning");
        pendingIcon.setSize("20px");
        pendingIcon.getStyle().set("min-width", "20px").set("min-height", "20px").set("margin-left", "-2px");
        Span pendingCountSpan = new Span();
        pendingCountSpan.getStyle().set("padding-left", "8px").set("color", "var(--lumo-contrast)").set("font-size", "var(--lumo-font-size-s)");
        this.pendingCountLayout = new HorizontalLayout(new Component[]{pendingIcon, pendingCountSpan});
        this.pendingCountLayout.setSpacing(false);
        this.pendingCountLayout.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.CENTER);
        this.pendingCountLayout.getStyle().set("padding-top", "4px");
        Icon deployedIcon = new Icon(VaadinIcon.CHECK_CIRCLE);
        deployedIcon.setColor("var(--lumo-success-color)");
        deployedIcon.setSize("16px");
        deployedIcon.getStyle().set("min-width", "16px").set("min-height", "16px");
        Span deployedCountSpan = new Span();
        deployedCountSpan.getStyle().set("padding-left", "10px").set("color", "var(--lumo-contrast)").set("font-size", "var(--lumo-font-size-s)");
        this.deployedCountLayout = new HorizontalLayout(new Component[]{deployedIcon, deployedCountSpan});
        this.deployedCountLayout.setSpacing(false);
        this.deployedCountLayout.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.CENTER);
        this.deployedCountLayout.getStyle().set("padding-top", "4px");
        this.resetButton = new Button(controller.getMessage("Reset", new Object[0]), (ComponentEventListener & Serializable)event -> {
            ConfirmDialog confirmResetDialog = new ConfirmDialog(controller.getMessage("Are you sure you want to reset the Configure Canvas?", new Object[0]), controller.getMessage(controller.getSymmetricEngine() != null ? "Your changes will be lost and the Canvas will display the current configuration as it exists in the database. You cannot undo this action." : "Your changes will be lost and you will be sent back to the Welcome screen. You cannot undo this action.", new Object[0]), controller.getMessage("Reset", new Object[0]), (ComponentEventListener & Serializable)e2 -> this.reset(true, true, false));
            Button cancelButton = new Button(controller.getMessage("Cancel", new Object[0]));
            cancelButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
            cancelButton.getStyle().set("margin-right", "16px");
            confirmResetDialog.setRejectable(true);
            confirmResetDialog.setRejectButton((Component)cancelButton);
            confirmResetDialog.open();
        });
        this.resetButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        this.resetButton.setTooltipText(controller.getMessage("Discard your changes and restore the Canvas to its original state. You will be prompted to confirm this action.", new Object[0]));
        this.deployButton = new Button(controller.getMessage("Deploy", new Object[0]), (ComponentEventListener & Serializable)event -> {
            boolean foundLink = false;
            boolean foundTables = false;
            for (ConfigCanvasEndpoint endpoint : this.context.getEndpointList()) {
                for (ConfigCanvasLink link : endpoint.getLinkList()) {
                    foundLink = true;
                    if (link.getAllTables().isEmpty()) continue;
                    foundTables = true;
                    break;
                }
                if (!foundTables) continue;
                break;
            }
            AbstractSidebarScreen currentScreen = this.screenHistory.isEmpty() ? null : this.screenHistory.getLast();
            Command & Serializable callback = (Command & Serializable)() -> {
                this.deployButton.setEnabled(false);
                this.closeSidebarAndClearSelection(false, false);
                new M<Void>(controller.getMessage("Loading Deploy Wizard...", new Object[0]), new M.a<Void>(){

                    @Override
                    public Void doWork() {
                        ConfigCanvas.this.deployWizard = new eo(controller, ConfigCanvas.this);
                        ConfigCanvas.this.deployWizard.addOpenedChangeListener((ComponentEventListener & Serializable)e2 -> {
                            if (!e2.isOpened()) {
                                ConfigCanvas.this.deployButton.setEnabled(true);
                            }
                        });
                        return null;
                    }

                    @Override
                    public void doUI(Void data) {
                        ConfigCanvas.this.deployWizard.f();
                        ConfigCanvas.this.deployWizard.open();
                    }
                }, controller.getBackgroundRefresherService(), null, false, false).show();
            };
            if (foundTables) {
                this.executeCallback(currentScreen, callback);
            } else {
                String header = controller.getMessage(foundLink ? "Are you sure you want to deploy with no tables?" : "Are you sure you want to deploy with no links or tables?", new Object[0]);
                String description = controller.getMessage(foundLink ? "You have not configured any tables for replication. If you proceed with deployment, then no data will be replicated." : "You have not configured any links between endpoints or any tables. If you proceed with deployment, then no data will be replicated.", new Object[0]);
                ConfirmDialog confirmDialog = new ConfirmDialog(header, description, controller.getMessage("Deploy", new Object[0]), (ComponentEventListener & Serializable)e2 -> this.executeCallback(currentScreen, callback));
                Button cancelButton = new Button(controller.getMessage("Cancel", new Object[0]));
                cancelButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
                cancelButton.getStyle().set("margin-right", "16px");
                confirmDialog.setRejectable(true);
                confirmDialog.setRejectButton((Component)cancelButton);
                confirmDialog.open();
            }
        });
        this.deployButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL, ButtonVariant.LUMO_PRIMARY});
        this.deployButton.getStyle().set("margin-right", "16px");
        Div deployDiv = new Div(new Component[]{this.deployButton});
        this.deployTooltip = Tooltip.forComponent((Component)deployDiv);
        this.updateDeployButtonEnabled();
        HorizontalLayout deploymentButtonLayout = new HorizontalLayout();
        deploymentButtonLayout.addAndExpand(new Component[]{new Span()});
        deploymentButtonLayout.add(new Component[]{this.resetButton, deployDiv});
        deploymentButtonLayout.getStyle().set("margin-top", "4px");
        VerticalLayout deploymentLayout = new VerticalLayout(new Component[]{totalCountLayout, this.undeployedCountLayout, this.remoteCountLayout, this.pendingCountLayout, this.deployedCountLayout, deploymentButtonLayout});
        deploymentLayout.setMargin(false);
        deploymentLayout.setSpacing(false);
        deploymentLayout.getStyle().set("padding", "0 0 0 8px");
        this.deploymentDiv = new ad();
        this.deploymentDiv.setWidth("264px");
        this.deploymentDiv.setLeft("20px");
        this.deploymentDiv.add(new Component[]{deploymentLayout});
        this.sidebarHeader = new HorizontalLayout();
        this.sidebarHeader.setWidthFull();
        this.sidebarHeader.getStyle().set("max-width", "100%").set("margin-top", "8px");
        this.sidebarHeader.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.CENTER);
        Hr divider = new Hr();
        divider.getStyle().set("margin", "8px 0 0");
        this.progressStepper = new ae(controller.getMessage("Endpoint_1", new Object[0]), controller.getMessage("Endpoint_2", new Object[0]), controller.getMessage("Tables", new Object[0]), controller.getMessage("Subset", new Object[0]), controller.getMessage("Transform", new Object[0]));
        this.progressStepper.setWidth("95%");
        this.progressStepper.getStyle().set("max-width", "95%").set("margin", "16px 0 0 16px");
        this.sidebarScreenLayout = new VerticalLayout();
        this.sidebarScreenLayout.setPadding(false);
        this.sidebarScreenLayout.getStyle().set("overflow-y", "auto");
        this.sidebarErrorMessageLayout = new HorizontalLayout();
        this.sidebarErrorMessageLayout.setPadding(false);
        this.sidebarErrorMessageLayout.getStyle().set("margin", "8px 16px");
        this.sidebarErrorMessageLayout.setVisible(false);
        this.helpAnchorDiv = new Div();
        this.helpAnchorDiv.getStyle().set("margin-left", "16px");
        this.sidebarFooter = new HorizontalLayout();
        this.sidebarFooter.setPadding(false);
        this.sidebarFooter.setSpacing(false);
        this.previousButton = new Button(controller.getMessage("Previous", new Object[0]), (ComponentEventListener & Serializable)event -> this.lastScreen());
        this.previousButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
        this.nextButton = new Button(controller.getMessage("Next", new Object[0]), (ComponentEventListener & Serializable)event -> this.nextScreen());
        this.nextButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.nextButtonShortcutRegistration = this.nextButton.addClickShortcut(Key.ENTER, new KeyModifier[0]);
        this.nextDiv = new Div(new Component[]{this.nextButton});
        this.nextTooltip = Tooltip.forComponent((Component)this.nextDiv);
        HorizontalLayout sidebarFooterLayout = new HorizontalLayout(new Component[]{this.helpAnchorDiv});
        sidebarFooterLayout.setWidthFull();
        sidebarFooterLayout.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.CENTER);
        sidebarFooterLayout.getStyle().set("padding", "0 16px 16px 0");
        sidebarFooterLayout.addAndExpand(new Component[]{new Span()});
        sidebarFooterLayout.add(new Component[]{this.sidebarFooter, this.previousButton, this.nextDiv});
        this.sidebar = new VerticalLayout(new Component[]{this.sidebarHeader, divider, this.progressStepper, this.sidebarScreenLayout, this.sidebarErrorMessageLayout, sidebarFooterLayout});
        this.sidebar.setPadding(false);
        this.sidebar.setSpacing(false);
        this.sidebar.expand(new Component[]{this.sidebarScreenLayout});
        this.sidebar.setWidth("55%");
        HorizontalLayout mainLayout = new HorizontalLayout(new Component[]{this.diagramScroller, this.sidebar});
        mainLayout.setWidthFull();
        mainLayout.setHeight("0");
        mainLayout.setSpacing(false);
        mainLayout.expand(new Component[]{this.diagramScroller});
        this.refreshEndpoints();
        if (this.initialSetup) {
            this.diagram = new ConfigCanvasDiagram(this, null);
            this.nextScreen();
        } else {
            this.sidebar.setVisible(false);
        }
        if (windowHeight > -1 && windowWidth > -1) {
            this.updateDivPositions(windowHeight, windowWidth);
            this.redrawDiagram();
        } else {
            this.diagramActionDiv.setVisible(false);
            this.deploymentDiv.setVisible(false);
            UI.getCurrent().getPage().retrieveExtendedClientDetails((Page.ExtendedClientDetailsReceiver & Serializable)details -> {
                this.updateDivPositions(details.getWindowInnerHeight(), details.getWindowInnerWidth());
                this.diagramActionDiv.setVisible(true);
                this.deploymentDiv.setVisible(true);
                if (this.initialSetup) {
                    int y2 = Math.max((this.windowHeight - 115) / 2 - 59, 112);
                    this.firstEndpoint.setY(y2);
                    this.position.updateEndpointCoordinates(this.firstEndpoint);
                    if (this.secondEndpoint != null) {
                        this.secondEndpoint.setY(y2);
                        this.position.updateEndpointCoordinates(this.secondEndpoint);
                    }
                }
                this.redrawDiagram();
            });
        }
        this.add(new Component[]{this.ribbon, mainLayout, this.navigationDiv, this.diagramActionDiv, this.deploymentDiv});
        this.expand(new Component[]{mainLayout});
        this.toggleDeleteShortcut(true);
    }

    public void reset(boolean refreshDiagram, boolean discardChanges, boolean loadFromJson) {
        this.initialSetup = false;
        this.addingNewReplication = false;
        ISymmetricEngine currentEngine = this.controller.getSymmetricEngine();
        File jsonFile = this.getJsonFile(false, null, currentEngine);
        if (discardChanges) {
            this.context.getEndpointList().clear();
            this.context.getSavedEndpointList().clear();
            this.context.clearRequiredLinks();
            this.context.clearRequiredRouterIds();
            this.position.getCoordinatesList().clear();
            if (discardChanges) {
                Date now = new Date();
                String version = Version.version();
                this.context.setModified(now);
                this.context.setDocumentVersion(version);
                this.position.setModified(now);
                this.position.setDocumentVersion(version);
                FileUtils.deleteQuietly((File)jsonFile);
                if (this.deployWizard == null || !this.deployWizard.e()) {
                    FileUtils.deleteQuietly((File)this.getJsonFile(true, null, currentEngine));
                }
                FileUtils.deleteQuietly((File)new File(PropertiesUtil.getEnginesDir(), "import.tmp"));
                FileUtils.deleteQuietly((File)new File(System.getProperty("java.io.tmpdir"), "import.sql"));
                if (currentEngine == null) {
                    d.a(false);
                    this.controller.logout();
                    return;
                }
            }
        }
        Gson gson = this.buildGson(true);
        boolean testEndpointConnections = false;
        boolean deserializedJson = false;
        boolean importedIntoCanvas = false;
        if (this.context.getEndpointList().isEmpty()) {
            if (!discardChanges && jsonFile.exists()) {
                if (loadFromJson) {
                    try {
                        FileReader reader = new FileReader(jsonFile);
                        this.context = (ConfigCanvasContext)gson.fromJson((Reader)reader, ConfigCanvasContext.class);
                        reader.close();
                        this.context.decryptPasswords(currentEngine != null ? currentEngine.getSecurityService() : SecurityServiceFactory.create());
                        this.context.updateEndpointList(gson);
                        for (ConfigCanvasEndpoint endpoint : this.context.getEndpointList()) {
                            for (ISymmetricEngine engine : this.controller.getSymmetricEngines()) {
                                String id = engine.getParameterService().getNodeGroupId();
                                if (!endpoint.getId().equals(id)) continue;
                                endpoint.setSymmetricEngine(engine);
                                break;
                            }
                            boolean deployed = endpoint.isDeployed();
                            endpoint.setConnectionSuccessful(deployed);
                            testEndpointConnections |= !deployed && StringUtils.isNotBlank((CharSequence)endpoint.getUrl());
                        }
                        this.showLicenseViolationWarningIfNecessary(this.getLicenseViolationLayout(-1, null, true, true, true, null));
                        deserializedJson = true;
                    }
                    catch (Exception e3) {
                        this.context.getEndpointList().clear();
                        this.context.getSavedEndpointList().clear();
                        this.log.warn("Failed to load Configure Canvas using the following .json file: " + jsonFile.getAbsolutePath(), (Throwable)e3);
                    }
                    this.initEndpointPositions(currentEngine);
                } else {
                    ConfirmDialog continueDialog = new ConfirmDialog(this.controller.getMessage("Do you want to continue where you left off?", new Object[0]), this.controller.getMessage("You last made changes %s ago. If you choose to reset the Configure Canvas, then your changes will be lost.", as.formatDurationLargestUnitOnly(System.currentTimeMillis() - jsonFile.lastModified())), this.controller.getMessage("Continue", new Object[0]), (ComponentEventListener & Serializable)e2 -> this.reset(true, false, true));
                    Button resetButton = new Button(this.controller.getMessage("Reset", new Object[0]));
                    resetButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
                    resetButton.getStyle().set("margin-right", "16px");
                    continueDialog.setRejectable(true);
                    continueDialog.setRejectButton((Component)resetButton);
                    continueDialog.addRejectListener((ComponentEventListener & Serializable)event -> this.reset(true, true, false));
                    continueDialog.open();
                    return;
                }
            }
            if (!deserializedJson) {
                if (currentEngine != null) {
                    this.loadConfigFromDatabase(currentEngine);
                    this.initEndpointPositions(currentEngine);
                    this.context.updateSavedEndpointList(gson);
                    testEndpointConnections |= this.context.getEndpointList().stream().anyMatch(e2 -> !e2.isDeployed() && StringUtils.isNotBlank((CharSequence)e2.getUrl()));
                } else {
                    File importEngineFile = new File(PropertiesUtil.getEnginesDir(), "import.tmp");
                    if (importEngineFile.exists()) {
                        File importSqlFile = new File(System.getProperty("java.io.tmpdir"), "import.sql");
                        if (importSqlFile.exists()) {
                            boolean importedIntoEngine;
                            ClientSymmetricEngine importEngine = new ClientSymmetricEngine(importEngineFile, false);
                            boolean bl2 = importedIntoEngine = importEngine.getDatabasePlatform().readTableFromDatabase(null, null, "sym_node") != null;
                            if (!importedIntoEngine) {
                                importEngine.setup();
                                try {
                                    String fileContent = FileUtils.readFileToString((File)importSqlFile, (Charset)Charset.defaultCharset());
                                    new SqlScript(fileContent, importEngine.getSqlTemplate(), true, null).execute();
                                    importedIntoEngine = true;
                                }
                                catch (IOException e4) {
                                    this.log.error("Failed to import configuration from file", (Throwable)e4);
                                    importEngine.stop();
                                }
                            }
                            if (importedIntoEngine) {
                                importEngine.getNodeService().deleteNode("import", false);
                                this.loadConfigFromDatabase((ISymmetricEngine)importEngine);
                                this.initEndpointPositions((ISymmetricEngine)importEngine);
                                this.context.setImportedFileName(importEngine.getParameterService().getString(dW.e));
                                for (Object channel : importEngine.getConfigurationService().getChannels(false).values()) {
                                    String channelId;
                                    if (channel.isFileSyncFlag() || channel.isReloadFlag() || (channelId = channel.getChannelId()).equals("default") || channelId.equals("config") || channelId.equals("heartbeat") || channelId.equals("dynamic") || channelId.equals("monitor") || channelId.equals("system")) continue;
                                    this.context.getImportedChannelIdSet().add(channelId);
                                }
                                Set defaultTransformTypeSet = TransformService.getBuiltInColumnTransformTypes();
                                for (String transformType : importEngine.getTransformService().getColumnTransforms().keySet()) {
                                    if (defaultTransformTypeSet.contains(transformType)) continue;
                                    this.context.getImportedTransformColumnTypeSet().add(transformType);
                                }
                                String importedLicenseKeyString = importEngine.getParameterService().getString(F.a);
                                com.jumpmind.symmetric.console.impl.M importedLicenseKey = c.a(importedLicenseKeyString, com.jumpmind.symmetric.console.impl.M.class);
                                if (this.controller.getLicenseService().a(importedLicenseKey) == null) {
                                    this.context.setImportedLicenseKeyString(importedLicenseKeyString);
                                    this.context.setImportedLicenseKey(importedLicenseKey);
                                }
                                importEngine.stop();
                                importedIntoCanvas = true;
                            }
                        } else {
                            FileUtils.deleteQuietly((File)importEngineFile);
                        }
                    }
                    if (!importedIntoCanvas) {
                        int y2 = Math.max((this.windowHeight - 115) / 2 - 59, 112);
                        this.firstEndpoint = new ConfigCanvasEndpoint(160, y2);
                        this.firstEndpoint.setId(this.controller.getMessage("Endpoint_1", new Object[0]));
                        this.firstEndpoint.setRenamable(true);
                        this.context.getEndpointList().add(this.firstEndpoint);
                        this.position.updateEndpointCoordinates(this.firstEndpoint);
                        this.secondEndpoint = new ConfigCanvasEndpoint(496, y2);
                        this.secondEndpoint.setId(this.controller.getMessage("Endpoint_2", new Object[0]));
                        this.secondEndpoint.setRenamable(true);
                        this.context.getEndpointList().add(this.secondEndpoint);
                        this.position.updateEndpointCoordinates(this.secondEndpoint);
                        this.firstEndpoint.addLink(this.secondEndpoint.getGuid(), this.secondEndpoint.getId());
                        this.context.updateSavedEndpointList(gson);
                        this.initialSetup = true;
                    }
                }
            }
        }
        if (!this.initialSetup && !deserializedJson) {
            this.context.getOriginalEndpointList().clear();
            if (currentEngine != null || importedIntoCanvas) {
                this.context.updateOriginalEndpointList(gson);
            }
        }
        if (testEndpointConnections) {
            new M<Void>(this.controller.getMessage("Testing connections...", new Object[0]), new M.a<Void>(){

                @Override
                public Void doWork() {
                    TextField urlField = new TextField();
                    for (ConfigCanvasEndpoint endpoint : ConfigCanvas.this.context.getEndpointList()) {
                        if (endpoint.isDeployed() || endpoint.getType() == null || !StringUtils.isNotBlank((CharSequence)endpoint.getUrl())) continue;
                        urlField.setValue(endpoint.getUrl());
                        String exceptionMessage = s.testConnection(ConfigCanvas.this.controller, endpoint.getType(), urlField, endpoint.getUserId(), endpoint.getPassword(), null, null, false, false, false, true);
                        endpoint.setExceptionMessage(exceptionMessage);
                        endpoint.setConnectionSuccessful(exceptionMessage == null);
                    }
                    return null;
                }

                @Override
                public void doUI(Void data) {
                    ConfigCanvas.this.updateDeployButtonEnabled();
                    ConfigCanvas.this.refreshEndpoints();
                    ConfigCanvas.this.redrawDiagram();
                }
            }, this.controller.getBackgroundRefresherService(), null, false, false).show();
        } else if (refreshDiagram) {
            this.refreshEndpoints();
            this.redrawDiagram();
        }
        if (this.sidebar != null) {
            if (discardChanges && this.initialSetup) {
                this.screenHistory.clear();
                this.sidebarScreenLayout.removeAll();
                this.progressStepper.reset();
                this.progressStepper.setStepName(0, this.firstEndpoint.getId());
                this.progressStepper.setStepName(1, this.secondEndpoint.getId());
                this.newReplicationButton.setEnabled(false);
                this.deleteButton.setEnabled(true);
                this.newReplicationTooltip.setText(this.controller.getMessage("Finish initial setup first", new Object[0]));
                this.deleteTooltip.setText(this.controller.getMessage("Delete the selected endpoint or link", new Object[0]));
                this.nextScreen();
                this.progressStepper.setVisible(true);
                this.nextDiv.setVisible(true);
                this.sidebar.setVisible(true);
                this.updateDivPositions(this.windowHeight, this.windowWidth);
            } else if (!this.initialSetup && this.sidebar.isVisible()) {
                this.closeSidebarAndClearSelection(false, false);
            }
        }
        if (this.deployButton != null) {
            this.updateDeployButtonEnabled();
        }
        this.initializing = false;
    }

    private File getJsonFile(boolean position, String consoleUserId, ISymmetricEngine engine) {
        String tmpDirString = System.getProperty("java.io.tmpdir");
        File stagingDir = new File(tmpDirString);
        if (engine != null) {
            IParameterService parameterService = engine.getParameterService();
            String stagingDirString = parameterService.getString("staging.dir");
            if (StringUtils.isEmpty((CharSequence)stagingDirString)) {
                stagingDirString = parameterService.getString("java.io.tmpdir", tmpDirString);
            }
            System.getProperty("java.io.tmpdir");
            stagingDir = new File(stagingDirString + File.separator + "canvas");
            try {
                FileUtils.forceMkdir((File)stagingDir);
            }
            catch (IOException e2) {
                this.log.warn("Failed to create parent directory for Configure Canvas .json file: " + stagingDir.getAbsolutePath(), (Throwable)e2);
            }
        }
        if (consoleUserId == null) {
            consoleUserId = this.controller.getConsoleUser() != null ? this.controller.getConsoleUser().getUserId() : "Unknown";
        }
        return new File(stagingDir, "configure-canvas-" + (position ? "position-" : "") + consoleUserId + ".json");
    }

    private void loadConfigFromDatabase(ISymmetricEngine currentEngine) {
        String targetId;
        String sourceId;
        NodeGroupLink groupLink;
        ConfigCanvasEndpoint endpoint;
        List<ConfigCanvasEndpoint> endpointList = this.context.getEndpointList();
        for (ISymmetricEngine engine : this.controller.getSymmetricEngines()) {
            ConfigCanvasEndpoint endpoint2;
            String id = engine.getParameterService().getNodeGroupId();
            List matchingEndpointList = endpointList.stream().filter(e2 -> id.equals(e2.getId())).collect(Collectors.toList());
            if (matchingEndpointList.size() == 0) {
                endpoint2 = new ConfigCanvasEndpoint();
                endpoint2.load(engine);
                endpointList.add(endpoint2);
                continue;
            }
            endpoint2 = (ConfigCanvasEndpoint)matchingEndpointList.get(0);
            endpoint2.updateRegistrationServerStatus();
        }
        INodeService nodeService = currentEngine.getNodeService();
        File enginesDir = new File(PropertiesUtil.getEnginesDir());
        File[] remoteFiles = enginesDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".remote"));
        if (remoteFiles != null) {
            for (File remoteFile : remoteFiles) {
                TypedProperties properties = new TypedProperties();
                try (FileInputStream is = new FileInputStream(remoteFile);){
                    properties.load((InputStream)is);
                    Iterator<ConfigCanvasEndpoint> id = properties.getProperty("group.id");
                    if (id == null || !endpointList.stream().noneMatch(arg_0 -> ConfigCanvas.lambda$loadConfigFromDatabase$3((String)((Object)id), arg_0))) continue;
                    ConfigCanvasEndpoint endpoint3 = new ConfigCanvasEndpoint();
                    endpoint3.load(properties);
                    endpointList.add(endpoint3);
                }
                catch (IOException e3) {
                    this.log.warn("Failed to load Configure Canvas endpoint using the following .remote file: " + remoteFile.getAbsolutePath(), (Throwable)e3);
                }
            }
        }
        for (Node node : nodeService.findAllNodes()) {
            String id = node.getNodeGroupId();
            boolean foundEndpoint = false;
            for (ConfigCanvasEndpoint endpoint4 : endpointList) {
                if (!id.equals(endpoint4.getId())) continue;
                if (endpoint4.isRemote()) {
                    endpoint4.load(node);
                }
                foundEndpoint = true;
                break;
            }
            if (foundEndpoint) continue;
            endpoint = new ConfigCanvasEndpoint();
            endpoint.load(node);
            endpointList.add(endpoint);
        }
        IConfigurationService configService = currentEngine.getConfigurationService();
        List groupLinkList = configService.getNodeGroupLinks(false);
        for (String id : configService.getNodeGroups().stream().map(g2 -> g2.getNodeGroupId()).toList()) {
            if (!endpointList.stream().noneMatch(e2 -> id.equals(e2.getId()))) continue;
            endpoint = new ConfigCanvasEndpoint();
            endpoint.setId(id);
            endpoint.setRenamable(groupLinkList.stream().noneMatch(l2 -> id.equals(l2.getSourceNodeGroupId()) || id.equals(l2.getTargetNodeGroupId())));
            endpointList.add(endpoint);
        }
        ITriggerRouterService triggerRouterService = currentEngine.getTriggerRouterService();
        List triggerRouterList = triggerRouterService.getTriggerRouters(false);
        List conflictList = currentEngine.getDataLoaderService().getConflictSettingsNodeGroupLinks();
        List fileTriggerRouterList = currentEngine.getFileSyncService().getFileTriggerRouters(false);
        for (Router router : triggerRouterService.getRouters()) {
            ConfigCanvasEndpoint targetEndpoint;
            String routerId = router.getRouterId();
            groupLink = router.getNodeGroupLink();
            sourceId = groupLink.getSourceNodeGroupId();
            targetId = groupLink.getTargetNodeGroupId();
            String targetCatalog = router.getTargetCatalogName();
            String targetSchema = router.getTargetSchemaName();
            if (Strings.CS.contains((CharSequence)targetCatalog, (CharSequence)"$(") || Strings.CS.contains((CharSequence)targetSchema, (CharSequence)"$(")) {
                this.context.setLinkRequired(sourceId, targetId);
                this.context.setRouterRequired(routerId);
                continue;
            }
            ConfigCanvasEndpoint sourceEndpoint = this.context.getEndpointById(sourceId);
            if (sourceEndpoint == null || (targetEndpoint = this.context.getEndpointById(targetId)) == null) continue;
            String targetGuid = targetEndpoint.getGuid();
            ConfigCanvasLink link = sourceEndpoint.getLink(targetGuid);
            if (link == null) {
                link = sourceEndpoint.addLink(targetGuid, targetId);
                boolean required = false;
                for (FileTriggerRouter fileTriggerRouter : fileTriggerRouterList) {
                    if (!routerId.equals(fileTriggerRouter.getRouterId())) continue;
                    this.context.setLinkRequired(sourceId, targetId);
                    this.context.setRouterRequired(routerId);
                    required = true;
                    break;
                }
                if (!required) {
                    for (DataLoaderService.ConflictNodeGroupLink conflict : conflictList) {
                        if (!groupLink.equals((Object)conflict.getNodeGroupLink())) continue;
                        this.context.setLinkRequired(sourceId, targetId);
                        break;
                    }
                }
            }
            ConfigCanvasLink reverseLink = targetEndpoint.getLink(sourceEndpoint.getGuid());
            HashSet<ConfigCanvasTable> tableSet = new HashSet<ConfigCanvasTable>();
            boolean useSourceCatalogSchema = router.isUseSourceCatalogSchema();
            for (TriggerRouter triggerRouter : triggerRouterList) {
                if (!triggerRouter.getRouterId().equals(routerId)) continue;
                Trigger trigger = triggerRouter.getTrigger();
                String tableName = trigger.getSourceTableName();
                String catalog = trigger.getSourceCatalogName();
                String schema = trigger.getSourceSchemaName();
                if (!(FormatUtils.isWildCarded((String)catalog) || Strings.CS.contains((CharSequence)catalog, (CharSequence)"$(") || FormatUtils.isWildCarded((String)schema) || Strings.CS.contains((CharSequence)schema, (CharSequence)"$(") || FormatUtils.isWildCarded((String)tableName) || tableName.contains("$("))) {
                    HashSet<ConfigCanvasTable> singleTableSet = new HashSet<ConfigCanvasTable>();
                    ConfigCanvasTable table = new ConfigCanvasTable(catalog, schema, tableName, useSourceCatalogSchema ? catalog : targetCatalog, useSourceCatalogSchema ? schema : targetSchema);
                    String triggerId = trigger.getTriggerId();
                    singleTableSet.add(table);
                    table.setTriggerId(triggerId);
                    String triggerIdPrefix = null;
                    String defaultTriggerId = ConfigCanvas.buildTriggerId(null, catalog, schema, tableName);
                    if (!Strings.CI.equals(triggerId, defaultTriggerId) && Strings.CI.endsWith((CharSequence)triggerId, (CharSequence)defaultTriggerId)) {
                        triggerIdPrefix = Strings.CI.removeEnd(triggerId, (CharSequence)defaultTriggerId);
                    }
                    link.addTables(singleTableSet, trigger.getChannelId(), triggerIdPrefix, targetCatalog, targetSchema, useSourceCatalogSchema, targetEndpoint.getDefaultCatalog(), targetEndpoint.getDefaultSchema());
                    tableSet.add(table);
                    if (reverseLink == null) continue;
                    link.setIncomingTableCount(reverseLink.getOutgoingTableCount());
                    reverseLink.setIncomingTableCount(link.getOutgoingTableCount());
                    continue;
                }
                this.context.setLinkRequired(sourceId, targetId);
                this.context.setRouterRequired(routerId);
            }
            String expressionString = router.getRouterExpression();
            AbstractSubsetRule subsetRule = null;
            switch (router.getRouterType()) {
                case "column": {
                    try {
                        List expressionList = ColumnMatchExpression.parse((String)expressionString);
                        if (expressionList.size() == 1) {
                            ColumnMatchExpression expression = (ColumnMatchExpression)expressionList.get(0);
                            String[] tokens = expression.getTokens();
                            if (expression.hasEquals() && tokens.length == 2 && (":EXTERNAL_ID".equals(tokens[1]) || ":NODE_ID".equals(tokens[1]) || ":NODE_GROUP_ID".equals(tokens[1]))) {
                                subsetRule = new ColumnRule(tableSet, routerId, tokens[0], tokens[1]);
                                break;
                            }
                        }
                    }
                    catch (SyntaxParsingException expressionList) {
                        // empty catch block
                    }
                    this.context.setLinkRequired(sourceId, targetId);
                    break;
                }
                case "lookuptable": {
                    try {
                        Map expressionMap = new LookupTableDataRouter().parse(expressionString);
                        if (!expressionMap.containsKey("ALL_NODES_VALUE")) {
                            subsetRule = new LookupRule(tableSet, routerId, (String)expressionMap.get("LOOKUP_TABLE"), (String)expressionMap.get("KEY_COLUMN"), (String)expressionMap.get("EXTERNAL_ID_COLUMN"), (String)expressionMap.get("LOOKUP_KEY_COLUMN"));
                            break;
                        }
                    }
                    catch (SyntaxParsingException syntaxParsingException) {
                        // empty catch block
                    }
                    this.context.setLinkRequired(sourceId, targetId);
                    break;
                }
                case "subselect": {
                    subsetRule = new SubselectRule(tableSet, routerId, expressionString);
                    break;
                }
                case "default": {
                    break;
                }
                default: {
                    this.context.setLinkRequired(sourceId, targetId);
                }
            }
            if (tableSet.isEmpty() || subsetRule == null) continue;
            link.getSubsetRuleList().add(subsetRule);
        }
        for (ConfigCanvasEndpoint endpoint3 : this.context.getEndpointList()) {
            endpoint3.getLinkList().removeIf(l2 -> l2.getOutgoingTableCount() < 1);
        }
        List transformList = currentEngine.getTransformService().getTransformTables(true, false);
        transformList.sort((t0, t1) -> t0.getTransformPoint().compareTo((Enum)t1.getTransformPoint()));
        for (TransformService.TransformTableNodeGroupLink transform : transformList) {
            ConfigCanvasLink reverseLink;
            ConfigCanvasLink link;
            ConfigCanvasEndpoint targetEndpoint;
            groupLink = transform.getNodeGroupLink();
            sourceId = groupLink.getSourceNodeGroupId();
            targetId = groupLink.getTargetNodeGroupId();
            ConfigCanvasEndpoint sourceEndpoint = this.context.getEndpointById(sourceId);
            if (sourceEndpoint == null || (targetEndpoint = this.context.getEndpointById(targetId)) == null || (link = sourceEndpoint.getLink(targetEndpoint.getGuid())) == null) continue;
            if (Strings.CS.contains((CharSequence)transform.getSourceCatalogName(), (CharSequence)"$(") || Strings.CS.contains((CharSequence)transform.getSourceSchemaName(), (CharSequence)"$(") || Strings.CS.contains((CharSequence)transform.getSourceTableName(), (CharSequence)"$(") || Strings.CS.contains((CharSequence)transform.getTargetCatalogName(), (CharSequence)"$(") || Strings.CS.contains((CharSequence)transform.getTargetSchemaName(), (CharSequence)"$(") || Strings.CS.contains((CharSequence)transform.getTargetTableName(), (CharSequence)"$(")) {
                this.context.setLinkRequired(sourceId, targetId);
                continue;
            }
            if (!link.addTransformIfInUse(transform, sourceEndpoint.getDefaultCatalog(), sourceEndpoint.getDefaultSchema()) || (reverseLink = targetEndpoint.getLink(sourceEndpoint.getGuid())) == null) continue;
            reverseLink.setIncomingTransformed(true);
        }
    }

    private void initEndpointPositions(ISymmetricEngine engine) {
        int x2 = 16;
        int y2 = 112;
        Set positionlessGuidSet = this.context.getEndpointList().stream().map(e2 -> e2.getGuid()).collect(Collectors.toSet());
        File jsonFile = this.getJsonFile(true, null, engine);
        if (jsonFile.exists()) {
            try {
                FileReader reader = new FileReader(jsonFile);
                this.position = (ConfigCanvasPosition)new Gson().fromJson((Reader)reader, ConfigCanvasPosition.class);
                reader.close();
                for (ConfigCanvasPosition.ConfigCanvasCoordinates coords : this.position.getCoordinatesList()) {
                    String guid = coords.getGuid();
                    String id = coords.getId();
                    for (ConfigCanvasEndpoint endpoint : this.context.getEndpointList()) {
                        if (guid != null && guid.equals(endpoint.getGuid())) {
                            endpoint.setX(coords.getX());
                            endpoint.setY(coords.getY());
                            this.position.setIdForGuid(guid, endpoint.getId());
                            positionlessGuidSet.remove(guid);
                        } else if (id != null && id.equals(endpoint.getId())) {
                            endpoint.setX(coords.getX());
                            endpoint.setY(coords.getY());
                            this.position.setGuidForId(id, endpoint.getGuid());
                            positionlessGuidSet.remove(endpoint.getGuid());
                        }
                        if (endpoint.getY() + 200 <= y2) continue;
                        y2 = endpoint.getY() + 200;
                    }
                }
            }
            catch (Exception e3) {
                this.log.warn("Failed to load Configure Canvas position using the following .json file: " + jsonFile.getAbsolutePath(), (Throwable)e3);
            }
        }
        if (!positionlessGuidSet.isEmpty()) {
            for (ConfigCanvasEndpoint endpoint : this.context.getEndpointList()) {
                if (!positionlessGuidSet.contains(endpoint.getGuid())) continue;
                endpoint.setX(x2);
                endpoint.setY(y2);
                this.position.updateEndpointCoordinates(endpoint);
                if (x2 > 640) {
                    x2 = 16;
                    y2 += 200;
                    continue;
                }
                x2 += 320;
            }
        }
    }

    public void showLicenseViolationWarningIfNecessary(VerticalLayout licenseViolationLayout) {
        if (licenseViolationLayout != null) {
            new LicenseViolationDialog(licenseViolationLayout).open();
        }
    }

    private void deleteSelection() {
        ConfigCanvasDiagramDetail diagramDetail = this.diagram.getDetail();
        String selectedEndpointGuid = diagramDetail.getSelectedEndpointGuid();
        String selectedLinkSourceGuid = diagramDetail.getSelectedLinkSourceGuid();
        String selectedLinkTargetGuid = diagramDetail.getSelectedLinkTargetGuid();
        boolean deletedSelection = false;
        if (selectedEndpointGuid != null) {
            if (this.context.isEndpointRequired(selectedEndpointGuid)) {
                CommonUiUtils.notify((String)this.controller.getMessage("This endpoint is required because advanced configuration outside of the Configure Canvas is using it", new Object[0]));
                return;
            }
            this.deleteEndpoint(selectedEndpointGuid);
            deletedSelection = true;
        } else if (selectedLinkSourceGuid != null && selectedLinkTargetGuid != null) {
            String selectedTargetId;
            ConfigCanvasEndpoint selectedSourceEndpoint = this.context.getEndpointByGuid(selectedLinkSourceGuid);
            ConfigCanvasEndpoint selectedTargetEndpoint = this.context.getEndpointByGuid(selectedLinkTargetGuid);
            if (selectedSourceEndpoint == null || selectedTargetEndpoint == null) {
                return;
            }
            String selectedSourceId = selectedSourceEndpoint.getId();
            if (this.context.isLinkRequired(selectedSourceId, selectedTargetId = selectedTargetEndpoint.getId())) {
                ConfigCanvasLink link = selectedSourceEndpoint.getLink(selectedLinkTargetGuid);
                ConfigCanvasLink reverseLink = selectedTargetEndpoint.getLink(selectedLinkSourceGuid);
                if (!(link != null && link.isUserCreated() || reverseLink != null && reverseLink.isUserCreated())) {
                    CommonUiUtils.notify((String)this.controller.getMessage("This link is required because advanced configuration outside of the Configure Canvas is using it", new Object[0]));
                    return;
                }
            }
            selectedSourceEndpoint.removeLink(selectedLinkTargetGuid);
            selectedTargetEndpoint.removeLink(selectedLinkSourceGuid);
            deletedSelection = true;
        }
        if (deletedSelection) {
            boolean redrawDiagram = !this.sidebar.isVisible();
            this.closeSidebarAndClearSelection(true, true);
            this.refreshEndpoints();
            if (redrawDiagram) {
                this.redrawDiagram();
            }
            this.updateDeployButtonEnabled();
        }
    }

    public ConfigCanvasEndpoint addEndpoint() {
        ConfigCanvasEndpoint newEndpoint;
        if (this.initialSetup) {
            newEndpoint = new ConfigCanvasEndpoint(496, Math.max((this.windowHeight - 115) / 2 - 59, 112));
            newEndpoint.setId(this.controller.getMessage("Endpoint_2", new Object[0]));
            newEndpoint.setRenamable(true);
            this.context.getEndpointList().add(newEndpoint);
        } else {
            newEndpoint = this.context.addEndpoint();
            if (this.addingNewReplication && this.firstEndpoint != null) {
                int x2 = this.firstEndpoint.getX() + 336;
                int y2 = this.firstEndpoint.getY();
                boolean foundEmptyCoords = false;
                block0: while (!foundEmptyCoords) {
                    for (ConfigCanvasEndpoint otherEndpoint : this.context.getEndpointList()) {
                        if (this.firstEndpoint.equals(otherEndpoint) || newEndpoint.equals(otherEndpoint)) continue;
                        int otherX = otherEndpoint.getX();
                        int otherY = otherEndpoint.getY();
                        if (otherX >= x2 + 200 || otherX <= x2 - 200 || otherY >= y2 + 200 || otherY <= y2 - 200) continue;
                        y2 = otherY + 200;
                        continue block0;
                    }
                    foundEmptyCoords = true;
                }
                newEndpoint.setX(x2);
                newEndpoint.setY(y2);
            }
        }
        this.position.updateEndpointCoordinates(newEndpoint);
        this.showLicenseViolationWarningIfNecessary(this.getLicenseViolationLayout(-1, null, true, false, true, null));
        return newEndpoint;
    }

    public void deleteEndpoint(String guid) {
        ArrayList<ConfigCanvasEndpoint> newEndpointList = new ArrayList<ConfigCanvasEndpoint>();
        for (ConfigCanvasEndpoint endpoint : this.context.getEndpointList()) {
            if (guid.equals(endpoint.getGuid())) continue;
            endpoint.removeLink(guid);
            newEndpointList.add(endpoint);
        }
        this.context.setEndpointList(newEndpointList);
        this.position.removeEndpointCoordinates(guid);
    }

    public VerticalLayout getLicenseViolationLayout(int nodesToAdd, Collection<String> tableNamesToAdd, boolean includeNodesAndGroups, boolean includeTables, boolean includeRecommendedActions, com.jumpmind.symmetric.console.impl.M key) {
        if (key == null && this.controller.getSymmetricEngine() == null && (key = this.context.getImportedLicenseKey()) == null) {
            return null;
        }
        Set<Object> undeployedIdSet = new HashSet();
        HashSet<String> canvasTableNameSet = new HashSet<String>();
        if (includeNodesAndGroups) {
            undeployedIdSet = this.context.getEndpointList().stream().filter(e2 -> !e2.isDeployed() && !e2.isRemote()).map(e2 -> e2.getId()).collect(Collectors.toSet());
        }
        if (includeTables) {
            canvasTableNameSet.addAll(this.context.getAllTableNames());
            if (tableNamesToAdd != null) {
                canvasTableNameSet.addAll(tableNamesToAdd);
            }
            if (key == null) {
                HashSet<String> existingTableNameSet = new HashSet<String>();
                for (TriggerRouter triggerRouter : this.controller.getSymmetricEngine().getTriggerRouterService().getTriggerRouters(false)) {
                    Trigger trigger = triggerRouter.getTrigger();
                    if (!trigger.isSyncOnInsert() && !trigger.isSyncOnUpdate() && !trigger.isSyncOnDelete()) continue;
                    existingTableNameSet.add(trigger.getSourceTableNameLowerCase());
                }
                canvasTableNameSet.removeAll(existingTableNameSet);
            }
        }
        ArrayList<Violation> violations = new ArrayList<Violation>();
        this.controller.checkLicenseViolations(nodesToAdd > -1 ? nodesToAdd : undeployedIdSet.size(), canvasTableNameSet.size(), undeployedIdSet, violations, key);
        UnorderedList violationList = new UnorderedList();
        int endpointsToDeleteCount = 0;
        int tablesToRemoveCount = 0;
        for (Violation violation : violations) {
            String type = violation.getType();
            int maxCount = (int)violation.getExpected();
            int actualCount = (int)violation.getActual();
            if (includeNodesAndGroups && type.equals("Nodes")) {
                endpointsToDeleteCount = Math.max(actualCount - maxCount, endpointsToDeleteCount);
                violationList.add(new Component[]{new ListItem(this.controller.getMessage("You have configured %d endpoints, but your license only allows %d nodes", actualCount, maxCount))});
                continue;
            }
            if (includeNodesAndGroups && type.equals("Groups")) {
                endpointsToDeleteCount = Math.max(actualCount - maxCount, endpointsToDeleteCount);
                violationList.add(new Component[]{new ListItem(this.controller.getMessage("You have configured %d node groups, but your license only allows %d node groups", actualCount, maxCount))});
                continue;
            }
            if (!includeTables || !type.equals("Tables")) continue;
            tablesToRemoveCount = actualCount - maxCount;
            violationList.add(new Component[]{new ListItem(this.controller.getMessage("You have configured %d tables, but your license only allows %d tables", actualCount, maxCount))});
        }
        long violationCount = violationList.getChildren().count();
        if (violationCount == 0L) {
            return null;
        }
        Object violationHeader = this.controller.getMessage("License Violation", new Object[0]);
        if (violationCount > 1L) {
            violationHeader = (String)violationHeader + "s";
        }
        VerticalLayout violationLayout = new VerticalLayout(new Component[]{new H4((String)violationHeader), violationList});
        violationLayout.setMargin(false);
        violationLayout.setPadding(false);
        violationLayout.setSpacing(false);
        if (includeRecommendedActions && (endpointsToDeleteCount > 0 || tablesToRemoveCount > 0)) {
            UnorderedList actionList = new UnorderedList();
            if (endpointsToDeleteCount > 0) {
                actionList.add(new Component[]{new ListItem(this.controller.getMessage("Delete %d or more endpoints to be within your node and/or node group limits", endpointsToDeleteCount))});
            }
            if (tablesToRemoveCount > 0) {
                actionList.add(new Component[]{new ListItem(this.controller.getMessage("Remove %d or more tables to be within your table limit", tablesToRemoveCount))});
            }
            actionList.add(new Component[]{new ListItem(this.controller.getMessage("Or contact sales@jumpmind.com to upgrade your license", new Object[0]))});
            violationLayout.add(new Component[]{new H4(this.controller.getMessage("Recommended Actions", new Object[0])), actionList});
        }
        return violationLayout;
    }

    private void updateDeployButtonEnabled() {
        for (ConfigCanvasEndpoint endpoint : this.context.getEndpointList()) {
            if ((endpoint.isDeployed() || endpoint.isRemote()) && (endpoint.getStateIconSrc() == null || !endpoint.getStateIconSrc().contains("/icons/pending.svg".substring(7)))) continue;
            this.deployButton.setEnabled(true);
            this.deployTooltip.setText(this.controller.getMessage("Open the Deploy Wizard", new Object[0]));
            return;
        }
        boolean foundDeletedEndpoint = false;
        for (ConfigCanvasEndpoint originalEndpoint : this.context.getOriginalEndpointList()) {
            if (this.context.getEndpointById(originalEndpoint.getId()) != null) continue;
            foundDeletedEndpoint = true;
            break;
        }
        this.deployButton.setEnabled(foundDeletedEndpoint && !this.context.getEndpointList().isEmpty());
        if (this.deployButton.isEnabled()) {
            this.deployTooltip.setText(this.controller.getMessage("Open the Deploy Wizard", new Object[0]));
        } else if (this.context.getEndpointList().isEmpty()) {
            this.deployTooltip.setText(this.controller.getMessage("Add a new replication first", new Object[0]));
        } else {
            this.deployTooltip.setText(this.controller.getMessage("There are no pending changes to deploy", new Object[0]));
        }
    }

    public void updateDivPositions(int windowHeight, int windowWidth) {
        AbstractSidebarScreen abstractSidebarScreen;
        this.windowHeight = windowHeight;
        boolean widthChanged = this.windowWidth != windowWidth;
        this.windowWidth = windowWidth;
        int diagramWidth = windowWidth;
        if (this.sidebar == null || this.sidebar.isVisible()) {
            diagramWidth = (int)Math.round((double)windowWidth * 0.45);
        }
        String upperDivTop = (this.ribbon.isVisible() ? 120 : 86) + "px";
        this.navigationDiv.setTop(upperDivTop);
        this.diagramActionDiv.setTop(upperDivTop);
        this.diagramActionDiv.setLeft(Math.max(diagramWidth - 292, 256) + "px");
        this.deploymentDiv.setTop(Math.max(windowHeight - (this.deploymentDivHeight + 38), this.deploymentDivHeight + 129) + "px");
        if (widthChanged && !this.screenHistory.isEmpty() && (abstractSidebarScreen = this.screenHistory.getLast()) instanceof TransformDataScreen) {
            TransformDataScreen transformDataScreen = (TransformDataScreen)abstractSidebarScreen;
            transformDataScreen.updateDivPosition(windowHeight, windowWidth);
        }
    }

    public void toggleDeleteShortcut(boolean enabled) {
        if (enabled && this.deleteShortcutRegistration == null) {
            this.deleteShortcutRegistration = Shortcuts.addShortcutListener((Component)this, (Command & Serializable)() -> {
                if (this.deleteButton.isEnabled() && (this.deployWizard == null || !this.deployWizard.isOpened())) {
                    this.deleteSelection();
                }
            }, (Key)Key.DELETE, (KeyModifier[])new KeyModifier[0]).allowBrowserDefault();
        } else if (!enabled && this.deleteShortcutRegistration != null) {
            this.deleteShortcutRegistration.remove();
            this.deleteShortcutRegistration = null;
        }
    }

    public void addListenersToToggleDeleteShortcut(Focusable<?> field) {
        field.addFocusListener((ComponentEventListener & Serializable)event -> this.toggleDeleteShortcut(false));
        field.addBlurListener((ComponentEventListener & Serializable)event -> this.toggleDeleteShortcut(true));
    }

    public void refresh() {
        this.refreshEndpoints();
        if (this.sidebar.isVisible()) {
            this.updateSidebarHeader();
        }
        this.redrawDiagram();
    }

    public void redrawDiagramIfStateChanged(ConfigCanvasEndpoint endpoint) {
        String originalState = endpoint.getStateIconSrc();
        this.refreshEndpoints();
        if (!Strings.CS.equals(originalState, endpoint.getStateIconSrc())) {
            this.redrawDiagram();
        }
    }

    public void updateSidebarHeader() {
        this.sidebarHeader.removeAll();
        if (this.screenHistory.isEmpty() || this.screenHistory.getLast() instanceof DefineEndpointScreen) {
            Icon icon;
            String iconSrc;
            boolean isFirst = true;
            if (!this.screenHistory.isEmpty()) {
                isFirst = ((DefineEndpointScreen)this.screenHistory.getLast()).isFirst();
            }
            HorizontalLayout endpointLayout = this.getEndpointLayout(isFirst, true);
            endpointLayout.getStyle().set("max-width", "90%").set("padding-left", "16px");
            ConfigCanvasEndpoint endpoint = isFirst ? this.firstEndpoint : this.secondEndpoint;
            String string = iconSrc = endpoint != null ? endpoint.getStateIconSrc() : "/icons/draft.svg";
            if (iconSrc == null) {
                if (endpoint.isRemote() && !endpoint.isDeployed()) {
                    icon = new Icon(VaadinIcon.CHECK_CIRCLE_O);
                    icon.addClassName("less-contrast");
                } else {
                    icon = new Icon(VaadinIcon.CHECK_CIRCLE);
                    icon.getStyle().set("color", "var(--lumo-success-color)");
                }
                icon.getStyle().set("height", "20px").set("width", "20px");
            } else if (iconSrc.contains("/icons/draft.svg".substring(7))) {
                icon = as.createSvgIcon(this.controller.getContextPath(), "/icons/draft.svg");
                icon.addClassName("svg-less-contrast");
            } else {
                icon = as.createSvgIcon(this.controller.getContextPath(), "/icons/pending.svg");
                icon.addClassName("svg-warning");
            }
            this.sidebarHeader.add(new Component[]{endpointLayout, icon});
        } else {
            Component linkLayout = this.getLinkLayout(true, true);
            linkLayout.getStyle().set("padding-left", "16px");
            this.sidebarHeader.add(new Component[]{linkLayout});
        }
        this.sidebarHeader.addAndExpand(new Component[]{new Span()});
        if (this.sidebarCloseIcon == null) {
            this.sidebarCloseIcon = new o(this.controller.getContextPath(), VaadinIcon.CLOSE_SMALL);
            this.sidebarCloseIcon.getStyle().set("margin-right", "16px").set("cursor", "pointer");
            this.sidebarCloseIcon.addClickListener((ComponentEventListener & Serializable)event -> {
                if (!this.screenHistory.isEmpty()) {
                    this.screenHistory.getLast().onCloseIconClick();
                }
            });
            this.sidebarCloseIconTooltip = Tooltip.forComponent((Component)this.sidebarCloseIcon);
        }
        if (!this.screenHistory.isEmpty()) {
            this.sidebarCloseIconTooltip.setText(this.screenHistory.getLast().getCloseIconTooltip());
        }
        this.sidebarHeader.add(new Component[]{this.sidebarCloseIcon});
    }

    public void refreshEndpoints() {
        int undeployedCount = 0;
        int remoteCount = 0;
        int pendingCount = 0;
        int deployedCount = 0;
        for (ConfigCanvasEndpoint endpoint : this.context.getEndpointList()) {
            StringBuilder displayHtml = new StringBuilder("<div class='canvas-node-text'>");
            if (endpoint.getType() != null) {
                String imageText = String.format("<img class=\"circle\" style=\"display: block; width: 48px; height: 48px; margin-left: auto; margin-right: auto\" src=\"%s\"/>", this.getEndpointImageUrl(endpoint.getType()));
                displayHtml.append(imageText);
            } else {
                if (this.endpointPlaceholderIcon == null) {
                    this.endpointPlaceholderIcon = new o(this.controller.getContextPath(), "/icons/database_o.svg", o.a.LARGE);
                    this.endpointPlaceholderIcon.getStyle().set("display", "block").set("margin-left", "auto").set("margin-right", "auto");
                    this.endpointPlaceholderIcon.setVisible(false);
                    this.add(new Component[]{this.endpointPlaceholderIcon});
                }
                displayHtml.append(this.endpointPlaceholderIcon.getElement().getOuterHTML());
            }
            endpoint.setHtml(displayHtml.append("</div>").toString());
            if (endpoint.isDeployed() || endpoint.isRemote()) {
                boolean changed = true;
                for (ConfigCanvasEndpoint originalEndpoint : this.context.getOriginalEndpointList()) {
                    if (!endpoint.getId().equals(originalEndpoint.getId())) continue;
                    changed = !this.getChangedLinks(originalEndpoint, endpoint, true).isEmpty();
                    break;
                }
                if (changed) {
                    if (this.pendingIconSrc == null) {
                        SvgIcon newIcon = as.createSvgIcon(this.controller.getContextPath(), "/icons/pending.svg");
                        newIcon.setVisible(false);
                        this.add(new Component[]{newIcon});
                        this.pendingIconSrc = newIcon.getElement().getAttribute("src");
                    }
                    endpoint.setStateIconSrc(this.pendingIconSrc);
                    ++pendingCount;
                    continue;
                }
            }
            if (endpoint.isDeployed()) {
                endpoint.setStateIconSrc(null);
                ++deployedCount;
                continue;
            }
            if (endpoint.isRemote()) {
                endpoint.setStateIconSrc(null);
                ++remoteCount;
                continue;
            }
            if (this.undeployedIconSrc == null) {
                SvgIcon newIcon = as.createSvgIcon(this.controller.getContextPath(), "/icons/draft.svg");
                newIcon.setVisible(false);
                this.add(new Component[]{newIcon});
                this.undeployedIconSrc = newIcon.getElement().getAttribute("src");
            }
            endpoint.setStateIconSrc(this.undeployedIconSrc);
            ++undeployedCount;
        }
        int endpointCount = undeployedCount + remoteCount + pendingCount + deployedCount;
        this.totalCountSpan.setText(String.valueOf(endpointCount));
        Object endpointText = this.controller.getMessage("Endpoint", new Object[0]).toLowerCase();
        if (endpointCount != 1) {
            endpointText = (String)endpointText + "s";
        }
        this.endpointSpan.setText((String)endpointText);
        this.deploymentDivHeight = 90;
        this.updateCountSpan(undeployedCount, this.undeployedCountLayout, "%d Undeployed");
        this.updateCountSpan(remoteCount, this.remoteCountLayout, "%d Remote Pending");
        int configChangeCount = 0;
        if (pendingCount > 0) {
            configChangeCount = this.getConfigChangeCount();
            Object pendingCountText = this.controller.getMessage("%d Pending with %d config change", pendingCount, configChangeCount);
            if (configChangeCount != 1) {
                pendingCountText = (String)pendingCountText + "s";
            }
            ((Span)this.pendingCountLayout.getComponentAt(1)).setText((String)pendingCountText);
            this.pendingCountLayout.setVisible(true);
            this.deploymentDivHeight += 25;
        } else {
            this.pendingCountLayout.setVisible(false);
        }
        this.updateCountSpan(deployedCount, this.deployedCountLayout, "%d Deployed");
        this.deploymentDiv.setHeight(this.deploymentDivHeight + "px");
        this.ribbon.setVisible(undeployedCount > 0 || pendingCount > 0 || configChangeCount > 0);
        this.updateDivPositions(this.windowHeight, this.windowWidth);
        this.updateDeployButtonEnabled();
    }

    private void updateCountSpan(int count, HorizontalLayout layout, String text) {
        if (count > 0) {
            ((Span)layout.getComponentAt(1)).setText(this.controller.getMessage(text, count));
            layout.setVisible(true);
            this.deploymentDivHeight += 25;
        } else {
            layout.setVisible(false);
        }
    }

    public int getConfigChangeCount() {
        HashSet<String> addedTableNameSet = new HashSet<String>();
        ArrayList<String> addedSubsetRuleNameList = new ArrayList<String>();
        ArrayList<String> addedTransformNameList = new ArrayList<String>();
        HashSet<String> removedTableNameSet = new HashSet<String>();
        ArrayList<String> removedSubsetRuleNameList = new ArrayList<String>();
        ArrayList<String> removedTransformNameList = new ArrayList<String>();
        for (ConfigCanvasEndpoint endpoint : this.getChangedEndpoints()) {
            boolean endpointRemoved = endpoint.isRemoved();
            for (ConfigCanvasLink link : endpoint.getLinkList()) {
                link.checkForConfigChanges(endpointRemoved, addedTableNameSet, addedSubsetRuleNameList, addedTransformNameList, removedTableNameSet, removedSubsetRuleNameList, removedTransformNameList);
            }
        }
        return addedTableNameSet.size() + addedSubsetRuleNameList.size() + addedTransformNameList.size() + removedTableNameSet.size() + removedSubsetRuleNameList.size() + removedTransformNameList.size();
    }

    public void redrawDiagram() {
        this.diagram = new ConfigCanvasDiagram(this, this.diagram != null ? this.diagram.getDetail() : null);
        this.diagram.getDetail().setEndpointList(this.context.getEndpointList());
        this.diagram.getDetail().setAllowSelectionAndConnection(!this.initialSetup && !this.addingNewReplication);
        this.diagram.getDetail().setReadOnly(this.isReadOnly());
        this.diagramScroller.setContent((Component)this.diagram);
    }

    private boolean isReadOnly() {
        return this.controller.getSymmetricEngine() != null && !this.controller.getConsoleUser().hasPrivilegeWrite("Create/Edit/Delete Configuration");
    }

    public boolean isSidebarErrorMessageVisible() {
        return this.sidebarErrorMessageLayout.isVisible();
    }

    public Anchor createHelpAnchor(String docAnchor) {
        String docUrl;
        String url = this.controller.getUrlPath();
        if (url == null || !as.hasHelpHtml()) {
            docUrl = "https://downloads.jumpmind.com/symmetricds";
            docAnchor = docAnchor.replace("/doc/", "/doc/" + Version.getMajorVersion() + "." + Version.getMinorVersion() + "/");
        } else {
            docUrl = url.toString().substring(0, url.toString().indexOf("/app"));
        }
        Icon icon = new Icon(VaadinIcon.QUESTION_CIRCLE);
        icon.setSize("24px");
        icon.setColor("var(--lumo-primary-color)");
        icon.getStyle().set("min-height", "24px").set("min-width", "24px");
        icon.setTooltipText(this.controller.getMessage("Open the SymmetricDS Pro User Guide in a new tab", new Object[0]));
        Anchor helpAnchor = new Anchor(docUrl + docAnchor, new Component[]{icon});
        helpAnchor.setTarget("_blank");
        return helpAnchor;
    }

    public boolean doesEndpointIdExist(String endpointId, boolean isFirst) {
        for (ConfigCanvasEndpoint endpoint : this.context.getEndpointList()) {
            if (endpointId == null || !endpointId.equals(endpoint.getId()) || endpoint.getGuid().equals((isFirst ? this.firstEndpoint : this.secondEndpoint).getGuid())) continue;
            return true;
        }
        return false;
    }

    public void closeSidebarAndClearSelection(boolean endpointDeleted, boolean callOnClose) {
        this.initialSetup = false;
        this.addingNewReplication = false;
        this.diagram.getDetail().setAllowSelectionAndConnection(true);
        this.diagram.getDetail().clearSelection();
        this.sidebarScreenLayout.removeAll();
        this.sidebarErrorMessageLayout.setVisible(false);
        boolean readOnly = this.isReadOnly();
        this.newReplicationButton.setEnabled(!readOnly);
        this.deleteButton.setEnabled(false);
        this.newReplicationTooltip.setText(this.controller.getMessage(readOnly ? "Requires write permission" : "Add a new link between new or existing endpoints", new Object[0]));
        this.deleteTooltip.setText(this.controller.getMessage("Select an undeployed endpoint or a link first", new Object[0]));
        this.sidebar.setVisible(false);
        this.updateDivPositions(this.windowHeight, this.windowWidth);
        if (!this.screenHistory.isEmpty()) {
            if (callOnClose) {
                this.screenHistory.getLast().onClose(endpointDeleted, null);
            }
            this.screenHistory.clear();
        }
    }

    private void executeCallback(AbstractSidebarScreen currentScreen, Command callback) {
        if (currentScreen != null) {
            currentScreen.onClose(false, callback);
        } else {
            callback.execute();
            this.redrawDiagram();
        }
    }

    public boolean isInitialSetup() {
        return this.initialSetup;
    }

    public boolean isAddingNewReplication() {
        return this.addingNewReplication;
    }

    public ConfigCanvasContext getContext() {
        return this.context;
    }

    public ConfigCanvasPosition getPosition() {
        return this.position;
    }

    public List<ConfigCanvasEndpoint> getEndpointList() {
        return this.context.getEndpointList();
    }

    public ConfigCanvasEndpoint getFirstEndpoint() {
        return this.firstEndpoint;
    }

    public void setFirstEndpoint(ConfigCanvasEndpoint firstEndpoint) {
        this.firstEndpoint = firstEndpoint;
    }

    public ConfigCanvasEndpoint getSecondEndpoint() {
        return this.secondEndpoint;
    }

    public void setSecondEndpoint(ConfigCanvasEndpoint secondEndpoint) {
        this.secondEndpoint = secondEndpoint;
    }

    public URL getUrl() {
        return this.url;
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public ae getProgressStepper() {
        return this.progressStepper;
    }

    public Button getPreviousButton() {
        return this.previousButton;
    }

    public Button getNextButton() {
        return this.nextButton;
    }

    public void setNextButtonTooltip(String tooltip) {
        this.nextTooltip.setText(tooltip);
    }

    public static String buildTriggerId(String prefix, String catalog, String schema, String tableName) {
        Object triggerIdPrefix = "";
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            triggerIdPrefix = (String)triggerIdPrefix + prefix;
        }
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            triggerIdPrefix = (String)triggerIdPrefix + catalog + ".";
        }
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            triggerIdPrefix = (String)triggerIdPrefix + schema + ".";
        }
        return ((String)triggerIdPrefix + tableName).toLowerCase();
    }

    public static HorizontalLayout createInfoLayout(String message) {
        Icon infoIcon = new Icon(VaadinIcon.INFO_CIRCLE_O);
        infoIcon.getStyle().set("min-height", "24px").set("min-width", "24px");
        HorizontalLayout infoLayout = new HorizontalLayout(new Component[]{infoIcon, new Span(message)});
        infoLayout.addClassName("blue-tinted-background");
        infoLayout.getStyle().set("color", "var(--lumo-primary-text-color)").set("gap", "10px").set("padding", "6px 8px").set("margin", "0");
        return infoLayout;
    }

    public String getEndpointImageUrl(s.a type) {
        if (this.endpointImageMap.containsKey(type)) {
            return this.endpointImageMap.get(type).getSrc();
        }
        String contextPath = this.controller.getContextPath();
        Image image = UI.getCurrent().getElement().getThemeList().contains((Object)"dark") ? as.createImage(contextPath, "/icons/databases/" + s.databaseNameMap.get(type) + "-48x48-dark.png") : as.createImage(contextPath, "/icons/databases/" + s.databaseNameMap.get(type) + "-48x48.png");
        image.setWidth("48px");
        image.setHeight("48px");
        image.getStyle().set("border-radius", "50%");
        if (!VaadinService.getCurrent().getDeploymentConfiguration().isProductionMode()) {
            image.setVisible(false);
            this.add(new Component[]{image});
        }
        this.endpointImageMap.put(type, image);
        return image.getSrc();
    }

    public HorizontalLayout getEndpointLayout(boolean isFirst, boolean isHeader) {
        return as.getEndpointLayout(this.controller, isFirst ? this.firstEndpoint : this.secondEndpoint, isHeader);
    }

    public Component getLinkLayout(Boolean isOutgoing, boolean isHeader) {
        if (isOutgoing == null) {
            return new Div();
        }
        HorizontalLayout linkLayout = new HorizontalLayout(new Component[]{this.getEndpointLayout(isOutgoing, isHeader), new Icon(VaadinIcon.ARROW_RIGHT), this.getEndpointLayout(isOutgoing == false, isHeader)});
        linkLayout.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.CENTER);
        return linkLayout;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.endpointImageMap.clear();
        this.endpointPlaceholderIcon = null;
        this.undeployedIconSrc = null;
        this.pendingIconSrc = null;
        ISymmetricEngine engine = this.controller.getSymmetricEngine();
        String newEngineName = engine != null ? engine.getEngineName() : null;
        boolean changedEngines = !attachEvent.isInitialAttach() && !Strings.CS.equals(this.engineName, newEngineName);
        this.engineName = newEngineName;
        if (!changedEngines) {
            if (engine == null || this.getJsonFile(false, null, engine).exists()) {
                this.refreshEndpoints();
                this.redrawDiagram();
            } else if (!attachEvent.isInitialAttach()) {
                this.reset(true, false, false);
            }
        }
        if (this.endpointDeploymentRefresher == null) {
            this.endpointDeploymentRefresher = new EndpointDeploymentRefresher();
            this.jsonFileRefresher = new JsonFileRefresher();
        }
        this.controller.getBackgroundRefresherService().c(this.endpointDeploymentRefresher);
        this.controller.getBackgroundRefresherService().c(this.jsonFileRefresher);
    }

    public List<ConfigCanvasEndpoint> getChangedEndpoints() {
        return this.getChangedEndpoints(this.context.getOriginalEndpointList(), false);
    }

    private List<ConfigCanvasEndpoint> getChangedEndpoints(List<ConfigCanvasEndpoint> originalEndpointList, boolean returnAfterOne) {
        ArrayList<ConfigCanvasEndpoint> changedEndpointList = new ArrayList<ConfigCanvasEndpoint>();
        for (ConfigCanvasEndpoint originalEndpoint : originalEndpointList) {
            boolean removed = true;
            String id = originalEndpoint.getId();
            for (ConfigCanvasEndpoint endpoint : this.context.getEndpointList()) {
                if (!id.equals(endpoint.getId())) continue;
                removed = false;
                break;
            }
            if (removed) {
                changedEndpointList.add(originalEndpoint);
                if (returnAfterOne) {
                    return changedEndpointList;
                }
            }
            if (returnAfterOne) continue;
            originalEndpoint.setRemoved(removed);
        }
        for (ConfigCanvasEndpoint endpoint : this.context.getEndpointList()) {
            if (!returnAfterOne && endpoint.getUrl() == null) continue;
            boolean isNew = true;
            String guid = endpoint.getGuid();
            String id = endpoint.getId();
            for (ConfigCanvasEndpoint originalEndpoint : originalEndpointList) {
                boolean modified;
                if (!id.equals(originalEndpoint.getId())) continue;
                s.a type = endpoint.getType();
                s.a originalType = originalEndpoint.getType();
                boolean bl2 = modified = (type != null || originalType != null) && (type == null || originalType == null || !type.getName().equals(originalType.getName())) || endpoint.isUsingCustomUrl() != originalEndpoint.isUsingCustomUrl() || !Strings.CS.equals(endpoint.getHost(), originalEndpoint.getHost()) || !Strings.CS.equals(endpoint.getPort(), originalEndpoint.getPort()) || !Strings.CS.equals(endpoint.getDatabaseName(), originalEndpoint.getDatabaseName()) || Boolean.TRUE.equals(endpoint.isUseOracleServiceName()) != Boolean.TRUE.equals(originalEndpoint.isUseOracleServiceName()) || !Strings.CS.equals(endpoint.getUrl(), originalEndpoint.getUrl()) || !Strings.CS.equals(endpoint.getUserId(), originalEndpoint.getUserId()) || !Strings.CS.equals(endpoint.getPassword(), originalEndpoint.getPassword()) || !endpoint.getAdvancedProperties().equals((Object)originalEndpoint.getAdvancedProperties());
                if (returnAfterOne && modified) {
                    changedEndpointList.add(originalEndpoint);
                    return changedEndpointList;
                }
                isNew = false;
                List<ConfigCanvasLink> changedLinkList = this.getChangedLinks(originalEndpoint, endpoint, returnAfterOne);
                if (!modified && changedLinkList.isEmpty()) break;
                ConfigCanvasEndpoint changedEndpoint = new ConfigCanvasEndpoint(guid, id, changedLinkList);
                changedEndpoint.setSymmetricEngine(endpoint.getSymmetricEngine());
                changedEndpoint.setDatabasePlatform(endpoint.getDatabasePlatform());
                changedEndpoint.setExceptionMessage(endpoint.getExceptionMessage());
                changedEndpoint.setType(endpoint.getType());
                changedEndpoint.setUrl(endpoint.getUrl());
                changedEndpoint.setUserId(endpoint.getUserId());
                changedEndpoint.setPassword(endpoint.getPassword());
                changedEndpoint.getAdvancedProperties().putAll((Properties)endpoint.getAdvancedProperties());
                changedEndpoint.setCaptureType(endpoint.getCaptureType());
                changedEndpoint.setDeployed(endpoint.isDeployed());
                endpoint.setModified(modified);
                changedEndpointList.add(changedEndpoint);
                if (!returnAfterOne) break;
                return changedEndpointList;
            }
            if (isNew) {
                changedEndpointList.add(endpoint);
                if (returnAfterOne) {
                    return changedEndpointList;
                }
            }
            if (returnAfterOne) continue;
            endpoint.setNew(isNew);
        }
        return changedEndpointList;
    }

    private List<ConfigCanvasLink> getChangedLinks(ConfigCanvasEndpoint originalEndpoint, ConfigCanvasEndpoint endpoint, boolean returnAfterOne) {
        ArrayList<ConfigCanvasLink> changedLinkList = new ArrayList<ConfigCanvasLink>();
        for (ConfigCanvasLink originalLink : originalEndpoint.getLinkList()) {
            if (endpoint.getLink(originalLink.getTargetEndpointGuid()) == null) {
                changedLinkList.add(originalLink);
                if (returnAfterOne) {
                    return changedLinkList;
                }
                originalLink.setRemoved(true);
                continue;
            }
            if (returnAfterOne) continue;
            originalLink.setRemoved(false);
        }
        for (ConfigCanvasLink link : endpoint.getLinkList()) {
            String targetEndpointGuid = link.getTargetEndpointGuid();
            ConfigCanvasLink originalLink = originalEndpoint.getLink(targetEndpointGuid);
            boolean addLink = false;
            if (originalLink != null) {
                List<Set<ConfigCanvasTransformTable>> changedTransformList;
                List<AbstractSubsetRule> changedSubsetRuleList;
                ConfigCanvasLink changedLink = new ConfigCanvasLink(targetEndpointGuid, link.getTargetEndpointId(), link.getOutgoingTableCount(), link.getIncomingTableCount());
                List<ConfigCanvasLink.ConfigCanvasTableGroup> changedTableGroupList = this.getChangedTableGroups(originalEndpoint, endpoint, originalLink, link, changedLink, returnAfterOne);
                if (!changedTableGroupList.isEmpty()) {
                    changedLink.getTableGroupList().addAll(changedTableGroupList);
                    if (returnAfterOne) {
                        changedLinkList.add(changedLink);
                        return changedLinkList;
                    }
                    addLink = true;
                }
                if (!(changedSubsetRuleList = this.getChangedSubsetRules(originalEndpoint, endpoint, originalLink, link, returnAfterOne)).isEmpty()) {
                    changedLink.getSubsetRuleList().addAll(changedSubsetRuleList);
                    if (returnAfterOne) {
                        changedLinkList.add(changedLink);
                        return changedLinkList;
                    }
                    addLink = true;
                }
                if (!(changedTransformList = this.getChangedTransformSets(originalEndpoint, endpoint, originalLink, link, returnAfterOne)).isEmpty()) {
                    changedLink.getTransformList().addAll(changedTransformList);
                    addLink = true;
                }
                if (addLink) {
                    changedLinkList.add(changedLink);
                    if (returnAfterOne) {
                        return changedLinkList;
                    }
                }
                if (returnAfterOne) continue;
                link.setNew(false);
                continue;
            }
            if (link.getAllTables().isEmpty()) continue;
            changedLinkList.add(link);
            if (returnAfterOne) {
                return changedLinkList;
            }
            link.setNew(true);
        }
        return changedLinkList;
    }

    private List<ConfigCanvasLink.ConfigCanvasTableGroup> getChangedTableGroups(ConfigCanvasEndpoint originalEndpoint, ConfigCanvasEndpoint endpoint, ConfigCanvasLink originalLink, ConfigCanvasLink link, ConfigCanvasLink changedLink, boolean returnAfterOne) {
        ArrayList<ConfigCanvasLink.ConfigCanvasTableGroup> changedTableGroupList = new ArrayList<ConfigCanvasLink.ConfigCanvasTableGroup>();
        ConfigCanvasEndpoint originalTargetEndpoint = this.context.getOriginalEndpointByGuid(originalLink.getTargetEndpointGuid());
        ConfigCanvasEndpoint targetEndpoint = this.context.getEndpointByGuid(originalLink.getTargetEndpointGuid());
        for (ConfigCanvasLink.ConfigCanvasTableGroup originalTableGroup : originalLink.getTableGroupList()) {
            String defaultTargetCatalog = null;
            String defaultTargetSchema = null;
            if (originalTargetEndpoint != null) {
                if (targetEndpoint != null && Strings.CS.equals(originalTargetEndpoint.getUrl(), targetEndpoint.getUrl()) && Strings.CS.equals(originalTargetEndpoint.getUserId(), targetEndpoint.getUserId())) {
                    defaultTargetCatalog = targetEndpoint.getDefaultCatalog();
                    defaultTargetSchema = targetEndpoint.getDefaultSchema();
                } else {
                    defaultTargetCatalog = originalTargetEndpoint.getDefaultCatalog();
                    defaultTargetSchema = originalTargetEndpoint.getDefaultSchema();
                }
            }
            if (link.getTableGroup(originalTableGroup.getChannelId(), originalTableGroup.getTriggerIdPrefix(), originalTableGroup.getTargetCatalog(), originalTableGroup.getTargetSchema(), originalTableGroup.isUseSourceCatalogSchema(), defaultTargetCatalog, defaultTargetSchema) == null) {
                changedTableGroupList.add(originalTableGroup);
                if (returnAfterOne) {
                    return changedTableGroupList;
                }
                originalTableGroup.setRemoved(true);
                continue;
            }
            if (returnAfterOne) continue;
            originalTableGroup.setRemoved(false);
        }
        for (ConfigCanvasLink.ConfigCanvasTableGroup tableGroup : link.getTableGroupList()) {
            boolean useSourceCatalogSchema;
            String targetSchema;
            String targetCatalog;
            String triggerIdPrefix;
            String channelId = tableGroup.getChannelId();
            ConfigCanvasLink.ConfigCanvasTableGroup originalTableGroup = originalLink.getTableGroup(channelId, triggerIdPrefix = tableGroup.getTriggerIdPrefix(), targetCatalog = tableGroup.getTargetCatalog(), targetSchema = tableGroup.getTargetSchema(), useSourceCatalogSchema = tableGroup.isUseSourceCatalogSchema(), targetEndpoint.getDefaultCatalog(), targetEndpoint.getDefaultSchema());
            if (originalTableGroup != null) {
                List<ConfigCanvasTable> changedTableList = this.getChangedTables(originalEndpoint, endpoint, originalTableGroup, tableGroup, returnAfterOne);
                if (changedTableList.isEmpty()) continue;
                ConfigCanvasLink configCanvasLink = changedLink;
                Objects.requireNonNull(configCanvasLink);
                changedTableGroupList.add(configCanvasLink.new ConfigCanvasLink.ConfigCanvasTableGroup(changedTableList, channelId, triggerIdPrefix, targetCatalog, targetSchema, useSourceCatalogSchema));
                if (!returnAfterOne) continue;
                return changedTableGroupList;
            }
            changedTableGroupList.add(tableGroup);
            if (returnAfterOne) {
                return changedTableGroupList;
            }
            tableGroup.setRemoved(false);
        }
        return changedTableGroupList;
    }

    /*
     * Unable to fully structure code
     */
    private List<AbstractSubsetRule> getChangedSubsetRules(ConfigCanvasEndpoint originalEndpoint, ConfigCanvasEndpoint endpoint, ConfigCanvasLink originalLink, ConfigCanvasLink link, boolean returnAfterOne) {
        changedSubsetRuleList = new ArrayList<AbstractSubsetRule>();
        for (AbstractSubsetRule originalSubsetRule : originalLink.getSubsetRuleList()) {
            if (!link.getSubsetRuleList().contains(originalSubsetRule)) {
                renamed = false;
                for (AbstractSubsetRule subsetRule : link.getSubsetRuleList()) {
                    originalName = subsetRule.getOriginalName();
                    if (originalName == null || !originalName.equals(originalSubsetRule.getName())) continue;
                    changedSubsetRuleList.add(subsetRule);
                    renamed = true;
                    break;
                }
                if (!renamed) {
                    changedSubsetRuleList.add(originalSubsetRule);
                }
                if (returnAfterOne) {
                    return changedSubsetRuleList;
                }
                if (renamed) continue;
                originalSubsetRule.setRemoved(true);
                continue;
            }
            if (returnAfterOne) continue;
            originalSubsetRule.setRemoved(false);
        }
        for (AbstractSubsetRule subsetRule : link.getSubsetRuleList()) {
            block15: {
                block17: {
                    block16: {
                        if (changedSubsetRuleList.contains(subsetRule)) continue;
                        if (!returnAfterOne) {
                            subsetRule.setOriginalName(null);
                        }
                        if ((originalSubsetRule = originalLink.getSubsetRule(name = subsetRule.getName())) == null) break block15;
                        ruleChanged = true;
                        changedSubsetRule = null;
                        if (!(subsetRule instanceof ColumnRule)) break block16;
                        columnRule = (ColumnRule)subsetRule;
                        if (!(originalSubsetRule instanceof ColumnRule)) break block16;
                        originalColumnRule = (ColumnRule)originalSubsetRule;
                        columnName = columnRule.getColumnName();
                        represents = columnRule.getRepresents();
                        v0 = ruleChanged = Strings.CS.equals(columnName, originalColumnRule.getColumnName()) == false || Strings.CS.equals(represents, originalColumnRule.getRepresents()) == false;
                        if (!ruleChanged) {
                            changedSubsetRule = new ColumnRule(null, name, columnName, represents);
                        }
                        break block17;
                    }
                    if (!(subsetRule instanceof LookupRule)) ** GOTO lbl-1000
                    lookupRule = (LookupRule)subsetRule;
                    if (originalSubsetRule instanceof LookupRule) {
                        originalLookupRule = (LookupRule)originalSubsetRule;
                        lookupTableName = lookupRule.getLookupTableName();
                        lookupColumnName = lookupRule.getLookupColumnName();
                        externalIdColumnName = lookupRule.getExternalIdColumnName();
                        replicatedColumnName = lookupRule.getReplicatedColumnName();
                        v1 = ruleChanged = Strings.CS.equals(lookupTableName, originalLookupRule.getLookupTableName()) == false || Strings.CS.equals(lookupColumnName, originalLookupRule.getLookupColumnName()) == false || Strings.CS.equals(externalIdColumnName, originalLookupRule.getExternalIdColumnName()) == false || Strings.CS.equals(replicatedColumnName, originalLookupRule.getReplicatedColumnName()) == false;
                        if (!ruleChanged) {
                            changedSubsetRule = new LookupRule(null, name, lookupTableName, lookupColumnName, externalIdColumnName, replicatedColumnName);
                        }
                    } else if (subsetRule instanceof SubselectRule) {
                        subselectRule = (SubselectRule)subsetRule;
                        if (originalSubsetRule instanceof SubselectRule) {
                            originalSubselectRule = (SubselectRule)originalSubsetRule;
                            subselect = subselectRule.getSubselect();
                            v2 = ruleChanged = Strings.CS.equals(subselect, originalSubselectRule.getSubselect()) == false;
                            if (!ruleChanged) {
                                changedSubsetRule = new SubselectRule(null, name, subselect);
                            }
                        }
                    }
                }
                if (ruleChanged) {
                    changedSubsetRuleList.add(subsetRule);
                    if (!returnAfterOne) continue;
                    return changedSubsetRuleList;
                }
                changedTableList = this.getChangedTables(originalEndpoint, endpoint, originalSubsetRule, subsetRule, returnAfterOne);
                if (changedTableList.isEmpty()) continue;
                changedSubsetRule.getTableSet().addAll(changedTableList);
                changedSubsetRuleList.add((AbstractSubsetRule)changedSubsetRule);
                if (!returnAfterOne) continue;
                return changedSubsetRuleList;
            }
            subsetRule.setRemoved(false);
            changedSubsetRuleList.add(subsetRule);
            if (!returnAfterOne) continue;
            return changedSubsetRuleList;
        }
        return changedSubsetRuleList;
    }

    private List<ConfigCanvasTable> getChangedTables(ConfigCanvasEndpoint originalEndpoint, ConfigCanvasEndpoint endpoint, HasConfigCanvasTableSet originalHasTableSet, HasConfigCanvasTableSet hasTableSet, boolean returnAfterOne) {
        ArrayList<ConfigCanvasTable> changedTableList = new ArrayList<ConfigCanvasTable>();
        for (ConfigCanvasTable originalTable : originalHasTableSet.getTableSet()) {
            String defaultSchema;
            String defaultCatalog;
            if (Strings.CS.equals(originalEndpoint.getUrl(), endpoint.getUrl()) && Strings.CS.equals(originalEndpoint.getUserId(), endpoint.getUserId())) {
                defaultCatalog = endpoint.getDefaultCatalog();
                defaultSchema = endpoint.getDefaultSchema();
            } else {
                defaultCatalog = originalEndpoint.getDefaultCatalog();
                defaultSchema = originalEndpoint.getDefaultSchema();
            }
            if (!hasTableSet.containsByName(originalTable.getCatalog(), originalTable.getSchema(), originalTable.getName(), defaultCatalog, defaultSchema)) {
                changedTableList.add(originalTable);
                if (returnAfterOne) {
                    return changedTableList;
                }
                originalTable.setRemoved(true);
                continue;
            }
            if (returnAfterOne) continue;
            originalTable.setRemoved(false);
        }
        for (ConfigCanvasTable table : hasTableSet.getTableSet()) {
            if (originalHasTableSet.containsByName(table.getCatalog(), table.getSchema(), table.getName(), endpoint.getDefaultCatalog(), endpoint.getDefaultSchema())) continue;
            table.setRemoved(false);
            changedTableList.add(table);
            if (!returnAfterOne) continue;
            return changedTableList;
        }
        return changedTableList;
    }

    private List<Set<ConfigCanvasTransformTable>> getChangedTransformSets(ConfigCanvasEndpoint originalEndpoint, ConfigCanvasEndpoint endpoint, ConfigCanvasLink originalLink, ConfigCanvasLink link, boolean returnAfterOne) {
        ArrayList<Set<ConfigCanvasTransformTable>> changedTransformSetList = new ArrayList<Set<ConfigCanvasTransformTable>>();
        for (Set<ConfigCanvasTransformTable> originalTransformSet : originalLink.getTransformList()) {
            String defaultSchema;
            String defaultCatalog;
            if (Strings.CS.equals(originalEndpoint.getUrl(), endpoint.getUrl()) && Strings.CS.equals(originalEndpoint.getUserId(), endpoint.getUserId())) {
                defaultCatalog = endpoint.getDefaultCatalog();
                defaultSchema = endpoint.getDefaultSchema();
            } else {
                defaultCatalog = originalEndpoint.getDefaultCatalog();
                defaultSchema = originalEndpoint.getDefaultSchema();
            }
            ConfigCanvasTransformTable firstOriginalTransform = originalTransformSet.iterator().next();
            if (link.getTransformSet(firstOriginalTransform.getTransformPoint(), firstOriginalTransform.getOriginalSourceCatalogName(), firstOriginalTransform.getOriginalSourceSchemaName(), defaultCatalog, defaultSchema) == null) {
                changedTransformSetList.add(originalTransformSet);
                if (returnAfterOne) {
                    return changedTransformSetList;
                }
                for (ConfigCanvasTransformTable originalTransform : originalTransformSet) {
                    originalTransform.setRemoved(true);
                }
                continue;
            }
            if (returnAfterOne) continue;
            for (ConfigCanvasTransformTable originalTransform : originalTransformSet) {
                originalTransform.setRemoved(false);
            }
        }
        for (Set<ConfigCanvasTransformTable> transformSet : link.getTransformList()) {
            ConfigCanvasTransformTable firstTransform = transformSet.iterator().next();
            Set<ConfigCanvasTransformTable> originalTransformSet = originalLink.getTransformSet(firstTransform.getTransformPoint(), firstTransform.getOriginalSourceCatalogName(), firstTransform.getOriginalSourceSchemaName(), endpoint.getDefaultCatalog(), endpoint.getDefaultSchema());
            if (originalTransformSet != null) {
                List<ConfigCanvasTransformTable> changedTransformList = this.getChangedTransforms(originalTransformSet, transformSet, returnAfterOne);
                if (!changedTransformList.isEmpty()) {
                    changedTransformSetList.add(new HashSet<ConfigCanvasTransformTable>(changedTransformList));
                    if (returnAfterOne) {
                        return changedTransformSetList;
                    }
                }
                if (returnAfterOne) continue;
                for (ConfigCanvasTransformTable transform : transformSet) {
                    transform.setNew(false);
                }
                continue;
            }
            changedTransformSetList.add(transformSet);
            if (returnAfterOne) {
                return changedTransformSetList;
            }
            for (ConfigCanvasTransformTable transform : transformSet) {
                transform.setNew(true);
            }
        }
        return changedTransformSetList;
    }

    private List<ConfigCanvasTransformTable> getChangedTransforms(Set<ConfigCanvasTransformTable> originalTransformSet, Set<ConfigCanvasTransformTable> transformSet, boolean returnAfterOne) {
        ArrayList<ConfigCanvasTransformTable> changedTransformList = new ArrayList<ConfigCanvasTransformTable>();
        for (ConfigCanvasTransformTable originalTransform : originalTransformSet) {
            boolean removed = true;
            String id = originalTransform.getId();
            for (ConfigCanvasTransformTable transform : transformSet) {
                if (!id.equals(transform.getId())) continue;
                removed = false;
                break;
            }
            if (removed) {
                changedTransformList.add(originalTransform);
                if (returnAfterOne) {
                    return changedTransformList;
                }
            }
            if (returnAfterOne) continue;
            originalTransform.setRemoved(removed);
        }
        for (ConfigCanvasTransformTable transform : transformSet) {
            boolean isNew = true;
            boolean changed = true;
            String id = transform.getId();
            for (ConfigCanvasTransformTable originalTransform : originalTransformSet) {
                if (!id.equals(originalTransform.getId())) continue;
                isNew = false;
                if (!Strings.CS.equals(transform.getSourceCatalogName(), originalTransform.getSourceCatalogName()) || !Strings.CS.equals(transform.getSourceSchemaName(), originalTransform.getSourceSchemaName()) || !Strings.CS.equals(transform.getTargetCatalogName(), originalTransform.getTargetCatalogName()) || !Strings.CS.equals(transform.getTargetSchemaName(), originalTransform.getTargetSchemaName()) || !transform.getColumnPolicy().equals((Object)originalTransform.getColumnPolicy()) || transform.isUpdateFirst() != originalTransform.isUpdateFirst() || !transform.getUpdateAction().equals(originalTransform.getUpdateAction()) || !transform.getDeleteAction().equals((Object)originalTransform.getDeleteAction()) || transform.getTransformOrder() != originalTransform.getTransformOrder() || this.haveAnyTransformColumnsChanged(originalTransform, transform)) break;
                changed = false;
                break;
            }
            if (changed) {
                transform.setRemoved(false);
                changedTransformList.add(transform);
                if (returnAfterOne) {
                    return changedTransformList;
                }
            }
            if (returnAfterOne) continue;
            transform.setNew(isNew);
        }
        return changedTransformList;
    }

    private boolean haveAnyTransformColumnsChanged(ConfigCanvasTransformTable originalTransform, ConfigCanvasTransformTable transform) {
        List<ConfigCanvasTransformTable.ConfigCanvasTransformColumn> originalTransformColumnList = originalTransform.getTransformColumns();
        List<ConfigCanvasTransformTable.ConfigCanvasTransformColumn> transformColumnList = transform.getTransformColumns();
        if (originalTransformColumnList.size() != transformColumnList.size()) {
            return true;
        }
        for (ConfigCanvasTransformTable.ConfigCanvasTransformColumn transformColumn : transformColumnList) {
            boolean newOrChanged = true;
            for (ConfigCanvasTransformTable.ConfigCanvasTransformColumn originalTransformColumn : originalTransformColumnList) {
                if (!Strings.CS.equals(transformColumn.getSourceColumnName(), originalTransformColumn.getSourceColumnName()) || !Strings.CS.equals(transformColumn.getTargetColumnName(), originalTransformColumn.getTargetColumnName()) || transformColumn.isPrimaryKey() != originalTransformColumn.isPrimaryKey() || !transformColumn.getTransformType().equals(originalTransformColumn.getTransformType()) || !Strings.CS.equals(transformColumn.getTransformExpression(), originalTransformColumn.getTransformExpression()) || transformColumn.getTransformOrder() != originalTransformColumn.getTransformOrder() || !transformColumn.getIncludeOn().equals((Object)originalTransformColumn.getIncludeOn())) continue;
                newOrChanged = false;
                break;
            }
            if (!newOrChanged) continue;
            return true;
        }
        return false;
    }

    public void replacePositionGuidsWithIds() {
        for (ConfigCanvasEndpoint endpoint : this.context.getEndpointList()) {
            this.position.replaceGuidWithId(endpoint.getGuid(), endpoint.getId());
        }
    }

    public void setSelectedEndpoint(ConfigCanvasEndpoint endpoint, boolean redrawDiagram) {
        String endpointGuid;
        String string = endpointGuid = endpoint != null ? endpoint.getGuid() : null;
        if (!Strings.CS.equals(endpointGuid, this.diagram.getDetail().getSelectedEndpointGuid())) {
            this.diagram.getDetail().clearSelection();
            this.diagram.getDetail().setSelectedEndpointGuid(endpointGuid);
            this.deleteButton.setEnabled(endpoint != null && !endpoint.isDeployed() && !endpoint.isRemote());
            this.deleteTooltip.setText(this.controller.getMessage(this.deleteButton.isEnabled() ? "Delete the selected endpoint or link" : "Select an undeployed endpoint or a link first", new Object[0]));
            if (redrawDiagram) {
                this.redrawDiagram();
            }
        }
    }

    public void setSelectedLink(String sourceGuid, String targetGuid) {
        String selectedSourceGuid = this.diagram.getDetail().getSelectedLinkSourceGuid();
        String selectedTargetGuid = this.diagram.getDetail().getSelectedLinkTargetGuid();
        if (!(Strings.CS.equals(sourceGuid, selectedSourceGuid) && Strings.CS.equals(targetGuid, selectedTargetGuid) || Strings.CS.equals(sourceGuid, selectedTargetGuid) && Strings.CS.equals(targetGuid, selectedSourceGuid))) {
            this.diagram.getDetail().clearSelection();
            this.diagram.getDetail().setSelectedLinkSourceGuid(sourceGuid);
            this.diagram.getDetail().setSelectedLinkTargetGuid(targetGuid);
            this.deleteButton.setEnabled(true);
            this.deleteTooltip.setText(this.controller.getMessage("Delete the selected endpoint or link", new Object[0]));
            this.redrawDiagram();
        }
    }

    public void endpointSelectedEvent(ConfigCanvasEndpoint selectedEndpoint) {
        if (!this.initialSetup && !this.addingNewReplication) {
            AbstractSidebarScreen currentScreen = null;
            if (!this.screenHistory.isEmpty()) {
                currentScreen = this.screenHistory.getLast();
                this.screenHistory.clear();
            }
            Command & Serializable callback = (Command & Serializable)() -> {
                this.sidebarErrorMessageLayout.setVisible(false);
                if (selectedEndpoint != null) {
                    this.firstEndpoint = selectedEndpoint;
                    this.nextScreen(new DefineEndpointScreen(this.controller, this, true));
                    this.progressStepper.setVisible(false);
                    this.nextDiv.setVisible(false);
                    this.sidebar.setVisible(true);
                    boolean localUndeployedEndpoint = !selectedEndpoint.isDeployed() && !selectedEndpoint.isRemote();
                    this.deleteButton.setEnabled(localUndeployedEndpoint && (this.controller.getSymmetricEngine() == null || this.controller.getConsoleUser().hasPrivilegeWrite("Canvas Screen")));
                    this.deleteTooltip.setText(this.controller.getMessage(localUndeployedEndpoint ? "Requires write permission" : "Select an undeployed endpoint or a link first", new Object[0]));
                } else {
                    this.sidebar.setVisible(false);
                    this.deleteButton.setEnabled(false);
                    this.deleteTooltip.setText(this.controller.getMessage("Select an undeployed endpoint or a link first", new Object[0]));
                }
                this.updateDivPositions(this.windowHeight, this.windowWidth);
            };
            this.executeCallback(currentScreen, callback);
        }
    }

    public void linkSelectedEvent(ConfigCanvasEndpoint selectedSourceEndpoint, ConfigCanvasEndpoint selectedTargetEndpoint) {
        if (!this.initialSetup && !this.addingNewReplication) {
            AbstractSidebarScreen currentScreen;
            if (!this.screenHistory.isEmpty()) {
                currentScreen = this.screenHistory.getLast();
                this.screenHistory.clear();
            } else {
                currentScreen = null;
            }
            Command & Serializable callback = (Command & Serializable)() -> {
                if (!(selectedSourceEndpoint == null || selectedTargetEndpoint == null || !selectedSourceEndpoint.isConnectionSuccessful() || !selectedTargetEndpoint.isConnectionSuccessful() || selectedSourceEndpoint.isRemote() && selectedSourceEndpoint.getUrl() == null || selectedTargetEndpoint.isRemote() && selectedTargetEndpoint.getUrl() == null)) {
                    this.sidebarErrorMessageLayout.setVisible(false);
                    this.showSelectTablesScreen(selectedSourceEndpoint, selectedTargetEndpoint);
                } else if (selectedSourceEndpoint != null && selectedTargetEndpoint != null) {
                    Object message;
                    String sourceId = selectedSourceEndpoint.getId();
                    boolean sourceConnectionSuccessful = selectedSourceEndpoint.isConnectionSuccessful();
                    String sourceExceptionMessage = selectedSourceEndpoint.getExceptionMessage();
                    String targetId = selectedTargetEndpoint.getId();
                    boolean targetConnectionSuccessful = selectedTargetEndpoint.isConnectionSuccessful();
                    String targetExceptionMessage = selectedTargetEndpoint.getExceptionMessage();
                    if (selectedSourceEndpoint.isRemote() && selectedSourceEndpoint.getUrl() == null && selectedTargetEndpoint.isRemote() && selectedTargetEndpoint.getUrl() == null) {
                        message = sourceId.equals(targetId) ? this.controller.getMessage("The '%s' endpoint is remote and connection details are unavailable.", sourceId) : this.controller.getMessage("The '%s' and '%s' endpoints are remote and connection details are unavailable.", sourceId, targetId);
                    } else if (!sourceConnectionSuccessful && StringUtils.isBlank((CharSequence)sourceExceptionMessage) && !targetConnectionSuccessful && StringUtils.isBlank((CharSequence)targetExceptionMessage)) {
                        message = sourceId.equals(targetId) ? this.controller.getMessage("The connection to the '%s' endpoint has failed.", sourceId) : this.controller.getMessage("The connections to the '%s' and '%s' endpoints have failed.", sourceId, targetId);
                    } else {
                        String targetMessage;
                        Object sourceMessage = this.getLinkCannotBeConfiguredMessageForEndpoint(selectedSourceEndpoint, sourceConnectionSuccessful, sourceExceptionMessage);
                        if (((String)sourceMessage).equals(targetMessage = this.getLinkCannotBeConfiguredMessageForEndpoint(selectedTargetEndpoint, targetConnectionSuccessful, targetExceptionMessage))) {
                            message = sourceMessage;
                        } else {
                            if (!targetMessage.equals("")) {
                                sourceMessage = StringUtils.isNotBlank((CharSequence)sourceExceptionMessage) && ((String)sourceMessage).endsWith(sourceExceptionMessage) ? (String)sourceMessage + "\n" : (String)sourceMessage + " ";
                            }
                            message = (String)sourceMessage + targetMessage;
                        }
                    }
                    if ((sourceConnectionSuccessful || targetConnectionSuccessful) && currentScreen instanceof DefineEndpointScreen) {
                        DefineEndpointScreen endpointScreen = (DefineEndpointScreen)currentScreen;
                        endpointScreen.onClose(false, () -> this.lambda$linkSelectedEvent$d9b8b3de$1(sourceConnectionSuccessful, targetConnectionSuccessful, selectedSourceEndpoint, selectedTargetEndpoint, (String)message));
                        return;
                    }
                    this.showLinkErrorMessage(selectedSourceEndpoint, selectedTargetEndpoint, (String)message);
                    boolean readOnly = this.isReadOnly();
                    this.deleteButton.setEnabled(!readOnly);
                    this.deleteTooltip.setText(this.controller.getMessage(readOnly ? "Requires write permission" : "Delete the selected endpoint or link", new Object[0]));
                } else {
                    this.sidebarErrorMessageLayout.setVisible(false);
                    this.sidebar.setVisible(false);
                }
                this.updateDivPositions(this.windowHeight, this.windowWidth);
            };
            this.executeCallback(currentScreen, callback);
        }
    }

    public void linkCreatedEvent(ConfigCanvasEndpoint linkSourceEndpoint, ConfigCanvasEndpoint linkTargetEndpoint, String sourceDiagramEndpointUuid, String targetDiagramEndpointUuid) {
        if (!this.initialSetup && !this.addingNewReplication && linkSourceEndpoint != null && linkTargetEndpoint != null) {
            linkSourceEndpoint.addLink(linkTargetEndpoint.getGuid(), linkTargetEndpoint.getId(), sourceDiagramEndpointUuid, targetDiagramEndpointUuid).setUserCreated(true);
            this.updateDeployButtonEnabled();
        }
    }

    private void showSelectTablesScreen(ConfigCanvasEndpoint selectedSourceEndpoint, ConfigCanvasEndpoint selectedTargetEndpoint) {
        this.firstEndpoint = selectedSourceEndpoint;
        this.secondEndpoint = selectedTargetEndpoint;
        this.nextScreen(new SelectTablesScreen(this.controller, this));
        this.progressStepper.setStepVisible(0, false);
        this.progressStepper.setStepVisible(1, false);
        this.progressStepper.setVisible(true);
        this.nextDiv.setVisible(true);
        this.sidebar.setVisible(true);
        boolean readOnly = this.isReadOnly();
        this.deleteButton.setEnabled(!readOnly);
        this.deleteTooltip.setText(this.controller.getMessage(readOnly ? "Requires write permission" : "Delete the selected endpoint or link", new Object[0]));
    }

    private String getLinkCannotBeConfiguredMessageForEndpoint(ConfigCanvasEndpoint endpoint, boolean connectionSuccessful, String exceptionMessage) {
        String id = endpoint.getId();
        if (endpoint.isRemote() && endpoint.getUrl() == null) {
            return this.controller.getMessage("The '%s' endpoint is remote and connection details are unavailable.", id);
        }
        if (!connectionSuccessful) {
            if (StringUtils.isNotBlank((CharSequence)exceptionMessage)) {
                return this.controller.getMessage("The connection to the '%s' endpoint has failed because of the following error: %s", id, exceptionMessage);
            }
            return this.controller.getMessage("The connection to the '%s' endpoint has failed.", id);
        }
        return "";
    }

    private void showLinkErrorMessage(ConfigCanvasEndpoint selectedSourceEndpoint, ConfigCanvasEndpoint selectedTargetEndpoint, String message) {
        Icon errorIcon = new Icon(VaadinIcon.EXCLAMATION_CIRCLE);
        errorIcon.getStyle().set("min-height", "24px").set("min-width", "24px");
        Span messageSpan = new Span();
        HorizontalLayout messageLayout = new HorizontalLayout(new Component[]{errorIcon, messageSpan});
        messageLayout.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.CENTER);
        messageLayout.getStyle().set("color", "var(--lumo-error-color)").set("font-weight", "600");
        if (selectedSourceEndpoint.getTableCount(selectedTargetEndpoint.getGuid()) > 0 || selectedTargetEndpoint.getTableCount(selectedSourceEndpoint.getGuid()) > 0) {
            messageSpan.setText(message + this.controller.getMessage(" This link cannot be configured without valid connection details.", new Object[0]));
            this.sidebarErrorMessageLayout.removeAll();
            this.sidebarErrorMessageLayout.add(new Component[]{messageLayout});
            this.sidebarErrorMessageLayout.setVisible(true);
            this.showSelectTablesScreen(selectedSourceEndpoint, selectedTargetEndpoint);
        } else {
            messageSpan.setText(message);
            ConfirmDialog messageDialog = new ConfirmDialog();
            messageDialog.setHeader(this.controller.getMessage("This link cannot be configured", new Object[0]));
            messageDialog.setText((Component)messageLayout);
            messageDialog.setConfirmButton((Component)as.createPrimaryButton(this.controller.getMessage("OK", new Object[0]), true));
            messageDialog.open();
            this.sidebarErrorMessageLayout.setVisible(false);
            this.sidebar.setVisible(false);
        }
    }

    public void endpointIdUpdated(String guid, String id, boolean isFromClient) {
        for (ConfigCanvasEndpoint otherEndpoint : this.getEndpointList()) {
            ConfigCanvasLink link = otherEndpoint.getLink(guid);
            if (link == null) continue;
            link.setTargetEndpointId(id);
        }
        this.position.setIdForGuid(guid, id);
        if (isFromClient) {
            this.refresh();
        }
    }

    private ISidebarScreen getCurrentScreen() {
        if (this.sidebarScreenLayout.getComponentCount() > 0) {
            return (ISidebarScreen)this.sidebarScreenLayout.getComponentAt(0);
        }
        return null;
    }

    private void nextScreen() {
        ISidebarScreen screen = this.getCurrentScreen();
        if (screen != null) {
            ISidebarScreen nextScreen = screen.next();
            if (nextScreen != null) {
                this.nextScreen(nextScreen);
            }
        } else {
            this.nextScreen(new DefineEndpointScreen(this.controller, this, true));
        }
    }

    public void nextScreen(ISidebarScreen screen) {
        if (screen != null) {
            this.sidebarScreenLayout.removeAll();
            this.sidebarScreenLayout.add(new Component[]{(AbstractSidebarScreen)screen});
            this.sidebarScreenLayout.expand(new Component[]{(AbstractSidebarScreen)screen});
            this.screenHistory.add((AbstractSidebarScreen)screen);
            this.helpAnchorDiv.removeAll();
            this.helpAnchorDiv.add(new Component[]{this.createHelpAnchor(screen.getDocAnchor())});
            this.sidebarFooter.removeAll();
            screen.addComponentsToFooter(this.sidebarFooter);
            this.previousButton.setEnabled(this.hasPreviousScreen() && screen.isPreviousEnabled());
            this.previousButton.setVisible(screen.isPreviousVisible());
            this.previousButton.setTooltipText(screen.getPreviousButtonTooltip());
            if (screen.isFinishVisible()) {
                this.nextButton.setText(this.controller.getMessage("Finish", new Object[0]));
            } else {
                this.nextButton.setText(this.controller.getMessage("Next", new Object[0]));
            }
            this.nextButton.setEnabled(screen.isNextEnabled());
            this.setNextButtonTooltip(screen.getNextButtonTooltip());
            this.updateSidebarHeader();
            this.sidebar.setVisible(true);
        }
    }

    private void lastScreen() {
        AbstractSidebarScreen screen;
        if (this.hasPreviousScreen() && (screen = this.screenHistory.getLast()).last()) {
            this.screenHistory.removeLast();
            screen = this.screenHistory.getLast();
            this.sidebarScreenLayout.removeAll();
            this.sidebarScreenLayout.add(new Component[]{screen});
            this.sidebarScreenLayout.expand(new Component[]{screen});
            this.helpAnchorDiv.removeAll();
            this.helpAnchorDiv.add(new Component[]{this.createHelpAnchor(screen.getDocAnchor())});
            this.sidebarFooter.removeAll();
            screen.addComponentsToFooter(this.sidebarFooter);
            this.previousButton.setEnabled(this.screenHistory.size() > 1 && screen.isPreviousEnabled());
            this.previousButton.setVisible(screen.isPreviousVisible());
            this.previousButton.setTooltipText(screen.getPreviousButtonTooltip());
            this.nextButton.setText(this.controller.getMessage("Next", new Object[0]));
            this.nextButton.setEnabled(screen.isNextEnabled());
            this.setNextButtonTooltip(screen.getNextButtonTooltip());
        }
    }

    public boolean hasPreviousScreen() {
        return this.screenHistory.size() > 1;
    }

    public void enableShortcuts(boolean enable) {
        if (enable && this.nextButtonShortcutRegistration == null) {
            this.nextButtonShortcutRegistration = this.nextButton.addClickShortcut(Key.ENTER, new KeyModifier[0]);
        } else if (!enable && this.nextButtonShortcutRegistration != null) {
            this.nextButtonShortcutRegistration.remove();
            this.nextButtonShortcutRegistration = null;
        }
    }

    private Gson buildGson(boolean includeLicenseKeyAdapter) {
        GsonBuilder gsonBuilder = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes field) {
                if (ConfigCanvasEndpoint.class.equals((Object)field.getDeclaringClass())) {
                    String name = field.getName();
                    return name.equals("html") || name.equals("stateIconSrc") || name.equals("connectionSuccessful") || name.equals("x") || name.equals("y");
                }
                return false;
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }
        }}).registerTypeAdapter(AbstractSubsetRule.class, (Object)new SubsetRuleAdapter());
        if (includeLicenseKeyAdapter) {
            return gsonBuilder.registerTypeAdapter(ConfigCanvasContext.class, (Object)new LicenseKeyAdapter()).create();
        }
        return gsonBuilder.create();
    }

    public void savePositionJsonFile(String consoleUserId, ISymmetricEngine engine) {
        Date now = new Date();
        this.position.setModified(now);
        File positionJsonFile = this.getJsonFile(true, consoleUserId, engine);
        if (!positionJsonFile.exists()) {
            this.position.setCreated(now);
        }
        try (FileWriter positionJsonFileWriter = new FileWriter(positionJsonFile);){
            new Gson().toJson((Object)this.position, (Appendable)positionJsonFileWriter);
            positionJsonFileWriter.flush();
            this.position.setChanged(false);
        }
        catch (Exception e2) {
            this.log.warn("Failed to save Configure Canvas position to the following .json file: " + positionJsonFile.getAbsolutePath(), (Throwable)e2);
        }
    }

    public void forceRefreshJsonFile() {
        this.forceRefreshJsonFile = true;
    }

    public boolean confirmExit(Runnable exitCallback) {
        if (this.ribbon.isVisible()) {
            ConfirmDialog confirmLeaveDialog = new ConfirmDialog(this.controller.getMessage("Are you sure you want to leave the Configure Canvas?", new Object[0]), this.controller.getMessage("If you leave the Canvas without deploying your changes, then they will not take effect.", new Object[0]), this.controller.getMessage("Leave", new Object[0]), (ComponentEventListener & Serializable)e2 -> exitCallback.run());
            Button stayButton = new Button(this.controller.getMessage("Stay", new Object[0]));
            stayButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
            stayButton.getStyle().set("margin-right", "16px");
            confirmLeaveDialog.setRejectable(true);
            confirmLeaveDialog.setRejectButton((Component)stayButton);
            confirmLeaveDialog.open();
            return false;
        }
        return true;
    }

    private /* synthetic */ void lambda$linkSelectedEvent$d9b8b3de$1(boolean sourceConnectionSuccessful, boolean targetConnectionSuccessful, ConfigCanvasEndpoint selectedSourceEndpoint, ConfigCanvasEndpoint selectedTargetEndpoint, String message) {
        if (sourceConnectionSuccessful && targetConnectionSuccessful) {
            this.linkSelectedEvent(selectedSourceEndpoint, selectedTargetEndpoint);
        } else {
            this.showLinkErrorMessage(selectedSourceEndpoint, selectedTargetEndpoint, message);
            this.updateDivPositions(this.windowHeight, this.windowWidth);
        }
    }

    private static /* synthetic */ boolean lambda$loadConfigFromDatabase$3(String id, ConfigCanvasEndpoint e2) {
        return id.equals(e2.getId());
    }

    class LicenseViolationDialog
    extends X {
        private static final long serialVersionUID = 1L;

        public LicenseViolationDialog(VerticalLayout layout) {
            super(ConfigCanvas.this.controller.getMessage("Warning", new Object[0]), ConfigCanvas.this.controller.getContextPath());
            this.setCloseOnOutsideClick(false);
            this.mainLayout.setSizeUndefined();
            this.mainLayout.add(new Component[]{layout});
            this.getFooter().add(new Component[]{as.createPrimaryButton(ConfigCanvas.this.controller.getMessage("OK", new Object[0]), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> this.close())});
        }
    }

    class EndpointDeploymentRefresher
    implements G<Set<String>> {
        EndpointDeploymentRefresher() {
        }

        @Override
        public Set<String> onBackgroundDataRefresh(ISymmetricEngine engine) {
            if (engine == null || ConfigCanvas.this.initializing || ConfigCanvas.this.deployWizard != null && ConfigCanvas.this.deployWizard.e()) {
                return null;
            }
            HashSet<String> deployedIdSet = new HashSet<String>();
            List nodeList = null;
            block0: for (ConfigCanvasEndpoint endpoint : ConfigCanvas.this.context.getEndpointList()) {
                if (endpoint.isDeployed()) continue;
                String id = endpoint.getId();
                if (endpoint.isRemote()) {
                    if (nodeList == null) {
                        nodeList = engine.getNodeService().findAllNodes(true);
                    }
                    for (Node node : nodeList) {
                        if (!id.equals(node.getNodeGroupId())) continue;
                        endpoint.load(node);
                        deployedIdSet.add(id);
                        continue block0;
                    }
                    continue;
                }
                for (ISymmetricEngine otherEngine : ConfigCanvas.this.controller.getSymmetricEngines()) {
                    if (!id.equals(otherEngine.getParameterService().getNodeGroupId())) continue;
                    endpoint.load(otherEngine);
                    deployedIdSet.add(id);
                    continue block0;
                }
            }
            return deployedIdSet.isEmpty() ? null : deployedIdSet;
        }

        @Override
        public void onBackgroundUIRefresh(Set<String> deployedIdSet) {
            if (deployedIdSet == null) {
                return;
            }
            if (ConfigCanvas.this.sidebar != null && ConfigCanvas.this.sidebar.isVisible() && ConfigCanvas.this.firstEndpoint != null && deployedIdSet.contains(ConfigCanvas.this.firstEndpoint.getId()) && !ConfigCanvas.this.screenHistory.isEmpty() && ConfigCanvas.this.screenHistory.getLast() instanceof DefineEndpointScreen) {
                ConfigCanvas.this.closeSidebarAndClearSelection(false, false);
            }
            ConfigCanvas.this.refreshEndpoints();
            ConfigCanvas.this.redrawDiagram();
        }

        @Override
        public void onUIError(Throwable ex2) {
        }
    }

    class JsonFileRefresher
    implements G<Void> {
        JsonFileRefresher() {
        }

        @Override
        public Void onBackgroundDataRefresh(ISymmetricEngine engine) {
            File jsonFile;
            boolean jsonFileExists;
            AbstractSidebarScreen abstractSidebarScreen;
            if (ConfigCanvas.this.initializing || ConfigCanvas.this.deployWizard != null && ConfigCanvas.this.deployWizard.e()) {
                return null;
            }
            if (ConfigCanvas.this.position.isChanged()) {
                ConfigCanvas.this.savePositionJsonFile(null, engine);
            }
            boolean checkForChangedEndpoints = true;
            if (ConfigCanvas.this.forceRefreshJsonFile) {
                checkForChangedEndpoints = false;
                ConfigCanvas.this.forceRefreshJsonFile = false;
            }
            if (!ConfigCanvas.this.screenHistory.isEmpty() && (abstractSidebarScreen = ConfigCanvas.this.screenHistory.getLast()) instanceof DefineEndpointScreen) {
                ConfigCanvasEndpoint endpointBeingEdited;
                DefineEndpointScreen defineEndpointScreen = (DefineEndpointScreen)abstractSidebarScreen;
                ConfigCanvasEndpoint configCanvasEndpoint = endpointBeingEdited = defineEndpointScreen.isFirst() ? ConfigCanvas.this.firstEndpoint : ConfigCanvas.this.secondEndpoint;
                if (endpointBeingEdited != null && !endpointBeingEdited.isConnectionSuccessful()) {
                    if (endpointBeingEdited.areAnyTablesConfigured()) {
                        checkForChangedEndpoints = false;
                    } else {
                        String guid = endpointBeingEdited.getGuid();
                        for (ConfigCanvasEndpoint endpoint : ConfigCanvas.this.context.getEndpointList()) {
                            ConfigCanvasLink link = endpoint.getLink(guid);
                            if (link == null || link.getOutgoingTableCount() <= 0 && link.getIncomingTableCount() <= 0) continue;
                            checkForChangedEndpoints = false;
                            break;
                        }
                    }
                }
            }
            if (checkForChangedEndpoints &= (jsonFileExists = (jsonFile = ConfigCanvas.this.getJsonFile(false, null, engine)).exists()) || ConfigCanvas.this.context.getImportedFileName() == null && ConfigCanvas.this.context.getImportedLicenseKeyString() == null && ConfigCanvas.this.context.getImportedChannelIdSet().isEmpty() && ConfigCanvas.this.context.getImportedTransformColumnTypeSet().isEmpty()) {
                try {
                    if (ConfigCanvas.this.getChangedEndpoints(ConfigCanvas.this.context.getSavedEndpointList(), true).isEmpty()) {
                        return null;
                    }
                }
                catch (ConcurrentModificationException e2) {
                    return null;
                }
            }
            Gson gson = ConfigCanvas.this.buildGson(true);
            ConfigCanvas.this.context.updateSavedEndpointList(gson);
            Date now = new Date();
            ConfigCanvas.this.context.setModified(now);
            ISecurityService securityService = engine != null ? engine.getSecurityService() : SecurityServiceFactory.create();
            ConfigCanvas.this.context.encryptPasswords(securityService);
            if (!jsonFileExists) {
                ConfigCanvas.this.context.setCreated(now);
            }
            try (FileWriter jsonFileWriter = new FileWriter(jsonFile);){
                gson.toJson((Object)ConfigCanvas.this.context, (Appendable)jsonFileWriter);
                jsonFileWriter.flush();
            }
            catch (Exception e3) {
                ConfigCanvas.this.log.warn("Failed to save Configure Canvas state to the following .json file: " + jsonFile.getAbsolutePath(), (Throwable)e3);
            }
            ConfigCanvas.this.context.decryptPasswords(securityService);
            return null;
        }

        @Override
        public void onBackgroundUIRefresh(Void backgroundData) {
        }

        @Override
        public void onUIError(Throwable ex2) {
        }
    }

    class SubsetRuleAdapter
    implements JsonDeserializer<Object>,
    JsonSerializer<Object> {
        private static final String CLASS_KEY = "CLASS";

        SubsetRuleAdapter() {
        }

        public JsonElement serialize(Object src, Type typeOfSrc, JsonSerializationContext context) {
            Class<?> subsetRuleClass = src.getClass();
            JsonElement jsonElement = context.serialize(src, subsetRuleClass);
            if (ColumnRule.class.equals(subsetRuleClass)) {
                jsonElement.getAsJsonObject().addProperty(CLASS_KEY, "column");
            } else if (LookupRule.class.equals(subsetRuleClass)) {
                jsonElement.getAsJsonObject().addProperty(CLASS_KEY, "lookuptable");
            } else if (SubselectRule.class.equals(subsetRuleClass)) {
                jsonElement.getAsJsonObject().addProperty(CLASS_KEY, "subselect");
            }
            return jsonElement;
        }

        public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                switch (json.getAsJsonObject().get(CLASS_KEY).getAsString()) {
                    case "column": {
                        return context.deserialize(json, ColumnRule.class);
                    }
                    case "lookuptable": {
                        return context.deserialize(json, LookupRule.class);
                    }
                    case "subselect": {
                        return context.deserialize(json, SubselectRule.class);
                    }
                }
            }
            catch (Exception e2) {
                throw new JsonParseException("Failed to deserialize subset rule: " + json.toString(), (Throwable)e2);
            }
            throw new JsonParseException("Failed to deserialize subset rule: " + json.toString());
        }
    }

    class LicenseKeyAdapter
    implements JsonDeserializer<ConfigCanvasContext> {
        LicenseKeyAdapter() {
        }

        public ConfigCanvasContext deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ConfigCanvasContext deserializedContext = (ConfigCanvasContext)ConfigCanvas.this.buildGson(false).fromJson((JsonElement)json.getAsJsonObject(), ConfigCanvasContext.class);
            String importedLicenseKeyString = deserializedContext.getImportedLicenseKeyString();
            if (importedLicenseKeyString != null) {
                deserializedContext.setImportedLicenseKey(c.a(importedLicenseKeyString, com.jumpmind.symmetric.console.impl.M.class));
            }
            return deserializedContext;
        }
    }
}

