/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.service.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.jumpmind.symmetric.console.remote.IMessageHandler;
import com.jumpmind.symmetric.console.remote.IRemoteStatusService;
import com.jumpmind.symmetric.console.service.IMetaDataService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.AbstractSymmetricEngine;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroup;
import org.jumpmind.util.CustomizableThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataService
implements IMetaDataService,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ISymmetricEngine engine;
    private Map<String, String> defaultCatalogMap;
    private Map<String, String> defaultSchemaMap;
    private Map<String, Map<String, Map<String, List<String>>>> tableMap;
    private CustomizableThreadFactory threadFactory;
    private ExecutorService executor;

    @Override
    public void refreshLocalMetaData(Set<ISymmetricEngine> engines) {
        HashSet<String> refreshedNodeGroupIds = new HashSet<String>();
        for (ISymmetricEngine engine : engines) {
            String nodeGroupId;
            Node identity = engine.getNodeService().findIdentity();
            if (identity == null || refreshedNodeGroupIds.contains(nodeGroupId = identity.getNodeGroupId())) continue;
            String defaultCatalog = engine.getTargetDialect().getPlatform().getDefaultCatalog();
            String defaultSchema = engine.getTargetDialect().getPlatform().getDefaultSchema();
            String tablePrefix = engine.getTablePrefix();
            HashSet<String> symTables = null;
            this.defaultCatalogMap.put(nodeGroupId, defaultCatalog);
            this.defaultSchemaMap.put(nodeGroupId, defaultSchema);
            if (tablePrefix != null) {
                symTables = new HashSet<String>(TableConstants.getTables((String)tablePrefix));
            }
            if (this.tableMap.get(nodeGroupId) == null) {
                this.tableMap.put(nodeGroupId, new HashMap());
            }
            if (defaultCatalog == null || defaultCatalog.isEmpty()) {
                if (this.tableMap.get(nodeGroupId).get(defaultCatalog) == null) {
                    this.tableMap.get(nodeGroupId).put(defaultCatalog, new HashMap());
                }
                this.refreshLocalSchemas(engine, nodeGroupId, symTables, tablePrefix, defaultCatalog, defaultSchema);
            } else {
                for (String c2 : engine.getTargetDialect().getPlatform().getDdlReader().getCatalogNames()) {
                    if (this.tableMap.get(nodeGroupId) == null) {
                        this.tableMap.put(nodeGroupId, new HashMap());
                    }
                    this.tableMap.get(nodeGroupId).put(c2, new HashMap());
                    this.refreshLocalSchemas(engine, nodeGroupId, symTables, tablePrefix, c2, defaultSchema);
                }
            }
            refreshedNodeGroupIds.add(nodeGroupId);
        }
    }

    public void refreshLocalSchemas(ISymmetricEngine engine, String nodeGroupId, Set<String> symTables, String tablePrefix, String catalog, String defaultSchema) {
        if (defaultSchema == null) {
            if (this.tableMap.get(nodeGroupId).get(catalog).get(defaultSchema) == null) {
                this.tableMap.get(nodeGroupId).get(catalog).put(defaultSchema, new ArrayList());
            }
            this.refreshLocalTables(engine, nodeGroupId, symTables, tablePrefix, catalog, defaultSchema);
        }
        List schemas = new ArrayList();
        try {
            schemas = engine.getTargetDialect().getPlatform().getDdlReader().getSchemaNames(catalog);
            if (schemas == null) {
                schemas = new ArrayList();
            }
        }
        catch (Exception e2) {
            this.log.debug("Unable to get schemas for catalog " + catalog, (Throwable)e2);
        }
        for (String schema : schemas) {
            if (this.tableMap.get(nodeGroupId).get(catalog).get(schema) == null) {
                this.tableMap.get(nodeGroupId).get(catalog).put(schema, new ArrayList());
            }
            this.refreshLocalTables(engine, nodeGroupId, symTables, tablePrefix, catalog, schema);
        }
    }

    @Override
    public void refreshLocalTables(ISymmetricEngine engine, String nodeGroupId, Set<String> symTables, String tablePrefix, String catalog, String schema) {
        ArrayList tableList = engine.getTargetDialect().getPlatform().getDdlReader().getTableNames(catalog, schema, new String[]{"TABLE"});
        if (tableList == null) {
            tableList = new ArrayList();
        }
        for (String tableName : tableList) {
            if (symTables == null || tableName == null || symTables.contains(tableName.toLowerCase()) || tableName.toLowerCase().startsWith(tablePrefix)) continue;
            this.tableMap.get(nodeGroupId).get(catalog).get(schema).add(tableName);
        }
    }

    @Override
    public void refreshMetaDataInBackground(final Set<ISymmetricEngine> engines, final boolean force) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                MetaDataService.this.refreshMetaData(engines, force);
            }
        });
    }

    @Override
    public void refreshMetaData(Set<ISymmetricEngine> engines, boolean force) {
        Set<String> missingGroups = this.getMissingMetaGroups();
        if (force || this.tableMap == null || missingGroups.size() > 0) {
            boolean clientConfig = this.engine.getParameterService().getString("console.auth.config.client", "false").equalsIgnoreCase("true");
            boolean remoteMetaEnabled = this.engine.getParameterService().is("console.remote.meta.data", false);
            boolean server = this.engine.getParameterService().isRegistrationServer();
            for (ISymmetricEngine e2 : AbstractSymmetricEngine.findEngines()) {
                if (!e2.getParameterService().isRegistrationServer()) continue;
                server = true;
            }
            if (remoteMetaEnabled && (server || !server && clientConfig)) {
                IRemoteStatusService remoteStatusService = (IRemoteStatusService)this.engine.getExtensionService().getExtensionPoint(IRemoteStatusService.class);
                final Gson gson = new GsonBuilder().create();
                if (!this.tableMap.containsKey(this.engine.getParameterService().getNodeGroupId())) {
                    this.refreshLocalMetaData(engines);
                }
                for (final String ng : missingGroups) {
                    Collection nodes;
                    if (this.engine.getNodeService().getCachedIdentity().getNodeGroupId().equals(ng) || (nodes = this.engine.getNodeService().findEnabledNodesFromNodeGroup(ng)) == null || nodes.size() <= 0) continue;
                    String nodeId = ((Node)nodes.iterator().next()).getNodeId();
                    final HashMap ngTables = new HashMap();
                    remoteStatusService.sendMessage(nodeId, "meta", new IMessageHandler(){

                        @Override
                        public void onMessage(String message) {
                            try {
                                JsonObject json = (JsonObject)gson.fromJson(message, JsonObject.class);
                                JsonArray catalogsArray = json.getAsJsonObject("metadata").getAsJsonArray("catalogs");
                                JsonElement defaultCatalog = json.getAsJsonObject("metadata").get("default-catalog");
                                JsonElement defaultSchema = json.getAsJsonObject("metadata").get("default-schema");
                                MetaDataService.this.defaultCatalogMap.put(ng, defaultCatalog == null ? null : defaultCatalog.getAsString());
                                MetaDataService.this.defaultSchemaMap.put(ng, defaultSchema == null ? null : defaultSchema.getAsString());
                                for (JsonElement catalogElement : catalogsArray) {
                                    JsonObject catalogObj = catalogElement.getAsJsonObject();
                                    String catalog = null;
                                    if (catalogObj.get("catalog") != null) {
                                        catalog = catalogObj.get("catalog").getAsString();
                                    }
                                    ngTables.put(catalog, new HashMap());
                                    for (JsonElement schemaElement : catalogObj.getAsJsonArray("schemas")) {
                                        JsonObject schemaObj = schemaElement.getAsJsonObject();
                                        String schema = null;
                                        if (schemaObj.get("schema") != null) {
                                            schema = schemaObj.get("schema").getAsString();
                                        }
                                        ((Map)ngTables.get(catalog)).put(schema, new ArrayList());
                                        for (JsonElement tableElement : schemaObj.getAsJsonArray("tables")) {
                                            ((List)((Map)ngTables.get(catalog)).get(schema)).add(tableElement.getAsString());
                                        }
                                    }
                                }
                                if (!ngTables.isEmpty()) {
                                    MetaDataService.this.tableMap.put(ng, ngTables);
                                }
                            }
                            catch (JsonSyntaxException e2) {
                                MetaDataService.this.log.error(message, (Throwable)e2);
                            }
                        }

                        @Override
                        public void onError(Exception ex2) {
                            System.out.println(ex2.getMessage());
                        }
                    });
                }
            }
        }
    }

    protected Set<String> getMissingMetaGroups() {
        HashSet<String> ret = new HashSet<String>();
        for (NodeGroup ng : this.engine.getConfigurationService().getNodeGroups()) {
            if (this.tableMap.containsKey(ng.getNodeGroupId())) continue;
            ret.add(ng.getNodeGroupId());
        }
        return ret;
    }

    @Override
    public boolean isReady(String nodeGroup) {
        return !this.getMissingMetaGroups().contains(nodeGroup);
    }

    @Override
    public String getDefaultCatalog(String nodeGroup) {
        return this.defaultCatalogMap.get(nodeGroup);
    }

    @Override
    public String getDefaultSchema(String nodeGroup) {
        return this.defaultSchemaMap.get(nodeGroup);
    }

    @Override
    public Map<String, Map<String, List<String>>> getTables(String nodeGroup) {
        return this.tableMap.get(nodeGroup);
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
        this.threadFactory = new CustomizableThreadFactory(engine.getParameterService().getEngineName().toLowerCase() + "-background-metaData");
        this.executor = Executors.newFixedThreadPool(engine.getParameterService().getInt("console.remote.meta.data.thread.count"), (ThreadFactory)this.threadFactory);
        this.defaultCatalogMap = Collections.synchronizedMap(new HashMap());
        this.defaultSchemaMap = Collections.synchronizedMap(new HashMap());
        this.tableMap = new ConcurrentHashMap<String, Map<String, Map<String, List<String>>>>();
    }
}

