/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.service.impl;

import com.jumpmind.symmetric.console.impl.L;
import com.jumpmind.symmetric.console.impl.e;
import com.jumpmind.symmetric.console.impl.i;
import com.jumpmind.symmetric.console.impl.l;
import com.jumpmind.symmetric.console.impl.m;
import com.jumpmind.symmetric.console.impl.n;
import com.jumpmind.symmetric.console.impl.o;
import com.jumpmind.symmetric.console.impl.p;
import com.jumpmind.symmetric.console.impl.q;
import com.jumpmind.symmetric.console.impl.r;
import com.jumpmind.symmetric.console.model.CompareRequest;
import com.jumpmind.symmetric.console.model.CompareStatus;
import com.jumpmind.symmetric.console.model.CompareTableStatus;
import com.jumpmind.symmetric.console.service.ICompareService;
import com.jumpmind.symmetric.console.service.impl.CompareServiceSqlMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.exception.HttpException;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.io.data.transform.TransformPoint;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeCommunication;
import org.jumpmind.symmetric.model.NodeHost;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessInfoKey;
import org.jumpmind.symmetric.model.ProcessType;
import org.jumpmind.symmetric.model.RemoteNodeStatus;
import org.jumpmind.symmetric.model.RemoteNodeStatuses;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.INodeCommunicationService;
import org.jumpmind.symmetric.service.impl.ISqlMap;
import org.jumpmind.symmetric.service.impl.TransformService;
import org.jumpmind.symmetric.transport.OfflineException;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.jumpmind.util.AppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareService
extends e
implements ICompareService,
IBuiltInExtensionPoint,
ISymmetricEngineAware,
INodeCommunicationService.INodeCommunicationExecutor {
    protected final Logger log = LoggerFactory.getLogger(CompareService.class);
    protected L licenseService;
    protected ISqlMap sqlMap;
    protected Map<String, CompareTableStatus> executingCompare = new ConcurrentHashMap<String, CompareTableStatus>();
    protected p compareTable;
    protected i compareChunk;
    protected o compareRow;
    protected m compareRepair;
    protected r transportMan;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        if (this.engine.getNodeService().findIdentity() != null && this.engine.getClusterService().lock("Compare")) {
            try {
                if (this.licenseService == null) {
                    this.licenseService = (L)this.engine.getExtensionService().getExtensionPoint(L.class);
                }
                int perRequestCount = this.parameterService.getInt("compare.queue.per.request.count", 1);
                boolean progress = this.licenseService.f();
                while (progress) {
                    List requests = this.engine.getSqlTemplate().query(this.sqlMap.getSql(new String[]{"selectCompareRequestsToProcessSql"}), (ISqlRowMapper)new CompareRequestRowMapper(), new Object[]{this.engine.getNodeId(), new Date(), this.engine.getNodeId(), this.engine.getNodeId()});
                    ArrayList<CompareRequest> requestsToProcess = new ArrayList<CompareRequest>();
                    ArrayList<CompareRequest> requestsToCancel = new ArrayList<CompareRequest>();
                    HashMap<String, CompareRequest> requestsToExecute = new HashMap<String, CompareRequest>();
                    for (CompareRequest request : requests) {
                        if (request.isCancelled()) {
                            requestsToCancel.add(request);
                            continue;
                        }
                        if (request.isProcessed()) {
                            requestsToExecute.putIfAbsent(this.buildKey(request.getSourceNodeId(), request.getCompareId()), request);
                            continue;
                        }
                        requestsToProcess.add(request);
                    }
                    this.cancelRequests(requestsToCancel);
                    this.queueRequests(requestsToExecute);
                    this.processRequests(requestsToProcess, requestsToExecute.size() * perRequestCount);
                    progress = (requestsToCancel.size() > 0 || requestsToExecute.size() > 0 || requestsToProcess.size() > 0) && this.parameterService.is("compare.immediate.if.request.found");
                    if (!progress) continue;
                    AppUtils.sleep((long)this.parameterService.getInt("compare.immediate.time.ms"));
                }
            }
            catch (Exception e2) {
                this.log.error("Error while processing compare requests", (Throwable)e2);
            }
            finally {
                this.engine.getClusterService().unlock("Compare");
            }
        }
    }

    protected void queueRequests(Map<String, CompareRequest> requestsToExecute) {
        ArrayList<CompareTableStatus> tablesToCompare = new ArrayList<CompareTableStatus>();
        int perRequestCount = this.parameterService.getInt("compare.queue.per.request.count", 1);
        for (CompareRequest request : requestsToExecute.values()) {
            List tableStatuses = this.engine.getSqlTemplate().query(this.sqlMap.getSql(new String[]{"selectCompareTableStatusByCompareIdStatusSql"}), (ISqlRowMapper)new CompareTableStatusRowMapper(), new Object[]{request.getSourceNodeId(), request.getCompareId(), "OK"});
            if (tableStatuses.size() == 0) {
                this.complete(request);
                continue;
            }
            boolean allInError = true;
            for (CompareTableStatus tableStatus : tableStatuses) {
                if (tableStatus.isErrorFlag()) continue;
                allInError = false;
                break;
            }
            if (allInError) {
                Collections.sort(tableStatuses, new q());
            }
            for (int i2 = 0; i2 < tableStatuses.size() && i2 < perRequestCount; ++i2) {
                CompareTableStatus tableStatus;
                tableStatus = (CompareTableStatus)tableStatuses.get(i2);
                if (tableStatus.isErrorFlag() && !allInError) continue;
                tableStatus.setCompareRequest(request);
                tablesToCompare.add(tableStatus);
            }
        }
        this.queueExecution(tablesToCompare);
    }

    protected synchronized boolean queueExecution(CompareTableStatus tableStatus) {
        boolean isRunning;
        ArrayList<CompareTableStatus> list = new ArrayList<CompareTableStatus>();
        list.add(tableStatus);
        RemoteNodeStatuses nodeStatuses = this.queueExecution(list);
        boolean bl2 = isRunning = !this.parameterService.is("cluster.lock.enabled");
        if (!isRunning) {
            for (int i2 = 0; i2 < 10; ++i2) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e2) {
                    break;
                }
                if (nodeStatuses.size() <= 0) continue;
                isRunning = true;
                break;
            }
        }
        return isRunning;
    }

    protected synchronized RemoteNodeStatuses queueExecution(List<CompareTableStatus> tableStatuses) {
        INodeCommunicationService nodeCommunicationService = this.engine.getNodeCommunicationService();
        RemoteNodeStatuses nodeStatuses = new RemoteNodeStatuses(this.engine.getConfigurationService().getChannels(false));
        int availableThreads = nodeCommunicationService.getAvailableThreads(NodeCommunication.CommunicationType.COMPARE);
        if (this.log.isDebugEnabled() && tableStatuses.size() > 0) {
            this.log.debug("There are {} tables to compare and {} threads available", (Object)tableStatuses.size(), (Object)availableThreads);
        }
        for (int i2 = 0; i2 < tableStatuses.size() && i2 < availableThreads; ++i2) {
            CompareTableStatus status = tableStatuses.get(i2);
            if (status.getCompareRequest() != null && status.getCompareRequest().isCancelled()) continue;
            String queue = this.buildKey(status.getCompareId(), status.getStepNumber());
            NodeCommunication lock = nodeCommunicationService.find(status.getSourceNodeId(), queue, NodeCommunication.CommunicationType.COMPARE);
            Date lockTimeout = DateUtils.addMilliseconds((Date)new Date(), (int)(-this.parameterService.getInt("compare.lock.timeout.ms", 0x6DDD00)));
            if (lock.getLockTime() == null || lock.getLockTime().before(lockTimeout)) {
                String key = this.buildKey(status.getSourceNodeId(), status.getCompareId(), status.getStepNumber());
                this.executingCompare.put(key, status);
                lock.setDeleteOnUnlock(true);
                this.log.debug("Calling for work on compare request {}-{}", (Object)status.getSourceNodeId(), (Object)queue);
                nodeCommunicationService.execute(lock, nodeStatuses, (INodeCommunicationService.INodeCommunicationExecutor)this);
                continue;
            }
            this.log.debug("Compare request {} is still locked", (Object)status.getNodeCompareIdStep());
        }
        return nodeStatuses;
    }

    @Override
    public void cancelCompareRequest(String sourceNodeId, long compareId, String userId) {
        if (compareId != 0L) {
            this.interruptProcessInfo(sourceNodeId, compareId);
        }
        AppUtils.sleep((long)500L);
        this.engine.getSqlTemplate().update(this.sqlMap.getSql(new String[]{"cancelCompareRequest"}), new Object[]{userId, new Date(), sourceNodeId, compareId}, new int[]{12, 93, 12, this.engine.getSymmetricDialect().getSqlTypeForIds()});
    }

    protected void cancelRequests(List<CompareRequest> requests) {
        if (requests.size() > 0) {
            Map<String, Boolean> allCancelledMap = this.getAllCancelledMap(requests);
            HashSet<String> interruptedCompareIds = new HashSet<String>();
            for (CompareRequest request : requests) {
                boolean isAllCancelled;
                if (request.getCompareId() == 0L || !interruptedCompareIds.add(request.getNodeCompareId()) || (isAllCancelled = BooleanUtils.toBoolean((Boolean)allCancelledMap.get(request.getNodeCompareId()))) && (!isAllCancelled || !request.getTargetNodeId().equals(this.engine.getNodeId()) || request.getCompareId() <= 0L)) continue;
                this.interruptProcessInfo(request.getSourceNodeId(), request.getCompareId());
            }
            AppUtils.sleep((long)500L);
            HashSet<String> cancelledCompareIds = new HashSet<String>();
            HashSet<CallSite> cancelledRequestIds = new HashSet<CallSite>();
            try (ISqlTransaction transaction = this.engine.getSqlTemplate().startSqlTransaction();){
                for (CompareRequest request : requests) {
                    boolean shouldCancelCompareId = request.getCompareId() != 0L && cancelledCompareIds.add(request.getNodeCompareId());
                    boolean isAllCancelled = BooleanUtils.toBoolean((Boolean)allCancelledMap.get(request.getNodeCompareId()));
                    Date now = new Date();
                    if (request.getSourceNodeId().equals(this.engine.getNodeId()) && shouldCancelCompareId) {
                        if (!isAllCancelled) {
                            transaction.prepareAndExecute(this.sqlMap.getSql(new String[]{"cancelCompareTableStatus"}), new Object[]{"CA", now, now, now, request.getSourceNodeId(), request.getCompareId(), "OK"});
                            this.log.info("Cancelled compare request {}", (Object)request.getNodeCompareId());
                        }
                    } else if (request.getTargetNodeId().equals(this.engine.getNodeId()) && isAllCancelled && shouldCancelCompareId) {
                        transaction.prepareAndExecute(this.sqlMap.getSql(new String[]{"cancelCompareTableStatus"}), new Object[]{"OK", now, now, now, request.getSourceNodeId(), request.getCompareId(), "OK"});
                        transaction.prepareAndExecute(this.sqlMap.getSql(new String[]{"cancelCompareStatus"}), new Object[]{now, now, request.getSourceNodeId(), request.getCompareId()});
                        this.log.info("Cancelled compare request {}", (Object)request.getNodeCompareId());
                    }
                    if (request.getSourceNodeId().equals(this.engine.getNodeId()) && !request.isProcessed() || request.getTargetNodeId().equals(this.engine.getNodeId()) && isAllCancelled) {
                        if (!request.isProcessed() && cancelledRequestIds.add((CallSite)((Object)(request.getSourceNodeId() + "|" + request.getTargetNodeId() + "|" + String.valueOf(request.getCreateTime()))))) {
                            this.log.info("Cancelled compare request between source {} and target {} created on {}", new Object[]{request.getSourceNodeId(), request.getTargetNodeId(), request.getCreateTime()});
                        }
                        request.setProcessed(true);
                        request.setCompleted(true);
                        ArrayList<CompareRequest> list = new ArrayList<CompareRequest>();
                        list.add(request);
                        this.updateCompareRequests(transaction, list);
                    }
                    transaction.commit();
                }
            }
        }
    }

    protected Map<String, Boolean> getAllCancelledMap(List<CompareRequest> requests) {
        HashMap<String, Boolean> allCancelledMap = new HashMap<String, Boolean>();
        HashSet<String> cancelledCompareIds = new HashSet<String>();
        for (CompareRequest request : requests) {
            if (request.getCompareId() == 0L || !cancelledCompareIds.add(request.getNodeCompareId())) continue;
            List tableStatuses = this.engine.getSqlTemplate().query(this.sqlMap.getSql(new String[]{"selectCompareTableStatusByCompareIdStatusSql"}), (ISqlRowMapper)new CompareTableStatusRowMapper(), new Object[]{request.getSourceNodeId(), request.getCompareId(), "OK"}, new int[]{12, this.engine.getSymmetricDialect().getSqlTypeForIds(), 1});
            boolean isAllCancelled = true;
            for (CompareTableStatus tableStatus : tableStatuses) {
                isAllCancelled &= tableStatus.getStatus().equals("CA");
                if (tableStatus.getStatus().equals("RQ")) continue;
                this.cleanUp(tableStatus);
            }
            allCancelledMap.put(request.getNodeCompareId(), isAllCancelled);
        }
        return allCancelledMap;
    }

    protected void interruptProcessInfo(String sourceNodeId, long compareId) {
        this.log.info("Compare request {}-{} is cancelled, sending interrupts", (Object)sourceNodeId, (Object)compareId);
        String queuePrefix = compareId + "|";
        for (ProcessInfo processInfo : this.engine.getStatisticManager().getProcessInfos()) {
            Thread thread;
            if (processInfo.getProcessType() != ProcessType.COMPARE_EXECUTE && processInfo.getProcessType() != ProcessType.COMPARE_START_HANDLE && processInfo.getProcessType() != ProcessType.COMPARE_GET_HANDLE && processInfo.getProcessType() != ProcessType.COMPARE_PUT_HANDLE || processInfo.getStatus() == ProcessInfo.ProcessStatus.OK || !processInfo.getQueue().startsWith(queuePrefix) || !processInfo.getSourceNodeId().equals(sourceNodeId) || (thread = processInfo.getThread()) == null || !thread.isAlive()) continue;
            thread.interrupt();
        }
    }

    protected void processRequests(List<CompareRequest> requests, int threadDemandCount) {
        if (requests.size() > 0) {
            int perRequestCount = this.parameterService.getInt("compare.queue.per.request.count", 1);
            int threadPoolCount = this.parameterService.getInt("compare.thread.per.server.count", 1) * this.countNodesCluster();
            this.log.info("Found {} compare requests to process, thread pool size is {} with demand of {}", new Object[]{requests.size(), threadPoolCount, threadDemandCount});
            try (ISqlTransaction transaction = this.engine.getSqlTemplate().startSqlTransaction();){
                ArrayList<TriggerHistory> triggerHistories = new ArrayList<TriggerHistory>();
                ArrayList<CompareRequest> compareRequests = new ArrayList<CompareRequest>();
                String lastTargetNodeId = null;
                CompareRequest lastRequest = null;
                long compareId = 0L;
                requests.sort(new n());
                Set<String> triggerIds = null;
                Map<String, List<TriggerHistory>> triggerHistByTriggerId = null;
                for (CompareRequest request : requests) {
                    if (lastTargetNodeId == null || !lastTargetNodeId.equals(request.getTargetNodeId())) {
                        if ((threadDemandCount += triggerHistories.size() > perRequestCount ? perRequestCount : triggerHistories.size()) >= threadPoolCount) break;
                        if (lastTargetNodeId != null) {
                            this.populateCompareTableStatus(transaction, triggerHistories, lastRequest);
                            this.updateCompareRequests(transaction, compareRequests);
                            triggerHistories.clear();
                            compareRequests.clear();
                        }
                        compareId = this.engine.getSequenceService().nextVal("compare_id");
                        lastTargetNodeId = request.getTargetNodeId();
                        triggerIds = this.getTriggerIdsForTargetNode(request.getTargetNodeId());
                    }
                    request.setCompareId(compareId);
                    request.setProcessed(true);
                    compareRequests.add(request);
                    if (request.getTriggerId().equals("ALL")) {
                        for (TriggerHistory hist : this.engine.getTriggerRouterService().getActiveTriggerHistories()) {
                            if (hist.getSourceTableNameLowerCase().startsWith(this.parameterService.getTablePrefix()) || !triggerIds.contains(hist.getTriggerId())) continue;
                            triggerHistories.add(hist);
                        }
                    } else if (triggerIds.contains(request.getTriggerId())) {
                        List<TriggerHistory> list;
                        if (triggerHistByTriggerId == null) {
                            triggerHistByTriggerId = this.getTriggerHistByTriggerId();
                        }
                        if ((list = triggerHistByTriggerId.get(request.getTriggerId())) != null) {
                            triggerHistories.addAll(list);
                        }
                    } else {
                        TriggerHistory hist = new TriggerHistory();
                        hist.setSourceTableName(request.getTriggerId());
                        triggerHistories.add(hist);
                    }
                    lastRequest = request;
                }
                if (lastRequest != null) {
                    this.populateCompareTableStatus(transaction, triggerHistories, lastRequest);
                    this.updateCompareRequests(transaction, compareRequests);
                }
                transaction.commit();
            }
        }
    }

    protected void populateCompareTableStatus(ISqlTransaction transaction, List<TriggerHistory> triggerHistories, CompareRequest request) {
        ArrayList<CompareTableStatus> tableStatuses = new ArrayList<CompareTableStatus>();
        boolean isError = false;
        try {
            int stepNumber = 0;
            Node sourceNode = this.findNode(request.getSourceNodeId(), request);
            Node targetNode = this.findNode(request.getTargetNodeId(), request);
            this.log.info("Creating compare request {} from node '{}' to node '{}' for {} tables", new Object[]{request.getCompareId(), request.getSourceNodeId(), request.getTargetNodeId(), triggerHistories.size()});
            List<Table> tables = new ArrayList();
            HashMap<Table, TriggerHistory> triggerHistoryByTable = new HashMap<Table, TriggerHistory>();
            for (TriggerHistory hist : triggerHistories) {
                Table table = null;
                table = hist.getTriggerId() == null ? new Table(hist.getSourceCatalogName(), hist.getSourceSchemaName(), hist.getSourceTableName()) : this.engine.getTargetDialect().getTargetPlatform().getTableFromCache(hist.getSourceCatalogName(), hist.getSourceSchemaName(), hist.getSourceTableName(), false);
                tables.add(table);
                triggerHistoryByTable.put(table, hist);
            }
            tables = Database.sortByForeignKeys(tables);
            for (Table table : tables) {
                TriggerHistory hist = (TriggerHistory)triggerHistoryByTable.get(table);
                CompareTableStatus tableStatus = new CompareTableStatus();
                tableStatus.setCompareId(request.getCompareId());
                tableStatus.setSourceNodeId(request.getSourceNodeId());
                tableStatus.setTargetNodeId(request.getTargetNodeId());
                tableStatus.setStepNumber(++stepNumber);
                tableStatus.setLevel("T");
                tableStatus.setStatus("RQ");
                tableStatus.setSourceCatalogName(hist.getSourceCatalogName());
                tableStatus.setSourceSchemaName(hist.getSourceSchemaName());
                tableStatus.setSourceTableName(hist.getSourceTableName());
                String targetCatalog = null;
                String targetSchema = null;
                String targetTableName = hist.getSourceTableName();
                List transforms = this.engine.getTransformService().findTransformsFor(sourceNode.getNodeGroupId(), targetNode.getNodeGroupId(), tableStatus.getSourceTableName());
                if (transforms != null && transforms.size() > 0) {
                    TransformService.TransformTableNodeGroupLink transform = (TransformService.TransformTableNodeGroupLink)transforms.get(0);
                    if (transform.getTransformPoint() == TransformPoint.EXTRACT) {
                        targetCatalog = SymmetricUtils.replaceNodeVariables((Node)sourceNode, (Node)targetNode, (String)transform.getTargetCatalogName());
                        targetSchema = SymmetricUtils.replaceNodeVariables((Node)sourceNode, (Node)targetNode, (String)transform.getTargetSchemaName());
                        targetTableName = SymmetricUtils.replaceNodeVariables((Node)sourceNode, (Node)targetNode, (String)transform.getTargetTableName());
                    }
                } else {
                    TriggerRouter triggerRouter = this.engine.getTriggerRouterService().getTriggerRouterByTriggerHist(targetNode.getNodeGroupId(), hist.getTriggerHistoryId(), false);
                    if (triggerRouter != null) {
                        targetCatalog = SymmetricUtils.replaceNodeVariables((Node)sourceNode, (Node)targetNode, (String)triggerRouter.getTargetCatalog(targetCatalog, hist));
                        targetSchema = SymmetricUtils.replaceNodeVariables((Node)sourceNode, (Node)targetNode, (String)triggerRouter.getTargetSchema(targetSchema, hist));
                        targetTableName = SymmetricUtils.replaceNodeVariables((Node)sourceNode, (Node)targetNode, (String)triggerRouter.getTargetTable(hist));
                    }
                }
                tableStatus.setTargetCatalogName(targetCatalog);
                tableStatus.setTargetSchemaName(targetSchema);
                tableStatus.setTargetTableName(targetTableName);
                if (hist.getTriggerId() == null) {
                    tableStatus.setIgnoreFlag(true);
                    tableStatus.setErrorFlag(true);
                    tableStatus.setErrorMessage("Table " + tableStatus.getSourceTableName() + " cannot be compared because it is missing a trigger history.");
                    tableStatus.setStatus("OK");
                    this.log.warn(tableStatus.getErrorMessage());
                    isError = true;
                } else if (hist.isMissingPk()) {
                    Trigger trigger = this.getTriggerForTargetNode(hist.getTriggerId(), targetNode);
                    if (trigger == null) {
                        tableStatus.setIgnoreFlag(true);
                        tableStatus.setErrorFlag(true);
                        tableStatus.setErrorMessage("Table " + tableStatus.getSourceTableName() + " cannot be compared because it is missing primary key and unable to find trigger ID " + hist.getTriggerId() + " to confirm sync key column names");
                        tableStatus.setStatus("OK");
                        this.log.warn(tableStatus.getErrorMessage());
                        isError = true;
                    } else if (StringUtils.isBlank((CharSequence)trigger.getSyncKeyNames())) {
                        tableStatus.setIgnoreFlag(true);
                        tableStatus.setErrorFlag(true);
                        tableStatus.setErrorMessage("Table " + tableStatus.getSourceTableName() + " cannot be compared because it is missing a primary key, unique key, or sync key.  Use Configure -> Table Triggers screen to configure sync key column names.");
                        tableStatus.setStatus("OK");
                        this.log.warn(tableStatus.getErrorMessage());
                        isError = true;
                    }
                }
                tableStatuses.add(tableStatus);
            }
        }
        catch (RuntimeException e2) {
            this.log.warn("Failed to populate compare table status", (Throwable)e2);
            request.setCancelled(true);
            request.setCompleted(true);
            isError = true;
        }
        CompareStatus status = new CompareStatus();
        status.setCompareId(request.getCompareId());
        status.setSourceNodeId(request.getSourceNodeId());
        status.setTargetNodeId(request.getTargetNodeId());
        status.setStartTime(new Date());
        status.setCreateTime(status.getStartTime());
        status.setTablesRequested(tableStatuses.size());
        status.setErrorFlag(isError);
        if (request.isCancelled()) {
            status.setCancelled(true);
            status.setCompleted(true);
            status.setEndTime(status.getStartTime());
        }
        this.insertCompareStatus(transaction, status);
        this.insertCompareTableStatus(transaction, tableStatuses);
    }

    protected Map<String, List<TriggerHistory>> getTriggerHistByTriggerId() {
        HashMap<String, List<TriggerHistory>> map = new HashMap<String, List<TriggerHistory>>();
        for (TriggerHistory hist : this.engine.getTriggerRouterService().getActiveTriggerHistories()) {
            ArrayList<TriggerHistory> list = (ArrayList<TriggerHistory>)map.get(hist.getTriggerId());
            if (list == null) {
                list = new ArrayList<TriggerHistory>();
                map.put(hist.getTriggerId(), list);
            }
            list.add(hist);
        }
        return map;
    }

    protected Set<String> getTriggerIdsForTargetNode(String targetNodeId) {
        HashSet<String> triggerIds = new HashSet<String>();
        Map triggersById = this.engine.getTriggerRouterService().getTriggerRoutersForCurrentNode(false);
        Node targetNode = this.engine.getNodeService().findNode(targetNodeId);
        if (targetNode != null) {
            for (List triggerRouters : triggersById.values()) {
                for (TriggerRouter triggerRouter : triggerRouters) {
                    if (!triggerRouter.getRouter().getNodeGroupLink().getTargetNodeGroupId().equals(targetNode.getNodeGroupId())) continue;
                    triggerIds.add(triggerRouter.getTriggerId());
                }
            }
        }
        return triggerIds;
    }

    protected Trigger getTriggerForTargetNode(String triggerId, Node targetNode) {
        Trigger trigger = null;
        Map triggersById = this.engine.getTriggerRouterService().getTriggerRoutersForCurrentNode(false);
        List triggerRouters = (List)triggersById.get(triggerId);
        if (triggerRouters != null) {
            for (TriggerRouter triggerRouter : triggerRouters) {
                if (!triggerRouter.getRouter().getNodeGroupLink().getTargetNodeGroupId().equals(targetNode.getNodeGroupId())) continue;
                trigger = triggerRouter.getTrigger();
                break;
            }
        }
        return trigger;
    }

    @Override
    public boolean handleStartCompare(String remoteNodeId, String sourceNodeId, long compareId, int stepNumber) {
        boolean isRunning = false;
        CompareTableStatus tableStatus = this.findCompareTableStatus(sourceNodeId, compareId, stepNumber, true);
        if (tableStatus != null && tableStatus.getCompareRequest() != null && !tableStatus.getCompareRequest().isCancelled()) {
            this.log.info("Received start for compare request {}-{}-{} from node {}", new Object[]{sourceNodeId, compareId, stepNumber, remoteNodeId});
            String queue = this.buildKey(tableStatus.getCompareId(), tableStatus.getStepNumber());
            ProcessInfo processInfo = this.engine.getStatisticManager().newProcessInfo(new ProcessInfoKey(tableStatus.getSourceNodeId(), queue, tableStatus.getTargetNodeId(), ProcessType.COMPARE_START_HANDLE));
            processInfo.setStatus(ProcessInfo.ProcessStatus.PROCESSING);
            tableStatus.setStatus("NE");
            tableStatus.setStartTime(new Date());
            if (this.isSource(tableStatus)) {
                this.updateCompareTableStatus(tableStatus);
            }
            isRunning = this.queueExecution(tableStatus);
            processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
        } else if (tableStatus != null && tableStatus.getCompareRequest() != null && tableStatus.getCompareRequest().isCancelled()) {
            this.log.info("Cancelled compare table status for key {}-{}-{} from node {}", new Object[]{sourceNodeId, compareId, stepNumber, remoteNodeId});
        } else {
            this.log.warn("Missing compare table status for key {}-{}-{} from node {}", new Object[]{sourceNodeId, compareId, stepNumber, remoteNodeId});
        }
        return isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleGetCompare(String remoteNodeId, String sourceNodeId, long compareId, int stepNumber, String level, OutputStream outputStream) {
        CompareTableStatus tableStatus = this.findCompareTableStatus(sourceNodeId, compareId, stepNumber, true);
        boolean success = false;
        if (tableStatus == null) {
            this.log.warn("Missing compare table status for key {}-{}-{} from node {}", new Object[]{sourceNodeId, compareId, stepNumber, remoteNodeId});
        } else if (tableStatus.getLevel().equals(level)) {
            String queue = this.buildKey(tableStatus.getCompareId(), tableStatus.getStepNumber());
            ProcessInfo processInfo = this.engine.getStatisticManager().newProcessInfo(new ProcessInfoKey(tableStatus.getSourceNodeId(), queue, tableStatus.getTargetNodeId(), ProcessType.COMPARE_GET_HANDLE));
            processInfo.setStatus(ProcessInfo.ProcessStatus.PROCESSING);
            IStagedResource resource = this.findResource(tableStatus, this.getResourceName(tableStatus));
            if (resource != null && resource.exists() && resource.getState() == IStagedResource.State.DONE) {
                this.log.info("Writing payload for resource {} to node {} for compare request {}", new Object[]{resource.getFile().getName(), remoteNodeId, tableStatus.getNodeCompareIdStep()});
                try {
                    IOUtils.copy((InputStream)resource.getInputStream(), (OutputStream)outputStream);
                    processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                    success = true;
                }
                catch (IOException e2) {
                    processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                    tableStatus.setErrorFlag(true);
                    tableStatus.setErrorMessage(e2.getClass().getName() + (String)(e2.getMessage() != null ? ": " + e2.getMessage() : ""));
                    this.log.warn("Failed to send payload for compare request {}-{}-{} because ", new Object[]{sourceNodeId, compareId, stepNumber, tableStatus.getErrorMessage()});
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)outputStream);
                    resource.close();
                }
            } else {
                processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
            }
        } else {
            this.log.info("Not ready to handle GET for {}-{}-{} because level {} does not match requested level {}", new Object[]{sourceNodeId, compareId, stepNumber, tableStatus.getLevel(), level});
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handlePutCompare(String remoteNodeId, String sourceNodeId, long compareId, int stepNumber, String level, InputStream inputStream) {
        CompareTableStatus tableStatus = this.findCompareTableStatus(sourceNodeId, compareId, stepNumber, true);
        boolean success = false;
        if (tableStatus == null) {
            this.log.warn("Missing compare table status for key {}-{}-{} from node {}", new Object[]{sourceNodeId, compareId, stepNumber, remoteNodeId});
        } else if (tableStatus.getLevel().equals(level) && tableStatus.getStatus().equals("NE")) {
            String queue = this.buildKey(tableStatus.getCompareId(), tableStatus.getStepNumber());
            ProcessInfo processInfo = this.engine.getStatisticManager().newProcessInfo(new ProcessInfoKey(tableStatus.getSourceNodeId(), queue, tableStatus.getTargetNodeId(), ProcessType.COMPARE_PUT_HANDLE));
            processInfo.setStatus(ProcessInfo.ProcessStatus.PROCESSING);
            IStagedResource resource = this.findResource(tableStatus, this.getResourceName(tableStatus) + "-remote");
            if (resource != null && resource.exists() && resource.getState() == IStagedResource.State.DONE) {
                this.log.debug("Skipping incoming payload for resource {} for node {} for compare request {} because it already exists", new Object[]{resource.getFile().getName(), remoteNodeId, tableStatus.getNodeCompareIdStep()});
                success = true;
            } else {
                resource = this.createResource(tableStatus, this.getResourceName(tableStatus) + "-remote");
                this.log.info("Receiving payload for resource {} from node {} for compare request {}", new Object[]{resource.getFile().getName(), remoteNodeId, tableStatus.getNodeCompareIdStep()});
                try {
                    IOUtils.copy((InputStream)inputStream, (OutputStream)resource.getOutputStream());
                    resource.setState(IStagedResource.State.DONE);
                    success = true;
                }
                catch (IOException e2) {
                    tableStatus.setErrorFlag(true);
                    tableStatus.setErrorMessage(e2.getClass().getName() + (String)(e2.getMessage() != null ? ": " + e2.getMessage() : ""));
                    this.log.warn("Failed to write payload for compare request {}-{}-{} because ", new Object[]{sourceNodeId, compareId, stepNumber, tableStatus.getErrorMessage()});
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                    resource.close();
                }
                this.queueExecution(tableStatus);
            }
            processInfo.setStatus(success ? ProcessInfo.ProcessStatus.OK : ProcessInfo.ProcessStatus.ERROR);
        } else {
            this.log.info("Not ready to handle PUT for {}-{}-{} because level {} does not match requested level {}", new Object[]{sourceNodeId, compareId, stepNumber, tableStatus.getLevel(), level});
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(NodeCommunication nodeCom, RemoteNodeStatus nodeStatus) {
        CompareTableStatus tableStatusDb;
        String key = this.buildKey(nodeCom.getNodeId(), nodeCom.getQueue());
        CompareTableStatus tableStatus = this.executingCompare.get(key);
        if (!(tableStatus == null || (tableStatusDb = this.findCompareTableStatus(tableStatus.getSourceNodeId(), tableStatus.getCompareId(), tableStatus.getStepNumber(), true)).getStatus().equals("RQ") && tableStatus.getStatus().equals("NE"))) {
            tableStatus = tableStatusDb;
        }
        if (tableStatus != null) {
            CompareRequest request = tableStatus.getCompareRequest();
            Node remoteNode = new Node(this.isSource(tableStatus) ? request.getTargetNodeId() : request.getSourceNodeId(), null);
            String queue = this.buildKey(tableStatus.getCompareId(), tableStatus.getStepNumber());
            ProcessInfo processInfo = this.engine.getStatisticManager().newProcessInfo(new ProcessInfoKey(tableStatus.getSourceNodeId(), queue, tableStatus.getTargetNodeId(), ProcessType.COMPARE_EXECUTE));
            processInfo.setCurrentTableName(this.isSource(tableStatus) ? tableStatus.getSourceTableName() : tableStatus.getTargetTableName());
            try {
                remoteNode = this.findNode(remoteNode.getNodeId(), request);
                if (tableStatus.getStatus().equals("FI")) {
                    if (this.isSource(tableStatus)) {
                        this.compareRepair.a(tableStatus, processInfo);
                    }
                } else if (tableStatus.getStatus().equals("CO")) {
                    if (this.isTarget(tableStatus)) {
                        this.markOkCompareTableStatus(tableStatus);
                    }
                } else if ("T".equals(tableStatus.getLevel())) {
                    this.compareTable.a(tableStatus, processInfo);
                } else if ("C".equals(tableStatus.getLevel())) {
                    this.compareChunk.a(tableStatus, processInfo);
                } else if ("R".equals(tableStatus.getLevel())) {
                    this.compareRow.a(tableStatus, processInfo);
                } else if ("F".equals(tableStatus.getLevel())) {
                    this.compareRepair.a(tableStatus, processInfo);
                }
                this.fireOnline(remoteNode, nodeStatus);
            }
            catch (l e2) {
                if (e2.a()) {
                    this.log.warn("Cancelling compare request {} because {}", (Object)tableStatus.getNodeCompareIdStep(), tableStatus.getErrorMessage() != null ? tableStatus.getErrorMessage() : e2.getClass().getName() + (String)(e2.getMessage() != null ? ": " + e2.getMessage() : ""));
                    this.engine.getSqlTemplate().update(this.sqlMap.getSql(new String[]{"cancelCompareRequest"}), new Object[]{"system", new Date(), tableStatus.getSourceNodeId(), tableStatus.getCompareId()}, new int[]{12, 93, 12, this.engine.getSymmetricDialect().getSqlTypeForIds()});
                }
                tableStatus.setErrorFlag(true);
                tableStatus.setErrorMessage(e2.getClass().getName() + (String)(e2.getMessage() != null ? ": " + e2.getMessage() : ""));
                tableStatus.setIgnoreFlag(true);
                tableStatus.setEndTime(new Date());
                tableStatus.setStatus("OK");
                this.log.warn("Ignoring compare request {} because {}", (Object)tableStatus.getNodeCompareIdStep(), (Object)tableStatus.getErrorMessage());
                this.updateCompareTableStatus(tableStatus);
            }
            catch (RuntimeException e3) {
                if (e3 instanceof HttpException || e3 instanceof OfflineException || this.isOffline(e3)) {
                    this.fireOffline(e3, remoteNode, nodeStatus);
                }
                this.log.error("Failed to compare request " + tableStatus.getNodeCompareIdStep() + ":", (Throwable)e3);
                tableStatus.setErrorFlag(true);
                tableStatus.setErrorMessage(e3.getClass().getName() + (String)(e3.getMessage() != null ? ": " + e3.getMessage() : ""));
                tableStatus.setEndTime(new Date());
                tableStatus.setStatus("OK");
                this.updateCompareTableStatus(tableStatus);
            }
            finally {
                if (tableStatus.isErrorFlag()) {
                    processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                } else {
                    processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                }
                this.executingCompare.remove(key);
            }
        } else {
            this.log.warn("Missing compare table status for key {}", (Object)key);
        }
    }

    protected void markOkCompareTableStatus(CompareTableStatus tableStatus) {
        this.cleanUp(tableStatus);
        tableStatus.setStatus("OK");
        tableStatus.setEndTime(new Date());
        this.updateCompareTableStatus(tableStatus);
    }

    protected void complete(CompareRequest request) {
        if (request.getSourceNodeId().equals(this.engine.getNodeId())) {
            this.log.info("Completed compare request {}-{}", (Object)request.getSourceNodeId(), (Object)request.getCompareId());
            try (ISqlTransaction transaction = this.engine.getSqlTemplate().startSqlTransaction();){
                Date endTime = new Date();
                transaction.prepareAndExecute(this.sqlMap.getSql(new String[]{"completeCompareStatus"}), new Object[]{endTime, endTime, request.getSourceNodeId(), request.getCompareId()}, new int[]{93, 93, 12, this.engine.getSymmetricDialect().getSqlTypeForIds()});
                transaction.prepareAndExecute(this.sqlMap.getSql(new String[]{"completeCompareRequest"}), new Object[]{endTime, request.getSourceNodeId(), request.getCompareId()}, new int[]{93, 12, this.engine.getSymmetricDialect().getSqlTypeForIds()});
                transaction.commit();
            }
        }
    }

    protected int countNodesCluster() {
        int nodesInCluster = 1;
        if (this.engine.getClusterService().isClusteringEnabled()) {
            List hosts = this.engine.getNodeService().findNodeHosts(this.engine.getNodeId());
            long recentTime = System.currentTimeMillis() - 86400L;
            nodesInCluster = 0;
            for (NodeHost host : hosts) {
                if (host.getHeartbeatTime() == null || host.getHeartbeatTime().getTime() <= recentTime) continue;
                ++nodesInCluster;
            }
            if (nodesInCluster == 0) {
                nodesInCluster = 1;
            }
        }
        return nodesInCluster;
    }

    @Override
    public List<CompareRequest> findUnprocessedCompareRequests() {
        return this.engine.getSqlTemplate().query(this.sqlMap.getSql(new String[]{"selectUnprocessedCompareRequestSql"}), (ISqlRowMapper)new CompareRequestRowMapper(), new Object[0]);
    }

    @Override
    public List<CompareRequest> findCompareRequests(String sourceNodeId, long compareId) {
        return this.engine.getSqlTemplate().query(this.sqlMap.getSql(new String[]{"selectCompareRequestSql"}), (ISqlRowMapper)new CompareRequestRowMapper(), new Object[]{sourceNodeId, compareId});
    }

    @Override
    public void insertCompareRequest(CompareRequest compareRequest) {
        try (ISqlTransaction transaction = this.engine.getSqlTemplate().startSqlTransaction();){
            ArrayList<CompareRequest> requests = new ArrayList<CompareRequest>();
            requests.add(compareRequest);
            this.insertCompareRequests(transaction, requests);
            transaction.commit();
        }
    }

    @Override
    public void insertCompareRequests(ISqlTransaction transaction, List<CompareRequest> requests) {
        int[] types = new int[]{12, 12, 12, 12, 93, 2, 2, 2, 2, 2, 2, 12, 2, 2, 2, 2, 93, 2, 2, 2, this.engine.getSymmetricDialect().getSqlTypeForIds(), 12, 93};
        Date now = new Date();
        transaction.prepare(this.sqlMap.getSql(new String[]{"insertCompareRequestSql"}));
        for (CompareRequest r2 : requests) {
            r2.setLastUpdateTime(now);
            r2.setCreateTime(new Date(r2.getCreateTime().getTime() / 1000L * 1000L));
            transaction.addRow((Object)r2, new Object[]{r2.getSourceNodeId(), r2.getTargetNodeId(), r2.getTriggerId(), r2.getRouterId(), r2.getCreateTime(), r2.isUseTableChecksum() ? 1 : 0, r2.isUseInflight() ? 1 : 0, r2.isUseRowLevel() ? 1 : 0, r2.isUseChunking() ? 1 : 0, r2.isUseScript() ? 1 : 0, r2.isUseRepair() ? 1 : 0, r2.getChecksumAlgorithm(), r2.getDecimalScale(), r2.getTimestampScale(), r2.getRealScale(), r2.isExcludeSurrogate() ? 1 : 0, r2.getNotBefore(), r2.isProcessed() ? 1 : 0, r2.isCompleted() ? 1 : 0, r2.isCancelled() ? 1 : 0, r2.getCompareId(), r2.getLastUpdateBy(), r2.getLastUpdateTime()}, types);
        }
        transaction.flush();
    }

    @Override
    public void updateCompareRequest(CompareRequest compareRequest) {
        try (ISqlTransaction transaction = this.engine.getSqlTemplate().startSqlTransaction();){
            ArrayList<CompareRequest> requests = new ArrayList<CompareRequest>();
            requests.add(compareRequest);
            this.updateCompareRequests(transaction, requests);
            transaction.commit();
        }
    }

    @Override
    public void updateCompareRequests(ISqlTransaction transaction, List<CompareRequest> requests) {
        int[] types = new int[]{2, 2, 2, 2, 2, 2, 12, 2, 2, 2, 2, 93, 2, 2, 2, this.engine.getSymmetricDialect().getSqlTypeForIds(), 12, 93, 12, 12, 12, 12, 93};
        Date now = new Date();
        transaction.prepare(this.sqlMap.getSql(new String[]{"updateCompareRequestSql"}));
        for (CompareRequest r2 : requests) {
            r2.setLastUpdateTime(now);
            transaction.addRow((Object)r2, new Object[]{r2.isUseTableChecksum() ? 1 : 0, r2.isUseInflight() ? 1 : 0, r2.isUseRowLevel() ? 1 : 0, r2.isUseChunking() ? 1 : 0, r2.isUseScript() ? 1 : 0, r2.isUseRepair() ? 1 : 0, r2.getChecksumAlgorithm(), r2.getDecimalScale(), r2.getTimestampScale(), r2.getRealScale(), r2.isExcludeSurrogate() ? 1 : 0, r2.getNotBefore(), r2.isProcessed() ? 1 : 0, r2.isCompleted() ? 1 : 0, r2.isCancelled() ? 1 : 0, r2.getCompareId(), r2.getLastUpdateBy(), r2.getLastUpdateTime(), r2.getSourceNodeId(), r2.getTargetNodeId(), r2.getTriggerId(), r2.getRouterId(), r2.getCreateTime()}, types);
        }
        transaction.flush();
    }

    @Override
    public List<CompareStatus> findActiveCompareStatuses() {
        return this.engine.getSqlTemplate().query(this.sqlMap.getSql(new String[]{"selectActiveCompareStatusSql"}), (ISqlRowMapper)new CompareStatusRowMapper(), new Object[0]);
    }

    @Override
    public List<CompareStatus> findAllCompareStatuses() {
        return this.engine.getSqlTemplate().query(this.sqlMap.getSql(new String[]{"selectAllCompareStatusSql"}), (ISqlRowMapper)new CompareStatusRowMapper(), new Object[0]);
    }

    @Override
    public CompareStatus findCompareStatus(String sourceNodeId, long compareId) {
        return (CompareStatus)this.engine.getSqlTemplate().queryForObject(this.sqlMap.getSql(new String[]{"selectCompareStatusByCompareIdSql"}), (ISqlRowMapper)new CompareStatusRowMapper(), new Object[]{sourceNodeId, compareId});
    }

    protected void insertCompareStatus(ISqlTransaction transaction, CompareStatus s2) {
        int[] types = new int[]{this.engine.getSymmetricDialect().getSqlTypeForIds(), 12, 12, 93, 93, 2, 2, 5, 5, 5, 93, 93};
        Date now = new Date();
        transaction.prepare(this.sqlMap.getSql(new String[]{"insertCompareStatusSql"}));
        s2.setLastUpdateTime(now);
        transaction.addRow((Object)s2, new Object[]{s2.getCompareId(), s2.getSourceNodeId(), s2.getTargetNodeId(), s2.getStartTime(), s2.getEndTime(), s2.getTablesRequested(), s2.getTablesCompared(), s2.isCompleted() ? 1 : 0, s2.isCancelled() ? 1 : 0, s2.isErrorFlag() ? 1 : 0, s2.getCreateTime(), s2.getLastUpdateTime()}, types);
        transaction.flush();
    }

    @Override
    public CompareTableStatus findCompareTableStatus(String sourceNodeId, long compareId, int stepNumber, boolean lookupCompareRequest) {
        List<CompareRequest> requests;
        CompareTableStatus tableStatus = (CompareTableStatus)this.engine.getSqlTemplate().queryForObject(this.sqlMap.getSql(new String[]{"selectCompareTableStatusSql"}), (ISqlRowMapper)new CompareTableStatusRowMapper(), new Object[]{sourceNodeId, compareId, stepNumber});
        if (tableStatus != null && lookupCompareRequest && (requests = this.findCompareRequests(sourceNodeId, compareId)).size() > 0) {
            tableStatus.setCompareRequest(requests.get(0));
        }
        return tableStatus;
    }

    @Override
    public List<CompareTableStatus> findCompareTableStatuses(String sourceNodeId, long compareId) {
        return this.engine.getSqlTemplate().query(this.sqlMap.getSql(new String[]{"selectCompareTableStatusByCompareIdSql"}), (ISqlRowMapper)new CompareTableStatusRowMapper(), new Object[]{sourceNodeId, compareId});
    }

    public void insertCompareTableStatus(ISqlTransaction transaction, List<CompareTableStatus> tableStatuses) {
        Date now = new Date();
        int[] types = new int[]{this.engine.getSymmetricDialect().getSqlTypeForIds(), 12, 2, 12, 1, 1, 12, 12, 12, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 12, 12, 12, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 5, 5, 5, 12, 93, 93, 93};
        transaction.prepare(this.sqlMap.getSql(new String[]{"insertCompareTableStatusSql"}));
        for (CompareTableStatus s2 : tableStatuses) {
            s2.setLastUpdateTime(now);
            transaction.addRow((Object)s2, new Object[]{s2.getCompareId(), s2.getSourceNodeId(), s2.getStepNumber(), s2.getTargetNodeId(), s2.getLevel(), s2.getStatus(), s2.getSourceCatalogName(), s2.getSourceSchemaName(), s2.getSourceTableName(), s2.getSourceRowCount(), s2.getSourceRowCountMillis(), s2.getSourceRowExtractMillis(), s2.getSourceRowExtractSize(), s2.getSourceRowSortMillis(), s2.getSourceRowChecksumMillis(), s2.getSourceRowFilterMillis(), s2.getSourceTableChecksumMillis(), s2.getSourceInflightCount(), s2.getSourceInflightMillis(), s2.getSourceChunkMillis(), s2.getTargetCatalogName(), s2.getTargetSchemaName(), s2.getTargetTableName(), s2.getTargetRowCount(), s2.getTargetRowCountMillis(), s2.getTargetRowExtractMillis(), s2.getTargetRowExtractSize(), s2.getTargetRowSortMillis(), s2.getTargetRowChecksumMillis(), s2.getTargetRowFilterMillis(), s2.getTargetTableChecksumMillis(), s2.getTargetInflightCount(), s2.getTargetInflightMillis(), s2.getTargetChunkMillis(), s2.getChunkMatchCount(), s2.getChunkDiffCount(), s2.getChunkDiffList(), s2.getChunkCompareMillis(), s2.getRowMatchCount(), s2.getRowDiffCount(), s2.getRowMissingCount(), s2.getRowExtraCount(), s2.getRowCompareMillis(), s2.getRepairQueryMillis(), s2.getRepairLoadMillis(), s2.getRepairRejectCount(), s2.isMatchFlag() ? 1 : 0, s2.isIgnoreFlag() ? 1 : 0, s2.isErrorFlag() ? 1 : 0, s2.getErrorMessage(), s2.getStartTime(), s2.getEndTime(), s2.getLastUpdateTime()}, types);
        }
        transaction.flush();
    }

    @Override
    public void updateCompareTableStatus(CompareTableStatus s2) {
        this.checkInterrupted();
        try (ISqlTransaction transaction = this.engine.getSqlTemplate().startSqlTransaction();){
            s2.setLastUpdateTime(new Date());
            transaction.prepareAndExecute(this.sqlMap.getSql(new String[]{"updateCompareTableStatusSql"}), new Object[]{s2.getTargetNodeId(), s2.getLevel(), s2.getStatus(), s2.getSourceCatalogName(), s2.getSourceSchemaName(), s2.getSourceTableName(), s2.getSourceRowCount(), s2.getSourceRowCountMillis(), s2.getSourceRowExtractMillis(), s2.getSourceRowExtractSize(), s2.getSourceRowSortMillis(), s2.getSourceRowChecksumMillis(), s2.getSourceRowFilterMillis(), s2.getSourceTableChecksumMillis(), s2.getSourceInflightCount(), s2.getSourceInflightMillis(), s2.getSourceChunkMillis(), s2.getTargetCatalogName(), s2.getTargetSchemaName(), s2.getTargetTableName(), s2.getTargetRowCount(), s2.getTargetRowCountMillis(), s2.getTargetRowExtractMillis(), s2.getTargetRowExtractSize(), s2.getTargetRowSortMillis(), s2.getTargetRowChecksumMillis(), s2.getTargetRowFilterMillis(), s2.getTargetTableChecksumMillis(), s2.getTargetInflightCount(), s2.getTargetInflightMillis(), s2.getTargetChunkMillis(), s2.getChunkMatchCount(), s2.getChunkDiffCount(), s2.getChunkDiffList(), s2.getChunkCompareMillis(), s2.getRowMatchCount(), s2.getRowDiffCount(), s2.getRowMissingCount(), s2.getRowExtraCount(), s2.getRowCompareMillis(), s2.getRepairQueryMillis(), s2.getRepairLoadMillis(), s2.getRepairRejectCount(), s2.isMatchFlag() ? 1 : 0, s2.isIgnoreFlag() ? 1 : 0, s2.isErrorFlag() ? 1 : 0, s2.getErrorMessage(), s2.getStartTime(), s2.getEndTime(), s2.getLastUpdateTime(), s2.getCompareId(), s2.getSourceNodeId(), s2.getStepNumber()}, new int[]{12, 1, 1, 12, 12, 12, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 12, 12, 12, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 12, 2, 2, 2, 2, 2, 2, 2, 2, 2, 5, 5, 5, 12, 93, 93, 93, this.engine.getSymmetricDialect().getSqlTypeForIds(), 12, 2});
            if (this.isSource(s2) && (s2.getStatus().equals("CO") || s2.getStatus().equals("OK"))) {
                transaction.prepareAndExecute(this.sqlMap.getSql(new String[]{"updateCompareStatusComparedSql"}), new Object[]{new Date(), s2.getSourceNodeId(), s2.getCompareId()}, new int[]{93, 12, this.engine.getSymmetricDialect().getSqlTypeForIds()});
            }
            transaction.commit();
        }
    }

    @Override
    public IStagedResource findResource(CompareTableStatus status, String name) {
        return super.findResource(status, name);
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
        this.sqlMap = new CompareServiceSqlMap(engine.getSymmetricDialect().getPlatform(), engine.getTablePrefix());
        this.parameterService = engine.getParameterService();
        this.extensionService = engine.getExtensionService();
        this.compareTable = new p(engine, this);
        this.compareChunk = new i(engine, this);
        this.compareRow = new o(engine, this);
        this.compareRepair = new m(engine, this);
        this.transportMan = new r(engine, this);
    }

    class CompareRequestRowMapper
    implements ISqlRowMapper<CompareRequest> {
        CompareRequestRowMapper() {
        }

        public CompareRequest mapRow(Row rs) {
            CompareRequest r2 = new CompareRequest();
            r2.setSourceNodeId(rs.getString("source_node_id"));
            r2.setTargetNodeId(rs.getString("target_node_id"));
            r2.setTriggerId(rs.getString("trigger_id"));
            r2.setRouterId(rs.getString("router_id"));
            r2.setCreateTime(rs.getDateTime("create_time"));
            r2.setUseTableChecksum(rs.getBoolean("use_table_checksum"));
            r2.setUseInflight(rs.getBoolean("use_inflight"));
            r2.setUseRowLevel(rs.getBoolean("use_row_level"));
            r2.setUseChunking(rs.getBoolean("use_chunking"));
            r2.setUseScript(rs.getBoolean("use_script"));
            r2.setUseRepair(rs.getBoolean("use_repair"));
            r2.setChecksumAlgorithm(rs.getString("checksum_algorithm"));
            r2.setDecimalScale(rs.getInt("decimal_scale"));
            r2.setTimestampScale(rs.getInt("timestamp_scale"));
            r2.setRealScale(rs.getInt("real_scale"));
            if (rs.containsKey((Object)"exclude_surrogate")) {
                r2.setExcludeSurrogate(rs.getBoolean("exclude_surrogate"));
            }
            r2.setNotBefore(rs.getDateTime("not_before"));
            r2.setProcessed(rs.getBoolean("processed"));
            r2.setCompleted(rs.getBoolean("completed"));
            r2.setCancelled(rs.getBoolean("cancelled"));
            r2.setCompareId(rs.getLong("compare_id"));
            r2.setLastUpdateBy(rs.getString("last_update_by"));
            r2.setLastUpdateTime(rs.getDateTime("last_update_time"));
            return r2;
        }
    }

    class CompareTableStatusRowMapper
    implements ISqlRowMapper<CompareTableStatus> {
        CompareTableStatusRowMapper() {
        }

        public CompareTableStatus mapRow(Row rs) {
            CompareTableStatus s2 = new CompareTableStatus();
            s2.setCompareId(rs.getLong("compare_id"));
            s2.setSourceNodeId(rs.getString("source_node_id"));
            s2.setStepNumber(rs.getInt("step_num"));
            s2.setTargetNodeId(rs.getString("target_node_id"));
            s2.setLevel(rs.getString("current_level"));
            s2.setStatus(rs.getString("status"));
            s2.setSourceCatalogName(rs.getString("source_catalog_name"));
            s2.setSourceSchemaName(rs.getString("source_schema_name"));
            s2.setSourceTableName(rs.getString("source_table_name"));
            s2.setSourceRowCount(rs.getLong("source_row_count"));
            s2.setSourceRowCountMillis(rs.getLong("source_row_count_millis"));
            s2.setSourceRowExtractMillis(rs.getLong("source_row_extract_millis"));
            s2.setSourceRowExtractSize(rs.getLong("source_row_extract_size"));
            s2.setSourceRowSortMillis(rs.getLong("source_row_sort_millis"));
            s2.setSourceRowChecksumMillis(rs.getLong("source_row_checksum_millis"));
            s2.setSourceRowFilterMillis(rs.getLong("source_row_filter_millis"));
            s2.setSourceTableChecksumMillis(rs.getLong("source_table_checksum_millis"));
            s2.setSourceInflightCount(rs.getLong("source_inflight_count"));
            s2.setSourceInflightMillis(rs.getLong("source_inflight_millis"));
            s2.setSourceChunkMillis(rs.getLong("source_chunk_millis"));
            s2.setTargetCatalogName(rs.getString("target_catalog_name"));
            s2.setTargetSchemaName(rs.getString("target_schema_name"));
            s2.setTargetTableName(rs.getString("target_table_name"));
            s2.setTargetRowCount(rs.getLong("target_row_count"));
            s2.setTargetRowCountMillis(rs.getLong("target_row_count_millis"));
            s2.setTargetRowExtractMillis(rs.getLong("target_row_extract_millis"));
            s2.setTargetRowExtractSize(rs.getLong("target_row_extract_size"));
            s2.setTargetRowSortMillis(rs.getLong("target_row_sort_millis"));
            s2.setTargetRowChecksumMillis(rs.getLong("target_row_checksum_millis"));
            s2.setTargetRowFilterMillis(rs.getLong("target_row_filter_millis"));
            s2.setTargetTableChecksumMillis(rs.getLong("target_table_checksum_millis"));
            s2.setTargetInflightCount(rs.getLong("target_inflight_count"));
            s2.setTargetInflightMillis(rs.getLong("target_inflight_millis"));
            s2.setTargetChunkMillis(rs.getLong("target_chunk_millis"));
            s2.setChunkMatchCount(rs.getLong("chunk_match_count"));
            s2.setChunkDiffCount(rs.getLong("chunk_diff_count"));
            s2.setChunkDiffList(rs.getString("chunk_diff_list"));
            s2.setChunkCompareMillis(rs.getLong("chunk_compare_millis"));
            s2.setRowMatchCount(rs.getLong("row_match_count"));
            s2.setRowDiffCount(rs.getLong("row_diff_count"));
            s2.setRowMissingCount(rs.getLong("row_missing_count"));
            s2.setRowExtraCount(rs.getLong("row_extra_count"));
            s2.setRowCompareMillis(rs.getLong("row_compare_millis"));
            s2.setRepairQueryMillis(rs.getLong("repair_query_millis"));
            s2.setRepairLoadMillis(rs.getLong("repair_load_millis"));
            s2.setRepairRejectCount(rs.getInt("repair_reject_count"));
            s2.setMatchFlag(rs.getBoolean("match_flag"));
            s2.setIgnoreFlag(rs.getBoolean("ignore_flag"));
            s2.setErrorFlag(rs.getBoolean("error_flag"));
            s2.setErrorMessage(rs.getString("error_message"));
            s2.setStartTime(rs.getDateTime("start_time"));
            s2.setEndTime(rs.getDateTime("end_time"));
            s2.setLastUpdateTime(rs.getDateTime("last_update_time"));
            return s2;
        }
    }

    class CompareStatusRowMapper
    implements ISqlRowMapper<CompareStatus> {
        CompareStatusRowMapper() {
        }

        public CompareStatus mapRow(Row rs) {
            CompareStatus s2 = new CompareStatus();
            s2.setCompareId(rs.getLong("compare_id"));
            s2.setSourceNodeId(rs.getString("source_node_id"));
            s2.setTargetNodeId(rs.getString("target_node_id"));
            s2.setStartTime(rs.getDateTime("start_time"));
            s2.setEndTime(rs.getDateTime("end_time"));
            s2.setTablesRequested(rs.getInt("tables_requested"));
            s2.setTablesCompared(rs.getInt("tables_compared"));
            s2.setCompleted(rs.getBoolean("completed"));
            s2.setCancelled(rs.getBoolean("cancelled"));
            s2.setErrorFlag(rs.getBoolean("error_flag"));
            s2.setCreateTime(rs.getDateTime("create_time"));
            s2.setLastUpdateTime(rs.getDateTime("last_update_time"));
            return s2;
        }
    }
}

