/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.service.impl;

import com.jumpmind.symmetric.console.impl.G;
import com.jumpmind.symmetric.console.service.IBackgroundNoHangupService;
import com.jumpmind.symmetric.console.ui.common.I;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class BackgroundNoHangupService
implements IBackgroundNoHangupService,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ISymmetricEngine engine;
    private transient ThreadPoolTaskScheduler taskScheduler;

    @Override
    public void queueWork(final G<? extends Object> refreshing, final I controller) {
        this.taskScheduler.getScheduledExecutor().schedule(new Runnable(){

            @Override
            public void run() {
                BackgroundNoHangupService.this.refresh(refreshing, controller);
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    protected void refresh(G<Object> refreshing, I controller) {
        try {
            UI ui;
            String engineName = "not available";
            if (this.engine != null) {
                engineName = this.engine.getEngineName();
            }
            MDC.put((String)"engineName", (String)engineName);
            long ts = System.currentTimeMillis();
            Object data = refreshing.onBackgroundDataRefresh(this.engine);
            long timeItTookInMs = System.currentTimeMillis() - ts;
            if (timeItTookInMs > 10000L) {
                this.log.info("refreshing data for {} for engine: {} took {}ms", new Object[]{refreshing.getClass().getSimpleName(), engineName, timeItTookInMs});
            }
            if (controller != null && (ui = (UI)controller.getUI().orElse(null)) != null && ui.getElement().getNode().isAttached()) {
                ui.access((Command & Serializable)() -> {
                    try {
                        long currentTime = System.currentTimeMillis();
                        refreshing.onBackgroundUIRefresh(data);
                        long timeItTookInMillis = System.currentTimeMillis() - currentTime;
                        if (timeItTookInMillis > 10000L) {
                            this.log.info("refreshing ui for {} took {}ms", (Object)refreshing.getClass().getSimpleName(), (Object)timeItTookInMillis);
                        }
                    }
                    catch (Throwable ex2) {
                        refreshing.onUIError(ex2);
                        this.log.warn("Error during background refresh of " + String.valueOf(refreshing.getClass()), ex2);
                    }
                });
            }
        }
        catch (Throwable e2) {
            this.log.error("Exception while refreshing " + String.valueOf(refreshing.getClass()), e2);
        }
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
        this.taskScheduler = new ThreadPoolTaskScheduler();
        this.taskScheduler.setThreadNamePrefix("background-nohup-");
        this.taskScheduler.setPoolSize(3);
        this.taskScheduler.initialize();
    }
}

