/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.remote;

import com.jumpmind.symmetric.console.remote.IMessageHandler;
import com.jumpmind.symmetric.console.remote.MessageContext;
import com.jumpmind.symmetric.console.remote.MessageDirection;
import com.jumpmind.symmetric.console.remote.RemoteStatusOfflineCheck;
import com.jumpmind.symmetric.console.remote.RemoteStatusService;
import com.jumpmind.symmetric.console.remote.SessionEndpoint;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class RemoteStatusMessageSender
implements Callable<String> {
    static final Logger log = LoggerFactory.getLogger(RemoteStatusMessageSender.class);
    private static AtomicInteger messageIdCounter = new AtomicInteger(0);
    final RemoteStatusOfflineCheck offlineCheck = new RemoteStatusOfflineCheck();
    private RemoteStatusService remoteStatusService;
    private Map<String, MessageContext> messageContexts;
    private String sourceNodeId;
    private String targetNodeId;
    private String message;
    private IMessageHandler messageHandler;

    public RemoteStatusMessageSender(RemoteStatusService remoteStatusService, Map<String, MessageContext> messageContexts, String sourceNodeId, String targetNodeId, String message, IMessageHandler messageHandler) {
        this.remoteStatusService = remoteStatusService;
        this.messageContexts = messageContexts;
        this.sourceNodeId = sourceNodeId;
        this.targetNodeId = targetNodeId;
        this.message = message;
        this.messageHandler = messageHandler;
    }

    @Override
    public String call() throws Exception {
        SessionEndpoint socket = null;
        try {
            socket = this.remoteStatusService.connect(this.targetNodeId);
            if (socket != null) {
                this.sendMessageImpl(socket);
            }
            return null;
        }
        catch (Exception ex2) {
            if (socket != null) {
                socket.close();
            }
            this.messageHandler.onError(ex2);
            String msg = "Exception while connecting to " + this.targetNodeId;
            log.debug(msg, (Throwable)ex2);
            return null;
        }
    }

    protected void sendMessageImpl(SessionEndpoint socket) throws IOException {
        String messageId = this.generateMessageId(this.targetNodeId);
        MessageContext messageContext = new MessageContext();
        messageContext.setSessionEndpoint(socket);
        messageContext.setMessageId(messageId);
        messageContext.setMessageHandler(this.messageHandler);
        this.messageContexts.put(messageId, messageContext);
        String messageWithHeaders = this.remoteStatusService.getMessageJson(messageContext, MessageDirection.REQUEST, this.message);
        if (log.isDebugEnabled()) {
            String prettyPrint = this.remoteStatusService.getMessageJsonPretty(messageContext, MessageDirection.REQUEST, this.message);
            log.debug("Sending message\n" + prettyPrint);
        }
        WebSocketSession session = socket.getSession(this.targetNodeId);
        if (socket.getSession() != null) {
            socket.getSession().getAsyncRemote().sendText(messageWithHeaders);
            messageContext.setSendTime(new Date());
        } else if (session != null) {
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)messageWithHeaders));
            messageContext.setSendTime(new Date());
        } else {
            String prettyPrint = this.remoteStatusService.getMessageJsonPretty(messageContext, MessageDirection.REQUEST, this.message);
            this.messageContexts.remove(messageId);
            log.debug("Failed to send message from {} to {}\n {}", new Object[]{this.sourceNodeId, this.targetNodeId, prettyPrint});
        }
    }

    protected String generateMessageId(String targetNodeId) {
        return this.sourceNodeId + "->" + targetNodeId + "-" + messageIdCounter.incrementAndGet();
    }
}

