/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.remote;

import com.jumpmind.symmetric.console.remote.IRemoteStatusService;
import com.jumpmind.symmetric.console.remote.RemoteStatusHttpIncomingTransport;
import com.jumpmind.symmetric.console.remote.RemoteStatusHttpOutgoingTransport;
import java.io.IOException;
import java.util.Map;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.transport.IIncomingTransport;
import org.jumpmind.symmetric.transport.IOutgoingWithResponseTransport;
import org.jumpmind.symmetric.transport.http.HttpConnection;
import org.jumpmind.symmetric.transport.http.HttpIncomingTransport;
import org.jumpmind.symmetric.transport.http.HttpOutgoingTransport;
import org.jumpmind.symmetric.transport.http.HttpTransportManager;

public class RemoteStatusHttpTransportManager
extends HttpTransportManager {
    private IRemoteStatusService remoteStatusService;

    public RemoteStatusHttpTransportManager(ISymmetricEngine engine) {
        super(engine);
    }

    protected void checkForConnectionUpgrade(HttpConnection conn) {
        this.getRemoteStatusService().checkForRemoteStatusRequest(conn);
    }

    public IIncomingTransport getFilePullTransport(Node remote, Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        HttpIncomingTransport incomingTransport = (HttpIncomingTransport)super.getFilePullTransport(remote, local, securityToken, requestProperties, registrationUrl);
        RemoteStatusHttpIncomingTransport remoteStatusTransport = new RemoteStatusHttpIncomingTransport(incomingTransport, this.getRemoteStatusService());
        return remoteStatusTransport;
    }

    public IIncomingTransport getPullTransport(Node remote, Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        HttpIncomingTransport incomingTransport = (HttpIncomingTransport)super.getPullTransport(remote, local, securityToken, requestProperties, registrationUrl);
        RemoteStatusHttpIncomingTransport remoteStatusTransport = new RemoteStatusHttpIncomingTransport(incomingTransport, this.getRemoteStatusService());
        return remoteStatusTransport;
    }

    public IIncomingTransport getPingTransport(Node remote, Node local, String registrationUrl) throws IOException {
        HttpIncomingTransport incomingTransport = (HttpIncomingTransport)super.getPingTransport(remote, local, registrationUrl);
        RemoteStatusHttpIncomingTransport remoteStatusTransport = new RemoteStatusHttpIncomingTransport(incomingTransport, this.getRemoteStatusService());
        return remoteStatusTransport;
    }

    public IOutgoingWithResponseTransport getPushTransport(Node remote, Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        HttpOutgoingTransport outgoingTransport = (HttpOutgoingTransport)super.getPushTransport(remote, local, securityToken, requestProperties, registrationUrl);
        RemoteStatusHttpOutgoingTransport remoteStatusTransport = new RemoteStatusHttpOutgoingTransport(outgoingTransport, this.getRemoteStatusService());
        return remoteStatusTransport;
    }

    public IOutgoingWithResponseTransport getPushTransport(Node remote, Node local, String securityToken, String registrationUrl) throws IOException {
        HttpOutgoingTransport outgoingTransport = (HttpOutgoingTransport)super.getPushTransport(remote, local, securityToken, registrationUrl);
        RemoteStatusHttpOutgoingTransport remoteStatusTransport = new RemoteStatusHttpOutgoingTransport(outgoingTransport, this.getRemoteStatusService());
        return remoteStatusTransport;
    }

    public IOutgoingWithResponseTransport getFilePushTransport(Node remote, Node local, String securityToken, String registrationUrl) throws IOException {
        HttpOutgoingTransport outgoingTransport = (HttpOutgoingTransport)super.getFilePushTransport(remote, local, securityToken, registrationUrl);
        RemoteStatusHttpOutgoingTransport remoteStatusTransport = new RemoteStatusHttpOutgoingTransport(outgoingTransport, this.getRemoteStatusService());
        return remoteStatusTransport;
    }

    protected IRemoteStatusService getRemoteStatusService() {
        if (this.remoteStatusService == null) {
            this.remoteStatusService = (IRemoteStatusService)this.engine.getExtensionService().getExtensionPoint(IRemoteStatusService.class);
        }
        return this.remoteStatusService;
    }
}

