/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.remote;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jumpmind.symmetric.console.remote.RemoteStatusCommand;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteProcessStatusCommand {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private RemoteStatusCommand remoteStatusCommand;
    private Gson gsonPretty = new GsonBuilder().setPrettyPrinting().create();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public RemoteProcessStatusCommand(RemoteStatusCommand remoteStatusCommand) {
        this.remoteStatusCommand = remoteStatusCommand;
    }

    public String execute() throws Exception {
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        options.addOption("f", "format", true, "The format to receive the response.");
        CommandLine cmd = parser.parse(options, this.remoteStatusCommand.getCommand().split(" "));
        String format = cmd.getOptionValue('f');
        boolean jsonFormat = false;
        boolean jsonPrettyFormat = false;
        if ("json".equals(format)) {
            jsonFormat = true;
        } else if ("jsonPretty".equalsIgnoreCase(format)) {
            jsonFormat = true;
            jsonPrettyFormat = true;
        }
        ISymmetricEngine engine = this.remoteStatusCommand.getEngine();
        List processInfos = engine.getStatisticManager().getProcessInfos();
        if (jsonFormat) {
            return this.formatAsJson(processInfos, jsonPrettyFormat);
        }
        return this.formatHumanReadable(processInfos);
    }

    private String formatAsJson(List<ProcessInfo> processInfos, boolean jsonPrettyFormat) {
        JsonObject json = new JsonObject();
        if (processInfos.isEmpty()) {
            json.addProperty("message", "No processes.");
        } else {
            JsonArray batchesArray = new JsonArray();
            for (ProcessInfo processInfo : processInfos) {
                JsonObject jsonProcess = new JsonObject();
                jsonProcess.addProperty("nodeId", this.remoteStatusCommand.getEngine().getNodeId());
                jsonProcess.addProperty("processType", processInfo.getProcessType().toString());
                jsonProcess.addProperty("status", processInfo.getStatus().toString());
                jsonProcess.addProperty("startTime", this.formatDate(processInfo.getStartTime()));
                jsonProcess.addProperty("lastStatusChangeTime", this.formatDate(processInfo.getLastStatusChangeTime()));
                jsonProcess.addProperty("endTime", this.formatDate(processInfo.getEndTime()));
                jsonProcess.addProperty("currentChannelId", processInfo.getCurrentChannelId());
                jsonProcess.addProperty("currentChannelThread", processInfo.getQueue());
                jsonProcess.addProperty("currentTableName", processInfo.getCurrentTableName());
                jsonProcess.addProperty("sourceNodeId", processInfo.getSourceNodeId());
                jsonProcess.addProperty("targetNodeId", processInfo.getTargetNodeId());
                jsonProcess.addProperty("batchCount", (Number)processInfo.getTotalBatchCount());
                jsonProcess.addProperty("currentBatchCount", (Number)processInfo.getCurrentBatchCount());
                jsonProcess.addProperty("currentBatchId", (Number)processInfo.getCurrentBatchId());
                jsonProcess.addProperty("currentDataCount", (Number)processInfo.getCurrentDataCount());
                jsonProcess.addProperty("currentLoadId", (Number)processInfo.getCurrentLoadId());
                jsonProcess.addProperty("totalDataCount", (Number)processInfo.getTotalDataCount());
                jsonProcess.addProperty("currentBatchStartTime", this.formatDate(processInfo.getCurrentBatchStartTime()));
                jsonProcess.addProperty("key", processInfo.getKey().toString());
                batchesArray.add((JsonElement)jsonProcess);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Add process {}", (Object)this.gsonPretty.toJson((JsonElement)jsonProcess));
            }
            json.add("processes", (JsonElement)batchesArray);
        }
        if (jsonPrettyFormat) {
            return this.gsonPretty.toJson((JsonElement)json);
        }
        return this.remoteStatusCommand.getGson().toJson((JsonElement)json);
    }

    private String formatDate(Date date) {
        if (date == null) {
            return "null";
        }
        return this.dateFormat.format(date);
    }

    private String formatHumanReadable(List<ProcessInfo> processInfos) {
        if (processInfos.isEmpty()) {
            return "No processes.";
        }
        StringBuilder buff = new StringBuilder();
        for (ProcessInfo processInfo : processInfos) {
            buff.append(String.format("%s,endTime=%s\r\n", processInfo.toString(), processInfo.getEndTime()));
        }
        return buff.toString();
    }
}

