/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.remote;

import com.jumpmind.symmetric.console.remote.AbstractBatchStatusCommand;
import com.jumpmind.symmetric.console.remote.BatchStatus;
import com.jumpmind.symmetric.console.remote.RemoteStatusCommand;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.Strings;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessType;

public class RemoteBatchPsCommand
extends AbstractBatchStatusCommand {
    private RemoteStatusCommand remoteStatusCommand;

    public RemoteBatchPsCommand(RemoteStatusCommand remoteStatusCommand) {
        super(remoteStatusCommand);
        this.remoteStatusCommand = remoteStatusCommand;
    }

    public String execute() throws Exception {
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        options.addOption("f", "format", true, "The format to receive the response.");
        CommandLine cmd = parser.parse(options, this.remoteStatusCommand.getCommand().split(" "));
        String format = cmd.getOptionValue('f');
        boolean jsonFormat = false;
        if ("json".equals(format)) {
            jsonFormat = true;
        }
        List<BatchStatus> statuses = this.getBatchStatuses();
        return this.formatResponse(statuses, jsonFormat);
    }

    protected List<BatchStatus> getBatchStatuses() {
        ArrayList<BatchStatus> batchStatuses = new ArrayList<BatchStatus>();
        ISymmetricEngine engine = this.remoteStatusCommand.getEngine();
        List processInfos = engine.getStatisticManager().getProcessInfos();
        for (ProcessInfo info : processInfos) {
            if (info.getCurrentBatchId() == 0L || info.getProcessType() != ProcessType.PULL_JOB_LOAD && info.getProcessType() != ProcessType.PUSH_HANDLER_LOAD && (info.getProcessType() != ProcessType.PULL_JOB_TRANSFER && info.getProcessType() != ProcessType.PUSH_JOB_TRANSFER && info.getProcessType() != ProcessType.PULL_HANDLER_TRANSFER && info.getProcessType() != ProcessType.PUSH_HANDLER_TRANSFER || info.getEndTime() != null) || !Strings.CS.equals(info.getSourceNodeId(), this.remoteStatusCommand.getRemoteNodeId()) && !Strings.CS.equals(info.getTargetNodeId(), this.remoteStatusCommand.getRemoteNodeId())) continue;
            String mappedStatus = this.mapStatus(info.getStatus()).name();
            batchStatuses.add(new BatchStatus(info.getCurrentBatchId(), mappedStatus, info.getCurrentDataCount(), this.getProcessedMillis(info)));
        }
        return batchStatuses;
    }

    protected AbstractBatch.Status mapStatus(ProcessInfo.ProcessStatus status) {
        switch (status) {
            case NEW: {
                return AbstractBatch.Status.NE;
            }
            case QUERYING: 
            case PROCESSING: {
                return AbstractBatch.Status.QY;
            }
            case TRANSFERRING: {
                return AbstractBatch.Status.SE;
            }
            case LOADING: 
            case ACKING: {
                return AbstractBatch.Status.LD;
            }
            case ERROR: {
                return AbstractBatch.Status.ER;
            }
            case OK: {
                return AbstractBatch.Status.OK;
            }
        }
        return AbstractBatch.Status.XX;
    }
}

