/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.model;

import com.jumpmind.symmetric.console.model.ConsolePrivilege;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.jumpmind.symmetric.model.IModelObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleUser
implements IModelObject {
    static final Logger log = LoggerFactory.getLogger(ConsoleUser.class);
    private static final long serialVersionUID = 1L;
    public static final String AUTH_METHOD_INTERNAL = "INTERNAL";
    public static final String AUTH_METHOD_LDAP = "LDAP";
    public static final String AUTH_METHOD_SAML = "SAML";
    public static final String AUTH_METHOD_OAUTH2 = "OAUTH2";
    private String firstName;
    private String lastName;
    private String email;
    private String otpKey;
    private String confirmCode;
    private String userId;
    private String hashedPassword;
    private String password = "";
    private String salt;
    private String authenticationMethod = "INTERNAL";
    private String role;
    private Date createTime;
    private Date lastLoginTime;
    private Date confirmCreateTime;
    private String lastLoginIpAddr;
    private String lastLoginNodeId;
    private Date lastUpdateTime;
    private Date lastPasswordTime;
    private String lastUpdateBy;
    private String encryptionMethod = "SHA-512";
    private int failedLoginAttempts;
    private boolean resetRequired;
    private boolean glassBreakRequired;
    private Date breakGlassStartTime;
    private Date breakGlassEndTime;
    private String breakGlassUserId;
    private Map<String, ConsolePrivilege> privileges;
    private boolean enabled = true;

    public void setHashedPassword(String hashedPassword) {
        this.hashedPassword = hashedPassword;
    }

    public String getHashedPassword() {
        return this.hashedPassword;
    }

    public void setOtpKey(String otpKey) {
        this.otpKey = otpKey;
    }

    public String getOtpKey() {
        return this.otpKey;
    }

    public void setConfirmCode(String confirmCode) {
        this.confirmCode = confirmCode;
    }

    public String getConfirmCode() {
        return this.confirmCode;
    }

    public void setPrivileges(Map<String, ConsolePrivilege> privileges) {
        this.privileges = privileges;
    }

    public Map<String, ConsolePrivilege> getPrivileges() {
        return this.privileges;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void cleanupClearTextPassword() {
        this.password = "";
    }

    public void setPassword(String password) {
        this.password = password;
        this.hashedPassword = ConsoleUser.hashPassword(password, this.encryptionMethod, this.salt);
    }

    public String getPassword() {
        return this.password;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    public void setLastUpdateBy(String lastUpdateBy) {
        this.lastUpdateBy = lastUpdateBy;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public Date getConfirmCreateTime() {
        return this.confirmCreateTime;
    }

    public void setConfirmCreateTime(Date confirmCreateTime) {
        this.confirmCreateTime = confirmCreateTime;
    }

    public Date getLastPasswordTime() {
        return this.lastPasswordTime;
    }

    public void setLastPasswordTime(Date lastPasswordTime) {
        this.lastPasswordTime = lastPasswordTime;
    }

    public static String hashPassword(String password, String encryptionMethod, String salt) {
        try {
            if (encryptionMethod == null || encryptionMethod.equals("")) {
                encryptionMethod = "SHA-1";
            }
            MessageDigest md = MessageDigest.getInstance(encryptionMethod);
            byte[] shaHash = new byte[40];
            if (salt != null && !salt.equals("")) {
                md.update(Hex.decodeHex((String)salt));
            }
            shaHash = md.digest(password.getBytes("iso-8859-1"));
            return new String(Hex.encodeHex((byte[])shaHash));
        }
        catch (Exception ex2) {
            log.error(ex2.getMessage(), (Throwable)ex2);
            return password;
        }
    }

    public String getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public void setEncryptionMethod(String encryptionMethod) {
        this.encryptionMethod = encryptionMethod;
    }

    public void generateSalt() {
        SecureRandom sr = new SecureRandom();
        byte[] saltBytes = new byte[8];
        sr.nextBytes(saltBytes);
        this.salt = new String(Hex.encodeHex((byte[])saltBytes));
    }

    public void updateEncryption(boolean useSalt, String encryptionMethod) {
        if (useSalt) {
            this.generateSalt();
        } else {
            this.salt = null;
        }
        if (this.encryptionMethod == null || !encryptionMethod.equals(this.encryptionMethod)) {
            this.encryptionMethod = encryptionMethod;
        }
        this.hashedPassword = ConsoleUser.hashPassword(this.password, this.encryptionMethod, this.salt);
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        if (authenticationMethod != null) {
            this.authenticationMethod = authenticationMethod;
        }
    }

    public int getFailedLoginAttempts() {
        return this.failedLoginAttempts;
    }

    public void setFailedLoginAttempts(int failedLoginAttempts) {
        this.failedLoginAttempts = failedLoginAttempts;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Date getLastLoginTime() {
        return this.lastLoginTime;
    }

    public void setLastLoginTime(Date lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public String getLastLoginIpAddr() {
        return this.lastLoginIpAddr;
    }

    public void setLastLoginIpAddr(String lastLoginIpAddr) {
        this.lastLoginIpAddr = lastLoginIpAddr;
    }

    public String getLastLoginNodeId() {
        return this.lastLoginNodeId;
    }

    public void setLastLoginNodeId(String lastLoginNodeId) {
        this.lastLoginNodeId = lastLoginNodeId;
    }

    public boolean hasPrivilegeRead(String privilegeId) {
        ConsolePrivilege priv = null;
        if (this.privileges != null) {
            priv = this.privileges.get(privilegeId);
        }
        return priv != null && (priv.isReadFlag() || priv.isWriteFlag());
    }

    public boolean hasPrivilegeWrite(String privilegeId) {
        ConsolePrivilege priv = null;
        if (this.privileges != null) {
            priv = this.privileges.get(privilegeId);
        }
        return priv != null && priv.isWriteFlag();
    }

    public boolean isResetRequired() {
        return this.resetRequired;
    }

    public void setResetRequired(boolean resetRequired) {
        this.resetRequired = resetRequired;
    }

    public boolean isGlassBreakRequired() {
        return this.glassBreakRequired;
    }

    public void setGlassBreakRequired(boolean glassBreakRequired) {
        this.glassBreakRequired = glassBreakRequired;
    }

    public Date getBreakGlassStartTime() {
        return this.breakGlassStartTime;
    }

    public void setBreakGlassStartTime(Date breakGlassStartTime) {
        this.breakGlassStartTime = breakGlassStartTime;
    }

    public Date getBreakGlassEndTime() {
        return this.breakGlassEndTime;
    }

    public void setBreakGlassEndTime(Date breakGlassEndTime) {
        this.breakGlassEndTime = breakGlassEndTime;
    }

    public String getBreakGlassUserId() {
        return this.breakGlassUserId;
    }

    public void setBreakGlassUserId(String breakGlassUserId) {
        this.breakGlassUserId = breakGlassUserId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConsoleUser other = (ConsoleUser)obj;
        return !(this.userId == null ? other.userId != null : !this.userId.equals(other.userId));
    }
}

