/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.model;

import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class CertInfo {
    private String alias;
    private String name;
    private String subject;
    private String issuer;
    private Date effective;
    private Date expiration;
    private String keyType;

    public CertInfo(Certificate cert, String alias) {
        this.alias = alias;
        if (cert instanceof X509Certificate) {
            X509Certificate x509 = (X509Certificate)cert;
            this.subject = x509.getSubjectX500Principal().getName();
            this.name = this.parseRdn(x509, "CN");
            if (this.name == null) {
                this.name = this.parseRdn(x509, "OU");
                if (this.name == null) {
                    this.name = this.parseRdn(x509, "O");
                    if (this.name == null) {
                        this.name = this.subject;
                    }
                }
            }
            this.issuer = x509.getIssuerX500Principal().getName();
            this.effective = x509.getNotBefore();
            this.expiration = x509.getNotAfter();
            PublicKey pubKey = x509.getPublicKey();
            if (pubKey instanceof RSAPublicKey) {
                RSAPublicKey rsaPk = (RSAPublicKey)pubKey;
                this.keyType = "RSA " + rsaPk.getModulus().bitLength() + "-bit";
            } else if (pubKey instanceof DSAPublicKey) {
                DSAPublicKey dsaPk = (DSAPublicKey)pubKey;
                this.keyType = "DSA " + dsaPk.getParams().getP().bitLength() + "-bit";
            } else if (pubKey instanceof ECPublicKey) {
                this.keyType = "Elliptic Curve";
            }
        }
    }

    private String parseRdn(X509Certificate x509, String type) {
        String rdnValue = null;
        try {
            LdapName dn2 = new LdapName(x509.getSubjectX500Principal().getName());
            for (Rdn rdn : dn2.getRdns()) {
                if (!rdn.getType().equalsIgnoreCase(type)) continue;
                rdnValue = rdn.getValue().toString();
            }
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        return rdnValue;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public Date getEffective() {
        return this.effective;
    }

    public void setEffective(Date effective) {
        this.effective = effective;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }
}

