/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.fZ;
import com.jumpmind.symmetric.console.impl.gR;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.model.MonitorEvent;
import com.jumpmind.symmetric.console.service.IConsoleEventService;
import com.jumpmind.symmetric.console.ui.common.as;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.service.IConfigurationService;

public class gq
implements fZ,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    private ISymmetricEngine a;

    @Override
    public MonitorEvent a(Monitor monitor) {
        MonitorEvent event = new MonitorEvent();
        ArrayList<String> channelIdList = new ArrayList<String>();
        Map channelMap = this.a.getConfigurationService().getChannels(false);
        int maxMaxBatchToSend = 0;
        long threshold = monitor.getThreshold();
        for (Channel channel : channelMap.values()) {
            int maxBatchToSend = channel.getMaxBatchToSend();
            if (maxBatchToSend > maxMaxBatchToSend) {
                maxMaxBatchToSend = maxBatchToSend;
            }
            if ((long)maxBatchToSend < threshold) continue;
            channelIdList.add(channel.getChannelId());
        }
        event.setValue(maxMaxBatchToSend);
        int channelIdCount = channelIdList.size();
        if (channelIdCount > 0) {
            String problemDescription = channelIdCount == 1 ? "The '" + (String)channelIdList.get(0) + "' channel has a high max batch to send of " + maxMaxBatchToSend : "The following channels have a high max batch to send: " + String.valueOf(channelIdList);
            problemDescription = problemDescription + ".  This can slow down status updates and may result in lost acks in some environments.";
            String actionDescription = "Reduce the max batch to send to " + (threshold - 1L) + " or less.";
            gR recommendation = new gR(problemDescription, actionDescription, true);
            ArrayList<gR.a> options = new ArrayList<gR.a>();
            gR gR2 = recommendation;
            Objects.requireNonNull(gR2);
            options.add(new gR.a(gR2, 1, "Reduce the max batch to send to a maximum of " + (threshold - 1L) + " for all channels", threshold - 1L));
            recommendation.a(options);
            event.setDetails(as.getMonitorEventGson().toJson((Object)recommendation));
        }
        return event;
    }

    @Override
    public boolean a(MonitorEvent event, gR recommendation) {
        int maxMaxBatchToSend = (int)event.getThreshold() - 1;
        if (event.getApprovedOption() == 1) {
            maxMaxBatchToSend = (int)recommendation.a(event.getApprovedOption());
        }
        IConfigurationService configService = this.a.getConfigurationService();
        ArrayList<String> modifiedChannelIdList = new ArrayList<String>();
        for (Channel channel : configService.getChannels(true).values()) {
            if (channel.getMaxBatchToSend() <= maxMaxBatchToSend) continue;
            channel.setMaxBatchToSend(maxMaxBatchToSend);
            configService.saveChannel(channel, true);
            modifiedChannelIdList.add(channel.getChannelId());
        }
        IConsoleEventService consoleEventService = (IConsoleEventService)this.a.getExtensionService().getExtensionPoint(IConsoleEventService.class);
        String nodeId = this.a.getNodeId();
        consoleEventService.addEvent(new ConsoleEvent(event.getApprovedBy(), "Channel Modified", nodeId, nodeId, null, ((Object)modifiedChannelIdList).toString()));
        return true;
    }

    @Override
    public String b() {
        return "maxBatchToSend";
    }

    @Override
    public boolean a() {
        return true;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.a = engine;
    }
}

