/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.fZ;
import com.jumpmind.symmetric.console.impl.gR;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.model.MonitorEvent;
import com.jumpmind.symmetric.console.service.IConsoleEventService;
import com.jumpmind.symmetric.console.ui.common.as;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.service.IConfigurationService;

public class gp
implements fZ,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    private ISymmetricEngine a;

    @Override
    public MonitorEvent a(Monitor monitor) {
        MonitorEvent event = new MonitorEvent();
        ArrayList<String> channelIdList = new ArrayList<String>();
        Map channelMap = this.a.getConfigurationService().getChannels(false);
        int maxMaxBatchSize = 0;
        long threshold = monitor.getThreshold();
        for (Channel channel : channelMap.values()) {
            if (channel.isReloadFlag()) continue;
            int maxBatchSize = channel.getMaxBatchSize();
            if (maxBatchSize > maxMaxBatchSize) {
                maxMaxBatchSize = maxBatchSize;
            }
            if ((long)maxBatchSize < threshold) continue;
            channelIdList.add(channel.getChannelId());
        }
        event.setValue(maxMaxBatchSize);
        int channelIdCount = channelIdList.size();
        if (channelIdCount > 0) {
            String problemDescription = channelIdCount == 1 ? "The '" + (String)channelIdList.get(0) + "' channel has a high max batch size of " + maxMaxBatchSize : "The following channels have a high max batch size: " + String.valueOf(channelIdList);
            problemDescription = problemDescription + ".  A high commit size can cause transactional overhead and slowness for smaller databases.";
            String actionDescription = "Reduce the max batch size to " + (threshold - 1L) + " or less.";
            gR recommendation = new gR(problemDescription, actionDescription, true);
            ArrayList<gR.a> options = new ArrayList<gR.a>();
            gR gR2 = recommendation;
            Objects.requireNonNull(gR2);
            options.add(gR2.new gR.a(1, "Reduce the max batch size to a maximum of " + (threshold - 1L) + " for all channels", threshold - 1L));
            recommendation.a(options);
            event.setDetails(as.getMonitorEventGson().toJson((Object)recommendation));
        }
        return event;
    }

    @Override
    public boolean a(MonitorEvent event, gR recommendation) {
        int maxMaxBatchSize = (int)event.getThreshold() - 1;
        if (event.getApprovedOption() == 1) {
            maxMaxBatchSize = (int)recommendation.a(event.getApprovedOption());
        }
        IConfigurationService configService = this.a.getConfigurationService();
        ArrayList<String> modifiedChannelIdList = new ArrayList<String>();
        for (Channel channel : configService.getChannels(true).values()) {
            if (channel.getMaxBatchSize() <= maxMaxBatchSize) continue;
            channel.setMaxBatchSize(maxMaxBatchSize);
            configService.saveChannel(channel, true);
            modifiedChannelIdList.add(channel.getChannelId());
        }
        IConsoleEventService consoleEventService = (IConsoleEventService)this.a.getExtensionService().getExtensionPoint(IConsoleEventService.class);
        String nodeId = this.a.getNodeId();
        consoleEventService.addEvent(new ConsoleEvent(event.getApprovedBy(), "Channel Modified", nodeId, nodeId, null, ((Object)modifiedChannelIdList).toString()));
        return true;
    }

    @Override
    public String b() {
        return "maxBatchSize";
    }

    @Override
    public boolean a() {
        return true;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.a = engine;
    }
}

