/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.fZ;
import com.jumpmind.symmetric.console.impl.gR;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.model.MonitorEvent;
import com.jumpmind.symmetric.console.service.IConsoleEventService;
import com.jumpmind.symmetric.console.service.IMonitorService;
import com.jumpmind.symmetric.console.ui.common.as;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.util.LogSummaryAppenderUtils;
import org.jumpmind.util.LogSummary;

public class gh
implements fZ,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    private ISymmetricEngine a;
    private IParameterService b;

    @Override
    public MonitorEvent a(Monitor monitor) {
        MonitorEvent event = new MonitorEvent();
        boolean canReduceParameter = true;
        Date notBefore = ((IMonitorService)this.a.getExtensionService().getExtensionPoint(IMonitorService.class)).getLastApprovalTime(monitor.getMonitorId(), this.b());
        String engineName = this.a.getEngineName();
        for (LogSummary logSummary : LogSummaryAppenderUtils.getLogSummaryErrors((String)engineName)) {
            String message = logSummary.getMessage();
            if (!notBefore.before(new Date(logSummary.getMostRecentTime())) || message == null || !message.contains("The form key limit of") || !message.endsWith("cannot be reduced any further.")) continue;
            canReduceParameter = false;
            break;
        }
        String groupId = this.b.getNodeGroupId();
        int reducedFormKeyLimit = 0;
        if (canReduceParameter) {
            for (LogSummary logSummary : LogSummaryAppenderUtils.getLogSummaryWarnings((String)engineName)) {
                String message = logSummary.getMessage();
                if (!notBefore.before(new Date(logSummary.getMostRecentTime())) || message == null || !message.contains("form key limit") || !message.endsWith(" during the next attempt.")) continue;
                int formKeyLimitFromMessage = message.contains("of 50000") ? 50000 : Integer.parseInt(StringUtils.substringAfterLast((String)Strings.CS.removeEnd(message, (CharSequence)" during the next attempt."), (String)" "));
                if (reducedFormKeyLimit != 0 && formKeyLimitFromMessage >= reducedFormKeyLimit) continue;
                reducedFormKeyLimit = formKeyLimitFromMessage;
            }
            int maxFormKeys = this.b.getInt("transport.max.form.keys");
            if (reducedFormKeyLimit > 0 && reducedFormKeyLimit < maxFormKeys) {
                event.setValue(1L);
                String problemDescription = String.format("Batch acknowledgments were failing due to too many form keys. SymmetricDS resolved the issue by temporarily reducing the number of form keys to %d.", reducedFormKeyLimit);
                String actionDescription = String.format("Permanently resolve the issue by reducing the %s parameter.", "transport.max.form.keys");
                gR recommendation = new gR(problemDescription, actionDescription, true);
                ArrayList<gR.a> options = new ArrayList<gR.a>();
                gR gR2 = recommendation;
                Objects.requireNonNull(gR2);
                options.add(gR2.new gR.a(1, String.format("Reduce the %s parameter to %d for the '%s' node.", "transport.max.form.keys", reducedFormKeyLimit, engineName), reducedFormKeyLimit));
                gR gR3 = recommendation;
                Objects.requireNonNull(gR3);
                options.add(gR3.new gR.a(2, String.format("Reduce the %s parameter to %d for the '%s' group.", "transport.max.form.keys", reducedFormKeyLimit, groupId), reducedFormKeyLimit));
                gR gR4 = recommendation;
                Objects.requireNonNull(gR4);
                options.add(gR4.new gR.a(3, String.format("Reduce the %s parameter to %d for all nodes.", "transport.max.form.keys", reducedFormKeyLimit), reducedFormKeyLimit));
                recommendation.a(options);
                event.setDetails(as.getMonitorEventGson().toJson((Object)recommendation));
            } else {
                event.setValue(0L);
            }
        } else {
            event.setValue(2L);
            ArrayList<String> sourceGroupIdList = new ArrayList<String>();
            for (NodeGroupLink groupLink : this.a.getConfigurationService().getNodeGroupLinks(false)) {
                if (!groupLink.getDataEventAction().equals((Object)NodeGroupLinkAction.W) || !groupLink.getTargetNodeGroupId().equals(groupId)) continue;
                sourceGroupIdList.add(groupLink.getSourceNodeGroupId());
            }
            String problemDescription = "Batch acknowledgments are failing due to too many form keys. SymmetricDS attempted to resolve the issue by reducing the number of form keys but was unsuccessful.";
            Object actionDescription = !sourceGroupIdList.isEmpty() ? (sourceGroupIdList.size() == 1 ? String.format("Increase the form key limit for incoming requests on the node(s) in the '%s' group.", sourceGroupIdList.get(0)) : "Increase the form key limit for incoming requests on the nodes in the following groups: " + String.valueOf(sourceGroupIdList) + ".") : String.format("Increase the form key limit for incoming requests on the node(s) that the '%s' node pulls from.", engineName);
            gR recommendation = new gR(problemDescription, (String)actionDescription, false);
            event.setDetails(as.getMonitorEventGson().toJson((Object)recommendation));
        }
        return event;
    }

    @Override
    public boolean a(MonitorEvent event, gR recommendation) {
        if (recommendation.e()) {
            int approvedOption = event.getApprovedOption();
            String userId = event.getApprovedBy();
            if (approvedOption == 1) {
                this.b.saveParameter(this.b.getExternalId(), this.b.getNodeGroupId(), "transport.max.form.keys", (Object)recommendation.a(1), userId);
            } else if (approvedOption == 2) {
                this.b.saveParameter("ALL", this.b.getNodeGroupId(), "transport.max.form.keys", (Object)recommendation.a(2), userId);
            } else {
                this.b.saveParameter("transport.max.form.keys", (Object)recommendation.a(3), userId);
            }
            IConsoleEventService consoleEventService = (IConsoleEventService)this.a.getExtensionService().getExtensionPoint(IConsoleEventService.class);
            String nodeId = this.a.getNodeId();
            consoleEventService.addEvent(new ConsoleEvent(userId, "Edit Parameter", nodeId, nodeId, null, "transport.max.form.keys"));
        }
        return true;
    }

    @Override
    public String b() {
        return "formKeys";
    }

    @Override
    public boolean a() {
        return false;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.a = engine;
        this.b = engine.getParameterService();
    }
}

