/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.db2.Db2DdlReader;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;

public class fa
extends Db2DdlReader {
    public fa(IDatabasePlatform platform) {
        super(platform);
    }

    protected void enhanceTableMetaData(Connection connection, DatabaseMetaDataWrapper metaData, Table table) throws SQLException {
        this.b(connection, metaData, table);
        this.a(connection, metaData, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void a(Connection connection, DatabaseMetaDataWrapper metaData, Table table) throws SQLException {
        this.log.debug("about to read access control meta data.");
        Object sql = "SELECT COUNT(*) AS ACCESS_CONTROLS FROM SYSIBM.SYSCONTROLS WHERE TBNAME = ?";
        if (StringUtils.isNotBlank((CharSequence)table.getSchema())) {
            sql = (String)sql + " AND TBSCHEMA=?";
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            int accessControlCount;
            pstmt = connection.prepareStatement((String)sql);
            pstmt.setString(1, table.getName());
            if (StringUtils.isNotBlank((CharSequence)table.getSchema())) {
                pstmt.setString(2, table.getSchema());
            }
            if ((rs = pstmt.executeQuery()).next() && (accessControlCount = rs.getInt(1)) > 0) {
                table.setAccessControlled(true);
                this.log.debug("Table {} has {} access controls.", (Object)table.getName(), (Object)accessControlCount);
            }
        }
        catch (Throwable throwable) {
            JdbcSqlTemplate.close(rs);
            JdbcSqlTemplate.close((PreparedStatement)pstmt);
            throw throwable;
        }
        JdbcSqlTemplate.close((ResultSet)rs);
        JdbcSqlTemplate.close((PreparedStatement)pstmt);
        this.log.debug("done reading access control meta data.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void b(Connection connection, DatabaseMetaDataWrapper metaData, Table table) throws SQLException {
        this.log.debug("about to read additional column data");
        Object sql = "SELECT NAME, DEFAULT FROM SYSIBM.SYSCOLUMNS WHERE TBNAME=?";
        if (StringUtils.isNotBlank((CharSequence)metaData.getSchemaPattern())) {
            sql = (String)sql + " AND TBCREATOR=?";
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = connection.prepareStatement((String)sql);
            pstmt.setString(1, table.getName());
            if (StringUtils.isNotBlank((CharSequence)metaData.getSchemaPattern())) {
                pstmt.setString(2, metaData.getSchemaPattern());
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String isIdentity;
                String columnName = rs.getString(1);
                Column column = table.getColumnWithName(columnName);
                if (column == null || (isIdentity = rs.getString(2)) == null || !isIdentity.startsWith("I") && !isIdentity.startsWith("J")) continue;
                column.setAutoIncrement(true);
                this.log.debug("Found identity column {} on {}", (Object)columnName, (Object)table.getName());
            }
        }
        catch (Throwable throwable) {
            JdbcSqlTemplate.close(rs);
            JdbcSqlTemplate.close((PreparedStatement)pstmt);
            throw throwable;
        }
        JdbcSqlTemplate.close((ResultSet)rs);
        JdbcSqlTemplate.close((PreparedStatement)pstmt);
        this.log.debug("done reading additional column data");
    }

    public List<Trigger> getTriggers(String catalog, String schema, String tableName) throws SqlException {
        ArrayList<Trigger> triggers = new ArrayList();
        this.log.debug("Reading triggers for: " + tableName);
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        String sql = "SELECT * FROM SYSCAT.TRIGGERS WHERE TABNAME=? and TABSCHEMA=?";
        triggers = sqlTemplate.query(sql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

            public Trigger a(Row row) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("TRIGNAME"));
                trigger.setSchemaName(row.getString("TRIGSCHEMA"));
                trigger.setTableName(row.getString("TABNAME"));
                trigger.setEnabled(true);
                trigger.setSource(row.getString("TEXT"));
                row.remove((Object)"TEXT");
                switch (row.getString("TRIGEVENT").charAt(0)) {
                    case 'I': {
                        row.put("TRIGEVENT", (Object)"INSERT");
                        break;
                    }
                    case 'U': {
                        row.put("TRIGEVENT", (Object)"UPDATE");
                        break;
                    }
                    case 'D': {
                        row.put("TRIGEVENT", (Object)"DELETE");
                    }
                }
                trigger.setTriggerType(Trigger.TriggerType.valueOf((String)row.getString("TRIGEVENT")));
                switch (row.getString("TRIGTIME").charAt(0)) {
                    case 'A': {
                        row.put("TRIGTIME", (Object)"AFTER");
                        break;
                    }
                    case 'B': {
                        row.put("TRIGTIME", (Object)"BEFORE");
                        break;
                    }
                    case 'I': {
                        row.put("TRIGTIME", (Object)"INSTEAD OF");
                    }
                }
                trigger.setMetaData((Map)row);
                return trigger;
            }

            public /* synthetic */ Object mapRow(Row row) {
                return this.a(row);
            }
        }, new Object[]{tableName, schema});
        return triggers;
    }

    protected void removeGeneratedColumns(Connection connection, DatabaseMetaDataWrapper metaData, Table table) throws SQLException {
        ArrayList<Column> tempColumns = new ArrayList<Column>();
        boolean found = false;
        for (int i2 = 0; i2 < table.getColumns().length; ++i2) {
            if (table.getColumn(i2).getMappedTypeCode() == -8 || table.getColumn(i2).getName().equals("DB2_GENERATED_ROWID_FOR_LOBS")) {
                found = true;
                this.log.info("Found generated and/or rowid column on table " + table.getFullyQualifiedTableName() + ", column " + table.getColumn(i2).getName());
                continue;
            }
            tempColumns.add(table.getColumn(i2));
        }
        if (found) {
            table.removeAllColumns();
            table.addColumns(tempColumns);
        }
    }
}

