/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;

public class fA
extends AbstractJdbcDdlReader {
    private Pattern a;
    private Pattern b;
    private Pattern c;
    private String d = "\\([0-9]\\)";

    public fA(IDatabasePlatform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
        this.setDefaultTablePattern("%");
        this.a = Pattern.compile("TO_DATE\\('([^']*)'\\, 'YYYY\\-MM\\-DD'\\)");
        this.b = Pattern.compile("TO_DATE\\('([^']*)'\\, 'HH24:MI:SS'\\)");
        this.c = Pattern.compile("TO_DATE\\('([^']*)'\\, 'YYYY\\-MM\\-DD HH24:MI:SS'\\)");
    }

    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        boolean tableHasBeenDeleted = this.a(connection, values);
        String schema = (String)values.get(this.getResultSetSchemaName());
        if (!tableHasBeenDeleted && !"SYSTEM".equals(schema)) {
            Table table = super.readTable(connection, metaData, values);
            if (table != null) {
                this.a(connection, table);
            }
            return table;
        }
        return null;
    }

    protected boolean a(Connection connection, Map<String, Object> values) throws SQLException {
        String tablename = (String)values.get("TABLE_NAME");
        return StringUtils.isNotBlank((CharSequence)tablename) && tablename.toLowerCase().startsWith("bin$");
    }

    protected Integer mapUnknownJdbcTypeForColumn(Map<String, Object> values) {
        String typeName = (String)values.get("TYPE_NAME");
        if (typeName != null && typeName.startsWith("DATE")) {
            return 91;
        }
        if (typeName != null && typeName.startsWith("TIMESTAMP") && !typeName.endsWith("TIME ZONE")) {
            return 93;
        }
        if (typeName != null && typeName.startsWith("TIMESTAMP") && typeName.endsWith("WITH TIME ZONE")) {
            return -101;
        }
        if (typeName != null && typeName.startsWith("TIMESTAMP") && typeName.endsWith("WITH LOCAL TIME ZONE")) {
            return -102;
        }
        if (typeName != null && typeName.startsWith("NVARCHAR")) {
            return 12;
        }
        if (typeName != null && typeName.startsWith("LONGNVARCHAR")) {
            return -1;
        }
        if (typeName != null && typeName.startsWith("NCHAR")) {
            return 1;
        }
        if (typeName != null && typeName.startsWith("XML")) {
            return -1;
        }
        if (typeName != null && typeName.endsWith("CLOB")) {
            return -1;
        }
        if (typeName != null && typeName.startsWith("BINARY_FLOAT")) {
            return 6;
        }
        if (typeName != null && typeName.startsWith("BINARY_DOUBLE")) {
            return 8;
        }
        if (typeName != null && typeName.startsWith("BFILE")) {
            return 12;
        }
        if (typeName != null && typeName.startsWith("INTERVAL")) {
            return 12;
        }
        return super.mapUnknownJdbcTypeForColumn(values);
    }

    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Column column = super.readColumn(metaData, values);
        if (column.getMappedTypeCode() == 2) {
            if (column.getScale() == 0) {
                if (column.getSizeAsInt() == 3) {
                    column.setMappedTypeCode(-6);
                } else if (column.getSizeAsInt() <= 22) {
                    column.setMappedTypeCode(4);
                } else if (column.getSizeAsInt() == 38) {
                    column.setMappedTypeCode(-5);
                }
            }
        } else if (column.getMappedTypeCode() == 6) {
            switch (column.getSizeAsInt()) {
                case 63: {
                    column.setMappedTypeCode(7);
                    break;
                }
                case 126: {
                    column.setMappedTypeCode(8);
                }
            }
        } else if (column.getMappedTypeCode() == 91 || column.getMappedTypeCode() == 93 || column.getMappedTypeCode() == -101 || column.getMappedTypeCode() == -102) {
            if (column.getDefaultValue() != null) {
                Timestamp timestamp = null;
                Matcher matcher = this.c.matcher(column.getDefaultValue());
                if (matcher.matches()) {
                    String timestampVal = matcher.group(1);
                    timestamp = Timestamp.valueOf(timestampVal);
                } else {
                    matcher = this.a.matcher(column.getDefaultValue());
                    if (matcher.matches()) {
                        String dateVal = matcher.group(1);
                        timestamp = new Timestamp(Date.valueOf(dateVal).getTime());
                    } else {
                        matcher = this.b.matcher(column.getDefaultValue());
                        if (matcher.matches()) {
                            String timeVal = matcher.group(1);
                            timestamp = new Timestamp(Time.valueOf(timeVal).getTime());
                        }
                    }
                }
                if (timestamp != null) {
                    column.setDefaultValue(timestamp.toString());
                }
            }
            if (column.getMappedTypeCode() == 91) {
                this.removeColumnSize(column);
            } else {
                column.setJdbcTypeName(column.getJdbcTypeName().replaceAll(this.d, ""));
                column.setSize(String.valueOf(column.getScale()));
                PlatformColumn platformColumn = column.findPlatformColumn(this.platform.getName());
                if (platformColumn != null) {
                    platformColumn.setType(platformColumn.getType().replaceAll(this.d, ""));
                    platformColumn.setSize(column.getSizeAsInt());
                    platformColumn.setDecimalDigits(0);
                }
            }
        } else if (TypeMap.isTextType((int)column.getMappedTypeCode())) {
            String defaultValue = column.getDefaultValue();
            if (StringUtils.isNotBlank((CharSequence)defaultValue) && defaultValue.startsWith("('") && defaultValue.endsWith("')")) {
                defaultValue = defaultValue.substring(2, defaultValue.length() - 2);
            }
            column.setDefaultValue(this.unescape(defaultValue, "'", "''"));
        }
        return column;
    }

    protected void a(Connection connection, Table table) throws SQLException {
        Column[] columns = table.getColumns();
        for (int idx = 0; idx < columns.length; ++idx) {
            columns[idx].setAutoIncrement(this.a(connection, table, columns[idx]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean a(Connection connection, Table table, Column column) throws SQLException {
        PreparedStatement prepStmt = null;
        IDdlBuilder builder = this.getPlatform().getDdlBuilder();
        String triggerName = builder.getConstraintName("TRG", table, column.getName(), null);
        String seqName = builder.getConstraintName("SEQ", table, column.getName(), null);
        if (!this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn()) {
            triggerName = triggerName.toUpperCase();
            seqName = seqName.toUpperCase();
        }
        try {
            prepStmt = connection.prepareStatement("SELECT * FROM user_triggers WHERE trigger_name = ?");
            prepStmt.setString(1, triggerName);
            ResultSet resultSet = prepStmt.executeQuery();
            if (!resultSet.next()) {
                resultSet.close();
                boolean bl2 = false;
                return bl2;
            }
            prepStmt.close();
            prepStmt = connection.prepareStatement("SELECT * FROM user_sequences WHERE sequence_name = ?");
            prepStmt.setString(1, seqName);
            resultSet = prepStmt.executeQuery();
            boolean resultFound = resultSet.next();
            resultSet.close();
            boolean bl3 = resultFound;
            return bl3;
        }
        finally {
            if (prepStmt != null) {
                prepStmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<IIndex> readIndices(Connection connection, DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT a.INDEX_NAME, a.INDEX_TYPE, a.UNIQUENESS, b.COLUMN_NAME, b.COLUMN_POSITION FROM ALL_INDEXES a ");
        query.append("JOIN ALL_IND_COLUMNS b ON a.table_name = b.table_name AND a.INDEX_NAME=b.INDEX_NAME AND a.TABLE_OWNER = b.TABLE_OWNER ");
        query.append("WHERE a.TABLE_NAME = ? ");
        query.append(" AND a.GENERATED_BY_SYSTEM = ? ");
        query.append(" AND a.TABLE_TYPE = ? ");
        query.append(" AND a.INDEX_NAME NOT IN (SELECT DISTINCT c.CONSTRAINT_NAME FROM ALL_CONSTRAINTS c WHERE c.CONSTRAINT_TYPE = ? AND c.TABLE_NAME=a.TABLE_NAME ");
        if (metaData.getSchemaPattern() != null) {
            query.append(" AND c.OWNER like ?) AND a.TABLE_OWNER like ? ");
        } else {
            query.append(")");
        }
        LinkedHashMap indices = new LinkedHashMap();
        try (PreparedStatement stmt = null;){
            stmt = connection.prepareStatement(query.toString());
            stmt.setString(1, this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn() ? tableName : tableName.toUpperCase());
            stmt.setString(2, "N");
            stmt.setString(3, "TABLE");
            stmt.setString(4, "P");
            if (metaData.getSchemaPattern() != null) {
                stmt.setString(5, metaData.getSchemaPattern().toUpperCase());
                stmt.setString(6, metaData.getSchemaPattern().toUpperCase());
            }
            ResultSet rs = stmt.executeQuery();
            HashMap<String, Object> values = new HashMap<String, Object>();
            while (rs.next()) {
                String name = rs.getString(1);
                String type = rs.getString(2);
                if (type.startsWith("NORMAL")) {
                    values.put("INDEX_TYPE", (short)3);
                    values.put("INDEX_NAME", name);
                    values.put("NON_UNIQUE", "UNIQUE".equalsIgnoreCase(rs.getString(3)) ? Boolean.FALSE : Boolean.TRUE);
                    values.put("COLUMN_NAME", rs.getString(4));
                    values.put("ORDINAL_POSITION", rs.getShort(5));
                    this.readIndex(metaData, values, indices);
                    continue;
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Skipping index " + name + " of type " + type);
            }
            rs.close();
        }
        return indices.values();
    }

    protected String getTableNamePattern(String tableName) {
        return String.format("%s", tableName).replaceAll("\\_", "/_");
    }

    public List<String> getTableNamesFromDatabase(String catalog, String schema, String[] tableTypes) {
        ArrayList<String> tableNames = new ArrayList();
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        StringBuilder sql = new StringBuilder("select TABLE_NAME from ALL_TABLES");
        Object[] params = null;
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            sql.append(" where OWNER=?");
            params = new Object[]{schema};
        }
        tableNames = sqlTemplate.query(sql.toString(), (ISqlRowMapper)new ISqlRowMapper<String>(){

            public String a(Row row) {
                return row.getString("TABLE_NAME");
            }

            public /* synthetic */ Object mapRow(Row row) {
                return this.a(row);
            }
        }, params);
        return tableNames;
    }

    public List<Trigger> getTriggers(String catalog, String schema, String tableName) throws SqlException {
        List<Trigger> triggers = new ArrayList();
        this.log.debug("Reading triggers for: " + tableName);
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        String sql = "SELECT * FROM ALL_TRIGGERS WHERE TABLE_NAME=? and OWNER=?";
        triggers = sqlTemplate.query(sql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

            public Trigger a(Row row) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("TRIGGER_NAME"));
                trigger.setSchemaName(row.getString("OWNER"));
                trigger.setTableName(row.getString("TABLE_NAME"));
                trigger.setEnabled(Boolean.valueOf(row.getString("STATUS")).booleanValue());
                trigger.setSource("create ");
                String triggerType = row.getString("TRIGGERING_EVENT");
                if (triggerType.equals("DELETE") || triggerType.equals("INSERT") || triggerType.equals("UPDATE")) {
                    trigger.setTriggerType(Trigger.TriggerType.valueOf((String)triggerType));
                }
                trigger.setMetaData((Map)row);
                return trigger;
            }

            public /* synthetic */ Object mapRow(Row row) {
                return this.a(row);
            }
        }, new Object[]{tableName, schema});
        for (final Trigger trigger : triggers) {
            String name = trigger.getName();
            String sourceSql = "select TEXT from all_source where NAME=? order by LINE ";
            sqlTemplate.query(sourceSql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

                public Trigger a(Row row) {
                    trigger.setSource(trigger.getSource() + "\n" + row.getString("TEXT"));
                    return trigger;
                }

                public /* synthetic */ Object mapRow(Row row) {
                    return this.a(row);
                }
            }, new Object[]{name});
        }
        return triggers;
    }

    protected void readForeignKeyUpdateRule(Map<String, Object> values, ForeignKey fk2) {
        fk2.setOnUpdateAction(ForeignKey.ForeignKeyAction.NOACTION);
    }
}

