/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.cQ;
import com.jumpmind.symmetric.console.ui.common.I;
import java.io.Reader;
import java.io.StringReader;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jumpmind.db.io.DatabaseXmlUtil;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.symmetric.io.stage.PerfResult;

public class cx
extends cQ {
    private static final long q = 1L;
    private IDatabasePlatform r;
    private List<PerfResult> s = new ArrayList<PerfResult>();
    private Exception t;
    private SecureRandom u;

    public cx(I controller, String engineName, IDatabasePlatform platform) {
        super(controller, engineName, "-db-perf-test", "Database Performance");
        this.r = platform;
    }

    public cx(I controller, String engineName, IDatabasePlatform platform, String threadNameSuffix, String header) {
        super(controller, engineName, threadNameSuffix, header);
        this.r = platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<PerfResult> a() {
        long startTime;
        LinkedHashMap<String, PerfResult> results;
        block73: {
            ISqlTemplate template = this.r.getSqlTemplate();
            results = new LinkedHashMap<String, PerfResult>();
            this.s.clear();
            long lastCallbackTime = startTime = System.currentTimeMillis();
            boolean tableExists = false;
            this.a.info("Starting database performance test, duration of 5 seconds");
            try {
                int i2;
                long ts;
                StringReader stringReader = new StringReader("<database name=\"perf\">\n    <table name=\"sym_perf_test\">\n        <column name=\"id\" type=\"INTEGER\" required=\"true\" primaryKey=\"true\" />\n        <column name=\"name\" type=\"VARCHAR\" size=\"50\" />\n        <column name=\"description\" type=\"VARCHAR\" size=\"250\" />\n        <column name=\"create_time\" type=\"TIMESTAMP\" />\n    </table>\n");
                Database database = DatabaseXmlUtil.read((Reader)stringReader);
                this.r.alterCaseToMatchDatabaseDefaultCase(database);
                this.r.createDatabase(database, false, false);
                tableExists = true;
                template.update("delete from sym_perf_test", new Object[0]);
                try (ISqlTransaction transaction = template.startSqlTransaction();){
                    ts = System.currentTimeMillis();
                    for (i2 = -1000; i2 < 0; ++i2) {
                        transaction.prepareAndExecute("insert into sym_perf_test values (?, ?, ?, ?)", new Object[]{i2, this.a(50), this.a(250), new Date()});
                        if (!this.p) break;
                    }
                    transaction.flush();
                    transaction.commit();
                    this.a(results, "Prime", 1000, System.currentTimeMillis() - ts);
                }
                if (!this.p) break block73;
                while (System.currentTimeMillis() - startTime < 5000L) {
                    transaction = template.startSqlTransaction();
                    try {
                        ts = System.currentTimeMillis();
                        for (i2 = 0; i2 < 10; ++i2) {
                            transaction.prepareAndExecute("insert into sym_perf_test values (?, ?, ?, ?)", new Object[]{i2, this.a(50), this.a(250), new Date()});
                            if (!this.p) break;
                        }
                        transaction.flush();
                        transaction.commit();
                        this.a(results, "Insert", 10, System.currentTimeMillis() - ts);
                    }
                    catch (Exception ex2) {
                        if (transaction != null) {
                            transaction.rollback();
                        }
                        throw ex2;
                    }
                    finally {
                        if (transaction != null) {
                            transaction.close();
                        }
                    }
                    if (!this.p) break block73;
                    transaction = template.startSqlTransaction();
                    try {
                        ts = System.currentTimeMillis();
                        for (i2 = 0; i2 < 10; ++i2) {
                            transaction.prepareAndExecute("update sym_perf_test set name=?, description=?, create_time=? where id=?", new Object[]{this.a(50), this.a(250), new Date(), i2});
                            if (!this.p) break;
                        }
                        transaction.flush();
                        transaction.commit();
                        this.a(results, "Update", 10, System.currentTimeMillis() - ts);
                    }
                    catch (Exception ex3) {
                        if (transaction != null) {
                            transaction.rollback();
                        }
                        throw ex3;
                    }
                    finally {
                        if (transaction != null) {
                            transaction.close();
                        }
                    }
                    if (!this.p) break block73;
                    transaction = template.startSqlTransaction();
                    try {
                        ts = System.currentTimeMillis();
                        for (i2 = 0; i2 < 10; ++i2) {
                            transaction.prepareAndExecute("delete from sym_perf_test where id=?", new Object[]{i2});
                            if (!this.p) break;
                        }
                        transaction.flush();
                        transaction.commit();
                        this.a(results, "Delete", 10, System.currentTimeMillis() - ts);
                    }
                    catch (Exception ex4) {
                        if (transaction != null) {
                            transaction.rollback();
                        }
                        throw ex4;
                    }
                    finally {
                        if (transaction != null) {
                            transaction.close();
                        }
                    }
                    if (!this.p) break block73;
                    transaction = template.startSqlTransaction();
                    try {
                        ts = System.currentTimeMillis();
                        transaction.prepare("insert into sym_perf_test values (?, ?, ?, ?)");
                        for (i2 = 0; i2 < 100; ++i2) {
                            transaction.addRow(null, new Object[]{i2, this.a(50), this.a(250), new Date()}, new int[]{4, 12, 12, 93});
                            if (!this.p) break;
                        }
                        transaction.flush();
                        transaction.commit();
                        this.a(results, "Bulk Insert", 100, System.currentTimeMillis() - ts);
                    }
                    catch (Exception ex5) {
                        if (transaction != null) {
                            transaction.rollback();
                        }
                        throw ex5;
                    }
                    finally {
                        if (transaction != null) {
                            transaction.close();
                        }
                    }
                    if (!this.p) break block73;
                    transaction = template.startSqlTransaction();
                    try {
                        ts = System.currentTimeMillis();
                        transaction.prepare("update sym_perf_test set name=?, description=?, create_time=? where id=?");
                        for (i2 = 0; i2 < 100; ++i2) {
                            transaction.addRow(null, new Object[]{this.a(50), this.a(250), new Date(), i2}, new int[]{12, 12, 93, 4});
                            if (!this.p) break;
                        }
                        transaction.flush();
                        transaction.commit();
                        this.a(results, "Bulk Update", 100, System.currentTimeMillis() - ts);
                    }
                    catch (Exception ex6) {
                        if (transaction != null) {
                            transaction.rollback();
                        }
                        throw ex6;
                    }
                    finally {
                        if (transaction != null) {
                            transaction.close();
                        }
                    }
                    if (!this.p) break block73;
                    transaction = template.startSqlTransaction();
                    try {
                        ts = System.currentTimeMillis();
                        transaction.prepare("delete from sym_perf_test where id=?");
                        for (i2 = 0; i2 < 100; ++i2) {
                            transaction.addRow(null, new Object[]{i2}, new int[]{4});
                            if (!this.p) break;
                        }
                        transaction.flush();
                        transaction.commit();
                        this.a(results, "Bulk Delete", 100, System.currentTimeMillis() - ts);
                    }
                    catch (Exception ex7) {
                        if (transaction != null) {
                            transaction.rollback();
                        }
                        throw ex7;
                    }
                    finally {
                        if (transaction != null) {
                            transaction.close();
                        }
                    }
                    if (this.p) {
                        ts = System.currentTimeMillis();
                        if (ts - lastCallbackTime <= 1000L) continue;
                        List<PerfResult> resultsList = this.a(results);
                        long totalSeconds = (ts - startTime) / 1000L;
                        this.a(totalSeconds, resultsList);
                        this.update(resultsList, (float)totalSeconds / 5.0f);
                        lastCallbackTime = ts;
                        continue;
                    }
                    break block73;
                }
                this.t = null;
            }
            catch (Exception e2) {
                this.a.error("Failed to run test", (Throwable)e2);
                this.t = e2;
            }
            finally {
                if (tableExists) {
                    template.update("drop table sym_perf_test", new Object[0]);
                }
            }
        }
        this.s = this.a(results);
        this.a((System.currentTimeMillis() - startTime) / 1000L, this.s);
        if (!this.p) {
            this.a.warn("Test cancelled by user");
            this.p = true;
        }
        return this.s;
    }

    protected void a(long totalSeconds, List<PerfResult> resultsAsList) {
        this.a.info("Running for {} seconds", (Object)totalSeconds);
        for (PerfResult result : resultsAsList) {
            this.a.info(result.toString());
        }
    }

    private void a(Map<String, PerfResult> results, String statName, int increment, long millis) {
        PerfResult result = results.get(statName);
        if (result == null) {
            result = new PerfResult(statName);
            results.put(statName, result);
        }
        result.incrementCount((long)increment);
        result.incrementMillis(millis);
    }

    private String a(int maxLength) {
        int length = this.i().nextInt(maxLength);
        if (length == 0) {
            length = 1;
        }
        StringBuilder str = new StringBuilder(length);
        for (int i2 = 0; i2 < length; ++i2) {
            str.append(this.h());
        }
        return str.toString();
    }

    private Character h() {
        int rnd = this.i().nextInt(52);
        int base = rnd < 26 ? 65 : 97;
        return Character.valueOf((char)(base + rnd % 26));
    }

    private SecureRandom i() {
        if (this.u == null) {
            this.u = new SecureRandom();
        }
        return this.u;
    }

    @Override
    protected List<PerfResult> b() {
        ArrayList<PerfResult> list = new ArrayList<PerfResult>();
        list.add(new PerfResult(this.b.getMessage("Prime", new Object[0])));
        list.add(new PerfResult(this.b.getMessage("Insert", new Object[0])));
        list.add(new PerfResult(this.b.getMessage("Update", new Object[0])));
        list.add(new PerfResult(this.b.getMessage("Delete", new Object[0])));
        list.add(new PerfResult(this.b.getMessage("Bulk Insert", new Object[0])));
        list.add(new PerfResult(this.b.getMessage("Bulk Update", new Object[0])));
        list.add(new PerfResult(this.b.getMessage("Bulk Delete", new Object[0])));
        return list;
    }

    protected List<PerfResult> a(Map<String, PerfResult> results) {
        ArrayList<PerfResult> list = new ArrayList<PerfResult>();
        this.a(this.b.getMessage("Prime", new Object[0]), results, list, 100L, 4000L);
        this.a(this.b.getMessage("Insert", new Object[0]), results, list, 100L, 3000L);
        this.a(this.b.getMessage("Update", new Object[0]), results, list, 100L, 2900L);
        this.a(this.b.getMessage("Delete", new Object[0]), results, list, 150L, 4000L);
        this.a(this.b.getMessage("Bulk Insert", new Object[0]), results, list, 200L, 6000L);
        this.a(this.b.getMessage("Bulk Update", new Object[0]), results, list, 200L, 5900L);
        this.a(this.b.getMessage("Bulk Delete", new Object[0]), results, list, 300L, 9000L);
        return list;
    }

    protected void a(String statName, Map<String, PerfResult> results, List<PerfResult> list, long lowCount, long highCount) {
        PerfResult result = results.get(statName);
        if (result != null) {
            long opSec = result.getOperationsPerSecond();
            if (opSec <= lowCount) {
                result.setRating(1.0f);
            } else if (opSec >= highCount) {
                result.setRating(9.9f);
            } else {
                float rating = 9.9f * ((float)(opSec - lowCount) / (float)(highCount - lowCount));
                result.setRating(rating);
            }
            list.add(result);
        }
    }

    public float c() {
        return this.b(this.s);
    }

    public List<PerfResult> d() {
        return this.s;
    }

    public Exception e() {
        return this.t;
    }
}

