/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.G;
import com.jumpmind.symmetric.console.impl.dA;
import com.jumpmind.symmetric.console.impl.dB;
import com.jumpmind.symmetric.console.impl.dj;
import com.jumpmind.symmetric.console.model.CompareRequest;
import com.jumpmind.symmetric.console.model.CompareStatus;
import com.jumpmind.symmetric.console.model.CompareTableStatus;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.service.ICompareService;
import com.jumpmind.symmetric.console.ui.common.H;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.J;
import com.jumpmind.symmetric.console.ui.common.K;
import com.jumpmind.symmetric.console.ui.common.ap;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.grid.ItemClickEvent;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.progressbar.ProgressBar;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.vaadin.ui.common.Label;
import org.jumpmind.vaadin.ui.common.TabSheet;
import org.jumpmind.vaadin.ui.common.TabbedApplicationPanel;

public abstract class cp
extends ap
implements G<Object>,
H,
J,
ComponentEventListener<ItemClickEvent<CompareStatus>> {
    private static final long g = 1L;
    protected Grid<CompareStatus> a;
    protected Checkbox b;
    protected Checkbox c;
    protected TabbedApplicationPanel d;
    protected String e;
    protected Set<CompareStatus> f = new HashSet<CompareStatus>();

    public cp(I controller, String description) {
        super(controller, null, description);
    }

    @Override
    public void init() {
        if (this.a == null) {
            boolean validLicense;
            HorizontalLayout infoLayout = this.b();
            if (infoLayout != null) {
                this.content.addAndExpand(new Component[]{infoLayout});
            }
            HorizontalLayout searchPanel = new HorizontalLayout();
            searchPanel.setSpacing(true);
            Button refreshNow = as.createIconButton(K.REFRESH);
            refreshNow.addClickListener((ComponentEventListener & Serializable)event -> this.onRefresh(new Object[0]));
            searchPanel.add(new Component[]{refreshNow});
            Button compareButton = new Button("Compare Data...");
            compareButton.getStyle().set("margin", "4px 16px");
            compareButton.addClickListener((ComponentEventListener & Serializable)event -> {
                ICompareService cs2 = (ICompareService)this.controller.getSymmetricEngine().getExtensionService().getExtensionPoint(ICompareService.class);
                dB context = new dB();
                context.e(this.h());
                context.a(cs2);
                new dA(this.controller, context, this.controller.getSymmetricEngine().getNodeId(), null, false, cs2).open();
            });
            boolean bl2 = validLicense = this.controller.getLicenseService().f();
            if (validLicense && this.controller.getConsoleUser().hasPrivilegeWrite("Compare Data")) {
                compareButton.setEnabled(true);
            } else {
                compareButton.setEnabled(false);
                if (!validLicense) {
                    Span warningSpan = new Span();
                    warningSpan.setSizeUndefined();
                    warningSpan.setText("This feature is not enabled in your license key.  Please contact sales@jumpmind.com for assistance.");
                    warningSpan.setClassName("v-label-marked");
                    searchPanel.add(new Component[]{warningSpan});
                }
            }
            if (this.controller.getConsoleUser().hasPrivilegeRead("Compare Data")) {
                searchPanel.add(new Component[]{compareButton});
            }
            Span separator = new Span();
            separator.setClassName("vrule");
            separator.setWidth(null);
            searchPanel.add(new Component[]{separator});
            Button resubmitButton = new Button("Resubmit");
            resubmitButton.setEnabled(false);
            resubmitButton.addClickListener((ComponentEventListener & Serializable)event -> this.a());
            if (this.controller.getConsoleUser().hasPrivilegeRead("Compare Data")) {
                searchPanel.add(new Component[]{resubmitButton});
            }
            Button cancelButton = new Button(this.message("Cancel", new Object[0]));
            cancelButton.setEnabled(false);
            cancelButton.addClickListener((ComponentEventListener & Serializable)event -> {
                Set selectedRows = this.a.getSelectedItems();
                if (selectedRows != null && selectedRows.size() > 0) {
                    boolean refresh = false;
                    for (CompareStatus status : selectedRows) {
                        if (status == null) continue;
                        refresh = true;
                        ICompareService cs2 = (ICompareService)this.controller.getSymmetricEngine().getExtensionService().getExtensionPoint(ICompareService.class);
                        cs2.cancelCompareRequest(status.getSourceNodeId(), status.getCompareId(), this.controller.getConsoleUser().getUserId());
                        this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Compare Cancelled", this.controller.getSymmetricEngine().getNodeId(), status.getSourceNodeId(), status.getTargetNodeId(), "compareId=" + status.getCompareId()));
                        this.f.add(status);
                    }
                    if (refresh) {
                        this.onRefresh(new Object[0]);
                    }
                }
            });
            if (this.controller.getConsoleUser().hasPrivilegeRead("Cancel")) {
                searchPanel.add(new Component[]{cancelButton});
            }
            searchPanel.addAndExpand(new Component[]{new Span()});
            this.b = new Checkbox("Active Only");
            this.b.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.onRefresh(new Object[0]));
            this.b.setValue((Object)false);
            searchPanel.add(new Component[]{this.b});
            searchPanel.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{this.b});
            this.c = new Checkbox(this.controller.getMessage("Auto Refresh", new Object[0]));
            this.c.setValue((Object)true);
            searchPanel.add(new Component[]{this.c});
            searchPanel.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{this.c});
            this.a = new Grid(CompareStatus.class);
            this.a.addItemClickListener((ComponentEventListener & Serializable)event -> {
                this.a.deselectAll();
                if (event != null && event.getItem() != null) {
                    this.a.select((Object)((CompareStatus)event.getItem()));
                }
            });
            Grid.Column idColumn = this.a.addColumn((ValueProvider & Serializable)status -> {
                if (status.getCompareId() <= 0L) {
                    return "?";
                }
                return status.getCompareId();
            });
            idColumn.setKey("id");
            idColumn.setHeader("Compare Id");
            Grid.Column sourceNodeColumn = this.a.addColumn((ValueProvider & Serializable)status -> status.getSourceNodeId());
            sourceNodeColumn.setKey("sourceNode");
            sourceNodeColumn.setHeader("Source Node");
            Grid.Column tablesColumn = this.a.addColumn((ValueProvider & Serializable)status -> status.getTablesRequested() == 0 ? "?" : Integer.valueOf(status.getTablesRequested()));
            tablesColumn.setKey("tables");
            tablesColumn.setHeader("Tables");
            this.a.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)status -> this.a((CompareStatus)status))).setHeader("Progress").setKey("progress").setPartNameGenerator((SerializableFunction & Serializable)object -> "align-center");
            Grid.Column durationColumn = this.a.addColumn((ValueProvider & Serializable)status -> {
                if (status.getCompareId() <= 0L) {
                    return "";
                }
                if (status.isCancelled()) {
                    return "";
                }
                Date startDate = status.getCreateTime();
                Date endDate = !status.isCompleted() && !status.isCancelled() || status.getEndTime() == null ? new Date() : status.getEndTime();
                return as.formatDurationFull(endDate.getTime() - startDate.getTime());
            });
            durationColumn.setKey("duration");
            durationColumn.setHeader("Duration");
            Grid.Column detailsColumn = this.a.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)status -> {
                Icon icon;
                if (status.getCompareId() > 0L) {
                    icon = new Icon(VaadinIcon.BAR_CHART);
                    icon.setColor("#1676F3");
                    icon.setClassName("mouse_pointer");
                } else if (status.isCancelled()) {
                    icon = new Icon(VaadinIcon.BAR_CHART);
                } else if (status.getCompareRequest() != null && status.getCompareRequest().getNotBefore() != null && status.getCompareRequest().getNotBefore().after(new Date())) {
                    icon = new Icon(VaadinIcon.CLOCK);
                    icon.setTooltipText(status.getCompareRequest().getNotBefore().toString());
                } else {
                    icon = new Icon(VaadinIcon.HOURGLASS);
                }
                return icon;
            }));
            detailsColumn.setKey("details");
            detailsColumn.setHeader("Details").setPartNameGenerator((SerializableFunction & Serializable)object -> "align-center");
            this.a.setSizeFull();
            this.a.setSelectionMode(Grid.SelectionMode.MULTI);
            this.a.getColumnByKey("details").setWidth("80px");
            this.c();
            this.a.removeColumnByKey("completed");
            this.a.removeColumnByKey("cancelled");
            this.a.removeColumnByKey("lastUpdateTime");
            this.a.removeColumnByKey("endTime");
            this.a.removeColumnByKey("errorFlag");
            this.a.removeColumnByKey("tablesCompared");
            this.a.removeColumnByKey("tablesRequested");
            this.a.removeColumnByKey("lastUpdateBy");
            for (Grid.Column column : this.a.getColumns()) {
                column.setResizable(true);
            }
            this.d();
            this.a.addItemClickListener((ComponentEventListener)this);
            ArrayList sortOrderList = new ArrayList();
            this.a.sort(sortOrderList);
            this.a.setPartNameGenerator((SerializableFunction & Serializable)status -> {
                if (status.isErrorFlag() && !status.isCompleted()) {
                    return "marked";
                }
                if (status.isCancelled()) {
                    return "cancelled";
                }
                return null;
            });
            this.a.addSelectionListener((SelectionListener & Serializable)event -> {
                boolean hasItems = !this.a.getSelectedItems().isEmpty();
                boolean canResubmit = hasItems && this.controller.getConsoleUser().hasPrivilegeWrite("Compare Data");
                boolean canCancel = hasItems && this.controller.getConsoleUser().hasPrivilegeWrite("Cancel");
                for (CompareStatus status : this.a.getSelectedItems()) {
                    if (status.isCancelled() || this.f.contains(status) || status.isCompleted()) {
                        canCancel = false;
                    }
                    if (status.isCompleted()) continue;
                    canResubmit = false;
                }
                cancelButton.setEnabled(canCancel);
                resubmitButton.setEnabled(canResubmit);
            });
            VerticalLayout loadsLayout = new VerticalLayout();
            loadsLayout.add(new Component[]{searchPanel, this.a});
            loadsLayout.expand(new Component[]{this.a});
            this.d = new TabbedApplicationPanel(){
                private static final long b = 1L;

                public void remove(TabSheet.EnhancedTab tab) {
                    int tabCount = this.tabList.size();
                    if (tab.isSelected() && tabCount > 1) {
                        int index = this.tabList.indexOf(tab);
                        if (index < tabCount - 1) {
                            this.tabs.setSelectedIndex(index + 1);
                        } else {
                            this.tabs.setSelectedIndex(index - 1);
                        }
                    }
                    this.tabs.remove(new Tab[]{tab});
                    this.tabList.remove(tab);
                }
            };
            this.d.setMainTab("All Compare Statuses", new Icon(VaadinIcon.EXCHANGE), (Component)loadsLayout);
            this.d.setSizeFull();
            this.content.add(new Component[]{this.d});
            this.content.setFlexGrow(30.0, new HasElement[]{this.d});
        }
    }

    protected void a() {
        ICompareService cs2 = (ICompareService)this.controller.getSymmetricEngine().getExtensionService().getExtensionPoint(ICompareService.class);
        String nodeId = this.controller.getSymmetricEngine().getNodeId();
        Set selectedRows = this.a.getSelectedItems();
        if (selectedRows != null && selectedRows.size() > 0) {
            for (CompareStatus status : selectedRows) {
                for (CompareRequest request : cs2.findCompareRequests(status.getSourceNodeId(), status.getCompareId())) {
                    String eventDetail = "Resubmit compare ID " + request.getCompareId();
                    request.setCreateTime(new Date());
                    request.setCompareId(0L);
                    request.setProcessed(false);
                    request.setCompleted(false);
                    request.setCancelled(false);
                    request.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    cs2.insertCompareRequest(request);
                    this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Compare Requested", nodeId, nodeId, request.getTargetNodeId(), eventDetail));
                }
            }
            this.onRefresh(new Object[0]);
        }
    }

    public Span a(CompareStatus s2) {
        Label label = new Label();
        if (s2.isCancelled()) {
            Icon icon = new Icon(VaadinIcon.BAN);
            icon.setColor("red");
            label.setLeftIcon((Component)icon);
        } else if (this.f.contains(s2)) {
            Icon icon = new Icon(VaadinIcon.MINUS_CIRCLE_O);
            icon.setColor("red");
            label.setLeftIcon((Component)icon);
        } else if (s2.isCompleted()) {
            Icon icon = new Icon(VaadinIcon.CHECK);
            icon.setColor("green");
            label.setLeftIcon((Component)icon);
        } else {
            String prefix;
            double percent;
            if (s2.isErrorFlag()) {
                Icon icon = new Icon(VaadinIcon.EXCLAMATION_CIRCLE);
                icon.setColor("red");
                label.setLeftIcon((Component)icon);
                Span error = new Span("Error");
                error.setClassName("unhealthy");
                return new Span(new Component[]{new HorizontalLayout(new Component[]{icon, error})});
            }
            if (s2.getCompareId() <= 0L) {
                return label;
            }
            if (s2.getTablesRequested() > s2.getTablesCompared()) {
                percent = (double)s2.getTablesCompared() / (double)s2.getTablesRequested();
                prefix = "Comparing: ";
            } else {
                percent = 1.0;
                prefix = "Finalizing: ";
            }
            if (Double.isNaN(percent *= 100.0)) {
                return label;
            }
            if (percent >= 100.0) {
                percent = 99.0;
            }
            if (percent < 0.0) {
                percent = 0.0;
            }
            Span percentComplete = new Span(prefix + new DecimalFormat("###").format(percent) + "%");
            ProgressBar progressBar = new ProgressBar();
            progressBar.setWidth("180px");
            progressBar.setValue(percent / 100.0);
            return new Span(new Component[]{new HorizontalLayout(new Component[]{percentComplete, progressBar})});
        }
        return label;
    }

    public void a(ItemClickEvent<CompareStatus> event) {
        if (event != null && event.getItem() != null && event.getColumn() != null && this.a != null) {
            this.a.deselectAll();
            if (event.getItem() != null) {
                this.a.select((Object)((CompareStatus)event.getItem()));
                if (event.getColumn().getKey().equals("details")) {
                    CompareStatus compareStatus = (CompareStatus)event.getItem();
                    this.b(compareStatus);
                }
            }
        }
    }

    protected void b(CompareStatus compareStatus) {
        String name;
        if (compareStatus != null && compareStatus.getCompareId() > 0L && this.d.getTab(name = "Compare ID " + compareStatus.getCompareId()) == null) {
            ICompareService cs2 = (ICompareService)this.controller.getSymmetricEngine().getExtensionService().getExtensionPoint(ICompareService.class);
            List<CompareTableStatus> tableStatuses = cs2.findCompareTableStatuses(compareStatus.getSourceNodeId(), compareStatus.getCompareId());
            dj tableStatusDetail = this.a(tableStatuses, compareStatus, cs2);
            tableStatusDetail.setHeight(null);
            this.d.addCloseableTab(name, new Icon(VaadinIcon.LINE_CHART), (Component)tableStatusDetail, false);
        }
    }

    @Override
    public Object onBackgroundDataRefresh(ISymmetricEngine engine) {
        TabSheet.EnhancedTab selectedTab;
        if (this.e == null || !this.e.equals(engine.getEngineName())) {
            Iterator tabIterator = this.d.iterator();
            int index = 0;
            HashSet<TabSheet.EnhancedTab> tabsToRemove = new HashSet<TabSheet.EnhancedTab>();
            while (tabIterator.hasNext()) {
                if (index > 0) {
                    tabsToRemove.add(this.d.getTab(index));
                }
                ++index;
                tabIterator.next();
            }
            this.e = engine.getEngineName();
            for (TabSheet.EnhancedTab t2 : tabsToRemove) {
                this.d.remove(t2);
            }
        }
        if ((selectedTab = this.d.getSelectedTab()).getComponent() instanceof dj) {
            dj tableStatusDetail = (dj)selectedTab.getComponent();
            tableStatusDetail.onBackgroundDataRefresh(engine);
        } else if (((Boolean)this.c.getValue()).booleanValue()) {
            List<CompareStatus> statuses = null;
            statuses = (Boolean)this.b.getValue() != false ? this.f() : this.e();
            CompareStatus activeStatus = null;
            int activeCount = 0;
            for (CompareStatus status : statuses) {
                if (status.isCompleted() || status.isCancelled()) continue;
                activeStatus = status;
                ++activeCount;
            }
            if (activeCount > 1) {
                activeStatus = null;
            }
            return new a(statuses, activeStatus);
        }
        return null;
    }

    @Override
    public void onBackgroundUIRefresh(Object backgroundData) {
        TabSheet.EnhancedTab selectedTab = this.d.getSelectedTab();
        if (selectedTab.getComponent() instanceof dj) {
            dj loadDetail = (dj)selectedTab.getComponent();
            loadDetail.onBackgroundUIRefresh(backgroundData);
        } else if (((Boolean)this.c.getValue()).booleanValue()) {
            a data = (a)backgroundData;
            this.a(data);
            this.b(data.b());
        }
    }

    protected void a(a data) {
        if (data != null && this.a != null) {
            Set selected = this.a.getSelectedItems();
            List<CompareStatus> statuses = data.a();
            if (statuses != null && statuses.size() > 0 && statuses.get(0) != null) {
                Set selectedItems = this.a.getSelectedItems();
                this.a.setItems(statuses);
                for (CompareStatus item : selectedItems) {
                    this.a.select((Object)item);
                }
                ArrayList<GridSortOrder> sortOrderList = new ArrayList<GridSortOrder>();
                sortOrderList.add(new GridSortOrder(this.a.getColumnByKey("createTime"), SortDirection.DESCENDING));
                this.a.sort(sortOrderList);
            } else if (statuses == null || statuses.size() == 0) {
                this.a.setItems(new ArrayList());
            }
            for (CompareStatus item : selected) {
                this.a.select((Object)item);
            }
        }
    }

    @Override
    public void onUIError(Throwable ex2) {
    }

    @Override
    public boolean onExit(Runnable exitClosure) {
        return true;
    }

    protected abstract HorizontalLayout b();

    protected abstract void c();

    protected abstract void d();

    protected abstract List<CompareStatus> e();

    protected abstract List<CompareStatus> f();

    protected abstract dj a(List<CompareTableStatus> var1, CompareStatus var2, ICompareService var3);

    protected abstract String g();

    protected abstract boolean h();

    @Override
    public void onRefresh(Object ... params) {
        this.onBackgroundUIRefresh(this.onBackgroundDataRefresh(this.controller.getSymmetricEngine()));
    }

    public /* synthetic */ void onComponentEvent(ComponentEvent componentEvent) {
        this.a((ItemClickEvent<CompareStatus>)((ItemClickEvent)componentEvent));
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "lambda$init$9b1b5227$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/AbstractComparePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> this.onRefresh(new Object[0]);
            }
            case "lambda$init$9b1b5227$2": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/AbstractComparePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    ICompareService cs2 = (ICompareService)this.controller.getSymmetricEngine().getExtensionService().getExtensionPoint(ICompareService.class);
                    dB context = new dB();
                    context.e(this.h());
                    context.a(cs2);
                    new dA(this.controller, context, this.controller.getSymmetricEngine().getNodeId(), null, false, cs2).open();
                };
            }
            case "lambda$init$9b1b5227$3": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/AbstractComparePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> this.a();
            }
            case "lambda$init$ba4eed5e$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/data/selection/SelectionListener") || !lambda.getFunctionalInterfaceMethodName().equals("selectionChange") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/data/selection/SelectionEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/AbstractComparePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/button/Button;Lcom/vaadin/flow/component/button/Button;Lcom/vaadin/flow/data/selection/SelectionEvent;)V")) break;
                return arg_0 -> ((cp)lambda.getCapturedArg(0)).a((Button)lambda.getCapturedArg(1), (Button)lambda.getCapturedArg(2), arg_0);
            }
            case "lambda$init$9b1b5227$4": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/AbstractComparePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    Set selectedRows = this.a.getSelectedItems();
                    if (selectedRows != null && selectedRows.size() > 0) {
                        boolean refresh = false;
                        for (CompareStatus status : selectedRows) {
                            if (status == null) continue;
                            refresh = true;
                            ICompareService cs2 = (ICompareService)this.controller.getSymmetricEngine().getExtensionService().getExtensionPoint(ICompareService.class);
                            cs2.cancelCompareRequest(status.getSourceNodeId(), status.getCompareId(), this.controller.getConsoleUser().getUserId());
                            this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Compare Cancelled", this.controller.getSymmetricEngine().getNodeId(), status.getSourceNodeId(), status.getTargetNodeId(), "compareId=" + status.getCompareId()));
                            this.f.add(status);
                        }
                        if (refresh) {
                            this.onRefresh(new Object[0]);
                        }
                    }
                };
            }
            case "lambda$init$9b1b5227$5": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/AbstractComparePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/grid/ItemClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    this.a.deselectAll();
                    if (event != null && event.getItem() != null) {
                        this.a.select((Object)((CompareStatus)event.getItem()));
                    }
                };
            }
            case "lambda$init$3fed5817$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializableFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/AbstractComparePanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/CompareStatus;)Lcom/vaadin/flow/component/html/Span;")) break;
                return (SerializableFunction & Serializable)status -> this.a((CompareStatus)status);
            }
            case "lambda$init$d2aebd25$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/AbstractComparePanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/CompareStatus;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)status -> status.getTablesRequested() == 0 ? "?" : Integer.valueOf(status.getTablesRequested());
            }
            case "lambda$init$3fed5817$4": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializableFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/AbstractComparePanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/CompareStatus;)Ljava/lang/String;")) break;
                return (SerializableFunction & Serializable)status -> {
                    if (status.isErrorFlag() && !status.isCompleted()) {
                        return "marked";
                    }
                    if (status.isCancelled()) {
                        return "cancelled";
                    }
                    return null;
                };
            }
            case "lambda$init$3fed5817$3": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializableFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/AbstractComparePanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/CompareStatus;)Ljava/lang/String;")) break;
                return (SerializableFunction & Serializable)object -> "align-center";
            }
            case "lambda$init$3fed5817$2": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializableFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/AbstractComparePanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/CompareStatus;)Ljava/lang/String;")) break;
                return (SerializableFunction & Serializable)object -> "align-center";
            }
            case "lambda$init$1cde72dc$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializableFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/AbstractComparePanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/CompareStatus;)Lcom/vaadin/flow/component/icon/Icon;")) break;
                return (SerializableFunction & Serializable)status -> {
                    Icon icon;
                    if (status.getCompareId() > 0L) {
                        icon = new Icon(VaadinIcon.BAR_CHART);
                        icon.setColor("#1676F3");
                        icon.setClassName("mouse_pointer");
                    } else if (status.isCancelled()) {
                        icon = new Icon(VaadinIcon.BAR_CHART);
                    } else if (status.getCompareRequest() != null && status.getCompareRequest().getNotBefore() != null && status.getCompareRequest().getNotBefore().after(new Date())) {
                        icon = new Icon(VaadinIcon.CLOCK);
                        icon.setTooltipText(status.getCompareRequest().getNotBefore().toString());
                    } else {
                        icon = new Icon(VaadinIcon.HOURGLASS);
                    }
                    return icon;
                };
            }
            case "lambda$init$3c62ae56$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/AbstractComparePanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/CompareStatus;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)status -> {
                    if (status.getCompareId() <= 0L) {
                        return "";
                    }
                    if (status.isCancelled()) {
                        return "";
                    }
                    Date startDate = status.getCreateTime();
                    Date endDate = !status.isCompleted() && !status.isCancelled() || status.getEndTime() == null ? new Date() : status.getEndTime();
                    return as.formatDurationFull(endDate.getTime() - startDate.getTime());
                };
            }
            case "lambda$init$3fab9f70$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/AbstractComparePanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                return (HasValue.ValueChangeListener & Serializable)event -> this.onRefresh(new Object[0]);
            }
            case "lambda$init$847a1a4d$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/AbstractComparePanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/CompareStatus;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)status -> status.getSourceNodeId();
            }
            case "lambda$init$b2635f2f$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/AbstractComparePanel") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/CompareStatus;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)status -> {
                    if (status.getCompareId() <= 0L) {
                        return "?";
                    }
                    return status.getCompareId();
                };
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }

    class a {
        protected List<CompareStatus> a;
        protected CompareStatus b;

        public a(List<CompareStatus> statuses, CompareStatus activeStatus) {
            this.a = statuses;
            this.b = activeStatus;
        }

        public List<CompareStatus> a() {
            return this.a;
        }

        public CompareStatus b() {
            return this.b;
        }
    }
}

