/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.google.gson.Gson;
import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.impl.an;
import com.jumpmind.symmetric.console.model.TableGroup;
import com.jumpmind.symmetric.console.model.TableGroupHier;
import com.jumpmind.symmetric.console.model.TableSelect;
import com.jumpmind.symmetric.console.service.ITableGroupService;
import com.jumpmind.symmetric.console.ui.common.H;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.as;
import com.jumpmind.symmetric.console.ui.common.b;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridMultiSelectionModel;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.radiobutton.RadioGroupVariant;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.selection.MultiSelectionListener;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.Reference;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.model.IModelObject;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.vaadin.ui.common.ColumnVisibilityToggler;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.ResizableDialog;

public class bA
extends b<TableGroupHier>
implements H {
    private static final long a = 1L;

    public bA(I controller) {
        super(controller.getMessage("Table group hierarchies are relationships between tables used to find dependent data.", new Object[0]), controller);
    }

    @Override
    protected R<TableGroupHier> createForm(boolean newItemFlag, boolean deleteFlag) {
        return new an(this.controller, this.grid.getSelectedItems(), newItemFlag, deleteFlag);
    }

    @Override
    public String getTitleKey() {
        return this.controller.getMessage("Table Group Hierarchies", new Object[0]);
    }

    @Override
    public String getEditTitle() {
        return "Edit '%s' Table Group Hierarchy";
    }

    @Override
    public String getNewTitle() {
        return "New Table Group Hierarchy";
    }

    protected String a(TableGroupHier item) {
        return item.getId();
    }

    @Override
    protected void addButtonsLeft(FlexLayout buttonLayout) {
        Button autoCreateButton = new Button(this.controller.getMessage("Auto Create...", new Object[0]), (ComponentEventListener & Serializable)event -> new a().show());
        autoCreateButton.getStyle().set("margin", "4px");
        if (!this.controller.getConsoleUser().hasPrivilegeWrite("Auto Create Table Group Hierarchies")) {
            autoCreateButton.getElement().setAttribute("title", String.format("Your role '%s' does not have the privileges needed for this action.", this.controller.getConsoleUser().getRole()));
            autoCreateButton.setEnabled(false);
        }
        if (this.controller.getConsoleUser().hasPrivilegeRead("Auto Create Table Group Hierarchies")) {
            buttonLayout.add(new Component[]{autoCreateButton});
        }
    }

    @Override
    protected void initGrid() {
        this.grid = new Grid(TableGroupHier.class);
    }

    @Override
    protected void fillGrid(Grid<TableGroupHier> grid) {
        String searchValue;
        ITableGroupService tableGroupService = this.controller.getTableGroupService();
        if (this.itemList != null) {
            this.itemList.clear();
        }
        if (!StringUtils.isBlank((CharSequence)(searchValue = this.searchField.getValue()))) {
            List<TableGroupHier> allHiers = tableGroupService.getTableGroupHiers(true);
            for (TableGroupHier hier : allHiers) {
                if (CommonUiUtils.isFilteredOut((String)hier.getId(), (String)searchValue)) continue;
                this.itemList.add(hier);
            }
        } else {
            this.itemList = new ArrayList<TableGroupHier>(tableGroupService.getTableGroupHiers(true));
        }
        this.updateItems(this.itemList);
    }

    @Override
    protected String getKeyColumn() {
        return "id";
    }

    @Override
    protected String[] getFilterColumns() {
        String[] columns = new String[]{"id"};
        return columns;
    }

    @Override
    protected Map<String, String> getVisibleGridColumns() {
        LinkedHashMap<String, String> columns = new LinkedHashMap<String, String>();
        columns.put("id", this.controller.getMessage("Table Group Hierarchy Id", new Object[0]));
        columns.put("tableGroupId", this.controller.getMessage("Table Group Id", new Object[0]));
        columns.put("sourceCatalogName", this.controller.getMessage("Source Catalog", new Object[0]));
        columns.put("sourceSchemaName", this.controller.getMessage("Source Schema", new Object[0]));
        columns.put("sourceTableName", this.controller.getMessage("Source Table", new Object[0]));
        columns.put("parentId", this.controller.getMessage("Parent Id", new Object[0]));
        columns.put("relationType", this.controller.getMessage("Relation Type", new Object[0]));
        columns.put("primaryColumnNames", this.controller.getMessage("Primary Column Names", new Object[0]));
        columns.put("localColumnNames", this.controller.getMessage("Local Column Names", new Object[0]));
        columns.put("parentColumnNames", this.controller.getMessage("Parent Column Names", new Object[0]));
        columns.put("lastUpdateTime", this.controller.getMessage("Last Updated", new Object[0]));
        columns.put("lastUpdateBy", this.controller.getMessage("Last Updated By", new Object[0]));
        columns.put("createTime", this.controller.getMessage("Created", new Object[0]));
        columns.put("createBy", this.controller.getMessage("Created By", new Object[0]));
        return columns;
    }

    @Override
    protected boolean isDeleteEnabled(StringBuilder tooltip) {
        if (!this.grid.getSelectedItems().isEmpty()) {
            if (this.controller.getConsoleUser().hasPrivilegeWrite("Table Groups/Hierarchies Screen")) {
                return true;
            }
            String consoleRoleId = "unknown";
            if (this.controller.getConsoleUser().getRole() != null) {
                consoleRoleId = this.controller.getConsoleUser().getRole();
            }
            tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", consoleRoleId));
            return false;
        }
        return false;
    }

    @Override
    protected boolean isNewEnabled(StringBuilder tooltip) {
        if (this.controller.getConsoleUser().hasPrivilegeWrite("Table Groups/Hierarchies Screen")) {
            return true;
        }
        String consoleRoleId = "unknown";
        if (this.controller.getConsoleUser().getRole() != null) {
            consoleRoleId = this.controller.getConsoleUser().getRole();
        }
        tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", consoleRoleId));
        return false;
    }

    @Override
    protected boolean isEditEnabled(StringBuilder tooltip) {
        if (this.controller.getConsoleUser().hasPrivilegeWrite("Table Groups/Hierarchies Screen")) {
            return true;
        }
        String consoleRoleId = "unknown";
        if (this.controller.getConsoleUser().getRole() != null) {
            consoleRoleId = this.controller.getConsoleUser().getRole();
        }
        tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", consoleRoleId));
        return false;
    }

    @Override
    protected boolean gridCanBeModified() {
        return this.controller.getConsoleUser().hasPrivilegeRead("Table Groups/Hierarchies Screen");
    }

    @Override
    protected boolean canSaveAsCopy() {
        return true;
    }

    @Override
    protected void hideColumns() {
        this.grid.getColumnByKey("lastUpdateTime").setVisible(false);
        this.grid.getColumnByKey("lastUpdateBy").setVisible(false);
        this.grid.getColumnByKey("createTime").setVisible(false);
        this.grid.getColumnByKey("createBy").setVisible(false);
    }

    @Override
    public String getDocAnchor() {
        return "/doc/html/user-guide.html#_table_group_hiers";
    }

    @Override
    protected /* synthetic */ String getId(IModelObject iModelObject) {
        return this.a((TableGroupHier)iModelObject);
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "lambda$addButtonsLeft$73fc920a$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> new a().show();
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }

    public class a
    extends ResizableDialog {
        private static final long b = 1L;
        private int c;
        private int d;
        private VerticalLayout e;
        private int f;
        private TextField g;
        private Select<NodeGroupLink> h;
        private RadioButtonGroup<TableGroup.WriterType> i;
        private Grid<TableSelect> j;
        private Set<TableSelect> k;
        private NodeGroupLink l;
        private TableSelect m;
        private TextField n;
        private TextField o;
        private TextField p;
        private Grid<TableGroupHier> q;
        private Map<String, Set<TableGroupHier>> r;
        private int s;
        private Set<TableGroupHier> t;
        private Set<TableGroupHier> u;
        private TextField v;
        private TextField w;
        private TextField x;
        private TextField y;
        private Button z;
        private Button A;
        private Button B;
        private Button C;
        private Span D;

        public a() {
            super(bA.this.controller.getMessage("Auto Create Table Group Hierarchies", new Object[0]));
            this.f = 0;
            this.A = new Button(bA.this.controller.getMessage("Next", new Object[0]));
            this.B = new Button(bA.this.controller.getMessage("Previous", new Object[0]));
            this.C = new Button(bA.this.controller.getMessage("Finish", new Object[0]));
            this.D = as.createSubHeader(bA.this.controller, bA.this.controller.getMessage("Automatically create channels for:", new Object[0]));
            this.setWidth("1297px");
            this.setHeight("825px");
            this.e = new VerticalLayout();
            this.e.setSizeFull();
            this.innerContent.add(new Component[]{this.D});
            this.A.setEnabled(false);
            this.B.setEnabled(false);
            this.C.setVisible(false);
            this.A.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
            this.C.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
            this.A.addClickListener((ComponentEventListener & Serializable)event -> {
                if (this.f == 0) {
                    this.b();
                    this.A.setEnabled(this.m != null);
                    this.B.setEnabled(true);
                } else if (this.f == 1) {
                    this.c();
                    this.A.setVisible(false);
                    this.C.setVisible(true);
                }
                ++this.f;
            });
            this.B.addClickListener((ComponentEventListener & Serializable)event -> {
                if (this.f == 1) {
                    this.a();
                    this.A.setEnabled(true);
                    this.B.setEnabled(false);
                } else if (this.f == 2) {
                    this.b();
                    this.A.setVisible(true);
                    this.A.setEnabled(this.m != null);
                    this.C.setVisible(false);
                }
                --this.f;
            });
            this.C.addClickListener((ComponentEventListener & Serializable)event -> {
                ITableGroupService tableGroupService = bA.this.controller.getTableGroupService();
                TableGroup group = new TableGroup();
                group.setId(this.g.getValue());
                group.setNodeGroupLink((NodeGroupLink)this.h.getValue());
                group.setWriterType((TableGroup.WriterType)((Object)((Object)((Object)this.i.getValue()))));
                tableGroupService.saveTableGroup(group);
                for (Set<TableGroupHier> hierSet : this.r.values()) {
                    for (TableGroupHier hier : hierSet) {
                        tableGroupService.saveTableGroupHier(hier);
                    }
                }
                bA.this.fillGrid((Grid<TableGroupHier>)bA.this.grid);
                bA.this.updateDisplaySpan();
                this.close();
            });
            Button cancelButton = new Button(bA.this.controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)event -> this.close());
            cancelButton.addClickListener((ComponentEventListener & Serializable)event -> this.close());
            this.innerContent.add(new Component[]{this.e});
            this.innerContent.expand(new Component[]{this.e});
            this.buildButtonFooter(new Component[]{cancelButton, this.B, this.A, this.C});
            this.a();
        }

        private void a() {
            this.e.removeAll();
            this.D.setText(bA.this.controller.getMessage("Create a table group", new Object[0]));
            if (this.g == null) {
                this.g = new TextField();
                this.g.setLabel(bA.this.controller.getMessage("Table Group Id", new Object[0]));
                this.g.setWidth("24em");
                this.g.setValueChangeMode(ValueChangeMode.LAZY);
                this.g.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.A.setEnabled(StringUtils.isNotBlank((CharSequence)((CharSequence)event.getValue()))));
            }
            this.e.add(new Component[]{this.g});
            this.g.focus();
            if (this.h == null) {
                ISymmetricEngine engine = bA.this.controller.getSymmetricEngine();
                List groupLinks = engine.getConfigurationService().getNodeGroupLinksFor(engine.getParameterService().getNodeGroupId(), false);
                if (groupLinks.isEmpty()) {
                    this.A.getElement().setAttribute("title", bA.this.controller.getMessage("No group links were found", new Object[0]));
                    Span errorSpan = as.getErrorSpan();
                    errorSpan.setText(bA.this.controller.getMessage("No group links were found", new Object[0]));
                    this.e.removeAll();
                    this.e.add(new Component[]{errorSpan});
                    return;
                }
                this.h = new Select();
                this.h.setItems((Collection)groupLinks);
                this.h.setLabel(bA.this.controller.getMessage("Group Link", new Object[0]));
                this.h.setWidth("24em");
                this.h.setValue(!groupLinks.isEmpty() ? (NodeGroupLink)groupLinks.get(0) : null);
                this.e.add(new Component[]{this.h});
            } else {
                this.e.add(new Component[]{this.h});
            }
            if (this.i == null) {
                this.i = new RadioButtonGroup();
                this.i.setLabel(bA.this.controller.getMessage("Writer Type", new Object[0]));
                this.i.setItems((Object[])TableGroup.WriterType.values());
                this.i.setRenderer(new ComponentRenderer((SerializableFunction & Serializable)item -> {
                    if (item.equals((Object)TableGroup.WriterType.DEFAULT)) {
                        return new Span(WordUtils.capitalizeFully((String)TableGroup.WriterType.DEFAULT.toString()));
                    }
                    if (item.equals((Object)TableGroup.WriterType.JSON)) {
                        return new Span(TableGroup.WriterType.JSON.toString());
                    }
                    if (item.equals((Object)TableGroup.WriterType.ASSIGNMENT)) {
                        return new Span(TableGroup.WriterType.ASSIGNMENT.toString());
                    }
                    return new Span();
                }));
                this.i.addThemeVariants((ThemeVariant[])new RadioGroupVariant[]{RadioGroupVariant.LUMO_VERTICAL});
                this.i.setValue((Object)TableGroup.WriterType.DEFAULT);
            }
            this.e.add(new Component[]{this.i});
        }

        private void b() {
            this.e.removeAll();
            this.D.setText(bA.this.controller.getMessage("Choose the root table", new Object[0]));
            if (this.l == null || !this.l.equals(this.h.getValue())) {
                ISymmetricEngine symmetricEngine = bA.this.controller.getSymmetricEngine();
                ITriggerRouterService triggerRouterService = symmetricEngine.getTriggerRouterService();
                boolean ignoreCase = bA.this.controller.getSymmetricEngine().getParameterService().is("db.metadata.ignore.case");
                Set symTables = TableConstants.getTables((String)bA.this.controller.getSymmetricEngine().getParameterService().getTablePrefix());
                ArrayList histories = new ArrayList(triggerRouterService.getActiveTriggerHistories());
                Iterator iter = histories.iterator();
                block0: while (iter.hasNext()) {
                    TriggerHistory hist = (TriggerHistory)iter.next();
                    for (String symTable : symTables) {
                        if (!hist.getSourceTableName().equals(symTable) && (!ignoreCase || !hist.getSourceTableName().equalsIgnoreCase(symTable))) continue;
                        iter.remove();
                        continue block0;
                    }
                }
                String sourceNodeGroup = ((NodeGroupLink)this.h.getValue()).getSourceNodeGroupId();
                String targetNodeGroup = ((NodeGroupLink)this.h.getValue()).getTargetNodeGroupId();
                this.k = new HashSet<TableSelect>();
                for (TriggerRouter triggerRouter : bA.this.controller.getSymmetricEngine().getTriggerRouterService().getTriggerRouters(false)) {
                    NodeGroupLink groupLink = triggerRouter.getRouter().getNodeGroupLink();
                    if (!groupLink.getSourceNodeGroupId().equals(sourceNodeGroup) || !groupLink.getTargetNodeGroupId().equals(targetNodeGroup) || triggerRouter.getInitialLoadOrder() < 0) continue;
                    Trigger trigger = triggerRouter.getTrigger();
                    if (triggerRouter.getTrigger().isSourceWildCarded()) {
                        for (TriggerHistory hist : histories) {
                            if (!hist.getTriggerId().equals(trigger.getTriggerId())) continue;
                            this.k.add(new TableSelect(hist));
                        }
                        continue;
                    }
                    this.k.add(new TableSelect(triggerRouter));
                }
            }
            this.l = (NodeGroupLink)this.h.getValue();
            this.j = new Grid();
            this.j.setSelectionMode(Grid.SelectionMode.SINGLE);
            HeaderRow filterRow = this.j.appendHeaderRow();
            HeaderRow headerRow = this.j.prependHeaderRow();
            if (this.k.stream().anyMatch(table -> StringUtils.isNotBlank((CharSequence)table.getSourceCatalogName()))) {
                this.j.addColumn((ValueProvider & Serializable)table -> table.getSourceCatalogName()).setKey("sourceCatalogName");
                this.n = this.a(true);
                ((HeaderRow.HeaderCell)filterRow.getCell(this.j.getColumnByKey("sourceCatalogName"))).setComponent((Component)this.n);
                ((HeaderRow.HeaderCell)headerRow.getCell(this.j.getColumnByKey("sourceCatalogName"))).setText(bA.this.controller.getMessage("Source Catalog", new Object[0]));
            }
            if (this.k.stream().anyMatch(table -> StringUtils.isNotBlank((CharSequence)table.getSourceSchemaName()))) {
                this.j.addColumn((ValueProvider & Serializable)table -> table.getSourceSchemaName()).setKey("sourceSchemaName");
                this.o = this.a(true);
                ((HeaderRow.HeaderCell)filterRow.getCell(this.j.getColumnByKey("sourceSchemaName"))).setComponent((Component)this.o);
                ((HeaderRow.HeaderCell)headerRow.getCell(this.j.getColumnByKey("sourceSchemaName"))).setText(bA.this.controller.getMessage("Source Schema", new Object[0]));
            }
            this.j.addColumn((ValueProvider & Serializable)select -> select.getSourceTableName()).setComparator((t0, t1) -> t0.getSourceTableName().compareToIgnoreCase(t1.getSourceTableName())).setKey("sourceTableName");
            this.p = this.a(true);
            ((HeaderRow.HeaderCell)filterRow.getCell(this.j.getColumnByKey("sourceTableName"))).setComponent((Component)this.p);
            ((HeaderRow.HeaderCell)headerRow.getCell(this.j.getColumnByKey("sourceTableName"))).setText(bA.this.controller.getMessage("Source Table", new Object[0]));
            this.j.addSelectionListener((SelectionListener & Serializable)event -> {
                if (event.isFromClient()) {
                    this.m = event.getFirstSelectedItem().orElse(null);
                }
                this.A.setEnabled(this.m != null);
            });
            for (Grid.Column column : this.j.getColumns()) {
                column.setResizable(true);
            }
            ArrayList<GridSortOrder> sortOrderList = new ArrayList<GridSortOrder>();
            sortOrderList.add(new GridSortOrder(this.j.getColumnByKey("sourceTableName"), SortDirection.ASCENDING));
            this.j.sort(sortOrderList);
            this.j.setItems(this.k);
            this.j.select((Object)this.m);
            this.e.add(new Component[]{this.j});
        }

        private void c() {
            this.e.removeAll();
            this.D.setText(bA.this.controller.getMessage("Choose the child tables to include in the group", new Object[0]));
            this.c = bA.this.controller.getSymmetricEngine().getParameterService().getInt("console.auto.create.table.group.hiers.depth.limit");
            this.d = bA.this.controller.getSymmetricEngine().getParameterService().getInt("console.auto.create.table.group.hiers.table.limit");
            this.u = new HashSet<TableGroupHier>();
            this.z = new Button(bA.this.controller.getMessage("Show More", new Object[0]), (ComponentEventListener & Serializable)event -> {
                this.z.setEnabled(false);
                this.c += 2;
                this.d += 10;
                this.e();
                this.f();
            });
            this.z.setEnabled(false);
            Button restoreButton = new Button(bA.this.controller.getMessage("Restore Removed Tables", new Object[0]), (ComponentEventListener & Serializable)event -> {
                for (TableGroupHier hier : this.u) {
                    Set<TableGroupHier> hierSet = this.r.get(hier.getTable().getFullyQualifiedTableNameLowerCase());
                    if (hierSet == null) {
                        hierSet = new HashSet<TableGroupHier>();
                    }
                    hierSet.add(hier);
                    this.r.put(hier.getTable().getFullyQualifiedTableNameLowerCase(), hierSet);
                }
                this.u.clear();
                ((Button)event.getSource()).setEnabled(false);
                this.f();
            });
            restoreButton.getStyle().set("margin-right", "4px");
            restoreButton.setEnabled(false);
            Button removeButton = new Button(bA.this.controller.getMessage("Remove", new Object[0]), (ComponentEventListener & Serializable)event -> {
                for (TableGroupHier hier : this.t) {
                    this.b(hier);
                }
                this.t.clear();
                ((Button)event.getSource()).setEnabled(false);
                restoreButton.setEnabled(true);
                this.f();
            });
            removeButton.getStyle().set("margin-left", "4px");
            removeButton.setEnabled(false);
            ColumnVisibilityToggler columnVisibilityToggler = new ColumnVisibilityToggler();
            HorizontalLayout upperLayout = new HorizontalLayout(new Component[]{this.z, restoreButton, bA.this.buildSeperater(), removeButton});
            upperLayout.addAndExpand(new Component[]{new Span()});
            upperLayout.add(new Component[]{columnVisibilityToggler});
            this.q = new Grid();
            this.q.setSelectionMode(Grid.SelectionMode.MULTI);
            this.t = new HashSet<TableGroupHier>();
            this.q.addItemClickListener((ComponentEventListener & Serializable)event -> {
                if (event.getColumn() != null) {
                    this.t.removeAll(this.q.getSelectedItems());
                    this.q.deselectAll();
                    this.q.select((Object)((TableGroupHier)event.getItem()));
                    this.t.add((TableGroupHier)event.getItem());
                    removeButton.setEnabled(true);
                }
            });
            ((GridMultiSelectionModel)this.q.getSelectionModel()).addMultiSelectionListener((MultiSelectionListener & Serializable)event -> {
                if (event.isFromClient()) {
                    this.t.addAll(event.getAddedSelection());
                    this.t.removeAll(event.getRemovedSelection());
                    removeButton.setEnabled(!this.t.isEmpty());
                }
            });
            HeaderRow filterRow = this.q.appendHeaderRow();
            HeaderRow headerRow = this.q.prependHeaderRow();
            columnVisibilityToggler.addColumn(this.q.addColumn((ValueProvider & Serializable)hier -> hier.getId()).setKey("id"), bA.this.controller.getMessage("Table Group Hierarchy Id", new Object[0]));
            this.v = this.a(false);
            ((HeaderRow.HeaderCell)filterRow.getCell(this.q.getColumnByKey("id"))).setComponent((Component)this.v);
            ((HeaderRow.HeaderCell)headerRow.getCell(this.q.getColumnByKey("id"))).setText(bA.this.controller.getMessage("Table Group Hierarchy Id", new Object[0]));
            columnVisibilityToggler.addColumn(this.q.addColumn((ValueProvider & Serializable)hier -> hier.getSourceCatalogName()).setKey("catalog"), bA.this.controller.getMessage("Source Catalog", new Object[0]));
            this.w = this.a(false);
            ((HeaderRow.HeaderCell)filterRow.getCell(this.q.getColumnByKey("catalog"))).setComponent((Component)this.w);
            ((HeaderRow.HeaderCell)headerRow.getCell(this.q.getColumnByKey("catalog"))).setText(bA.this.controller.getMessage("Source Catalog", new Object[0]));
            columnVisibilityToggler.addColumn(this.q.addColumn((ValueProvider & Serializable)hier -> hier.getSourceSchemaName()).setKey("schema"), bA.this.controller.getMessage("Source Schema", new Object[0]));
            this.x = this.a(false);
            ((HeaderRow.HeaderCell)filterRow.getCell(this.q.getColumnByKey("schema"))).setComponent((Component)this.x);
            ((HeaderRow.HeaderCell)headerRow.getCell(this.q.getColumnByKey("schema"))).setText(bA.this.controller.getMessage("Source Schema", new Object[0]));
            columnVisibilityToggler.addColumn(this.q.addColumn((ValueProvider & Serializable)hier -> hier.getSourceTableName()).setKey("table").setComparator((h0, h1) -> h0.getSourceTableName().compareToIgnoreCase(h1.getSourceTableName())), bA.this.controller.getMessage("Source Table", new Object[0]));
            this.y = this.a(false);
            ((HeaderRow.HeaderCell)filterRow.getCell(this.q.getColumnByKey("table"))).setComponent((Component)this.y);
            ((HeaderRow.HeaderCell)headerRow.getCell(this.q.getColumnByKey("table"))).setText(bA.this.controller.getMessage("Source Table", new Object[0]));
            columnVisibilityToggler.addColumn(this.q.addColumn((ValueProvider & Serializable)hier -> hier.getPrimaryColumnNames()).setKey("primaryColumnNames"), bA.this.controller.getMessage("Primary Column Names", new Object[0])).setVisible(false);
            ((HeaderRow.HeaderCell)headerRow.getCell(this.q.getColumnByKey("primaryColumnNames"))).setText(bA.this.controller.getMessage("Primary Column Names", new Object[0]));
            columnVisibilityToggler.addColumn(this.q.addColumn((ValueProvider & Serializable)hier -> hier.getLocalColumnNames()).setKey("localColumnNames"), bA.this.controller.getMessage("Local Column Names", new Object[0])).setVisible(false);
            ((HeaderRow.HeaderCell)headerRow.getCell(this.q.getColumnByKey("localColumnNames"))).setText(bA.this.controller.getMessage("Local Column Names", new Object[0]));
            columnVisibilityToggler.addColumn(this.q.addColumn((ValueProvider & Serializable)hier -> hier.getParentColumnNames()).setKey("parentColumnNames"), bA.this.controller.getMessage("Parent Column Names", new Object[0])).setVisible(false);
            ((HeaderRow.HeaderCell)headerRow.getCell(this.q.getColumnByKey("parentColumnNames"))).setText(bA.this.controller.getMessage("Parent Column Names", new Object[0]));
            columnVisibilityToggler.addColumn(this.q.addColumn((ValueProvider & Serializable)hier -> hier.getParentId()).setKey("parentId"), bA.this.controller.getMessage("Parent Id", new Object[0])).setVisible(false);
            ((HeaderRow.HeaderCell)headerRow.getCell(this.q.getColumnByKey("parentId"))).setText(bA.this.controller.getMessage("Parent Id", new Object[0]));
            for (Grid.Column column : this.q.getColumns()) {
                column.setResizable(true);
            }
            ArrayList<GridSortOrder> sortOrderList = new ArrayList<GridSortOrder>();
            sortOrderList.add(new GridSortOrder(this.q.getColumnByKey("table"), SortDirection.ASCENDING));
            this.q.sort(sortOrderList);
            if (!((TableGroup.WriterType)((Object)this.i.getValue())).equals((Object)TableGroup.WriterType.DEFAULT)) {
                Binder binder = new Binder();
                this.q.getEditor().setBinder(binder);
                Select relationType = new Select();
                relationType.setItems((Object[])TableGroupHier.RelationType.values());
                binder.forField((HasValue)relationType).bind(TableGroupHier::getRelationType, TableGroupHier::setRelationType);
                columnVisibilityToggler.addColumn(this.q.addColumn((ValueProvider & Serializable)hier -> hier.getRelationType()).setEditorComponent((Component)relationType).setKey("relationType"), bA.this.controller.getMessage("Relation Type", new Object[0]));
                ((HeaderRow.HeaderCell)headerRow.getCell(this.q.getColumnByKey("relationType"))).setText(bA.this.controller.getMessage("Relation Type", new Object[0]));
                CommonUiUtils.configureEditor(this.q);
            }
            this.e();
            this.e.add(new Component[]{new Span(bA.this.controller.getMessage("The below tables will be included in the table group. Configure their relation types and remove any tables that you want to exclude.", new Object[0]))});
            this.e.add(new Component[]{upperLayout});
            this.e.addAndExpand(new Component[]{this.q});
        }

        private void d() {
            ArrayList<TableSelect> filteredList = new ArrayList<TableSelect>();
            for (TableSelect select : this.k) {
                if (this.a(select)) continue;
                filteredList.add(select);
            }
            this.j.setItems(filteredList);
            if (this.k.contains(this.m)) {
                this.j.select((Object)this.m);
            }
        }

        private boolean a(TableSelect table) {
            boolean validCatalog = this.n == null || !CommonUiUtils.isFilteredOut((String)table.getSourceCatalogName(), (String)this.n.getValue());
            boolean validSchema = this.o == null || !CommonUiUtils.isFilteredOut((String)table.getSourceSchemaName(), (String)this.o.getValue());
            boolean validTable = !CommonUiUtils.isFilteredOut((String)table.getSourceTableName(), (String)this.p.getValue());
            return !validCatalog || !validSchema || !validTable;
        }

        private void e() {
            Set<TableGroupHier> hierSet3;
            this.r = new HashMap<String, Set<TableGroupHier>>();
            Iterator rootHier = null;
            for (TableSelect item : this.k) {
                Iterator hier = new TableGroupHier();
                ((TableGroupHier)((Object)hier)).setId(item.getSourceTableName());
                ((TableGroupHier)((Object)hier)).setTableGroupId(this.g.getValue());
                ((TableGroupHier)((Object)hier)).setSourceTableName(item.getSourceTableName());
                ((TableGroupHier)((Object)hier)).setSourceSchemaName(item.getSourceSchemaName());
                ((TableGroupHier)((Object)hier)).setSourceCatalogName(item.getSourceCatalogName());
                if (!((TableGroup.WriterType)((Object)this.i.getValue())).equals((Object)TableGroup.WriterType.DEFAULT)) {
                    ((TableGroupHier)((Object)hier)).setRelationType(TableGroupHier.RelationType.ARRAY);
                }
                Table table = bA.this.controller.getSymmetricEngine().getTargetDialect().getTargetPlatform().getTableFromCache(item.getSourceCatalogName(), item.getSourceSchemaName(), item.getSourceTableName(), false);
                ((TableGroupHier)((Object)hier)).setPrimaryColumnNames(String.join((CharSequence)",", table.getPrimaryKeyColumnNames()));
                ((TableGroupHier)((Object)hier)).setTable(table);
                hierSet3 = new HashSet<TableGroupHier>();
                hierSet3.add((TableGroupHier)((Object)hier));
                this.r.put(table.getFullyQualifiedTableNameLowerCase(), hierSet3);
                if (!item.equals(this.m)) continue;
                rootHier = hier;
            }
            if (rootHier != null) {
                this.s = 1;
                HashMap<TableGroupHier, TableGroupHier> childParentMap = new HashMap<TableGroupHier, TableGroupHier>();
                childParentMap.put((TableGroupHier)((Object)rootHier), (TableGroupHier)null);
                this.a(this.r, childParentMap, 1);
                HashSet<TableGroupHier> hiersToRemove = new HashSet<TableGroupHier>();
                for (String key : this.r.keySet()) {
                    hierSet3 = this.r.get(key);
                    for (TableGroupHier hier : hierSet3) {
                        if (hier == null || hier.equals(rootHier) || hier.getParentId() != null) continue;
                        hiersToRemove.add(hier);
                    }
                }
                for (TableGroupHier hier : hiersToRemove) {
                    String tableName = hier.getTable().getFullyQualifiedTableNameLowerCase();
                    Set<TableGroupHier> hierSet2 = this.r.get(tableName);
                    if (hierSet2 == null || hierSet2.size() == 1) {
                        this.r.remove(tableName);
                        continue;
                    }
                    hierSet2.remove(hier);
                    this.r.put(tableName, hierSet2);
                }
                HashSet<TableGroupHier> allHiers = new HashSet<TableGroupHier>();
                for (Set<TableGroupHier> hierSet3 : this.r.values()) {
                    allHiers.addAll(hierSet3);
                }
                this.q.setItems(allHiers);
            }
        }

        private void f() {
            ArrayList<TableGroupHier> filteredList = new ArrayList<TableGroupHier>();
            for (Set<TableGroupHier> hierSet : this.r.values()) {
                for (TableGroupHier tableGroupHier : hierSet) {
                    if (this.a(tableGroupHier)) continue;
                    filteredList.add(tableGroupHier);
                }
            }
            this.q.setItems(filteredList);
            for (TableGroupHier hier : this.t) {
                for (Set set : this.r.values()) {
                    if (!set.contains(hier)) continue;
                    this.q.select((Object)hier);
                }
            }
        }

        private boolean a(TableGroupHier hier) {
            boolean validId = this.v == null || !CommonUiUtils.isFilteredOut((String)hier.getId(), (String)this.v.getValue());
            boolean validCatalog = this.w == null || !CommonUiUtils.isFilteredOut((String)hier.getSourceCatalogName(), (String)this.w.getValue());
            boolean validSchema = this.x == null || !CommonUiUtils.isFilteredOut((String)hier.getSourceSchemaName(), (String)this.x.getValue());
            boolean validTable = !CommonUiUtils.isFilteredOut((String)hier.getSourceTableName(), (String)this.y.getValue());
            return !validId || !validCatalog || !validSchema || !validTable;
        }

        private void b(TableGroupHier hier) {
            String tableName = hier.getTable().getFullyQualifiedTableNameLowerCase();
            Set<TableGroupHier> hierSet = this.r.get(tableName);
            if (hierSet == null || hierSet.size() == 1) {
                this.r.remove(tableName);
            } else {
                hierSet.remove(hier);
                this.r.put(tableName, hierSet);
            }
            HashSet<TableGroupHier> hiersToRemove = new HashSet<TableGroupHier>();
            HashSet<TableGroupHier> allHiers = new HashSet<TableGroupHier>();
            for (Set<TableGroupHier> otherHierSet : this.r.values()) {
                allHiers.addAll(otherHierSet);
            }
            for (TableGroupHier otherHier : allHiers) {
                if (!hier.getId().equals(otherHier.getParentId())) continue;
                hiersToRemove.add(otherHier);
            }
            for (TableGroupHier hierToRemove : hiersToRemove) {
                this.b(hierToRemove);
            }
            this.u.add(hier);
        }

        private TextField a(boolean isRootTableGrid) {
            TextField filter = new TextField();
            filter.addThemeVariants((ThemeVariant[])new TextFieldVariant[]{TextFieldVariant.LUMO_SMALL});
            filter.setWidthFull();
            if (isRootTableGrid) {
                filter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.d());
            } else {
                filter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.f());
            }
            filter.setValueChangeMode(ValueChangeMode.LAZY);
            return filter;
        }

        private void a(Map<String, Set<TableGroupHier>> hierTableMap, Map<TableGroupHier, TableGroupHier> childParentMap, int depth) {
            if (depth >= this.c || this.s >= this.d) {
                this.z.setEnabled(true);
                return;
            }
            HashMap<TableGroupHier, TableGroupHier> newChildParentMap = new HashMap<TableGroupHier, TableGroupHier>();
            for (TableGroupHier currentHier : childParentMap.keySet()) {
                TableGroupHier newHier;
                Gson gson;
                TableGroupHier parentHier = childParentMap.get(currentHier);
                Set<TableGroupHier> existingHiers = hierTableMap.get(currentHier.getTable().getFullyQualifiedTableNameLowerCase());
                for (ForeignKey fk2 : currentHier.getTable().getForeignKeys()) {
                    ForeignKey[] foreignTable = fk2.getForeignTable();
                    if (foreignTable == null) {
                        foreignTable = bA.this.controller.getSymmetricEngine().getTargetDialect().getTargetPlatform().getTableFromCache(fk2.getForeignTableCatalog(), fk2.getForeignTableSchema(), fk2.getForeignTableName(), false);
                    }
                    Set<TableGroupHier> hierSet = hierTableMap.get(foreignTable.getFullyQualifiedTableNameLowerCase());
                    HashSet<TableGroupHier> newHierSet = new HashSet<TableGroupHier>();
                    for (TableGroupHier hier : hierSet) {
                        if (hier == null || hier.equals(parentHier) || existingHiers != null && !existingHiers.stream().noneMatch(h2 -> hier.getId().equals(h2.getParentId()))) continue;
                        if (hier.getParentId() == null) {
                            this.a(hier, currentHier, fk2, true);
                            ++this.s;
                            if (this.s >= this.d) {
                                this.z.setEnabled(true);
                                return;
                            }
                            newChildParentMap.put(hier, currentHier);
                            continue;
                        }
                        gson = new Gson();
                        newHier = (TableGroupHier)gson.fromJson(gson.toJson((Object)hier), TableGroupHier.class);
                        newHier.setTable(hier.getTable());
                        this.a(newHier, currentHier, fk2, true);
                        newHierSet.add(newHier);
                    }
                    hierSet.addAll(newHierSet);
                    hierTableMap.put(foreignTable.getFullyQualifiedTableNameLowerCase(), hierSet);
                }
                HashSet<TableGroupHier> allHiers = new HashSet<TableGroupHier>();
                for (Set<TableGroupHier> hierSet : hierTableMap.values()) {
                    allHiers.addAll(hierSet);
                }
                HashSet<TableGroupHier> newHierSet = new HashSet<TableGroupHier>();
                block4: for (TableGroupHier hier : allHiers) {
                    if (hier == null || hier.equals(currentHier) || hier.equals(parentHier) || existingHiers != null && !existingHiers.stream().noneMatch(h2 -> hier.getId().equals(h2.getParentId())) || hier.getParentId() != null && hier.getParentId().equals(currentHier.getId())) continue;
                    for (ForeignKey fk3 : hier.getTable().getForeignKeys()) {
                        Table foreignTable = fk3.getForeignTable();
                        if (foreignTable == null) {
                            foreignTable = bA.this.controller.getSymmetricEngine().getTargetDialect().getTargetPlatform().getTableFromCache(fk3.getForeignTableCatalog(), fk3.getForeignTableSchema(), fk3.getForeignTableName(), false);
                        }
                        if (!foreignTable.getFullyQualifiedTableNameLowerCase().equals(currentHier.getTable().getFullyQualifiedTableNameLowerCase())) continue;
                        if (hier.getParentId() == null) {
                            this.a(hier, currentHier, fk3, false);
                            ++this.s;
                            if (this.s >= this.d) {
                                this.z.setEnabled(true);
                                return;
                            }
                            newChildParentMap.put(hier, currentHier);
                            continue block4;
                        }
                        gson = new Gson();
                        newHier = (TableGroupHier)gson.fromJson(gson.toJson((Object)hier), TableGroupHier.class);
                        newHier.setTable(hier.getTable());
                        this.a(newHier, currentHier, fk3, false);
                        newHierSet.add(newHier);
                        continue block4;
                    }
                }
                for (TableGroupHier newHier2 : newHierSet) {
                    String tableName = newHier2.getTable().getFullyQualifiedTableNameLowerCase();
                    Set<TableGroupHier> hierSet = hierTableMap.get(tableName);
                    hierSet.add(newHier2);
                    hierTableMap.put(tableName, hierSet);
                }
            }
            if (!newChildParentMap.isEmpty()) {
                this.a(hierTableMap, newChildParentMap, depth + 1);
            }
        }

        private void a(TableGroupHier childHier, TableGroupHier currentHier, ForeignKey fk2, boolean fkReferencesChild) {
            childHier.setId(currentHier.getSourceTableName() + "_" + childHier.getSourceTableName());
            childHier.setParentId(currentHier.getId());
            Object localColumnNames = "";
            Object parentColumnNames = "";
            for (Reference reference : fk2.getReferences()) {
                if (!((String)localColumnNames).isEmpty()) {
                    localColumnNames = (String)localColumnNames + ",";
                    parentColumnNames = (String)parentColumnNames + ",";
                }
                if (fkReferencesChild) {
                    localColumnNames = (String)localColumnNames + reference.getForeignColumnName();
                    parentColumnNames = (String)parentColumnNames + reference.getLocalColumnName();
                    continue;
                }
                localColumnNames = (String)localColumnNames + reference.getLocalColumnName();
                parentColumnNames = (String)parentColumnNames + reference.getForeignColumnName();
            }
            childHier.setLocalColumnNames((String)localColumnNames);
            childHier.setParentColumnNames((String)parentColumnNames);
        }

        private static /* synthetic */ Object a(SerializedLambda lambda) {
            switch (lambda.getImplMethodName()) {
                case "lambda$buildThirdScreen$e445ab8f$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/button/Button;Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                    return arg_0 -> ((a)((Object)lambda.getCapturedArg(0))).a((Button)lambda.getCapturedArg(1), arg_0);
                }
                case "lambda$createFilterField$2d9abd85$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                    return (HasValue.ValueChangeListener & Serializable)event -> this.d();
                }
                case "lambda$createFilterField$2d9abd85$2": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                    return (HasValue.ValueChangeListener & Serializable)event -> this.f();
                }
                case "getRelationType": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/model/TableGroupHier") || !lambda.getImplMethodSignature().equals("()Lcom/jumpmind/symmetric/console/model/TableGroupHier$RelationType;")) break;
                    return TableGroupHier::getRelationType;
                }
                case "lambda$new$9b1b5227$4": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                    return (ComponentEventListener & Serializable)event -> this.close();
                }
                case "lambda$new$9b1b5227$3": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                    return (ComponentEventListener & Serializable)event -> {
                        ITableGroupService tableGroupService = bA.this.controller.getTableGroupService();
                        TableGroup group = new TableGroup();
                        group.setId(this.g.getValue());
                        group.setNodeGroupLink((NodeGroupLink)this.h.getValue());
                        group.setWriterType((TableGroup.WriterType)((Object)((Object)((Object)this.i.getValue()))));
                        tableGroupService.saveTableGroup(group);
                        for (Set<TableGroupHier> hierSet : this.r.values()) {
                            for (TableGroupHier hier : hierSet) {
                                tableGroupService.saveTableGroupHier(hier);
                            }
                        }
                        bA.this.fillGrid((Grid<TableGroupHier>)bA.this.grid);
                        bA.this.updateDisplaySpan();
                        this.close();
                    };
                }
                case "setRelationType": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/data/binder/Setter") || !lambda.getFunctionalInterfaceMethodName().equals("accept") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;Ljava/lang/Object;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/model/TableGroupHier") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/TableGroupHier$RelationType;)V")) break;
                    return TableGroupHier::setRelationType;
                }
                case "lambda$new$9b1b5227$2": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                    return (ComponentEventListener & Serializable)event -> {
                        if (this.f == 1) {
                            this.a();
                            this.A.setEnabled(true);
                            this.B.setEnabled(false);
                        } else if (this.f == 2) {
                            this.b();
                            this.A.setVisible(true);
                            this.A.setEnabled(this.m != null);
                            this.C.setVisible(false);
                        }
                        --this.f;
                    };
                }
                case "lambda$new$9b1b5227$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                    return (ComponentEventListener & Serializable)event -> {
                        if (this.f == 0) {
                            this.b();
                            this.A.setEnabled(this.m != null);
                            this.B.setEnabled(true);
                        } else if (this.f == 1) {
                            this.c();
                            this.A.setVisible(false);
                            this.C.setVisible(true);
                        }
                        ++this.f;
                    };
                }
                case "lambda$buildThirdScreen$b86523c9$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/data/selection/MultiSelectionListener") || !lambda.getFunctionalInterfaceMethodName().equals("selectionChange") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/data/selection/MultiSelectionEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/button/Button;Lcom/vaadin/flow/data/selection/MultiSelectionEvent;)V")) break;
                    return arg_0 -> ((a)((Object)lambda.getCapturedArg(0))).a((Button)lambda.getCapturedArg(1), arg_0);
                }
                case "lambda$buildFirstScreen$3fab9f70$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                    return (HasValue.ValueChangeListener & Serializable)event -> this.A.setEnabled(StringUtils.isNotBlank((CharSequence)((CharSequence)event.getValue())));
                }
                case "lambda$buildThirdScreen$9b1b5227$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                    return (ComponentEventListener & Serializable)event -> {
                        this.z.setEnabled(false);
                        this.c += 2;
                        this.d += 10;
                        this.e();
                        this.f();
                    };
                }
                case "lambda$buildThirdScreen$82f82ac4$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                    return (ComponentEventListener & Serializable)event -> {
                        for (TableGroupHier hier : this.u) {
                            Set<TableGroupHier> hierSet = this.r.get(hier.getTable().getFullyQualifiedTableNameLowerCase());
                            if (hierSet == null) {
                                hierSet = new HashSet<TableGroupHier>();
                            }
                            hierSet.add(hier);
                            this.r.put(hier.getTable().getFullyQualifiedTableNameLowerCase(), hierSet);
                        }
                        this.u.clear();
                        ((Button)event.getSource()).setEnabled(false);
                        this.f();
                    };
                }
                case "lambda$buildThirdScreen$ba6e7b7d$7": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/TableGroupHier;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)hier -> hier.getParentColumnNames();
                }
                case "lambda$buildThirdScreen$ba6e7b7d$6": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/TableGroupHier;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)hier -> hier.getLocalColumnNames();
                }
                case "lambda$buildThirdScreen$ba6e7b7d$5": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/TableGroupHier;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)hier -> hier.getPrimaryColumnNames();
                }
                case "lambda$buildThirdScreen$ba6e7b7d$4": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/TableGroupHier;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)hier -> hier.getSourceTableName();
                }
                case "lambda$buildSecondScreen$ba6e7b7d$3": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/TableSelect;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)select -> select.getSourceTableName();
                }
                case "lambda$buildThirdScreen$ba6e7b7d$9": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/TableGroupHier;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)hier -> hier.getRelationType();
                }
                case "lambda$buildThirdScreen$ba6e7b7d$8": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/TableGroupHier;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)hier -> hier.getParentId();
                }
                case "lambda$buildSecondScreen$ba6e7b7d$1": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/TableSelect;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)table -> table.getSourceCatalogName();
                }
                case "lambda$buildSecondScreen$ba6e7b7d$2": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/TableSelect;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)table -> table.getSourceSchemaName();
                }
                case "lambda$buildFirstScreen$3fed5817$1": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializableFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/TableGroup$WriterType;)Lcom/vaadin/flow/component/html/Span;")) break;
                    return (SerializableFunction & Serializable)item -> {
                        if (item.equals((Object)TableGroup.WriterType.DEFAULT)) {
                            return new Span(WordUtils.capitalizeFully((String)TableGroup.WriterType.DEFAULT.toString()));
                        }
                        if (item.equals((Object)TableGroup.WriterType.JSON)) {
                            return new Span(TableGroup.WriterType.JSON.toString());
                        }
                        if (item.equals((Object)TableGroup.WriterType.ASSIGNMENT)) {
                            return new Span(TableGroup.WriterType.ASSIGNMENT.toString());
                        }
                        return new Span();
                    };
                }
                case "lambda$buildThirdScreen$ba6e7b7d$3": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/TableGroupHier;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)hier -> hier.getSourceSchemaName();
                }
                case "lambda$buildThirdScreen$ba6e7b7d$2": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/TableGroupHier;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)hier -> hier.getSourceCatalogName();
                }
                case "lambda$buildThirdScreen$ba6e7b7d$1": {
                    if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/TableGroupHier;)Ljava/lang/Object;")) break;
                    return (ValueProvider & Serializable)hier -> hier.getId();
                }
                case "lambda$buildThirdScreen$5ab91c4c$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/button/Button;Lcom/vaadin/flow/component/grid/ItemClickEvent;)V")) break;
                    return arg_0 -> ((a)((Object)lambda.getCapturedArg(0))).a((Button)lambda.getCapturedArg(1), arg_0);
                }
                case "lambda$new$596470aa$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                    return (ComponentEventListener & Serializable)event -> this.close();
                }
                case "lambda$buildSecondScreen$bfb64eaf$1": {
                    if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/data/selection/SelectionListener") || !lambda.getFunctionalInterfaceMethodName().equals("selectionChange") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/data/selection/SelectionEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/TableGroupHierEditPanel$TableGroupHierAutoCreateDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/data/selection/SelectionEvent;)V")) break;
                    return (SelectionListener & Serializable)event -> {
                        if (event.isFromClient()) {
                            this.m = event.getFirstSelectedItem().orElse(null);
                        }
                        this.A.setEnabled(this.m != null);
                    };
                }
            }
            throw new IllegalArgumentException("Invalid lambda deserialization");
        }
    }
}

