/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.ui.common.I;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.confirmdialog.ConfirmDialog;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.StringToIntegerConverter;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.symmetric.io.data.transform.ColumnPolicy;
import org.jumpmind.symmetric.io.data.transform.TargetDmlAction;
import org.jumpmind.symmetric.io.data.transform.TransformPoint;
import org.jumpmind.symmetric.io.data.transform.TransformTable;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.ITransformService;
import org.jumpmind.symmetric.service.impl.TransformService;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class ap
extends R<TransformService.TransformTableNodeGroupLink> {
    private static final long serialVersionUID = 1L;
    Select<NodeGroupLink> nodeGroupLink;
    Select<TransformPoint> transformPoint;
    TextField sourceCatalogName;
    TextField sourceSchemaName;
    Select<a> sourceTableName;
    Select<String> targetCatalogName;
    boolean settingTargetCatalogs;
    Select<String> targetSchemaName;
    boolean settingTargetSchemas;
    Select<String> targetTableName;
    String initialSourceTableName;
    String initialTargetTableName;
    String originalId;

    public ap(I controller, Set<TransformService.TransformTableNodeGroupLink> itemSet, boolean newItemFlag, boolean deleteFlag) {
        super(controller, itemSet, newItemFlag, deleteFlag);
    }

    @Override
    public void initFields() {
        if (!this.newItemFlag && !this.isBulk) {
            this.originalId = ((TransformService.TransformTableNodeGroupLink)this.itemSet.iterator().next()).getTransformId();
        }
        this.binder = new Binder(TransformService.TransformTableNodeGroupLink.class);
        if (!this.isBulk && !this.newItemFlag) {
            this.initialSourceTableName = ((TransformService.TransformTableNodeGroupLink)this.itemSet.iterator().next()).getSourceTableName();
            this.initialTargetTableName = ((TransformService.TransformTableNodeGroupLink)this.itemSet.iterator().next()).getTargetTableName();
        }
        TextField transformId = new TextField();
        transformId.setId("transformId");
        transformId.setClassName("input-long");
        this.binder.forField((HasValue)transformId).withValidator((SerializablePredicate & Serializable)value -> !StringUtils.isBlank((CharSequence)value) || this.isBulk, this.controller.getMessage("%s is required.", "Transform Id")).bind("transformId");
        transformId.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)transformId, this.controller.getMessage("Transform Id", new Object[0])));
        IConfigurationService configService = this.controller.getSymmetricEngine().getConfigurationService();
        this.nodeGroupLink = new Select();
        this.nodeGroupLink.setItems((Collection)configService.getNodeGroupLinks(false));
        this.nodeGroupLink.setId("nodeGroupLink");
        this.formatComboBox(this.nodeGroupLink);
        this.binder.forField(this.nodeGroupLink).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Group Link")).bind("nodeGroupLink");
        this.nodeGroupLink.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (this.transformPoint != null) {
                this.loadSourceTables(this.getSourceTables());
                this.loadTargetCatalogs(this.getTargetCatalogs());
            }
        });
        this.nodeGroupLink.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)this.nodeGroupLink, this.controller.getMessage("Group Link", new Object[0])));
        this.transformPoint = new Select();
        this.transformPoint.setItems((Object[])TransformPoint.values());
        this.transformPoint.setId("transformPoint");
        this.formatComboBox(this.transformPoint);
        this.binder.forField(this.transformPoint).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Transform Point")).bind("transformPoint");
        this.transformPoint.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (this.nodeGroupLink != null) {
                this.loadSourceTables(this.getSourceTables());
                this.loadTargetCatalogs(this.getTargetCatalogs());
            }
        });
        this.transformPoint.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)this.transformPoint, this.controller.getMessage("Transform Point", new Object[0])));
        Select columnPolicy = new Select();
        columnPolicy.setItems((Object[])ColumnPolicy.values());
        columnPolicy.setValue((Object)ColumnPolicy.SPECIFIED);
        columnPolicy.setId("columnPolicy");
        this.formatComboBox(columnPolicy);
        this.binder.forField((HasValue)columnPolicy).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Column Policy")).bind("columnPolicy");
        columnPolicy.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)columnPolicy, this.controller.getMessage("Column Policy", new Object[0])));
        this.advancedFieldList = new ArrayList();
        this.sourceCatalogName = new TextField();
        this.sourceCatalogName.setId("sourceCatalogName");
        this.sourceCatalogName.setClassName("input-long");
        this.binder.forField((HasValue)this.sourceCatalogName).bind("sourceCatalogName");
        this.sourceSchemaName = new TextField();
        this.sourceSchemaName.setId("sourceSchemaName");
        this.sourceSchemaName.setClassName("input-long");
        this.binder.forField((HasValue)this.sourceSchemaName).bind("sourceSchemaName");
        if (this.controller.getSymmetricEngine().getParameterService().is("console.remote.meta.data", false)) {
            this.sourceCatalogName.setVisible(false);
            this.advancedFieldList.add(new R.a((HasValue<?, ?>)this.sourceCatalogName, this.controller.getMessage("Source Catalog", new Object[0])));
            this.sourceSchemaName.setVisible(false);
            this.advancedFieldList.add(new R.a((HasValue<?, ?>)this.sourceSchemaName, this.controller.getMessage("Source Schema", new Object[0])));
            this.loadSourceTables(this.getSourceTables());
            this.sourceTableName.setId("sourceTableName");
            this.sourceTableName.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                a item = (a)this.sourceTableName.getValue();
                if (item != null && StringUtils.isNotEmpty((CharSequence)item.getCatalog())) {
                    this.sourceCatalogName.setValue(item.getCatalog());
                }
                if (item != null && StringUtils.isNotEmpty((CharSequence)item.getSchema())) {
                    this.sourceSchemaName.setValue(item.getSchema());
                }
            });
            this.sourceTableName.setRequiredIndicatorVisible(!this.isBulk);
            if (!this.isBulk) {
                this.binder.forField(this.sourceTableName).withValidator((SerializablePredicate & Serializable)value -> value != null && !value.equals(this.sourceTableName.getEmptyValue()), this.controller.getMessage("%s is required.", "Source Table")).withConverter((Converter)new b()).bind("sourceTableName");
                this.fieldList.add(new R.a((HasValue<?, ?>)this.sourceTableName, this.controller.getMessage("Source Table", new Object[0])));
            } else {
                this.binder.forField(this.sourceTableName).withConverter((Converter)new b()).bind("sourceTableName");
                this.fieldList.add(new R.a((HasValue<?, ?>)this.sourceTableName, this.controller.getMessage("Source Table", new Object[0])));
            }
            this.loadTargetCatalogs(this.getTargetCatalogs());
            this.targetCatalogName.setId("targetCatalogName");
            this.targetCatalogName.setEmptySelectionAllowed(true);
            this.targetCatalogName.setEmptySelectionCaption("<default>");
            this.binder.forField(this.targetCatalogName).bind("targetCatalogName");
            this.fieldList.add(new R.a((HasValue<?, ?>)this.targetCatalogName, this.controller.getMessage("Target Catalog", new Object[0])));
            this.targetSchemaName.setId("targetSchemaName");
            this.targetSchemaName.setEmptySelectionAllowed(true);
            this.targetSchemaName.setEmptySelectionCaption("<default>");
            this.binder.forField(this.targetSchemaName).bind("targetSchemaName");
            this.fieldList.add(new R.a((HasValue<?, ?>)this.targetSchemaName, this.controller.getMessage("Target Schema", new Object[0])));
            this.targetTableName.setId("targetTableName");
            this.targetTableName.setRequiredIndicatorVisible(!this.isBulk);
            if (!this.isBulk) {
                this.binder.forField(this.targetTableName).withValidator((SerializablePredicate & Serializable)value -> value != null && !value.equals(this.targetTableName.getEmptyValue()), this.controller.getMessage("%s is required.", "Target Table")).bind("targetTableName");
                this.fieldList.add(new R.a((HasValue<?, ?>)this.targetTableName, this.controller.getMessage("Target Table", new Object[0])));
            } else {
                this.binder.forField(this.targetTableName).bind("targetTableName");
                this.fieldList.add(new R.a((HasValue<?, ?>)this.targetTableName, this.controller.getMessage("Target Table", new Object[0])));
            }
        } else {
            this.fieldList.add(new R.a((HasValue<?, ?>)this.sourceCatalogName, this.controller.getMessage("Source Catalog", new Object[0])));
            this.fieldList.add(new R.a((HasValue<?, ?>)this.sourceSchemaName, this.controller.getMessage("Source Schema", new Object[0])));
            TextField sourceTableNameField = new TextField();
            sourceTableNameField.setId("sourceTableName");
            sourceTableNameField.setClassName("input-long");
            this.binder.forField((HasValue)sourceTableNameField).withValidator((SerializablePredicate & Serializable)value -> !value.equals(sourceTableNameField.getEmptyValue()) || this.isBulk, this.controller.getMessage("%s is required.", "Source Table")).bind("sourceTableName");
            sourceTableNameField.setRequiredIndicatorVisible(!this.isBulk);
            this.fieldList.add(new R.a((HasValue<?, ?>)sourceTableNameField, this.controller.getMessage("Source Table", new Object[0])));
            TextField targetCatalogNameField = new TextField();
            targetCatalogNameField.setId("targetCatalogName");
            targetCatalogNameField.setClassName("input-long");
            this.binder.forField((HasValue)targetCatalogNameField).bind("targetCatalogName");
            this.fieldList.add(new R.a((HasValue<?, ?>)targetCatalogNameField, this.controller.getMessage("Target Catalog", new Object[0])));
            TextField targetSchemaNameField = new TextField();
            targetSchemaNameField.setId("targetSchemaName");
            targetSchemaNameField.setClassName("input-long");
            this.binder.forField((HasValue)targetSchemaNameField).bind("targetSchemaName");
            this.fieldList.add(new R.a((HasValue<?, ?>)targetSchemaNameField, this.controller.getMessage("Target Schema", new Object[0])));
            TextField targetTableNameField = new TextField();
            targetTableNameField.setId("targetTableName");
            targetTableNameField.setClassName("input-long");
            this.binder.forField((HasValue)targetTableNameField).withValidator((SerializablePredicate & Serializable)value -> !value.equals(targetTableNameField.getEmptyValue()) || this.isBulk, this.controller.getMessage("%s is required.", "Target Table")).bind("targetTableName");
            targetTableNameField.setRequiredIndicatorVisible(!this.isBulk);
            this.fieldList.add(new R.a((HasValue<?, ?>)targetTableNameField, this.controller.getMessage("Target Table", new Object[0])));
        }
        Checkbox updateFirst = new Checkbox();
        updateFirst.setId("updateFirst");
        this.binder.forField((HasValue)updateFirst).bind("updateFirst");
        this.advancedFieldList.add(new R.a((HasValue<?, ?>)updateFirst, this.controller.getMessage("Update First", new Object[0])));
        ArrayList<TargetDmlAction> deleteActionList = new ArrayList<TargetDmlAction>();
        deleteActionList.add(TargetDmlAction.NONE);
        deleteActionList.add(TargetDmlAction.DEL_ROW);
        deleteActionList.add(TargetDmlAction.UPDATE_COL);
        Select deleteAction = new Select();
        deleteAction.setItems(deleteActionList);
        deleteAction.setValue((Object)TargetDmlAction.DEL_ROW);
        deleteAction.setId("deleteAction");
        this.formatComboBox(deleteAction);
        this.binder.forField((HasValue)deleteAction).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Delete Action")).bind("deleteAction");
        deleteAction.setRequiredIndicatorVisible(!this.isBulk);
        deleteAction.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a((HasValue<?, ?>)deleteAction, this.controller.getMessage("Delete Action", new Object[0])));
        ArrayList<String> updateActionList = new ArrayList<String>();
        updateActionList.add(TargetDmlAction.UPD_ROW.name());
        updateActionList.add(TargetDmlAction.INS_ROW.name());
        updateActionList.add(TargetDmlAction.DEL_ROW.name());
        updateActionList.add(TargetDmlAction.NONE.name());
        Select updateAction = new Select();
        updateAction.setItems(updateActionList);
        updateAction.setValue((Object)TargetDmlAction.UPD_ROW.name());
        updateAction.setId("updateAction");
        this.formatComboBox(updateAction);
        this.binder.forField((HasValue)updateAction).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Update Action")).bind("updateAction");
        updateAction.setRequiredIndicatorVisible(!this.isBulk);
        updateAction.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a((HasValue<?, ?>)updateAction, this.controller.getMessage("Update Action", new Object[0])));
        TextField transformOrder = new TextField();
        transformOrder.setId("transformOrder");
        transformOrder.setClassName("input-long");
        this.binder.forField((HasValue)transformOrder).withConverter((Converter)new StringToIntegerConverter(this.controller.getMessage("Transform Order must be an integer.", new Object[0]))).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Transform Order")).bind("transformOrder");
        transformOrder.setRequiredIndicatorVisible(!this.isBulk);
        transformOrder.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a((HasValue<?, ?>)transformOrder, this.controller.getMessage("Transform Order", new Object[0])));
    }

    @Override
    protected void generateNewItem() {
        TransformService.TransformTableNodeGroupLink transformTable = new TransformService.TransformTableNodeGroupLink();
        transformTable.setDeleteAction(TargetDmlAction.DEL_ROW);
        transformTable.setUpdateAction(TargetDmlAction.UPD_ROW.name());
        this.newItem = transformTable;
    }

    @Override
    public boolean save(boolean saveAsCopy) {
        if (this.binder.validate().isOk()) {
            if (!this.isBulk) {
                TransformService.TransformTableNodeGroupLink transformTable;
                if (!this.newItemFlag) {
                    try {
                        if (saveAsCopy) {
                            if (this.newItem == null) {
                                this.generateNewItem();
                            }
                            this.binder.writeBean((Object)((TransformService.TransformTableNodeGroupLink)this.newItem));
                        } else {
                            this.binder.writeBean((Object)((TransformService.TransformTableNodeGroupLink)this.itemSet.iterator().next()));
                        }
                    }
                    catch (ValidationException e2) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    transformTable = saveAsCopy ? (TransformService.TransformTableNodeGroupLink)this.newItem : (TransformService.TransformTableNodeGroupLink)this.itemSet.iterator().next();
                } else {
                    try {
                        this.binder.writeBean((Object)((TransformService.TransformTableNodeGroupLink)this.newItem));
                    }
                    catch (ValidationException e3) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    transformTable = (TransformService.TransformTableNodeGroupLink)this.newItem;
                }
                this.saveTransformTable(transformTable, saveAsCopy);
                this.addEvent(this.newItemFlag ? "Transform Created" : "Transform Modified", transformTable.getTransformId());
            } else {
                for (TransformService.TransformTableNodeGroupLink transformTable : this.itemSet) {
                    this.saveFieldsToTransformTable(this.fieldList, transformTable);
                    this.saveFieldsToTransformTable(this.advancedFieldList, transformTable);
                    this.saveTransformTable(transformTable, saveAsCopy);
                }
                this.addEvent("Transform Modified", this.itemSet.stream().map(TransformTable::getTransformId).collect(Collectors.toSet()));
            }
            if (this.formListener != null) {
                this.formListener.formSaved();
            }
            return true;
        }
        return false;
    }

    public void showInvalidTransformDialog(TransformService.TransformTableNodeGroupLink transformTable, boolean saveAsCopy) {
        this.formListener.getFormLayout().enableCancelShortcut(false);
        new ConfirmDialog(this.controller.getMessage("Confirm", new Object[0]), this.controller.getMessage("Are you sure you want to save the transform?  There isn't a table routing combination configured yet that will capture the data to be transformed.", "Transform"), this.controller.getMessage("Ok", new Object[0]), (ComponentEventListener & Serializable)e2 -> this.saveModel(transformTable, saveAsCopy), this.controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)e2 -> this.formListener.getFormLayout().enableCancelShortcut(true)).open();
    }

    public static boolean transformEquals(String s1, String s2) {
        return Strings.CI.equals(s1, s2) || StringUtils.isEmpty((CharSequence)s1) && StringUtils.isEmpty((CharSequence)s2);
    }

    public boolean isTransformConnectedAtExtract(List<TriggerRouter> triggerRouters, TransformService.TransformTableNodeGroupLink transformLink) {
        for (TriggerRouter triggerRouter : triggerRouters) {
            Router router = triggerRouter.getRouter();
            Trigger t2 = triggerRouter.getTrigger();
            if (!router.getNodeGroupLink().equals((Object)transformLink.getNodeGroupLink())) continue;
            if (router.isUseSourceCatalogSchema()) {
                if (!ap.transformEquals(t2.getSourceCatalogName(), transformLink.getSourceCatalogName()) || !ap.transformEquals(t2.getSourceSchemaName(), transformLink.getSourceSchemaName()) || !ap.transformEquals(t2.getSourceTableName(), transformLink.getSourceTableName())) continue;
                return true;
            }
            if (ap.transformEquals(router.getTargetCatalogName(), transformLink.getSourceCatalogName()) && ap.transformEquals(router.getTargetSchemaName(), transformLink.getSourceSchemaName()) && StringUtils.isEmpty((CharSequence)router.getTargetTableName())) {
                return true;
            }
            if (!ap.transformEquals(router.getTargetCatalogName(), transformLink.getSourceCatalogName()) || !ap.transformEquals(router.getTargetSchemaName(), transformLink.getSourceSchemaName()) || !StringUtils.isNotEmpty((CharSequence)router.getTargetTableName()) || !ap.transformEquals(router.getTargetCatalogName(), transformLink.getSourceCatalogName()) || !ap.transformEquals(router.getTargetSchemaName(), transformLink.getSourceSchemaName()) || !ap.transformEquals(router.getTargetTableName(), transformLink.getSourceTableName())) continue;
            return true;
        }
        return false;
    }

    public boolean isLoadTransformConnected(List<TriggerRouter> triggerRouters, TransformService.TransformTableNodeGroupLink loadTransformLink, List<TransformService.TransformTableNodeGroupLink> extractTransformsConnected) {
        for (TransformService.TransformTableNodeGroupLink extractTransformLink : extractTransformsConnected) {
            if (!ap.transformEquals(extractTransformLink.getTargetCatalogName(), loadTransformLink.getSourceCatalogName()) || !ap.transformEquals(extractTransformLink.getTargetSchemaName(), loadTransformLink.getSourceSchemaName()) || !ap.transformEquals(extractTransformLink.getTargetTableName(), loadTransformLink.getSourceTableName())) continue;
            return true;
        }
        return this.isTransformConnectedAtExtract(triggerRouters, loadTransformLink);
    }

    private void saveFieldsToTransformTable(List<R.a> fields, TransformService.TransformTableNodeGroupLink transformTable) {
        for (R.a formField : fields) {
            HasValue<?, ?> field = formField.getField();
            Checkbox checkbox = formField.getCheckbox();
            if (checkbox == null || !((Boolean)checkbox.getValue()).booleanValue() || !(field instanceof Component)) continue;
            switch (((Component)field).getId().orElse("")) {
                case "nodeGroupLink": {
                    transformTable.setNodeGroupLink((NodeGroupLink)field.getValue());
                    break;
                }
                case "transformPoint": {
                    transformTable.setTransformPoint((TransformPoint)field.getValue());
                    break;
                }
                case "columnPolicy": {
                    transformTable.setColumnPolicy((ColumnPolicy)field.getValue());
                    break;
                }
                case "sourceCatalogName": {
                    transformTable.setSourceCatalogName((String)field.getValue());
                    break;
                }
                case "sourceSchemaName": {
                    transformTable.setSourceSchemaName((String)field.getValue());
                    break;
                }
                case "sourceTableName": {
                    if (field instanceof TextField) {
                        transformTable.setSourceTableName((String)field.getValue());
                        break;
                    }
                    transformTable.setSourceTableName(((a)field.getValue()).toString());
                    break;
                }
                case "targetCatalogName": {
                    transformTable.setTargetCatalogName((String)field.getValue());
                    break;
                }
                case "targetSchemaName": {
                    transformTable.setTargetSchemaName((String)field.getValue());
                    break;
                }
                case "targetTableName": {
                    transformTable.setTargetTableName((String)field.getValue());
                    break;
                }
                case "updateFirst": {
                    transformTable.setUpdateFirst(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "deleteAction": {
                    transformTable.setDeleteAction((TargetDmlAction)field.getValue());
                    break;
                }
                case "updateAction": {
                    transformTable.setUpdateAction((String)field.getValue());
                    break;
                }
                case "transformOrder": {
                    transformTable.setTransformOrder(Integer.parseInt((String)field.getValue()));
                }
            }
        }
    }

    protected void saveTransformTable(TransformService.TransformTableNodeGroupLink transformTable, boolean saveAsCopy) {
        List triggerRouters = this.controller.getSymmetricEngine().getTriggerRouterService().getTriggerRouters(false);
        if (transformTable.getTransformPoint().equals((Object)TransformPoint.EXTRACT) && !this.isTransformConnectedAtExtract(triggerRouters, transformTable)) {
            this.showInvalidTransformDialog(transformTable, saveAsCopy);
        } else if (transformTable.getTransformPoint().equals((Object)TransformPoint.LOAD)) {
            ArrayList<TransformService.TransformTableNodeGroupLink> validExtractTransforms = new ArrayList<TransformService.TransformTableNodeGroupLink>();
            if (transformTable.getTransformPoint().equals((Object)TransformPoint.LOAD)) {
                for (TransformService.TransformTableNodeGroupLink transformTableLink : this.controller.getSymmetricEngine().getTransformService().getTransformTables(false)) {
                    if (!transformTable.getNodeGroupLink().equals((Object)transformTableLink.getNodeGroupLink()) || !transformTableLink.getTransformPoint().equals((Object)TransformPoint.EXTRACT) || !this.isTransformConnectedAtExtract(triggerRouters, transformTableLink)) continue;
                    validExtractTransforms.add(transformTableLink);
                }
            }
            if (!this.isLoadTransformConnected(triggerRouters, transformTable, validExtractTransforms)) {
                this.showInvalidTransformDialog(transformTable, saveAsCopy);
            } else {
                this.saveModel(transformTable, saveAsCopy);
            }
        } else {
            this.saveModel(transformTable, saveAsCopy);
        }
    }

    protected void saveModel(TransformService.TransformTableNodeGroupLink transformTable, boolean saveAsCopy) {
        int indexParens;
        ITransformService transformService = this.controller.getSymmetricEngine().getTransformService();
        transformTable.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
        if (this.controller.getSymmetricEngine().getParameterService().is("console.remote.meta.data", false) && (indexParens = transformTable.getSourceTableName().indexOf("(")) > 0) {
            transformTable.setSourceTableName(transformTable.getSourceTableName().substring(0, indexParens).trim());
        }
        if (saveAsCopy) {
            transformService.saveTransformTableAsCopy(this.originalId, transformTable);
        } else if (this.isBulk || this.newItemFlag || this.originalId == null || this.originalId.equals(transformTable.getTransformId())) {
            transformService.saveTransformTable(transformTable, false);
        } else {
            transformService.renameTransformTable(this.originalId, transformTable);
        }
    }

    @Override
    public void delete() {
        ITransformService transformService = this.controller.getSymmetricEngine().getTransformService();
        for (TransformService.TransformTableNodeGroupLink transformTable : this.itemSet) {
            transformService.deleteTransformTable(transformTable.getTransformId());
        }
        this.addEvent("Transform Deleted", this.itemSet.stream().map(TransformTable::getTransformId).collect(Collectors.toSet()));
        if (this.formListener != null) {
            this.formListener.formDeleted();
        }
    }

    @Override
    protected List<String> getOrderedFieldIds() {
        ArrayList<String> orderedFields = new ArrayList<String>();
        orderedFields.add("transformId");
        orderedFields.add("nodeGroupLink");
        orderedFields.add("transformPoint");
        orderedFields.add("columnPolicy");
        orderedFields.add("sourceCatalogName");
        orderedFields.add("sourceSchemaName");
        orderedFields.add("sourceTableName");
        orderedFields.add("targetCatalogName");
        orderedFields.add("targetSchemaName");
        orderedFields.add("targetTableName");
        orderedFields.add("updateFirst");
        orderedFields.add("deleteAction");
        orderedFields.add("updateAction");
        orderedFields.add("transformOrder");
        return orderedFields;
    }

    protected List<String> getTargetCatalogs() {
        try {
            if (this.controller.getSymmetricEngine().getParameterService().is("console.remote.meta.data", false)) {
                NodeGroupLink link = (NodeGroupLink)this.nodeGroupLink.getValue();
                ArrayList<String> items = new ArrayList<String>();
                for (String s2 : this.controller.getCatalogs(link.getTargetNodeGroupId())) {
                    if (s2 == null) continue;
                    items.add(s2);
                }
                items.sort(null);
                return items;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected List<String> getTargetSchemas() {
        try {
            if (this.controller.getSymmetricEngine().getParameterService().is("console.remote.meta.data", false) && this.targetCatalogName != null && this.targetCatalogName.getValue() != null) {
                NodeGroupLink link = (NodeGroupLink)this.nodeGroupLink.getValue();
                ArrayList<String> items = new ArrayList<String>();
                String catalogValue = (String)this.targetCatalogName.getValue();
                if (StringUtils.isNotEmpty((CharSequence)catalogValue)) {
                    for (String s2 : this.controller.getSchemas(link.getTargetNodeGroupId(), catalogValue)) {
                        if (s2 == null) continue;
                        items.add(s2);
                    }
                }
                items.sort(null);
                return items;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected List<String> getTargetTables() {
        List<String> tables = new ArrayList<String>();
        try {
            if (this.controller.getSymmetricEngine().getParameterService().is("console.remote.meta.data", false) && this.targetCatalogName != null && this.targetSchemaName != null) {
                NodeGroupLink link = (NodeGroupLink)this.nodeGroupLink.getValue();
                String catalogValue = null;
                catalogValue = this.targetCatalogName.getValue() == null || StringUtils.isBlank((CharSequence)((CharSequence)this.targetCatalogName.getValue())) ? this.controller.getDefaultCatalog(link.getTargetNodeGroupId()) : (String)this.targetCatalogName.getValue();
                String schemaValue = null;
                schemaValue = this.targetSchemaName.getValue() == null || StringUtils.isBlank((CharSequence)((CharSequence)this.targetSchemaName.getValue())) ? this.controller.getDefaultSchema(link.getTargetNodeGroupId()) : (String)this.targetSchemaName.getValue();
                tables = this.controller.getTables(link.getTargetNodeGroupId(), catalogValue, schemaValue);
                tables.removeIf(table -> table == null);
                tables.sort(String.CASE_INSENSITIVE_ORDER);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tables == null) {
            tables = new ArrayList();
        }
        if (this.initialTargetTableName != null && !tables.contains(this.initialTargetTableName)) {
            tables.add(0, this.initialTargetTableName);
        }
        return tables;
    }

    protected void loadTargetCatalogs(List<String> catalogs) {
        if (catalogs == null) {
            catalogs = new ArrayList<String>();
        }
        String value = null;
        if (this.targetCatalogName == null) {
            this.targetCatalogName = new Select();
            this.targetCatalogName.setItems(catalogs);
            this.formatComboBox(this.targetCatalogName);
            this.targetCatalogName.setClassName("input-long");
            this.targetCatalogName.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                if (!this.settingTargetCatalogs) {
                    this.loadTargetSchemas(this.getTargetSchemas());
                }
            });
        } else {
            if (catalogs.contains(this.targetCatalogName.getValue())) {
                value = (String)this.targetCatalogName.getValue();
            }
            this.settingTargetCatalogs = true;
            this.targetCatalogName.setItems(catalogs);
            this.settingTargetCatalogs = false;
        }
        this.loadTargetSchemas(this.getTargetSchemas());
        this.targetCatalogName.setValue((Object)value);
    }

    protected void loadTargetSchemas(List<String> schemas) {
        if (schemas == null) {
            schemas = new ArrayList<String>();
        }
        String value = null;
        if (this.targetSchemaName == null) {
            this.targetSchemaName = new Select();
            this.targetSchemaName.setItems(schemas);
            this.formatComboBox(this.targetSchemaName);
            this.targetSchemaName.setClassName("input-long");
            this.targetSchemaName.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                if (!this.settingTargetSchemas) {
                    this.loadTargetTables(this.getTargetTables());
                }
            });
        } else {
            if (schemas.contains(this.targetSchemaName.getValue())) {
                value = (String)this.targetSchemaName.getValue();
            }
            this.settingTargetSchemas = true;
            this.targetSchemaName.setItems(schemas);
            this.settingTargetSchemas = false;
        }
        this.loadTargetTables(this.getTargetTables());
        this.targetSchemaName.setValue((Object)value);
    }

    protected void loadTargetTables(List<String> tables) {
        if (tables == null) {
            tables = new ArrayList<String>();
        }
        String value = null;
        if (this.targetTableName == null) {
            this.targetTableName = new Select();
            this.targetTableName.setItems(tables);
            this.formatComboBox(this.targetTableName);
            this.targetTableName.setClassName("input-long");
        } else {
            if (tables.contains(this.targetTableName.getValue())) {
                value = (String)this.targetTableName.getValue();
            }
            this.targetTableName.setItems(tables);
        }
        this.targetTableName.setValue((Object)value);
    }

    protected void loadSourceTables(List<a> tables) {
        boolean tablesEmpty;
        boolean bl2 = tablesEmpty = tables == null || tables.size() == 0;
        if (tablesEmpty) {
            tables = new ArrayList<a>();
        }
        if (this.sourceTableName == null) {
            this.sourceTableName = new Select();
            this.sourceTableName.setItems(tables);
            this.formatComboBox(this.sourceTableName);
            this.sourceTableName.setClassName("input-long");
        } else {
            this.sourceTableName.setItems(tables);
        }
        this.sourceTableName.setEnabled(!tablesEmpty);
    }

    public List<a> getSourceTables() {
        HashSet<a> tables = new HashSet<a>();
        NodeGroupLink groupLink = (NodeGroupLink)this.nodeGroupLink.getValue();
        if (groupLink != null) {
            Map<String, List<Trigger>> triggerByRouterMap = this.getTriggerByRouterMap(groupLink.getSourceNodeGroupId());
            if (this.transformPoint.getValue() != null) {
                if (((TransformPoint)this.transformPoint.getValue()).equals((Object)TransformPoint.LOAD)) {
                    this.getSourceTablesBasedOnExtractTransform(tables);
                }
                for (Router router : this.controller.getSymmetricEngine().getTriggerRouterService().getRouters()) {
                    if (!router.getNodeGroupLink().equals((Object)groupLink)) continue;
                    if (router.isUseSourceCatalogSchema()) {
                        List<Trigger> triggers = triggerByRouterMap.get(router.getRouterId());
                        if (triggers == null) continue;
                        for (Trigger t3 : triggers) {
                            a item = new a();
                            String catalog = t3.getSourceCatalogName();
                            String schema = t3.getSourceSchemaName();
                            item.setTable(t3.getSourceTableName());
                            item.setCatalog(catalog);
                            item.setSchema(schema);
                            tables.add(item);
                        }
                        continue;
                    }
                    String catalog = router.getTargetCatalogName();
                    String schema = router.getTargetSchemaName();
                    List<Trigger> triggers = triggerByRouterMap.get(router.getRouterId());
                    if (triggers == null) continue;
                    for (Trigger t4 : triggers) {
                        a item = new a();
                        item.setTable(t4.getSourceTableName());
                        item.setCatalog(catalog);
                        item.setSchema(schema);
                        tables.add(item);
                    }
                }
            }
        }
        if (this.initialSourceTableName != null && tables.stream().noneMatch(t2 -> this.initialSourceTableName.equals(t2.getTable()))) {
            tables.add(new a(null, null, this.initialSourceTableName));
        }
        ArrayList<a> tableList = new ArrayList<a>(tables);
        tableList.sort(null);
        return tableList;
    }

    public void getSourceTablesBasedOnExtractTransform(Set<a> tables) {
        NodeGroupLink groupLink = (NodeGroupLink)this.nodeGroupLink.getValue();
        List transforms = this.controller.getSymmetricEngine().getTransformService().getTransformTables(false);
        for (TransformService.TransformTableNodeGroupLink transform : transforms) {
            if (!transform.getTransformPoint().equals((Object)TransformPoint.EXTRACT) || !transform.getNodeGroupLink().equals((Object)groupLink)) continue;
            tables.add(new a(transform.getTargetCatalogName(), transform.getTargetSchemaName(), transform.getTargetTableName()));
        }
    }

    public Map<String, List<Trigger>> getTriggerByRouterMap(String nodeGroupId) {
        List triggerRouters = this.controller.getSymmetricEngine().getTriggerRouterService().getAllTriggerRoutersForCurrentNode(nodeGroupId);
        HashMap<String, List<Trigger>> result = new HashMap<String, List<Trigger>>();
        for (TriggerRouter triggerRouter : triggerRouters) {
            if (result.get(triggerRouter.getRouter().getRouterId()) == null) {
                result.put(triggerRouter.getRouterId(), new ArrayList());
            }
            ((List)result.get(triggerRouter.getRouterId())).add(triggerRouter.getTrigger());
        }
        return result;
    }

    @Override
    public String getKeyId() {
        return "transformId";
    }

    @Override
    public String getHelpSectionName() {
        return "_transforms";
    }

    public class b
    implements Converter<a, String> {
        private static final long serialVersionUID = 1L;

        public Result<String> convertToModel(a value, ValueContext context) {
            return Result.ok((Object)(value == null ? null : value.toString()));
        }

        public a convertToPresentation(String value, ValueContext context) {
            return value == null ? null : new a(null, null, value);
        }
    }

    public class a
    implements Serializable,
    Comparable<a> {
        private static final long serialVersionUID = 1L;
        private String catalog;
        private String schema;
        private String table;

        public a() {
        }

        public a(String catalog, String schema, String table) {
            this.table = table;
            this.catalog = catalog;
            this.schema = schema;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.table == null ? "" : this.table);
            boolean parenAppended = false;
            if (StringUtils.isNotEmpty((CharSequence)this.catalog)) {
                sb.append(" (").append(this.catalog).append(".");
                parenAppended = true;
            }
            if (StringUtils.isNotEmpty((CharSequence)this.schema)) {
                if (!parenAppended) {
                    sb.append(" (");
                    parenAppended = true;
                }
                sb.append(this.schema);
            }
            if (parenAppended) {
                sb.append(")");
            }
            return sb.toString();
        }

        public String getCatalog() {
            return this.catalog;
        }

        public void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        public String getSchema() {
            return this.schema;
        }

        public void setSchema(String schema) {
            this.schema = schema;
        }

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public boolean equals(Object obj) {
            return obj == null ? false : this.toString().equals(obj.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        @Override
        public int compareTo(a item) {
            return String.CASE_INSENSITIVE_ORDER.compare(this.table, item.table);
        }
    }
}

