/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.P;
import com.jumpmind.symmetric.console.ui.common.as;
import com.jumpmind.symmetric.console.ui.common.w;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.job.IJobManager;
import org.jumpmind.symmetric.model.JobDefinition;
import org.jumpmind.symmetric.model.NodeGroup;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.springframework.scheduling.support.CronTrigger;

public class ad
extends R<JobDefinition> {
    private static final long serialVersionUID = 1L;
    private String originalName;

    public ad(I controller, Set<JobDefinition> itemSet, boolean newItemFlag, boolean deleteFlag) {
        super(controller, itemSet, newItemFlag, deleteFlag);
    }

    @Override
    public void initFields() {
        boolean builtIn;
        boolean bl2 = builtIn = !this.newItemFlag && !this.itemSet.isEmpty() && ((JobDefinition)this.itemSet.iterator().next()).getJobType() == JobDefinition.JobType.BUILT_IN;
        if (!(builtIn || this.newItemFlag || this.isBulk)) {
            this.originalName = ((JobDefinition)this.itemSet.iterator().next()).getJobName();
        }
        this.binder = new Binder(JobDefinition.class);
        TextField jobName = new TextField();
        jobName.setId("jobName");
        jobName.setRequiredIndicatorVisible(!builtIn);
        jobName.setEnabled(!builtIn);
        jobName.setReadOnly(builtIn);
        this.fieldList.add(new R.a((HasValue<?, ?>)jobName, this.controller.getMessage("Job Name", new Object[0])));
        TextField description = new TextField();
        description.setId("description");
        this.binder.forField((HasValue)description).bind("description");
        description.setEnabled(!builtIn);
        description.setReadOnly(builtIn);
        this.fieldList.add(new R.a((HasValue<?, ?>)description, this.controller.getMessage("Description", new Object[0])));
        if (builtIn) {
            TextField jobType = new TextField();
            jobType.setId("jobType");
            jobType.setValue(JobDefinition.JobType.BUILT_IN.name());
            jobType.setEnabled(false);
            jobType.setReadOnly(true);
            this.fieldList.add(new R.a((HasValue<?, ?>)jobType, this.controller.getMessage("Job Type", new Object[0])));
            TextField nodeGroupId = new TextField();
            nodeGroupId.setId("nodeGroupId");
            this.binder.forField((HasValue)nodeGroupId).bind("nodeGroupId");
            nodeGroupId.setEnabled(false);
            nodeGroupId.setReadOnly(true);
            this.fieldList.add(new R.a((HasValue<?, ?>)nodeGroupId, this.controller.getMessage("Node Group", new Object[0])));
        } else {
            ArrayList<JobDefinition.JobType> jobTypeList = new ArrayList<JobDefinition.JobType>();
            jobTypeList.add(JobDefinition.JobType.BSH);
            jobTypeList.add(JobDefinition.JobType.JAVA);
            jobTypeList.add(JobDefinition.JobType.SQL);
            Select jobType = new Select();
            jobType.setItems(jobTypeList);
            jobType.setId("jobType");
            this.formatComboBox(jobType);
            this.binder.forField((HasValue)jobType).withValidator((SerializablePredicate & Serializable)value -> value != null, this.controller.getMessage("%s is required.", "Job Type")).bind("jobType");
            jobType.setRequiredIndicatorVisible(true);
            this.fieldList.add(new R.a((HasValue<?, ?>)jobType, this.controller.getMessage("Job Type", new Object[0])));
            ArrayList<String> nodeGroupIdList = new ArrayList<String>();
            nodeGroupIdList.add("ALL");
            for (NodeGroup nodeGroup : this.controller.getSymmetricEngine().getConfigurationService().getNodeGroups()) {
                nodeGroupIdList.add(nodeGroup.getNodeGroupId());
            }
            Select nodeGroupId = new Select();
            nodeGroupId.setItems(nodeGroupIdList);
            nodeGroupId.setId("nodeGroupId");
            this.formatComboBox(nodeGroupId);
            this.binder.forField((HasValue)nodeGroupId).withValidator((SerializablePredicate & Serializable)value -> value != null, this.controller.getMessage("%s is required.", "Job Type")).bind("nodeGroupId");
            nodeGroupId.setRequiredIndicatorVisible(true);
            this.fieldList.add(new R.a((HasValue<?, ?>)nodeGroupId, this.controller.getMessage("Node Group", new Object[0])));
        }
        Checkbox automaticStartup = new Checkbox();
        automaticStartup.setId("automaticStartup");
        this.binder.forField((HasValue)automaticStartup).bind("automaticStartup");
        this.fieldList.add(new R.a((HasValue<?, ?>)automaticStartup, this.controller.getMessage("Auto Start-up", new Object[0])));
        final Checkbox clustered = new Checkbox();
        clustered.setId("clustered");
        this.binder.forField((HasValue)clustered).bind("clustered");
        this.fieldList.add(new R.a((HasValue<?, ?>)clustered, this.controller.getMessage("Clustered", new Object[0])));
        Validator<String> jobNameValidator = new Validator<String>(){
            private static final long serialVersionUID = 1L;

            public ValidationResult apply(String value, ValueContext context) {
                Map locks;
                if (StringUtils.isBlank((CharSequence)value)) {
                    return ValidationResult.error((String)ad.this.controller.getMessage("%s is required.", "Job Name"));
                }
                if (((Boolean)clustered.getValue()).booleanValue() && (locks = ad.this.controller.getSymmetricEngine().getClusterService().findLocks()).get(value) != null) {
                    return ValidationResult.error((String)ad.this.controller.getMessage("Job Name cannot match existing cluster lock.", new Object[0]));
                }
                return ValidationResult.ok();
            }
        };
        this.binder.forField((HasValue)jobName).withValidator((Validator)jobNameValidator).bind("jobName");
        w schedule = new w(null){
            private static final long serialVersionUID = 1L;

            @Override
            protected void init(String name) {
                if (!ad.this.newItemFlag) {
                    this.setPresentationValue(((JobDefinition)ad.this.itemSet.iterator().next()).getSchedule());
                }
                HorizontalLayout layout = new HorizontalLayout();
                this.buildLayout(layout);
                this.add(new Component[]{layout});
            }

            @Override
            public void update() {
                HorizontalLayout layout = (HorizontalLayout)this.getChildren().iterator().next();
                this.buildLayout(layout);
            }

            private void buildLayout(HorizontalLayout layout) {
                this.button.setClassName("edit-button-text-field");
                layout.removeAll();
                layout.add(new Component[]{this.button});
                String displayValue = this.getValue();
                if (displayValue != null && displayValue.matches("^[0-9]+$")) {
                    displayValue = as.formatDurationFull(Long.parseLong(displayValue));
                }
                Span valueSpan = new Span(displayValue);
                layout.add(new Component[]{valueSpan});
                layout.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{valueSpan});
            }
        };
        schedule.setId("schedule");
        Span scheduleSpan = as.getErrorSpan();
        this.binder.forField((HasValue)schedule).withValidator((SerializablePredicate & Serializable)value -> value != null && !value.equals(schedule.getEmptyValue()), this.controller.getMessage("%s is required.", "Schedule")).withValidationStatusHandler(as.getValidationHandler((Component)schedule, scheduleSpan)).bind("schedule");
        schedule.addClickListener((ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
            P dialog = new P(this.controller, schedule, true, true, !this.newItemFlag);
            dialog.addOpenedChangeListener((ComponentEventListener & Serializable)e2 -> this.formListener.getFormLayout().enableCancelShortcut(!e2.isOpened()));
            dialog.open();
        });
        schedule.setRequiredIndicatorVisible(true);
        this.fieldList.add(new R.a((HasValue<?, ?>)schedule, this.controller.getMessage("Schedule", new Object[0]), (Component)scheduleSpan));
    }

    @Override
    protected void generateNewItem() {
        this.newItem = new JobDefinition();
    }

    @Override
    public boolean save(boolean saveAsCopy) {
        if (this.binder.validate().isOk()) {
            JobDefinition definition;
            IJobManager jobManager = this.controller.getSymmetricEngine().getJobManager();
            if (!this.newItemFlag) {
                try {
                    if (saveAsCopy) {
                        if (this.newItem == null) {
                            this.generateNewItem();
                        }
                        this.binder.writeBean((Object)((JobDefinition)this.newItem));
                    } else {
                        this.binder.writeBean((Object)((JobDefinition)this.itemSet.iterator().next()));
                    }
                }
                catch (ValidationException e2) {
                    CommonUiUtils.notify((String)"Failed to write to bean");
                }
                definition = saveAsCopy ? (JobDefinition)this.newItem : (JobDefinition)this.itemSet.iterator().next();
            } else {
                try {
                    this.binder.writeBean((Object)((JobDefinition)this.newItem));
                }
                catch (ValidationException e3) {
                    CommonUiUtils.notify((String)"Failed to write to bean");
                }
                definition = (JobDefinition)this.newItem;
            }
            String user = this.controller.getConsoleUser().getUserId();
            if (this.newItemFlag) {
                definition.setCreateBy(user);
            }
            IParameterService parameterService = this.controller.getSymmetricEngine().getParameterService();
            parameterService.saveParameter("ALL", "ALL", definition.getStartParameter(), (Object)definition.isAutomaticStartup(), this.controller.getConsoleUser().getUserId());
            if (definition.getSchedule().equals("Default")) {
                parameterService.deleteParameter("ALL", "ALL", definition.getPeriodicParameter());
                parameterService.deleteParameter("ALL", "ALL", definition.getCronParameter());
            } else if (definition.isCronSchedule()) {
                new CronTrigger(definition.getSchedule());
                parameterService.saveParameter("ALL", "ALL", definition.getCronParameter(), (Object)definition.getSchedule(), this.controller.getConsoleUser().getUserId());
                parameterService.deleteParameter("ALL", "ALL", definition.getPeriodicParameter());
            } else {
                parameterService.saveParameter("ALL", "ALL", definition.getPeriodicParameter(), (Object)definition.getSchedule(), this.controller.getConsoleUser().getUserId());
                parameterService.deleteParameter("ALL", "ALL", definition.getCronParameter());
                if (JobDefinition.JobType.BUILT_IN.equals((Object)definition.getJobType()) && parameterService.getString(definition.getCronParameter()) != null) {
                    parameterService.saveParameter("ALL", "ALL", definition.getCronParameter(), (Object)"", this.controller.getConsoleUser().getUserId());
                }
            }
            if (definition.getJobType() != JobDefinition.JobType.BUILT_IN) {
                definition.setLastUpdateBy(user);
                if (this.newItemFlag) {
                    definition.setDefaultAutomaticStartup(definition.isAutomaticStartup());
                    definition.setDefaultSchedule(definition.getSchedule());
                    jobManager.saveJob(definition);
                } else if (saveAsCopy) {
                    jobManager.saveJobAsCopy(definition);
                } else if (this.originalName == null || this.originalName.equals(definition.getJobName())) {
                    jobManager.saveJob(definition);
                } else {
                    jobManager.renameJob(this.originalName, definition);
                }
            }
            this.addEvent(this.newItemFlag ? "Job Created" : "Job Modified", definition.getJobName());
            this.newItemFlag = false;
            if (this.formListener != null) {
                this.formListener.formSaved();
            }
            return true;
        }
        return false;
    }

    @Override
    public void delete() {
        IJobManager jobManager = this.controller.getSymmetricEngine().getJobManager();
        IParameterService parameterService = this.controller.getSymmetricEngine().getParameterService();
        for (JobDefinition definition : this.itemSet) {
            jobManager.removeJob(definition.getJobName());
            parameterService.deleteParameter(definition.getStartParameter());
            parameterService.deleteParameter(definition.getCronParameter());
            parameterService.deleteParameter(definition.getPeriodicParameter());
            this.addEvent("Job Deleted", definition.getJobName());
        }
        if (this.formListener != null) {
            this.formListener.formDeleted();
        }
    }

    @Override
    protected List<String> getOrderedFieldIds() {
        ArrayList<String> orderedFields = new ArrayList<String>();
        if (!this.isBulk) {
            orderedFields.add("jobName");
            orderedFields.add("description");
            orderedFields.add("jobType");
            orderedFields.add("nodeGroupId");
            orderedFields.add("automaticStartup");
            orderedFields.add("clustered");
            orderedFields.add("schedule");
            orderedFields.add("requiresRegistration");
        }
        return orderedFields;
    }

    @Override
    public String getKeyId() {
        return "jobName";
    }

    @Override
    public String getHelpSectionName() {
        return "_jobs";
    }
}

