/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp.router;

import com.anfcorp.stores.symmetric.corp.router.DmlStatement;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.AbstractDataRouter;
import org.jumpmind.symmetric.route.SimpleRouterContext;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class AuditTableDataRouter
extends AbstractDataRouter
implements ISymmetricEngineAware {
    private static final String COLUMN_AUDIT_EVENT = "AUDIT_EVENT";
    private static final String COLUMN_AUDIT_TIME = "AUDIT_TIME";
    private static final String COLUMN_AUDIT_ID = "AUDIT_ID";
    private Map<String, Table> auditTables = new HashMap<String, Table>();
    private JdbcTemplate jdbcTemplate;
    private ISymmetricEngine engine;

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }

    public Set<String> routeToNodes(SimpleRouterContext context, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad, boolean initialLoadSelectUsed, TriggerRouter triggerRouter) {
        DataEventType eventType = dataMetaData.getData().getDataEventType();
        if (eventType == DataEventType.INSERT || eventType == DataEventType.UPDATE || eventType == DataEventType.DELETE) {
            Table table = dataMetaData.getTable();
            String tableName = table.getName();
            Table auditTable = this.auditTables.get(tableName);
            if (auditTable == null) {
                auditTable = this.toAuditTable(table, dataMetaData.getTriggerHistory());
                this.auditTables.put(tableName, auditTable);
            }
            String auditTableName = auditTable.getName();
            HashMap<String, Object> values = null;
            values = eventType != DataEventType.DELETE ? new HashMap<String, Object>(this.getNewDataAsObject(null, dataMetaData, this.engine.getSymmetricDialect(), true)) : new HashMap(this.getOldDataAsObject(null, dataMetaData, this.engine.getSymmetricDialect(), true));
            Long sequence = (Long)context.getContextCache().get(auditTableName);
            if (sequence == null) {
                try {
                    sequence = 1L + (Long)this.jdbcTemplate.queryForObject(String.format("select coalesce(max(%s), 0) from %s", COLUMN_AUDIT_ID, auditTableName), Long.class);
                }
                catch (IncorrectResultSizeDataAccessException ex) {
                    sequence = 1L;
                }
            } else {
                sequence = 1L + sequence;
            }
            context.getContextCache().put(auditTableName, sequence);
            values.put(COLUMN_AUDIT_ID, sequence);
            values.put(COLUMN_AUDIT_TIME, new Date());
            values.put(COLUMN_AUDIT_EVENT, eventType.getCode());
            DmlStatement statement = new DmlStatement(DmlStatement.DmlType.INSERT, auditTable.getCatalog(), auditTable.getSchema(), auditTable.getName(), auditTable.getPrimaryKeyColumns(), auditTable.getColumns(), true, "\"", null);
            int[] types = statement.getTypes();
            Object[] args = statement.getValueArray(values);
            String sql = statement.getSql();
            this.jdbcTemplate.update(sql, args, types);
        }
        return null;
    }

    public static Column[] orderColumns(String[] columnNames, Table table) {
        Column[] unorderedColumns = table.getColumns();
        Column[] orderedColumns = new Column[columnNames.length];
        block0: for (int i = 0; i < columnNames.length; ++i) {
            String name = columnNames[i];
            for (Column column : unorderedColumns) {
                if (column == null || !column.getName().equalsIgnoreCase(name)) continue;
                orderedColumns[i] = column;
                continue block0;
            }
        }
        return orderedColumns;
    }

    protected Table toAuditTable(Table table, TriggerHistory triggerHistory) {
        Column[] columns;
        Table auditTable = new Table();
        auditTable.setCatalog(table.getCatalog());
        auditTable.setSchema(table.getSchema());
        String tableName = table.getName();
        auditTable.setName(String.format("%s_AUDIT", tableName));
        Column column = new Column();
        column.setName(COLUMN_AUDIT_ID);
        column.setPrimaryKey(true);
        column.setTypeCode(-5);
        auditTable.addColumn(column);
        column = new Column();
        column.setName(COLUMN_AUDIT_TIME);
        column.setTypeCode(93);
        auditTable.addColumn(column);
        column = new Column();
        column.setName(COLUMN_AUDIT_EVENT);
        column.setTypeCode(1);
        column.setSize("1");
        auditTable.addColumn(column);
        for (Column col : columns = AuditTableDataRouter.orderColumns(triggerHistory.getParsedColumnNames(), table)) {
            if (col == null) continue;
            try {
                column = (Column)col.clone();
                column.setRequired(false);
                column.setPrimaryKey(false);
                auditTable.addColumn(column);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return auditTable;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

