/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp.model;

import com.anfcorp.stores.symmetric.corp.model.TransactionId;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ReturnTransaction {
    private TransactionId id;
    private Set<TransactionId> originalTransactions;
    private Map<TenderBucketType, BigDecimal> tenderBuckets = new HashMap<TenderBucketType, BigDecimal>(TenderBucketType.values().length);

    public ReturnTransaction(TransactionId id) {
        this.id = id;
    }

    public void addToBucket(TenderBucketType id, BigDecimal tenderAmount) {
        BigDecimal sum = this.tenderBuckets.get((Object)id);
        if (sum == null) {
            sum = BigDecimal.ZERO;
        }
        this.tenderBuckets.put(id, sum.add(tenderAmount));
    }

    public TransactionId getId() {
        return this.id;
    }

    public Set<TransactionId> getOriginalTransactions() {
        if (this.originalTransactions == null) {
            this.originalTransactions = new HashSet<TransactionId>();
        }
        return this.originalTransactions;
    }

    public Map<TenderBucketType, BigDecimal> getTenderBuckets() {
        return this.tenderBuckets;
    }

    public boolean isRefund() {
        Collection<BigDecimal> tenders = this.tenderBuckets.values();
        BigDecimal tenderAmount = BigDecimal.ZERO;
        for (BigDecimal t : tenders) {
            tenderAmount = tenderAmount.add(t);
        }
        return tenderAmount.compareTo(BigDecimal.ZERO) <= 0;
    }

    public static enum TenderBucketType {
        CASH,
        CREDIT,
        CHECK,
        DEBIT,
        PAYPAL,
        OTHER;

    }
}

