/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp.format;

import com.anfcorp.stores.symmetric.corp.TemplatedPublisherFilter;
import com.anfcorp.stores.symmetric.corp.cache.TimeZoneCache;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jumpmind.db.model.Table;

public class PeoplesoftTimestampFormat
implements TemplatedPublisherFilter.IFormat {
    static final Log logger = LogFactory.getLog(PeoplesoftTimestampFormat.class);
    static final String[] TO_DATE = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSSSSS"};
    static final String TO_PEOPLESOFT = "yyyy-MM-dd'T'HH:mm:ss.SSSSSS";
    static final FastDateFormat DATETIME_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
    static final FastDateFormat TZ_FORMATTER = FastDateFormat.getInstance((String)"Z");
    private TimeZoneCache timeZoneCache;

    @Override
    public String format(Table table, String[] allData, String data) throws ParseException {
        if (!StringUtils.isBlank((String)data)) {
            if (StringUtils.length((String)data) > 23) {
                logger.info((Object)("truncating peoplesoft time before=" + data));
                data = StringUtils.substring((String)data, (int)0, (int)23);
                logger.info((Object)("truncating peoplesoft time after=" + data));
            }
            Date date = DateUtils.parseDate((String)data, (String[])TO_DATE);
            String offset = "-0000";
            int column = table.getColumnIndex("ID_STR_RT");
            String storeId = null;
            if (column >= 0) {
                storeId = allData[column];
                offset = table.getColumnIndex("TIMEZONE_OFFSET") >= 0 ? TimeZoneCache.sanitizeOffsetForPeoplesoft(allData[table.getColumnIndex("TIMEZONE_OFFSET")]) : this.timeZoneCache.lookupTimeZoneOffSet(storeId);
            }
            if (offset == null) {
                throw new IllegalStateException(String.format("Could not find a timezone offset for the store please check sym_node where external_id='%s'", storeId));
            }
            return DATETIME_FORMATTER.format(date) + offset;
        }
        return data;
    }

    public void setTimeZoneCache(TimeZoneCache timeZoneCache) {
        this.timeZoneCache = timeZoneCache;
    }
}

