/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp.cache;

import com.anfcorp.stores.symmetric.corp.model.TaxAuthorityBean;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class TaxAuthorityCache {
    static final Log logger = LogFactory.getLog(TaxAuthorityCache.class);
    private DataSource dataSource;
    int refreshInterval;
    private String taxAuthoritySql;
    private long lastTimeRefreshed = 0L;
    private Map<BigDecimal, TaxAuthorityBean> cachedTaxAuthority = new HashMap<BigDecimal, TaxAuthorityBean>();
    private JdbcTemplate jdbcTemplate;

    public TaxAuthorityBean getTaxAuthorityBean(BigDecimal taxAuthorityId) {
        logger.debug((Object)("taxAuthorityId=" + taxAuthorityId));
        return this.doGetTaxAuthorityBean(taxAuthorityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaxAuthorityBean doGetTaxAuthorityBean(BigDecimal taxAuthorityId) {
        TaxAuthorityBean ret = null;
        if (this.refreshInterval > 0) {
            this.cacheTaxAuthorityId(taxAuthorityId);
            Map<BigDecimal, TaxAuthorityBean> map = this.cachedTaxAuthority;
            synchronized (map) {
                if (this.cachedTaxAuthority.containsKey(taxAuthorityId)) {
                    ret = this.cachedTaxAuthority.get(taxAuthorityId);
                }
            }
        } else {
            ret = this.getTaxAuthorityBean(this.getListOfTaxAuthorityBean(taxAuthorityId));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheTaxAuthorityId(BigDecimal taxAuthorityId) {
        long timeRightNow = Calendar.getInstance().getTimeInMillis();
        Map<BigDecimal, TaxAuthorityBean> map = this.cachedTaxAuthority;
        synchronized (map) {
            if (timeRightNow > this.lastTimeRefreshed + (long)this.refreshInterval) {
                this.setTaxAuthorityCache(taxAuthorityId);
            }
        }
    }

    private void setTaxAuthorityCache(BigDecimal taxAuthorityId) {
        try {
            TaxAuthorityBean taxAuthority = this.getTaxAuthorityBean(this.getListOfTaxAuthorityBean(taxAuthorityId));
            this.lastTimeRefreshed = Calendar.getInstance().getTimeInMillis();
            this.cachedTaxAuthority.put(taxAuthority.getTaxAuthorityId(), taxAuthority);
            logger.debug((Object)("cachedTaxAuthority=" + this.cachedTaxAuthority));
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
    }

    private List<Map<String, Object>> getListOfTaxAuthorityBean(BigDecimal taxAuthorityId) {
        if (this.jdbcTemplate == null) {
            this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        }
        return this.jdbcTemplate.queryForList(this.taxAuthoritySql, new Object[]{taxAuthorityId});
    }

    private TaxAuthorityBean getTaxAuthorityBean(List<Map<String, Object>> list) {
        Vector<TaxAuthorityBean> ret = new Vector<TaxAuthorityBean>();
        for (Map<String, Object> map : list) {
            TaxAuthorityBean tax = new TaxAuthorityBean();
            tax.setRoundingCode(((BigDecimal)map.get("SC_RND")).intValue());
            tax.setRoundingDigitQuantity((BigDecimal)map.get("QU_DGT_RND"));
            tax.setTaxAuthorityId((BigDecimal)map.get("ID_ATHY_TX"));
            ret.add(tax);
        }
        return ret.size() > 0 ? (TaxAuthorityBean)ret.get(0) : null;
    }

    public void setRefreshInterval(int refreshIntervalInSeconds) {
        this.refreshInterval = refreshIntervalInSeconds * 1000;
    }

    public void setTaxAuthoritySql(String taxAuthoritySql) {
        this.taxAuthoritySql = taxAuthoritySql;
    }

    public int getRefreshInterval() {
        return this.refreshInterval / 1000;
    }

    public String getTaxAuthoritySql() {
        return this.taxAuthoritySql;
    }

    public Map<BigDecimal, TaxAuthorityBean> getCachedTaxAuthority() {
        return this.cachedTaxAuthority;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

