/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp.cache;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class IPosStoreToGeoCodeCache {
    static final Log logger = LogFactory.getLog(IPosStoreToGeoCodeCache.class);
    private DataSource dataSource;
    int refreshInterval;
    private String iposStoreSql;
    private long lastTimeRefreshed = 0L;
    private Map<String, String> cachedIposStores = new HashMap<String, String>();
    private JdbcTemplate jdbcTemplate;

    public String getGeoCode(String id_str_rt) {
        logger.debug((Object)("id_str_rt=" + id_str_rt));
        return this.doGetGeoCode(id_str_rt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doGetGeoCode(String id_str_rt) {
        String ret = null;
        this.cacheIposStore();
        Map<String, String> map = this.cachedIposStores;
        synchronized (map) {
            if (this.cachedIposStores.containsKey(id_str_rt)) {
                ret = this.cachedIposStores.get(id_str_rt);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheIposStore() {
        long timeRightNow = Calendar.getInstance().getTimeInMillis();
        Map<String, String> map = this.cachedIposStores;
        synchronized (map) {
            if (timeRightNow > this.lastTimeRefreshed + (long)this.refreshInterval) {
                this.setIposStoreCache();
            }
        }
    }

    private void setIposStoreCache() {
        try {
            if (this.jdbcTemplate == null) {
                this.jdbcTemplate = new JdbcTemplate(this.dataSource);
            }
            List listCache = this.jdbcTemplate.queryForList(this.iposStoreSql);
            this.lastTimeRefreshed = Calendar.getInstance().getTimeInMillis();
            this.cachedIposStores.clear();
            for (Map map : listCache) {
                this.cachedIposStores.put((String)map.get("ID_STR_RT"), (String)map.get("ID_CD_GEO"));
            }
            logger.debug((Object)("cachedIposStores=" + this.cachedIposStores));
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
    }

    public void setRefreshInterval(int refreshIntervalInSeconds) {
        this.refreshInterval = refreshIntervalInSeconds * 1000;
    }

    public void setIposStoreSql(String iposStoreSql) {
        this.iposStoreSql = iposStoreSql;
    }

    public int getRefreshInterval() {
        return this.refreshInterval / 1000;
    }

    public String getIposStoreSql() {
        return this.iposStoreSql;
    }

    public Map<String, String> getCachedIposStores() {
        return this.cachedIposStores;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

