/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp.cache;

import com.anfcorp.stores.symmetric.corp.model.CurrencyBean;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class CurrencyCache {
    static final Log logger = LogFactory.getLog(CurrencyCache.class);
    private DataSource dataSource;
    int refreshInterval;
    private String currencySql;
    private String currencySqlForCurrencyCode;
    private long lastTimeRefreshed = 0L;
    private Map<BigDecimal, CurrencyBean> cachedCurrency = new HashMap<BigDecimal, CurrencyBean>();
    private JdbcTemplate jdbcTemplate;

    public CurrencyBean getCurrencyBean(BigDecimal currencyId) {
        logger.debug((Object)("currencyId=" + currencyId));
        return this.doGetCurrencyBean(currencyId);
    }

    public CurrencyBean getCurrencyBeanForCurrencyCode(String isoCurrencyCode) {
        logger.debug((Object)("currencyCode=" + isoCurrencyCode));
        return this.doGetCurrencyBeanForCurrencyCode(isoCurrencyCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CurrencyBean doGetCurrencyBean(BigDecimal currencyId) {
        CurrencyBean ret = null;
        if (this.refreshInterval > 0) {
            this.cacheCurrencyId(currencyId);
            Map<BigDecimal, CurrencyBean> map = this.cachedCurrency;
            synchronized (map) {
                if (this.cachedCurrency.containsKey(currencyId)) {
                    ret = this.cachedCurrency.get(currencyId);
                }
            }
        } else {
            ret = this.getCurrencyBean(this.getListOfCurrencyBean(currencyId));
        }
        return ret;
    }

    protected CurrencyBean doGetCurrencyBeanForCurrencyCode(String currencyCode) {
        CurrencyBean ret = null;
        ret = this.getCurrencyBean(this.getListOfCurrencyBeanForCurrencyCode(currencyCode));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheCurrencyId(BigDecimal currencyId) {
        long timeRightNow = Calendar.getInstance().getTimeInMillis();
        Map<BigDecimal, CurrencyBean> map = this.cachedCurrency;
        synchronized (map) {
            if (timeRightNow > this.lastTimeRefreshed + (long)this.refreshInterval) {
                this.setCurrencyCache(currencyId);
            }
        }
    }

    private void setCurrencyCache(BigDecimal currencyId) {
        try {
            CurrencyBean currencyBean = this.getCurrencyBean(this.getListOfCurrencyBean(currencyId));
            this.lastTimeRefreshed = Calendar.getInstance().getTimeInMillis();
            this.cachedCurrency.put(currencyBean.getCurrencyId(), currencyBean);
            logger.debug((Object)("cachedCurrency=" + this.cachedCurrency));
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
    }

    private List<Map<String, Object>> getListOfCurrencyBean(BigDecimal currencyId) {
        if (this.jdbcTemplate == null) {
            this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        }
        return this.jdbcTemplate.queryForList(this.currencySql, new Object[]{currencyId});
    }

    private List<Map<String, Object>> getListOfCurrencyBeanForCurrencyCode(String isoCurrencyCode) {
        if (this.jdbcTemplate == null) {
            this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        }
        return this.jdbcTemplate.queryForList(this.currencySqlForCurrencyCode, new Object[]{isoCurrencyCode});
    }

    private CurrencyBean getCurrencyBean(List<Map<String, Object>> list) {
        Vector<CurrencyBean> ret = new Vector<CurrencyBean>();
        for (Map<String, Object> map : list) {
            CurrencyBean currency = new CurrencyBean();
            currency.setCurrencyId((BigDecimal)map.get("ID_CNY_ICD"));
            currency.setCurrencyScale(((BigDecimal)map.get("QU_CNY_SCLE")).intValue());
            currency.setIsoCurrencyCode((String)map.get("CD_CNY_ISO"));
            currency.setIsoCurrencyNum((String)map.get("NUM_CNY_ISO"));
            ret.add(currency);
        }
        return ret.size() > 0 ? (CurrencyBean)ret.get(0) : null;
    }

    public void setRefreshInterval(int refreshIntervalInSeconds) {
        this.refreshInterval = refreshIntervalInSeconds * 1000;
    }

    public void setCurrencySql(String currencySql) {
        this.currencySql = currencySql;
    }

    public void setCurrencySqlForCurrencyCode(String currencySqlForCurrencyCode) {
        this.currencySqlForCurrencyCode = currencySqlForCurrencyCode;
    }

    public int getRefreshInterval() {
        return this.refreshInterval / 1000;
    }

    public String getCurrencySql() {
        return this.currencySql;
    }

    public Map<BigDecimal, CurrencyBean> getCachedCurrency() {
        return this.cachedCurrency;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

