/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp;

import java.text.ParseException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.symmetric.integrate.AbstractTextPublisherDataLoaderFilter;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;

public class TemplatedPublisherFilter
extends AbstractTextPublisherDataLoaderFilter {
    static final Log logger = LogFactory.getLog(TemplatedPublisherFilter.class);
    private String headerTableTemplate;
    private String footerTableTemplate;
    private String contentTableTemplate;
    private Map<String, IFormat> columnNameToDataFormatter;
    private boolean processDelete = true;
    private boolean processInsert = true;
    private boolean processUpdate = true;
    private IDatabaseWriterFilter dataFilter;

    protected String addTextElement(DataContext ctx, Table table, CsvData data) {
        if (this.dataFilter == null || this.dataFilter.beforeWrite(ctx, table, data)) {
            String template = null;
            if (this.processDelete && data.getDataEventType() == DataEventType.DELETE) {
                template = this.contentTableTemplate;
                if (template != null) {
                    template = this.fillOutTemplate(DmlStatement.DmlType.DELETE, template, table, null, data.getParsedData("pkData"));
                }
            } else if (this.processInsert && data.getDataEventType() == DataEventType.INSERT) {
                template = this.contentTableTemplate;
                if (template != null) {
                    template = this.fillOutTemplate(DmlStatement.DmlType.INSERT, template, table, data.getParsedData("rowData"), null);
                }
            } else if (this.processUpdate && data.getDataEventType() == DataEventType.DELETE && (template = this.contentTableTemplate) != null) {
                template = this.fillOutTemplate(DmlStatement.DmlType.UPDATE, template, table, data.getParsedData("rowData"), data.getParsedData("pkData"));
            }
            return template;
        }
        return null;
    }

    protected String addTextFooter(DataContext ctx) {
        return this.footerTableTemplate;
    }

    protected String addTextHeader(DataContext ctx) {
        return this.headerTableTemplate;
    }

    protected String fillOutTemplate(DmlStatement.DmlType dmlType, String template, Table table, String[] data, String[] keys) {
        String[] colNames = null;
        if (data == null) {
            colNames = table.getPrimaryKeyColumnNames();
            data = keys;
        } else {
            colNames = table.getColumnNames();
        }
        for (int i = 0; i < data.length; ++i) {
            String col = colNames[i];
            template = this.replace(template, col, this.format(table, data, col, data[i]));
        }
        template = template.replace("DMLTYPE", dmlType.name());
        template = template.replace("TIMESTAMP", Long.toString(System.currentTimeMillis()));
        return template;
    }

    protected String format(Table table, String[] allData, String col, String data) {
        IFormat formatter;
        if (this.columnNameToDataFormatter != null && (formatter = this.columnNameToDataFormatter.get(col)) != null) {
            try {
                data = formatter.format(table, allData, data);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return data;
    }

    protected String replace(String template, String token, String value) {
        if (value == null) {
            value = "";
        }
        if (template != null) {
            template = template.replace("%" + token + "%", value);
        }
        return template;
    }

    public void setColumnNameToDataFormatter(Map<String, IFormat> columnNameToDataFormatter) {
        this.columnNameToDataFormatter = columnNameToDataFormatter;
    }

    public void setProcessDelete(boolean processDeletes) {
        this.processDelete = processDeletes;
    }

    public void setProcessInsert(boolean processInserts) {
        this.processInsert = processInserts;
    }

    public void setProcessUpdate(boolean processUpdates) {
        this.processUpdate = processUpdates;
    }

    public void setHeaderTableTemplate(String headerTableTemplate) {
        this.headerTableTemplate = headerTableTemplate;
    }

    public void setFooterTableTemplate(String footerTableTemplate) {
        this.footerTableTemplate = footerTableTemplate;
    }

    public void setContentTableTemplate(String contentTableTemplate) {
        this.contentTableTemplate = contentTableTemplate;
    }

    public void setDataFilter(IDatabaseWriterFilter dataFilter) {
        this.dataFilter = dataFilter;
    }

    public static interface IFormat {
        public String format(Table var1, String[] var2, String var3) throws ParseException;
    }
}

