/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.INodeGroupExtensionPoint;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.load.IReloadListener;
import org.jumpmind.symmetric.model.Node;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class ReloadListener
implements IReloadListener,
INodeGroupExtensionPoint,
ISymmetricEngineAware {
    static final Log logger = LogFactory.getLog(ReloadListener.class);
    DataSource dataSource;
    String selectMaxAlertIdIdSql;
    String dropSequenceSql;
    String createSequenceSql;
    String selectStagingIdlStoreSql;
    String insertStagingIdlStoreSql;
    private String updateStatementToRunOnWorkstationSql = null;
    private String selectTransactionNumberFromRegionSql = null;
    ISymmetricEngine engine;

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }

    public void afterReload(ISqlTransaction transaction, Node node, long loadId) {
        if (node.getNodeGroupId().equals("region")) {
            JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
            String storeId = node.getExternalId();
            int startId = (Integer)jdbcTemplate.queryForObject(this.selectMaxAlertIdIdSql, Integer.class, new Object[]{storeId}) + 1;
            this.engine.getDataService().insertSqlEvent(transaction, node, this.dropSequenceSql, true, -1L, "reload");
            this.engine.getDataService().insertSqlEvent(transaction, node, this.createSequenceSql.replace("%BEGIN_ID%", Integer.toString(startId)), true, -1L, "reload");
        } else if (!StringUtils.isBlank((String)node.getNodeId()) && node.getNodeId().length() == 9 && node.getNodeGroupId().equals("till")) {
            try {
                HashMap<String, String> params = new HashMap<String, String>(2);
                params.put("ID_STR_RT", node.getNodeId().substring(0, 5));
                params.put("ID_WS", node.getNodeId().substring(6, 9));
                NamedParameterJdbcTemplate template = new NamedParameterJdbcTemplate(this.dataSource);
                int transactionNumber = (Integer)template.queryForObject(this.selectTransactionNumberFromRegionSql, params, Integer.class);
                this.engine.getDataService().insertSqlEvent(transaction, node, StringUtils.replace((String)this.updateStatementToRunOnWorkstationSql, (String)"%region.ai_trn%", (String)Integer.toString(transactionNumber)), true, -1L, "listener");
            }
            catch (IncorrectResultSizeDataAccessException ex) {
                logger.info((Object)("Could not calculate the max ai_trn for " + node.getNodeId()));
            }
        }
    }

    public void beforeReload(ISqlTransaction transaction, Node node, long loadId) {
        String storeId = node.getExternalId();
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        List results = jdbcTemplate.queryForList(this.selectStagingIdlStoreSql, String.class, new Object[]{storeId});
        if (CollectionUtils.isEmpty((Collection)results)) {
            jdbcTemplate.update(this.insertStagingIdlStoreSql, new Object[]{storeId});
        }
    }

    public String[] getNodeGroupIdsToApplyTo() {
        return new String[]{"corp"};
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setSelectMaxAlertIdIdSql(String selectMaxAuditIdSql) {
        this.selectMaxAlertIdIdSql = selectMaxAuditIdSql;
    }

    public void setDropSequenceSql(String dropSequenceSql) {
        this.dropSequenceSql = dropSequenceSql;
    }

    public void setCreateSequenceSql(String createSequenceSql) {
        this.createSequenceSql = createSequenceSql;
    }

    public void setSelectTransactionNumberFromRegionSql(String selectTransactionNumberFromRegionSql) {
        this.selectTransactionNumberFromRegionSql = selectTransactionNumberFromRegionSql;
    }

    public void setUpdateStatementToRunOnWorkstationSql(String updateStatementToRunOnWorkstationSql) {
        this.updateStatementToRunOnWorkstationSql = updateStatementToRunOnWorkstationSql;
    }

    public void setSelectStagingIdlStoreSql(String selectStagingIdlStoreSql) {
        this.selectStagingIdlStoreSql = selectStagingIdlStoreSql;
    }

    public void setInsertStagingIdlStoreSql(String insertStagingIdlStoreSql) {
        this.insertStagingIdlStoreSql = insertStagingIdlStoreSql;
    }
}

