/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterFilterAdapter;
import org.springframework.jdbc.core.JdbcTemplate;

public class PasswordSyncFilter
extends DatabaseWriterFilterAdapter {
    private DataSource dataSource;
    private String insertSql;
    private static final String CACHE_KEY = PasswordSyncFilter.class.getName();

    public boolean beforeWrite(DataContext context, Table table, CsvData data) {
        if (table.getName().equalsIgnoreCase("ANF_PA_EM_PWD") && data.getDataEventType() == DataEventType.UPDATE) {
            String[] columnValues = data.getParsedData("rowData");
            String employeeId = columnValues[table.getColumnIndex("ID_EM")];
            String employeePwd = columnValues[table.getColumnIndex("EMPLOYEE_PWD")];
            this.getPasswordChangeMap(context).put(employeeId, employeePwd);
        }
        return true;
    }

    protected Map<String, String> getPasswordChangeMap(DataContext context) {
        HashMap passwords = (HashMap)context.get(CACHE_KEY);
        if (passwords == null) {
            passwords = new HashMap();
            context.put(CACHE_KEY, passwords);
        }
        return passwords;
    }

    public void batchComplete(DataContext context) {
        Map<String, String> passwords = this.getPasswordChangeMap(context);
        for (String employeeId : passwords.keySet()) {
            this.createPwdEvent(employeeId, passwords.get(employeeId));
        }
        passwords.clear();
    }

    protected void createPwdEvent(String employeeId, String employeePwd) {
        String tableKey = "ID_EM=" + employeeId;
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        template.update(this.insertSql, new Object[]{tableKey, employeePwd});
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String[] getNodeGroupIdsToApplyTo() {
        return new String[]{"corp"};
    }

    public void setInsertSql(String insertSql) {
        this.insertSql = insertSql;
    }
}

