/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp;

import com.anfcorp.stores.encryption.client.service.StoresSecurityHelper;
import com.anfcorp.stores.signature.SignatureFactory;
import com.anfcorp.stores.signature.ThreeByteAsciiSignature;
import com.anfcorp.stores.signature.UnknownSignatureTypeException;
import com.anfcorp.stores.symmetric.corp.cache.CurrencyCache;
import com.anfcorp.stores.symmetric.corp.cache.ParameterCache;
import com.anfcorp.stores.symmetric.corp.cache.TaxAuthorityCache;
import com.anfcorp.stores.symmetric.corp.model.CurrencyBean;
import com.anfcorp.stores.symmetric.corp.model.ParameterBean;
import com.anfcorp.stores.symmetric.corp.model.TaxAuthorityBean;
import com.anfcorp.stores.symmetric.corp.model.TrLtmSlsRtn;
import com.anfcorp.stores.symmetric.corp.model.TrLtmSlsRtnTx;
import com.anfcorp.stores.symmetric.corp.model.TrRtl;
import com.anfcorp.stores.symmetric.mail.MailSender;
import java.io.File;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.spec.SecretKeySpec;
import javax.sql.DataSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.integrate.XmlPublisherDatabaseWriterFilter;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.util.Context;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class OutboundSalesXmlPublisherFilter
extends XmlPublisherDatabaseWriterFilter {
    public static final DateTimeFormatter outputFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private DataSource dataSource;
    private Set<String> tableNamesToPublishAsGroup;
    private List<String> groupByColumnNames;
    private TaxAuthorityCache taxAuthorityCache;
    private CurrencyCache currencyCache;
    private MailSender mailSender;
    private ParameterCache parameterCache;
    static final Log logger = LogFactory.getLog(OutboundSalesXmlPublisherFilter.class);
    static final String EXCEPTION = "Exception in OutboundSalesXmlPublisherFilter";
    static final String NODE_ID_TYPE_IGNORE = "IGNORE";
    static final String NODE_ID_TYPE_IGNOREME = "IGNOREME";
    static final int MAX_GIFT_CARD_LENGTH = 16;
    static StoresSecurityHelper helper = StoresSecurityHelper.getInstance();
    static List<SecretKeySpec> secretKeySpecList = null;
    private boolean sendEmailOnError = false;
    private String environment;
    private String testCreditCardNumber;
    private String aesKeyFile;

    public void setAesKeyFile(String keyFile) {
        this.aesKeyFile = keyFile;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setTableNamesToPublishAsGroup(Set<String> tableNamesToPublishAsGroup) {
        super.setTableNamesToPublishAsGroup(tableNamesToPublishAsGroup);
        this.tableNamesToPublishAsGroup = tableNamesToPublishAsGroup;
    }

    public Set<String> getTableNamesToPublishAsGroup() {
        return this.tableNamesToPublishAsGroup;
    }

    public void setGroupByColumnNames(List<String> groupByColumnNames) {
        super.setGroupByColumnNames(groupByColumnNames);
        this.groupByColumnNames = groupByColumnNames;
    }

    public List<String> getGroupByColumnNames() {
        return this.groupByColumnNames;
    }

    public void setTaxAuthorityCache(TaxAuthorityCache taxAuthorityCache) {
        this.taxAuthorityCache = taxAuthorityCache;
    }

    public void setCurrencyCache(CurrencyCache currencyCache) {
        this.currencyCache = currencyCache;
    }

    private void sendEmailAboutError(String errorMessage, String errorType) {
        if (this.sendEmailOnError) {
            this.mailSender.sendMail(errorMessage, errorType);
        }
    }

    private String getStackTrace(Throwable t) {
        if (t != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(t.getClass().getName()).append(": ").append(this.escapeIllegalCharacters(t.getMessage()));
            StackTraceElement[] stack = t.getStackTrace();
            for (int i = 0; i < stack.length; ++i) {
                StackTraceElement e = stack[i];
                sb.append("  at ").append(e.getClassName()).append(".").append(e.getMethodName()).append("(").append(e.getFileName()).append(" ").append(e.getLineNumber()).append(")\n");
            }
            return sb.toString();
        }
        return "";
    }

    private String escapeIllegalCharacters(String info) {
        if (info == null) {
            return "";
        }
        info = info.replaceAll("'", "''");
        info = info.replaceAll("\"", "''");
        return info;
    }

    public boolean beforeWrite(DataContext ctx, Table table, CsvData data) {
        if (this.tableNamesToPublishAsGroup.contains(table.getName())) {
            String[] values = data.getParsedData("rowData");
            if (data.getDataEventType() == DataEventType.UPDATE) {
                if ("TR_LTM_CRDB_CRD_TN".equalsIgnoreCase(table.getName()) || "TR_LTM_CHK_TND".equalsIgnoreCase(table.getName()) || "ANF_TR_MID_PCKUP".equalsIgnoreCase(table.getName())) {
                    values = this.getConvertedSignatureText(table, ctx, values);
                    values = this.getDecryptedCCExpDate(table, ctx, values);
                    values = this.getCCEncryptedNumber(table, ctx, values);
                    values = this.getConvertedCreditDebitTenderLineItem(table, ctx, values);
                    values = this.getConvertedDCCInformation(table, ctx, values);
                    values = this.getFormattedDateTimes(table, ctx, values);
                    data = data.copyWithoutOldData();
                    data.putParsedData("rowData", values);
                    return super.beforeWrite(ctx, table, data);
                }
            } else if (data.getDataEventType() == DataEventType.INSERT) {
                if (ctx != null && table.getName() != null && table.getName().equalsIgnoreCase("TR_TRN")) {
                    String TY_TRN = values[table.getColumnIndex("TY_TRN")];
                    ctx.put("TY_TRN", (Object)TY_TRN);
                }
                values = this.getDecryptedCCExpDate(table, ctx, values);
                values = this.getCCEncryptedNumber(table, ctx, values);
                values = this.getDecryptedGiftCardNumber(table, ctx, values);
                values = this.getConvertedSignatureText(table, ctx, values);
                values = this.getConvertedCreditDebitTenderLineItem(table, ctx, values);
                values = this.getConvertedDCCInformation(table, ctx, values);
                values = this.getFormattedDateTimes(table, ctx, values);
                data = data.copyWithoutOldData();
                data.putParsedData("rowData", values);
                return super.beforeWrite(ctx, table, data);
            }
        }
        return true;
    }

    private String[] getConvertedDCCInformation(Table table, DataContext ctx, String[] data) {
        if (ctx != null && "TR_LTM_TND".equalsIgnoreCase(table.getName())) {
            String foreignCurrencyCode;
            boolean dccTransaction = false;
            String newExchangeRate = null;
            String newForeignAmountTendered = null;
            String newForeignCurrencyCode = null;
            CurrencyBean currencyBean = null;
            if (table.getColumnIndex("DE_FRG_CNY") != -1 && StringUtils.isNotBlank((String)(foreignCurrencyCode = data[table.getColumnIndex("DE_FRG_CNY")]))) {
                dccTransaction = true;
                currencyBean = this.currencyCache.getCurrencyBeanForCurrencyCode(foreignCurrencyCode);
                if (currencyBean == null || StringUtils.isBlank((String)currencyBean.getIsoCurrencyNum())) {
                    logger.error((Object)("Currency or ISO Currency Number is not configured in CO_CNY for " + foreignCurrencyCode + " Setting to 000"));
                    newForeignCurrencyCode = "000";
                } else {
                    newForeignCurrencyCode = currencyBean.getIsoCurrencyNum();
                }
            }
            if (dccTransaction) {
                Formatter formatter;
                StringBuilder sb;
                if (table.getColumnIndex("MO_RT_TO_BUY") != -1) {
                    newExchangeRate = data[table.getColumnIndex("MO_RT_TO_BUY")];
                    int decimalPlaces = newExchangeRate.indexOf(46);
                    decimalPlaces = decimalPlaces == -1 ? 0 : newExchangeRate.length() - decimalPlaces - 1;
                    newExchangeRate = newExchangeRate.replace(".", "");
                    sb = new StringBuilder();
                    formatter = new Formatter(sb);
                    formatter.format("%1d%7s", decimalPlaces, newExchangeRate);
                    newExchangeRate = sb.toString();
                    newExchangeRate = newExchangeRate.replaceAll(" ", "0");
                    if (newExchangeRate.length() > 8) {
                        logger.error((Object)("Truncating the formatted exchange rate to 8 chars.  Investigate why exchange rate is too long: " + newExchangeRate));
                        newExchangeRate = newExchangeRate.substring(0, 8);
                    }
                }
                if (table.getColumnIndex("FRG_MO_ITM_LN_TND") != -1) {
                    String foreignAmountTendered = data[table.getColumnIndex("FRG_MO_ITM_LN_TND")];
                    if (currencyBean != null) {
                        sb = new StringBuilder();
                        formatter = new Formatter(sb);
                        formatter.format("%." + currencyBean.getCurrencyScale() + "f", Float.valueOf(foreignAmountTendered));
                        foreignAmountTendered = sb.toString();
                    }
                    newForeignAmountTendered = foreignAmountTendered.replace(".", "");
                }
                if (newExchangeRate != null || newForeignAmountTendered != null || newExchangeRate != null) {
                    String[] newData = new String[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        newData[i] = data[i];
                    }
                    if (newExchangeRate != null) {
                        logger.info((Object)("Transformed exchange rate from " + data[table.getColumnIndex("MO_RT_TO_BUY")] + " to <" + newExchangeRate + ">"));
                        newData[table.getColumnIndex((String)"MO_RT_TO_BUY")] = newExchangeRate;
                    }
                    if (newForeignAmountTendered != null) {
                        logger.info((Object)("Transformed foreign amount tendered from " + data[table.getColumnIndex("FRG_MO_ITM_LN_TND")] + " to <" + newForeignAmountTendered + ">"));
                        newData[table.getColumnIndex((String)"FRG_MO_ITM_LN_TND")] = newForeignAmountTendered;
                    }
                    if (newExchangeRate != null) {
                        logger.info((Object)("Transformed foreign currency tendered from " + data[table.getColumnIndex("DE_FRG_CNY")] + " to <" + newForeignCurrencyCode + ">"));
                        newData[table.getColumnIndex((String)"DE_FRG_CNY")] = newForeignCurrencyCode;
                    }
                    data = newData;
                }
            }
        }
        return data;
    }

    private String[] getConvertedSignatureText(Table table, DataContext ctx, String[] data) {
        String signatureText;
        if (ctx != null && table.getName() != null && "TR_LTM_CRDB_CRD_TN".equalsIgnoreCase(table.getName()) && table.getColumnIndex("CH_IM_TND_AZN_CT") != -1 && (signatureText = data[table.getColumnIndex("CH_IM_TND_AZN_CT")]) != null && signatureText.trim().length() > 0) {
            String decodedSignatureText = null;
            String nodeId = ctx.getBatch().getSourceNodeId();
            if (nodeId != null && !"store21".equals(nodeId)) {
                try {
                    decodedSignatureText = new String(Base64.decodeBase64((byte[])signatureText.getBytes()));
                }
                catch (Throwable e) {
                    decodedSignatureText = signatureText;
                }
            } else {
                decodedSignatureText = signatureText;
            }
            if (decodedSignatureText != null && decodedSignatureText.trim().length() > 0 && !"null".equals(decodedSignatureText)) {
                String newSignature = null;
                try {
                    newSignature = SignatureFactory.convert((String)decodedSignatureText, ThreeByteAsciiSignature.class);
                }
                catch (UnknownSignatureTypeException e) {
                    logger.info((Object)e, (Throwable)e);
                }
                if (newSignature != null) {
                    String[] newData = new String[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        newData[i] = data[i];
                    }
                    newData[table.getColumnIndex((String)"CH_IM_TND_AZN_CT")] = newSignature;
                    data = newData;
                }
            }
        }
        return data;
    }

    private String[] getConvertedCreditDebitTenderLineItem(Table table, DataContext ctx, String[] data) {
        if (ctx != null && table.getName() != null && "TR_LTM_CRDB_CRD_TN".equalsIgnoreCase(table.getName()) && table.getColumnIndex("ID_ISSR_TND_MD") != -1) {
            int nameIndex;
            String encodedIdentifier;
            String creditCardType = data[table.getColumnIndex("ID_ISSR_TND_MD")];
            data = this.copy(data);
            this.mapResaCards(table, ctx, data);
            if (!StringUtils.isBlank((String)creditCardType) && !StringUtils.isBlank((String)(encodedIdentifier = data[table.getColumnIndex("LU_AZN_STLM_DT")]))) {
                String decodedIdentifier = null;
                try {
                    decodedIdentifier = new String(Base64.decodeBase64((byte[])encodedIdentifier.getBytes()));
                    decodedIdentifier = StringUtils.remove((String)decodedIdentifier, (char)'\u001c');
                    decodedIdentifier = StringUtils.remove((String)decodedIdentifier, (char)'\u001f');
                }
                catch (Throwable e) {
                    decodedIdentifier = encodedIdentifier;
                }
                data[table.getColumnIndex((String)"LU_AZN_STLM_DT")] = decodedIdentifier;
            }
            if ((nameIndex = table.getColumnIndex("ANF_NM_PYE")) != -1) {
                data[nameIndex] = this.removeNonAlphaNumberic(data[nameIndex]);
            }
        }
        return data;
    }

    private String removeNonAlphaNumberic(String name) {
        if (StringUtils.isNotBlank((String)name) && !StringUtils.isAlphanumericSpace((String)name)) {
            StringBuilder newName = new StringBuilder();
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (!Character.isLetterOrDigit(c) && c != ' ') continue;
                newName.append(c);
            }
            name = newName.toString();
        }
        return name;
    }

    private String[] copy(String[] data) {
        String[] newData = new String[data.length];
        for (int i = 0; i < data.length; ++i) {
            newData[i] = data[i];
        }
        return newData;
    }

    private void mapResaCards(Table table, DataContext ctx, String[] data) {
        if (ctx != null && table.getName() != null && table.getName().equalsIgnoreCase("TR_LTM_CRDB_CRD_TN")) {
            String tender;
            String issuer = data[table.getColumnIndex("ID_ISSR_TND_MD")];
            if (issuer != null) {
                if (issuer.contains("Maestro Int")) {
                    data[table.getColumnIndex((String)"TY_TND")] = "DBIT";
                }
                if (issuer.contains("Solo")) {
                    data[table.getColumnIndex((String)"TY_TND")] = "DBIT";
                }
                if (issuer.contains("UK Maestro")) {
                    data[table.getColumnIndex((String)"TY_TND")] = "DBIT";
                }
                if (issuer.contains("Visa Debit")) {
                    data[table.getColumnIndex((String)"TY_TND")] = "DBIT";
                }
                if (issuer.contains("Visa Electron")) {
                    data[table.getColumnIndex((String)"TY_TND")] = "DBIT";
                }
            }
            if ((tender = data[table.getColumnIndex("TY_TND")]) == "DBIT" || "DBIT".equals(tender)) {
                data[table.getColumnIndex((String)"TY_TND")] = "DBIT";
                data[table.getColumnIndex((String)"ID_ISSR_TND_MD")] = "DEBITCARD";
            }
        }
    }

    private String[] getCCEncryptedNumber(Table table, DataContext ctx, String[] data) {
        if (ctx != null && table.getName() != null && table.getName().equalsIgnoreCase("TR_LTM_CRDB_CRD_TN")) {
            String encryptedNumber = data[table.getColumnIndex("ID_NCRPT_ACNT_CRD")];
            boolean isTokenized = StringUtils.equalsIgnoreCase((String)data[table.getColumnIndex("TY_AUTH_ENC")], (String)"T");
            boolean isUnknown = StringUtils.equalsIgnoreCase((String)data[table.getColumnIndex("TY_AUTH_ENC")], (String)"U");
            boolean isOffline = StringUtils.equalsIgnoreCase((String)data[table.getColumnIndex("TY_AUTH_ENC")], (String)"G");
            if (!(encryptedNumber == null || isTokenized || isUnknown || isOffline)) {
                String encriptedNumber15 = null;
                try {
                    if (!"TEST".equalsIgnoreCase(this.environment)) {
                        logger.info((Object)"Tring to Encrypted the credit card number ");
                        encriptedNumber15 = encryptedNumber;
                        logger.info((Object)"Encrypted the credit card number successfully");
                    } else {
                        encriptedNumber15 = this.testCreditCardNumber;
                    }
                }
                catch (Throwable e) {
                    logger.error((Object)"Failed to encript the credit card number using header 1.5", e);
                    this.sendEmailAboutError(this.getStackTrace(e), EXCEPTION);
                    throw new RuntimeException(e);
                }
                String[] newData = new String[data.length];
                for (int i = 0; i < data.length; ++i) {
                    newData[i] = data[i];
                }
                newData[table.getColumnIndex((String)"ID_NCRPT_ACNT_CRD")] = encriptedNumber15;
                data = newData;
            }
        }
        return data;
    }

    private String[] getDecryptedCCExpDate(Table table, DataContext ctx, String[] data) {
        String FUTURE_DATE = "1250";
        if (ctx != null && table.getName() != null && table.getName().equalsIgnoreCase("TR_LTM_CRDB_CRD_TN")) {
            String encryptedDate = data[table.getColumnIndex("DC_EP_NCRPT_CRD")];
            int encryptionTypeIndex = table.getColumnIndex("TY_AUTH_ENC");
            boolean p2pEncrypted = false;
            if (encryptionTypeIndex != -1) {
                p2pEncrypted = StringUtils.equalsIgnoreCase((String)data[encryptionTypeIndex], (String)"P");
            }
            int id_ws = 0;
            try {
                id_ws = Integer.parseInt(data[table.getColumnIndex("ID_WS")]);
            }
            catch (NumberFormatException e) {
                logger.error((Object)("Unable to parse workstation ID value: " + data[table.getColumnIndex("ID_WS")]));
            }
            if (encryptedDate != null) {
                Object decriptedExpDate = null;
                try {
                    logger.info((Object)("trying to use the cryption util to decrypt data" + encryptedDate));
                    decriptedExpDate = this.decrypt(encryptedDate, true);
                    logger.info((Object)("decrypt was succesful for - " + encryptedDate));
                    try {
                        if (((String)decriptedExpDate).length() == 5) {
                            mm = ((String)decriptedExpDate).substring(0, 2);
                            yy = ((String)decriptedExpDate).substring(3, 5);
                            decriptedExpDate = Integer.parseInt(mm) == 0 || Integer.parseInt(yy) == 0 || Integer.parseInt(mm) > 12 || Integer.parseInt(yy) < 9 ? "1250" : mm + yy;
                        } else if (((String)decriptedExpDate).length() == 4) {
                            if (StringUtils.containsOnly((String)decriptedExpDate, (String)"0")) {
                                decriptedExpDate = "1250";
                            } else if (id_ws > 50 || p2pEncrypted) {
                                String yy = ((String)decriptedExpDate).substring(0, 2);
                                String mm = ((String)decriptedExpDate).substring(2, 4);
                                decriptedExpDate = mm + yy;
                            } else {
                                mm = ((String)decriptedExpDate).substring(0, 2);
                                yy = ((String)decriptedExpDate).substring(2, 4);
                                if (Integer.parseInt(mm) == 0 || Integer.parseInt(yy) == 0 || Integer.parseInt(mm) > 12 || Integer.parseInt(yy) < 9) {
                                    decriptedExpDate = "1250";
                                }
                            }
                        } else if (id_ws < 51) {
                            if (p2pEncrypted) {
                                mm = ((String)decriptedExpDate).substring(0, 2);
                                yy = ((String)decriptedExpDate).substring(5, 7);
                                decriptedExpDate = mm + yy;
                            } else {
                                decriptedExpDate = "1250";
                            }
                        } else {
                            if (((String)decriptedExpDate).length() != 8) {
                                decriptedExpDate = "1250";
                            }
                            if (StringUtils.containsOnly((String)decriptedExpDate, (String)"0")) {
                                decriptedExpDate = "1250";
                            } else {
                                String p2pyy = ((String)decriptedExpDate).substring(0, 2);
                                String p2pmm = ((String)decriptedExpDate).substring(2, 4);
                                String yy = ((String)decriptedExpDate).substring(4, 6);
                                String mm = ((String)decriptedExpDate).substring(6, 8);
                                decriptedExpDate = p2pmm + p2pyy + mm + yy;
                            }
                        }
                    }
                    catch (NumberFormatException nfe) {
                        decriptedExpDate = "1250";
                    }
                    if (((String)decriptedExpDate).contains("/")) {
                        decriptedExpDate = "1250";
                    }
                    logger.info((Object)("decriptedExpDate: " + (String)decriptedExpDate));
                }
                catch (Throwable e) {
                    logger.error((Object)"Failed to decript the credit card expiration date", e);
                    this.sendEmailAboutError(this.getStackTrace(e), EXCEPTION);
                    throw new RuntimeException(e);
                }
                String[] newData = new String[data.length];
                for (int i = 0; i < data.length; ++i) {
                    newData[i] = data[i];
                }
                newData[table.getColumnIndex((String)"DC_EP_NCRPT_CRD")] = decriptedExpDate;
                data = newData;
                logger.info((Object)"successfully decripted the expiry date");
            }
        }
        return data;
    }

    private String[] getDecryptedGiftCardNumber(Table table, DataContext ctx, String[] data) {
        String encryptedGiftCardNumber;
        if (ctx != null && table.getName() != null && table.getName().equalsIgnoreCase("TR_LTM_GF_CRD_TND")) {
            String encryptedGiftCardNumber2 = data[table.getColumnIndex("ID_NCRPT_ACNT_GF_CRD")];
            if (encryptedGiftCardNumber2 != null) {
                String decriptedGiftCardNumber = null;
                if (encryptedGiftCardNumber2.length() > 16) {
                    try {
                        logger.info((Object)("block 1 - Tring to decrypt the gift card number " + encryptedGiftCardNumber2));
                        decriptedGiftCardNumber = this.removeNonAlphaNumberic(this.decrypt(encryptedGiftCardNumber2, true));
                        logger.info((Object)"block 1 -decrypt the gift card number - succesful");
                    }
                    catch (Throwable e) {
                        logger.error((Object)"block 1 -Failed to decript the giftcard number", e);
                        this.sendEmailAboutError(this.getStackTrace(e), EXCEPTION);
                        throw new RuntimeException(e);
                    }
                } else {
                    decriptedGiftCardNumber = encryptedGiftCardNumber2;
                }
                String[] newData = new String[data.length];
                for (int i = 0; i < data.length; ++i) {
                    newData[i] = data[i];
                }
                newData[table.getColumnIndex((String)"ID_MSK_ACNT_GF_CRD")] = decriptedGiftCardNumber;
                data = newData;
            }
        } else if (ctx != null && table.getName() != null && table.getName().equalsIgnoreCase("DO_CRD_GF") && (encryptedGiftCardNumber = data[table.getColumnIndex("ID_NCRPT_ACNT_GF_CRD")]) != null) {
            String decriptedGiftCardNumber = null;
            if (encryptedGiftCardNumber.length() > 16) {
                try {
                    logger.info((Object)("block 2 -Tring to decrypt the gift card number " + encryptedGiftCardNumber));
                    decriptedGiftCardNumber = this.removeNonAlphaNumberic(this.decrypt(encryptedGiftCardNumber, true));
                    logger.info((Object)"block 2 -decrypt the gift card number - succesful");
                }
                catch (Throwable e) {
                    logger.error((Object)"block 2 -Failed to decript the giftcard number", e);
                    this.sendEmailAboutError(this.getStackTrace(e), EXCEPTION);
                    throw new RuntimeException(e);
                }
            } else {
                decriptedGiftCardNumber = encryptedGiftCardNumber;
            }
            String[] newData = new String[data.length];
            for (int i = 0; i < data.length; ++i) {
                newData[i] = data[i];
            }
            newData[table.getColumnIndex((String)"ID_MSK_ACNT_GF_CRD")] = decriptedGiftCardNumber;
            data = newData;
        }
        return data;
    }

    public static BigDecimal round(BigDecimal d, int decimalPlace) {
        BigDecimal bd = d;
        return bd.setScale(decimalPlace, 4);
    }

    private CurrencyBean getCurrencyBean(String currencyId) {
        CurrencyBean ret = null;
        if (currencyId != null) {
            ret = this.currencyCache.getCurrencyBean(new BigDecimal(currencyId));
        }
        return ret;
    }

    public void getVatLessData(DataContext ctx, Element root) {
        logger.info((Object)"Entering VAT Calculation");
        HashMap<CallSite, String> myTaxMap = new HashMap<CallSite, String>();
        HashMap<CallSite, TaxAuthorityBean> myTaxAuthMap = new HashMap<CallSite, TaxAuthorityBean>();
        HashMap<String, String> myExtdItemPriceMap = new HashMap<String, String>();
        HashMap<String, String> myDiscItemPriceMap = new HashMap<String, String>();
        HashMap<String, String> myRetailItemPriceMap = new HashMap<String, String>();
        CurrencyBean currencyBean = null;
        try {
            Element firstRow;
            int i;
            List rowList = root.getChildren("row");
            currencyBean = this.getLocalStoreCurrencyForTransaction(rowList);
            if (currencyBean == null) {
                currencyBean = new CurrencyBean();
            }
            TrLtmSlsRtnTx trLtmSlsRtnTx = new TrLtmSlsRtnTx();
            for (int i2 = 0; i2 < rowList.size(); ++i2) {
                Element firstRow2 = (Element)rowList.get(i2);
                if (firstRow2 == null || firstRow2.getAttribute("entity") == null || !"TR_LTM_SLS_RTN_TX".equalsIgnoreCase(firstRow2.getAttribute("entity").getValue())) continue;
                logger.info((Object)"Processing table TR_LTM_SLS_RTN_TX");
                trLtmSlsRtnTx.setElement(firstRow2);
                if (!trLtmSlsRtnTx.isVat()) continue;
                String uniqueKey = trLtmSlsRtnTx.getIdStrRt() + trLtmSlsRtnTx.getIdWs() + trLtmSlsRtnTx.getDcDyBsn() + trLtmSlsRtnTx.getAiTrn() + trLtmSlsRtnTx.getAiLnItm();
                myTaxMap.put((CallSite)((Object)uniqueKey), trLtmSlsRtnTx.getPeTx());
                myTaxAuthMap.put((CallSite)((Object)uniqueKey), this.taxAuthorityCache.getTaxAuthorityBean(new BigDecimal(trLtmSlsRtnTx.getIdAthyTx())));
                logger.info((Object)("uniqueKey " + uniqueKey + " taxRate " + trLtmSlsRtnTx.getPeTx()));
            }
            TrLtmSlsRtn trLtmSlsRtn = new TrLtmSlsRtn();
            for (i = 0; i < rowList.size(); ++i) {
                firstRow = (Element)rowList.get(i);
                if (firstRow == null || firstRow.getAttribute("entity") == null || !"TR_LTM_SLS_RTN".equalsIgnoreCase(firstRow.getAttribute("entity").getValue())) continue;
                logger.info((Object)"Processing table TR_LTM_SLS_RTN");
                List dataList = firstRow.getChildren("data");
                BigDecimal taxRate = BigDecimal.ZERO;
                trLtmSlsRtn.setElement(firstRow);
                String uniqueKey = trLtmSlsRtn.getIdStrRt() + trLtmSlsRtn.getIdWs() + trLtmSlsRtn.getDcDyBsn() + trLtmSlsRtn.getAiTrn() + trLtmSlsRtn.getAiLnItm();
                TaxAuthorityBean taxAuthBean = (TaxAuthorityBean)myTaxAuthMap.get(uniqueKey);
                if (taxAuthBean == null) {
                    taxAuthBean = new TaxAuthorityBean();
                }
                if (myTaxMap != null && myTaxMap.get(uniqueKey) != null) {
                    taxRate = new BigDecimal((String)myTaxMap.get(uniqueKey));
                }
                if (taxRate.compareTo(BigDecimal.ZERO) != 0) {
                    if (trLtmSlsRtn.getMoExtnLnItmRtn().compareTo(BigDecimal.ZERO) != 0) {
                        trLtmSlsRtn.setMoExtnLnItmRtn(OutboundSalesXmlPublisherFilter.round(trLtmSlsRtn.getMoExtnLnItmRtn(), currencyBean.getCurrencyScale()).subtract(OutboundSalesXmlPublisherFilter.round(trLtmSlsRtn.getMoTaxIncLnItmRtn(), currencyBean.getCurrencyScale())).divide(BigDecimal.ONE, taxAuthBean.getRoundingDigitQuantity().intValue(), taxAuthBean.getRoundingCode()));
                    }
                    if (trLtmSlsRtn.getMoExtnDscLnItm().compareTo(BigDecimal.ZERO) != 0) {
                        trLtmSlsRtn.setMoExtnDscLnItm(OutboundSalesXmlPublisherFilter.round(trLtmSlsRtn.getMoExtnDscLnItm(), currencyBean.getCurrencyScale()).subtract(OutboundSalesXmlPublisherFilter.round(trLtmSlsRtn.getMoTaxIncLnItmRtn(), currencyBean.getCurrencyScale())).divide(BigDecimal.ONE, taxAuthBean.getRoundingDigitQuantity().intValue(), taxAuthBean.getRoundingCode()));
                    }
                    if (trLtmSlsRtn.getMoPrnPrc().compareTo(BigDecimal.ZERO) != 0) {
                        trLtmSlsRtn.setMoPrnPrc(this.calculateVatLess(taxAuthBean.getRoundingDigitQuantity().intValue(), taxAuthBean.getRoundingCode(), trLtmSlsRtn.getMoPrnPrc(), taxRate));
                    }
                }
                for (int j = 0; j < dataList.size(); ++j) {
                    Attribute attribute;
                    Element firstDataElement = (Element)dataList.get(j);
                    if (firstDataElement == null || (attribute = firstDataElement.getAttribute("key")) == null) continue;
                    String value = attribute.getValue();
                    if ("MO_EXTN_LN_ITM_RTN".equalsIgnoreCase(value)) {
                        firstDataElement.setText(OutboundSalesXmlPublisherFilter.round(trLtmSlsRtn.getMoExtnLnItmRtn(), currencyBean.getCurrencyScale()).toString());
                        continue;
                    }
                    if ("MO_EXTN_DSC_LN_ITM".equalsIgnoreCase(value)) {
                        firstDataElement.setText(OutboundSalesXmlPublisherFilter.round(trLtmSlsRtn.getMoExtnDscLnItm(), currencyBean.getCurrencyScale()).toString());
                        continue;
                    }
                    if (!"MO_PRN_PRC".equalsIgnoreCase(value)) continue;
                    firstDataElement.setText(OutboundSalesXmlPublisherFilter.round(trLtmSlsRtn.getMoPrnPrc(), currencyBean.getCurrencyScale()).toString());
                }
                if (trLtmSlsRtn.isVoid()) continue;
                myExtdItemPriceMap.put(uniqueKey, trLtmSlsRtn.getMoExtnLnItmRtn().toString());
                myDiscItemPriceMap.put(uniqueKey, trLtmSlsRtn.getMoExtnDscLnItm().toString());
                myRetailItemPriceMap.put(uniqueKey, trLtmSlsRtn.getMoPrnPrc().toString());
                logger.info((Object)("uniqueKey::" + uniqueKey + " extendedPrice " + trLtmSlsRtn.getMoExtnLnItmRtn().toString()));
                logger.info((Object)("uniqueKey::" + uniqueKey + " discountedPrice " + trLtmSlsRtn.getMoExtnDscLnItm().toString()));
                logger.info((Object)("uniqueKey::" + uniqueKey + " RetailsPrice " + trLtmSlsRtn.getMoPrnPrc().toString()));
            }
            for (i = 0; i < rowList.size(); ++i) {
                firstRow = (Element)rowList.get(i);
                TrRtl trRtl = new TrRtl();
                if (firstRow == null || firstRow.getAttribute("entity") == null || !"TR_RTL".equalsIgnoreCase(firstRow.getAttribute("entity").getValue())) continue;
                logger.info((Object)"Processing table TR_RTL");
                List dataList = firstRow.getChildren("data");
                trRtl.setTrRtlTotals(myExtdItemPriceMap, myDiscItemPriceMap, myRetailItemPriceMap, currencyBean);
                for (int j = 0; j < dataList.size(); ++j) {
                    Attribute attribute;
                    Element firstDataElement = (Element)dataList.get(j);
                    if (firstDataElement == null || (attribute = firstDataElement.getAttribute("key")) == null) continue;
                    String value = attribute.getValue();
                    if ("MO_SLS_TOT".equalsIgnoreCase(value)) {
                        firstDataElement.setText(OutboundSalesXmlPublisherFilter.round(trRtl.getExtdPriceTotal(), currencyBean.getCurrencyScale()).toString());
                        continue;
                    }
                    if ("MO_DSC_TOT".equalsIgnoreCase(value)) {
                        firstDataElement.setText(OutboundSalesXmlPublisherFilter.round(trRtl.getDiscountAmount(), currencyBean.getCurrencyScale()).toString());
                        continue;
                    }
                    if (!"MO_NT_TOT".equalsIgnoreCase(value)) continue;
                    firstDataElement.setText(OutboundSalesXmlPublisherFilter.round(trRtl.getDiscPriceTotal(), currencyBean.getCurrencyScale()).toString());
                }
                logger.info((Object)("MO_SLS_TOT " + OutboundSalesXmlPublisherFilter.round(trRtl.getExtdPriceTotal(), currencyBean.getCurrencyScale()).toString()));
                logger.info((Object)("MO_DSC_TOT " + OutboundSalesXmlPublisherFilter.round(trRtl.getDiscountAmount(), currencyBean.getCurrencyScale()).toString()));
                logger.info((Object)("MO_NT_TOT " + OutboundSalesXmlPublisherFilter.round(trRtl.getDiscPriceTotal(), currencyBean.getCurrencyScale()).toString()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        logger.info((Object)"VAT Calculation Done");
    }

    private CurrencyBean getLocalStoreCurrencyForTransaction(List rowList) {
        CurrencyBean currencyBean = null;
        for (int i = 0; i < rowList.size(); ++i) {
            Element row = (Element)rowList.get(i);
            if (row != null && row.getAttribute("entity") != null && "TR_LTM_TND".equalsIgnoreCase(row.getAttribute("entity").getValue())) {
                Element data;
                int j;
                List dataList = row.getChildren("data");
                for (j = 0; j < dataList.size(); ++j) {
                    data = (Element)dataList.get(j);
                    if (data == null || data.getAttribute("key") == null || !"LCL_DE_CNY".equals(data.getAttribute("key").getValue())) continue;
                    if (!StringUtils.isNotBlank((String)data.getText())) break;
                    currencyBean = this.currencyCache.getCurrencyBeanForCurrencyCode(data.getText());
                    break;
                }
                if (currencyBean == null) {
                    for (j = 0; j < dataList.size(); ++j) {
                        data = (Element)dataList.get(j);
                        if (data == null || data.getAttribute("key") == null || !"ID_CNY_ICD".equals(data.getAttribute("key").getValue())) continue;
                        currencyBean = this.getCurrencyBean(data.getText());
                        break;
                    }
                }
            }
            if (currencyBean != null) break;
        }
        return currencyBean;
    }

    private void updateKeyedinDepositsForIposStores(DataContext ctx, Element root) {
        double tenderTotal = 0.0;
        try {
            List dataList;
            List rowList = root.getChildren("row");
            block2: for (Element rowElement : rowList) {
                if (rowElement == null || rowElement.getAttribute("entity") == null || !"ANF_LE_HST_UC_TND".equalsIgnoreCase(rowElement.getAttribute("entity").getValue())) continue;
                dataList = rowElement.getChildren("data");
                for (Element dataElement : dataList) {
                    if (dataElement == null || dataElement.getAttribute("key") == null || !"TY_TND".equalsIgnoreCase(dataElement.getAttribute("key").getValue())) continue;
                    String tenderType = dataElement.getText();
                    if (!"Cash".equalsIgnoreCase(tenderType) && !"TravCheck".equalsIgnoreCase(tenderType) && !"MallCert".equalsIgnoreCase(tenderType)) continue block2;
                    for (Element dataElement2 : dataList) {
                        if (dataElement2 == null || dataElement2.getAttribute("key") == null || !"CP_TND_TOT".equalsIgnoreCase(dataElement2.getAttribute("key").getValue())) continue;
                        String tenderTotalStr = dataElement2.getText();
                        if ("".equalsIgnoreCase(tenderTotalStr) || tenderTotalStr == null) continue block2;
                        tenderTotal = this.calculateTotalDeposits(tenderTotalStr, tenderTotal);
                        continue block2;
                    }
                    continue block2;
                }
            }
            block5: for (Element rowElement : rowList) {
                if (rowElement == null || rowElement.getAttribute("entity") == null || !"ANF_LE_HST_UC_TND".equalsIgnoreCase(rowElement.getAttribute("entity").getValue())) continue;
                dataList = rowElement.getChildren("data");
                for (Element dataElement : dataList) {
                    if (dataElement == null || dataElement.getAttribute("key") == null || !"CP_TND_TOT".equalsIgnoreCase(dataElement.getAttribute("key").getValue())) continue;
                    dataElement.setText(this.formatDouble(tenderTotal));
                    continue block5;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while processing the keyed-in deposits for IPOS Stores", (Throwable)e);
        }
    }

    private String formatDouble(Double initValue) {
        String strValue = null;
        try {
            DecimalFormat fmt = new DecimalFormat();
            fmt.setMinimumFractionDigits(2);
            fmt.setMaximumFractionDigits(2);
            strValue = fmt.format(initValue);
            if (strValue != null && strValue.contains(",")) {
                strValue = strValue.replaceAll(",", "");
            }
        }
        catch (Exception e) {
            strValue = Double.valueOf(initValue).toString();
            logger.error((Object)("Error formatting the Double value: " + strValue), (Throwable)e);
        }
        return strValue;
    }

    private boolean isTable(String tableName, Element rowElement) {
        return rowElement != null && rowElement.getAttribute("entity") != null && tableName.equalsIgnoreCase(rowElement.getAttribute("entity").getValue());
    }

    private String getColumn(String columnName, Element rowElement) {
        List dataList = rowElement.getChildren("data");
        for (Element dataElement : dataList) {
            if (dataElement == null || dataElement.getAttribute("key") == null || !columnName.equalsIgnoreCase(dataElement.getAttribute("key").getValue())) continue;
            return dataElement.getText();
        }
        return null;
    }

    private void removeStoreCoupons(Element root) {
        HashSet<Element> couponSaleReturnLineItems = null;
        HashSet<Element> couponRetailLineItems = null;
        List rowList = root.getChildren("row");
        for (Element rowElement : rowList) {
            BigDecimal value;
            String extendedAmount;
            if (!this.isTable("TR_LTM_SLS_RTN", rowElement) || StringUtils.isBlank((String)(extendedAmount = this.getColumn("MO_EXTN_LN_ITM_RTN", rowElement))) || (value = new BigDecimal(extendedAmount)).signum() != 0 || !"PROMOCODE".equals(this.getColumn("SPL_INSTRC", rowElement)) && !this.isStoreCoupon(this.getColumn("ID_ITM", rowElement))) continue;
            if (couponSaleReturnLineItems == null) {
                couponSaleReturnLineItems = new HashSet<Element>(1);
            }
            couponSaleReturnLineItems.add(rowElement);
        }
        if (couponSaleReturnLineItems != null && couponSaleReturnLineItems.size() > 0) {
            for (Element couponRow : couponSaleReturnLineItems) {
                String lineNumber = this.getColumn("AI_LN_ITM", couponRow);
                for (Element rowElement : rowList) {
                    String lineNumberToCompare;
                    if (!this.isTable("TR_LTM_RTL_TRN", rowElement) && !this.isTable("TR_LTM_SLS_RTN_TX", rowElement) || !lineNumber.equals(lineNumberToCompare = this.getColumn("AI_LN_ITM", rowElement))) continue;
                    if (couponRetailLineItems == null) {
                        couponRetailLineItems = new HashSet<Element>(2);
                    }
                    couponRetailLineItems.add(rowElement);
                }
                couponRow.detach();
            }
        }
        if (couponRetailLineItems != null && couponRetailLineItems.size() > 0) {
            for (Element couponRow : couponRetailLineItems) {
                couponRow.detach();
            }
        }
    }

    private void validateSKU(DataContext ctx, Element root) {
        try {
            List rowList = root.getChildren("row");
            for (Element rowElement : rowList) {
                if (rowElement == null || rowElement.getAttribute("entity") == null || !"AS_ITM_UNK".equalsIgnoreCase(rowElement.getAttribute("entity").getValue())) continue;
                List dataList = rowElement.getChildren("data");
                String itemSku = null;
                String storeId = null;
                for (Element dataElement : dataList) {
                    if (dataElement != null && dataElement.getAttribute("key") != null && "DE_ITM".equalsIgnoreCase(dataElement.getAttribute("key").getValue())) {
                        itemSku = dataElement.getText();
                    }
                    if (dataElement == null || dataElement.getAttribute("key") == null || !"ID_STR_RT".equalsIgnoreCase(dataElement.getAttribute("key").getValue())) continue;
                    storeId = dataElement.getText();
                }
                if (itemSku == null || storeId == null) continue;
                String brandId = storeId.substring(0, 1);
                int count = 0;
                count = "1".equals(brandId) || "2".equals(brandId) ? this.verifySKUinRMS(itemSku, new String[]{"1", "2"}) : this.verifySKUinRMS(itemSku, new String[]{brandId});
                if (count < 1) {
                    switch (Integer.parseInt(brandId)) {
                        case 1: {
                            itemSku = "199000011";
                            break;
                        }
                        case 2: {
                            itemSku = "299000011";
                            break;
                        }
                        case 3: {
                            itemSku = "399000011";
                            break;
                        }
                        case 4: {
                            itemSku = "499000011";
                            break;
                        }
                        case 5: {
                            itemSku = "599000011";
                        }
                    }
                }
                Element newDataElement = new Element("data");
                newDataElement.setText(itemSku);
                newDataElement.setAttribute("key", "DUMP_SKU");
                rowElement.addContent((Content)newDataElement);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while processing the keyed-in deposits for IPOS Stores", (Throwable)e);
        }
    }

    private void addScale(DataContext ctx, Element root) {
        try {
            List rowList = root.getChildren("row");
            for (Element rowElement : rowList) {
                CurrencyBean currencyBean;
                if (rowElement == null || rowElement.getAttribute("entity") == null || !"TR_LTM_TND".equalsIgnoreCase(rowElement.getAttribute("entity").getValue())) continue;
                List dataList = rowElement.getChildren("data");
                String foreignAmountTendered = null;
                String foreignCurrencyCode = null;
                for (Element dataElement : dataList) {
                    if (dataElement != null && dataElement.getAttribute("key") != null && "FRG_MO_ITM_LN_TND".equalsIgnoreCase(dataElement.getAttribute("key").getValue())) {
                        foreignAmountTendered = dataElement.getText();
                    }
                    if (dataElement == null || dataElement.getAttribute("key") == null || !"ID_CNY_ICD".equalsIgnoreCase(dataElement.getAttribute("key").getValue())) continue;
                    foreignCurrencyCode = dataElement.getText();
                }
                if (foreignAmountTendered == null || foreignCurrencyCode == null || (currencyBean = this.currencyCache.getCurrencyBean(new BigDecimal(foreignCurrencyCode))) == null) continue;
                for (Element dataElement : dataList) {
                    if (dataElement == null || dataElement.getAttribute("key") == null || !"FRG_MO_ITM_LN_TND".equalsIgnoreCase(dataElement.getAttribute("key").getValue())) continue;
                    dataElement.setAttribute("scale", String.format("%s", currencyBean.getCurrencyScale()));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while processing the keyed-in deposits for IPOS Stores", (Throwable)e);
        }
    }

    private boolean isStoreCoupon(String itemSKU) {
        String SQL = "select count(*) from as_itm where id_itm=? and ty_itm=?";
        try {
            JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
            return (Integer)jdbcTemplate.queryForObject("select count(*) from as_itm where id_itm=? and ty_itm=?", Integer.class, new Object[]{itemSKU, "SCPN"}) > 0;
        }
        catch (Exception e) {
            logger.error((Object)"Error while looking up for the valid sku", (Throwable)e);
            return false;
        }
    }

    private int verifySKUinRMS(String itemSKU, String[] brands) {
        String FIND_BY_ID_ITM = "SELECT COUNT(*) FROM AFCOADM.ANF_UT_SKU_XREF WHERE ID_ITM=:ID_ITM AND BRAND_ID IN (:BRAND_ID)";
        int count = 0;
        try {
            NamedParameterJdbcTemplate jdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
            MapSqlParameterSource parameters = new MapSqlParameterSource();
            parameters.addValue("ID_ITM", (Object)itemSKU);
            parameters.addValue("BRAND_ID", Arrays.asList(brands));
            count = (Integer)jdbcTemplate.queryForObject(FIND_BY_ID_ITM, (SqlParameterSource)parameters, Integer.class);
        }
        catch (Exception e) {
            logger.error((Object)"Error while looking up for the valid sku", (Throwable)e);
        }
        return count;
    }

    private double calculateTotalDeposits(String strValue, double totalDeposit) {
        try {
            totalDeposit += Double.parseDouble(strValue);
        }
        catch (NumberFormatException nfe) {
            logger.error((Object)("Error calculating the keyed-in deposits. CP_TND_TOT column contains invalid value: " + strValue), (Throwable)nfe);
        }
        catch (Exception e) {
            logger.error((Object)"Error calculating the keyed-in deposits", (Throwable)e);
        }
        return totalDeposit;
    }

    public void batchCommitted(DataContext context) {
        Map ctxCache = this.getXmlCache((Context)context);
        Collection buffers = ctxCache.values();
        for (Element root : buffers) {
            if (this.ignoreBatch(context, root)) {
                logger.info((Object)"Removing the batch with nodeId=IGNORE");
                buffers.remove(root);
                continue;
            }
            this.getVatLessData(context, root);
            this.updateKeyedinDepositsForIposStores(context, root);
            this.validateSKU(context, root);
            this.defaultPromotionValues(context, root);
            this.removeStoreCoupons(root);
            this.addScale(context, root);
            this.updateDateFormatInIdForBatch(context, root);
        }
        if (this.doesXmlExistToPublish((Context)context)) {
            this.finalizeXmlAndPublish((Context)context);
        }
    }

    public void batchComplete(DataContext ctx) {
    }

    private void updateDateFormatInIdForBatch(DataContext ctx, Element root) {
        String id = root.getAttributeValue("id").toString();
        if (id != null) {
            id = id.replaceAll("-", "");
        }
        root.setAttribute("id", id);
    }

    private boolean ignoreBatch(DataContext ctx, Element root) {
        boolean exists = false;
        try {
            String nodeId = root.getAttributeValue("nodeid").toString();
            if (NODE_ID_TYPE_IGNORE.equalsIgnoreCase(nodeId) || NODE_ID_TYPE_IGNOREME.equalsIgnoreCase(nodeId)) {
                exists = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while checking for the nodeID to ignore the batch from publishing", (Throwable)e);
        }
        return exists;
    }

    private void defaultPromotionValues(DataContext ctx, Element root) {
        List rowList = root.getChildren("row");
        for (Element rowElement : rowList) {
            String value;
            Attribute attribute;
            if (rowElement == null || rowElement.getAttribute("entity") == null || !"CO_MDFR_RTL_PRC".equalsIgnoreCase(rowElement.getAttribute("entity").getValue())) continue;
            List dataList = rowElement.getChildren("data");
            String id_prm_cmp = null;
            String cd_mth_prdv = null;
            for (Element firstDataElement : dataList) {
                if (firstDataElement == null || (attribute = firstDataElement.getAttribute("key")) == null) continue;
                value = attribute.getValue();
                if ("ID_PRM_CMP".equalsIgnoreCase(value)) {
                    id_prm_cmp = firstDataElement.getText();
                    continue;
                }
                if (!"CD_MTH_PRDV".equalsIgnoreCase(value)) continue;
                cd_mth_prdv = firstDataElement.getText();
            }
            if (cd_mth_prdv == null || "0".equals(cd_mth_prdv) || id_prm_cmp != null && !"0".equals(id_prm_cmp)) continue;
            for (Element firstDataElement : dataList) {
                if (firstDataElement == null || (attribute = firstDataElement.getAttribute("key")) == null) continue;
                value = attribute.getValue();
                if ("ID_PRM_CMP".equalsIgnoreCase(value)) {
                    firstDataElement.setText(this.getDefaultPromoCompId());
                    continue;
                }
                if (!"ID_PRM".equalsIgnoreCase(value)) continue;
                firstDataElement.setText(this.getDefaultPromoId());
            }
        }
    }

    private String getDefaultPromoId() {
        ParameterBean defaultPromoIdBean = this.parameterCache.getParameterBean("POS", "SalesXmlPublisher", "DefaultPromoId");
        return defaultPromoIdBean != null ? defaultPromoIdBean.getParamValue() : "3309002";
    }

    private String getDefaultPromoCompId() {
        ParameterBean defaultPromoIdBean = this.parameterCache.getParameterBean("POS", "SalesXmlPublisher", "DefaultPromoCompId");
        return defaultPromoIdBean != null ? defaultPromoIdBean.getParamValue() : "3301586";
    }

    private BigDecimal calculateVat(int scale, int roundingMode, BigDecimal amount, BigDecimal taxRate) {
        BigDecimal fraction = taxRate.divide(taxRate.add(BigDecimal.ONE), scale + 1, roundingMode).divide(BigDecimal.ONE, scale, roundingMode);
        return amount.multiply(fraction).divide(BigDecimal.ONE, scale, roundingMode);
    }

    private BigDecimal calculateVatLess(int scale, int roundingMode, BigDecimal amount, BigDecimal taxRate) {
        BigDecimal bdAmount = amount;
        BigDecimal bdTaxRate = taxRate.divide(BigDecimal.TEN, scale + 1, roundingMode).divide(BigDecimal.TEN, scale + 1, roundingMode);
        BigDecimal vat = this.calculateVat(scale, roundingMode, bdAmount, bdTaxRate);
        return bdAmount.subtract(vat).divide(BigDecimal.ONE, scale, roundingMode);
    }

    public void setMailSender(MailSender mailSender) {
        this.mailSender = mailSender;
    }

    public void setSendEmailOnError(boolean sendEmail) {
        this.sendEmailOnError = sendEmail;
    }

    protected void toXmlElement(DataEventType dml, Element xml, String tableName, String[] columnNames, String[] data, String[] keyNames, String[] keys) {
        Element row = new Element("row");
        xml.addContent((Content)row);
        row.setAttribute("entity", tableName);
        row.setAttribute("dml", dml.getCode());
        String[] colNames = null;
        if (data == null) {
            colNames = keyNames;
            data = keys;
        } else {
            colNames = columnNames;
        }
        for (int i = 0; i < data.length; ++i) {
            String col = colNames[i];
            Element dataElement = new Element("data");
            row.addContent((Content)dataElement);
            dataElement.setAttribute("key", col);
            if (data[i] != null) {
                dataElement.setText(data[i]);
                continue;
            }
            dataElement.setAttribute("nil", "true", OutboundSalesXmlPublisherFilter.getXmlNamespace());
        }
        this.postProcessXMLRow(row, tableName, columnNames, data);
    }

    private void postProcessXMLRow(Element row, String tableName, String[] columnNames, String[] data) {
        if (StringUtils.equals((String)tableName, (String)"TR_LTM_PAYPAL_TND")) {
            HashMap<String, String> rowMap = new HashMap<String, String>();
            for (int i = 0; i < columnNames.length; ++i) {
                rowMap.put(columnNames[i], data[i]);
            }
            String value = (String)rowMap.get("LU_PAYER_ID");
            if (StringUtils.isBlank((String)value) && StringUtils.isBlank((String)(value = (String)rowMap.get("LU_AUTH_ID")))) {
                value = "MISSING DATA";
            }
            Element newDataElement = new Element("data");
            newDataElement.setText(value);
            newDataElement.setAttribute("key", "ID_NCRPT_ACNT_CRD");
            row.addContent((Content)newDataElement);
        }
    }

    private String[] getFormattedDateTimes(Table table, DataContext ctx, String[] data) {
        String[] newData = new String[data.length];
        String[] columns = new String[]{"TS_TRN_BGN", "TS_TRN_END", "TS_CRT_RCRD", "TS_MDF_RCRD", "TS_LN_ITM_BGN", "TS_LN_ITM_END"};
        List<String> columnNames = Arrays.asList(columns);
        boolean createdNewData = false;
        logger.info((Object)("Begin Date formatting for table <" + table.getName() + ">"));
        for (String columnName : columnNames) {
            String transformedDate = null;
            if (table.getColumnIndex(columnName) != -1) {
                logger.info((Object)("date column <" + columnName + "> index is : " + table.getColumnIndex(columnName)));
                String date = data[table.getColumnIndex(columnName)];
                logger.info((Object)("date column <" + columnName + "> value before formatting : " + date));
                if (date != null) {
                    transformedDate = this.formatDate(date);
                }
            }
            if (transformedDate == null) continue;
            if (!createdNewData) {
                for (int i = 0; i < data.length; ++i) {
                    newData[i] = data[i];
                }
                createdNewData = true;
            }
            if (transformedDate == null) continue;
            logger.info((Object)("Transformed date column <" + columnName + "> value from " + data[table.getColumnIndex(columnName)] + " to <" + transformedDate + ">"));
            newData[table.getColumnIndex((String)columnName)] = transformedDate;
        }
        logger.info((Object)("End Date formatting for table <" + table.getName() + ">"));
        if (!createdNewData) {
            return data;
        }
        return newData;
    }

    private String formatDate(String timestamp) {
        String pattern19 = "yyyy-MM-dd HH:mm:ss";
        String pattern21 = "yyyy-MM-dd HH:mm:ss.S";
        String pattern22 = "yyyy-MM-dd HH:mm:ss.SS";
        String pattern23 = "yyyy-MM-dd HH:mm:ss.SSS";
        String pattern26 = "yyyy-MM-dd HH:mm:ss.SSSSSS";
        String pattern29 = "yyyy-MM-dd HH:mm:ss.SSSSSSSSS";
        String patternValue = String.valueOf(timestamp.length());
        DateTimeFormatter inputFormat = null;
        switch (patternValue) {
            case "19": {
                inputFormat = DateTimeFormatter.ofPattern(pattern19);
                break;
            }
            case "21": {
                inputFormat = DateTimeFormatter.ofPattern(pattern21);
                break;
            }
            case "22": {
                inputFormat = DateTimeFormatter.ofPattern(pattern22);
                break;
            }
            case "23": {
                inputFormat = DateTimeFormatter.ofPattern(pattern23);
                break;
            }
            case "26": {
                inputFormat = DateTimeFormatter.ofPattern(pattern26);
                break;
            }
            case "29": {
                inputFormat = DateTimeFormatter.ofPattern(pattern29);
            }
        }
        LocalDateTime formatDateTime = LocalDateTime.parse(timestamp, inputFormat);
        return formatDateTime.format(outputFormat);
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setTestCreditCardNumber(String testCreditCardNumber) {
        this.testCreditCardNumber = testCreditCardNumber;
    }

    private String decrypt(String encryptedString, boolean encode) throws Exception {
        try {
            logger.info((Object)("Tring to decrypt information using AES algorithm: " + encryptedString));
            if (null == secretKeySpecList) {
                logger.info((Object)"Tring to load the AES secret key for the first time on this Region server");
                File file = new File(this.aesKeyFile);
                logger.info((Object)"AES key file loaded succesfully");
                secretKeySpecList = helper.getKeySpecList(file);
            }
            if (encode) {
                String decodedEncryptedString = new String(Base64.decodeBase64((byte[])encryptedString.getBytes()));
                logger.info((Object)("Base64 decoded encrypted string is: " + decodedEncryptedString));
                return helper.decrypt(secretKeySpecList, decodedEncryptedString);
            }
            return helper.decrypt(secretKeySpecList, encryptedString);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to decrypt using AES algorithm: " + encryptedString));
            logger.error((Object)e.getMessage());
            throw e;
        }
    }

    public void setParameterCache(ParameterCache parameterCache) {
        this.parameterCache = parameterCache;
    }
}

