/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.config.INodeIdCreator;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.Node;

public class NodeIdGenerator
implements INodeIdCreator,
ISymmetricEngineAware {
    ISymmetricEngine engine;

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }

    public static String parseNodeId(String hostNameString, String defaultValue) {
        Pattern p = Pattern.compile("(\\d{5})-\\D{3}-\\D(\\d{3}).*");
        Matcher m = p.matcher(hostNameString);
        if (m.find() && m.groupCount() == 2) {
            return m.group(1) + "-" + m.group(2);
        }
        return defaultValue;
    }

    public String buildNodeId(Node node) {
        String syncURL = node.getSyncUrl();
        if (!StringUtils.isBlank((String)syncURL)) {
            return NodeIdGenerator.parseNodeId(syncURL, syncURL);
        }
        return StringUtils.isBlank((String)node.getExternalId()) ? "0" : node.getExternalId();
    }

    public String[] getNodeGroupIdsToApplyTo() {
        return new String[]{"corp"};
    }

    public String selectNodeId(Node node, String remoteHost, String remoteAddress) {
        if (StringUtils.isBlank((String)node.getNodeId())) {
            return this.buildNodeId(node);
        }
        return node.getNodeId();
    }

    public String generateNodeId(Node node, String remoteHost, String remoteAddress) {
        if (StringUtils.isBlank((String)node.getNodeId())) {
            return this.buildNodeId(node);
        }
        return node.getNodeId();
    }

    public String generatePassword(Node node) {
        return this.engine.getSecurityService().nextSecureHexString(30);
    }
}

