/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp;

import com.anfcorp.stores.symmetric.corp.TemplatedPublisherFilter;
import com.anfcorp.stores.symmetric.corp.cache.StoreCountryStateCache;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.DmlStatement;

public class ClockPunchPublisherFilter
extends TemplatedPublisherFilter {
    private StoreCountryStateCache storeCountryStateCache;

    public void setStoreCountryStateCache(StoreCountryStateCache storeCountryStateCache) {
        this.storeCountryStateCache = storeCountryStateCache;
    }

    @Override
    protected String fillOutTemplate(DmlStatement.DmlType dmlType, String template, Table table, String[] data, String[] keys) {
        template = super.fillOutTemplate(dmlType, template, table, data, keys);
        String storeId = data[table.getColumnIndex("ID_STR_RT")];
        StoreCountryStateCache.StoreCountryState countryState = this.storeCountryStateCache.get(storeId);
        if (countryState == null) {
            throw new IllegalStateException(String.format("Could not find the store, %s, in the database.", storeId));
        }
        if (countryState.getCountry() == null) {
            throw new IllegalStateException(String.format("The country was null on the address table or there was no lo_ads record for the store, %s", storeId));
        }
        if (countryState.getState() == null) {
            throw new IllegalStateException(String.format("The state was null on the address table for the store, %s", storeId));
        }
        template = template.replace("%COUNTRY%", countryState == null ? "" : countryState.getCountry());
        template = template.replace("%STATE%", countryState == null ? "" : countryState.getState());
        logger.info((Object)("template=" + template));
        return template;
    }
}

