/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.UniqueKeyException;
import org.jumpmind.db.sql.mapper.StringMapper;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.cache.ICacheManager;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.config.INodeIdCreator;
import org.jumpmind.symmetric.ext.IOfflineServerListener;
import org.jumpmind.symmetric.model.NetworkedNode;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.model.NodeHost;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.NodeStatus;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.security.INodePasswordFilter;
import org.jumpmind.symmetric.service.FilterCriterion;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.NodeServiceSqlMap;
import org.jumpmind.symmetric.util.DefaultNodeIdCreator;
import org.jumpmind.util.AppUtils;

public class NodeService
extends AbstractService
implements INodeService {
    private ISymmetricEngine engine;
    private IExtensionService extensionService;
    private Node cachedNodeIdentity;
    private Map<String, NodeSecurity> securityCache;
    private long securityCacheTime;
    private Map<String, Node> nodeCache = new HashMap<String, Node>();
    private long nodeCacheTime;
    private INodePasswordFilter nodePasswordFilter;
    private NodeHost nodeHostForCurrentNode = null;
    private ICacheManager cacheManager;

    public NodeService(ISymmetricEngine engine) {
        super(engine.getParameterService(), engine.getSymmetricDialect());
        this.engine = engine;
        this.cacheManager = engine.getCacheManager();
        this.extensionService = engine.getExtensionService();
        this.extensionService.addExtensionPoint(new DefaultNodeIdCreator(this.parameterService, this, engine.getSecurityService()));
        this.setSqlMap(new NodeServiceSqlMap(this.symmetricDialect.getPlatform(), this.createSqlReplacementTokens()));
    }

    @Override
    public String findSymmetricVersion() {
        return (String)this.sqlTemplate.queryForObject(this.getSql("findSymmetricVersionSql"), String.class, new Object[0]);
    }

    @Override
    public String findIdentityNodeId() {
        Node node = this.findIdentity();
        return node != null ? node.getNodeId() : null;
    }

    @Override
    public String getExternalId(String nodeId) {
        String externalId = null;
        Node node = this.findNode(nodeId, true);
        if (node != null) {
            externalId = node.getExternalId();
        }
        return externalId;
    }

    @Override
    public Collection<Node> findEnabledNodesFromNodeGroup(String nodeGroupId) {
        return this.cacheManager.getNodesByGroup(nodeGroupId);
    }

    @Override
    public Collection<Node> getEnabledNodesFromDatabase() {
        return this.sqlTemplate.query(this.getSql("selectNodePrefixSql", "findEnabledNodes"), (ISqlRowMapper)new NodeRowMapper(), new Object[0]);
    }

    @Override
    public Set<Node> findNodesThatOriginatedFromNodeId(String originalNodeId) {
        return this.findNodesThatOriginatedFromNodeId(originalNodeId, true);
    }

    @Override
    public Collection<Node> findNodesWithOpenRegistration() {
        return this.sqlTemplate.query(this.getSql("selectNodePrefixSql", "findNodesWithOpenRegistrationSql"), (ISqlRowMapper)new NodeRowMapper(), new Object[0]);
    }

    @Override
    public Set<Node> findNodesThatOriginatedFromNodeId(String originalNodeId, boolean recursive) {
        HashSet<Node> all = new HashSet<Node>();
        List list = this.sqlTemplate.query(this.getSql("selectNodePrefixSql", "findNodesCreatedByMeSql"), (ISqlRowMapper)new NodeRowMapper(), new Object[]{originalNodeId});
        if (list.size() > 0) {
            all.addAll(list);
            if (recursive) {
                for (Node node : list) {
                    all.addAll(this.findNodesThatOriginatedFromNodeId(node.getNodeId()));
                }
            }
        }
        return all;
    }

    @Override
    public Node findNode(String id) {
        List list = this.sqlTemplate.query(this.getSql("selectNodePrefixSql", "findNodeSql"), (ISqlRowMapper)new NodeRowMapper(), new Object[]{id});
        return (Node)this.getFirstEntry(list);
    }

    @Override
    public Node findNodeInCacheOnly(String id) {
        return this.nodeCache.get(id);
    }

    @Override
    public Node findNode(String id, boolean useCache) {
        if (useCache) {
            long cacheTimeoutInMs = this.parameterService.getLong("cache.node.time.ms");
            if (System.currentTimeMillis() - this.nodeCacheTime >= cacheTimeoutInMs) {
                this.nodeCache = this.findAllNodesAsMap();
                this.nodeCacheTime = System.currentTimeMillis();
            }
            return this.nodeCache.get(id);
        }
        return this.findNode(id);
    }

    @Override
    public void flushNodeCache() {
        this.nodeCacheTime = 0L;
    }

    @Override
    public Node findNodeByExternalId(String nodeGroupId, String externalId) {
        List list = this.sqlTemplate.query(this.getSql("selectNodePrefixSql", "findNodeByExternalIdSql"), (ISqlRowMapper)new NodeRowMapper(), new Object[]{nodeGroupId, externalId});
        return (Node)this.getFirstEntry(list);
    }

    @Override
    public void ignoreNodeChannelForExternalId(boolean enabled, String channelId, String nodeGroupId, String externalId) {
        Node node = this.findNodeByExternalId(nodeGroupId, externalId);
        if (this.sqlTemplate.update(this.getSql("nodeChannelControlIgnoreSql"), new Object[]{enabled ? 1 : 0, node.getNodeId(), channelId}) <= 0) {
            this.sqlTemplate.update(this.getSql("insertNodeChannelControlSql"), new Object[]{node.getNodeId(), channelId, enabled ? 1 : 0, 0});
        }
    }

    @Override
    public List<NodeHost> findNodeHosts(String nodeId) {
        return this.sqlTemplate.query(this.getSql("selectNodeHostPrefixSql", "selectNodeHostByNodeIdSql"), (ISqlRowMapper)new NodeHostRowMapper(), new Object[]{nodeId});
    }

    @Override
    public void deleteNodeHost(String nodeId) {
        this.platform.getSqlTemplate().update(this.getSql("deleteNodeHostSql"), new Object[]{nodeId});
    }

    @Override
    public void deleteNodeHostInstance(String nodeId, String instanceId) {
        this.platform.getSqlTemplate().update(this.getSql("deleteNodeHostInstanceSql"), new Object[]{nodeId, instanceId});
    }

    @Override
    public void updateNodeHost(NodeHost nodeHost) {
        if (this.sqlTemplate.update(this.getSql("updateNodeHostSql"), new Object[]{nodeHost.getIpAddress(), nodeHost.getInstanceId(), nodeHost.getOsUser(), nodeHost.getOsName(), nodeHost.getOsArch(), nodeHost.getOsVersion(), nodeHost.getAvailableProcessors(), nodeHost.getFreeMemoryBytes(), nodeHost.getTotalMemoryBytes(), nodeHost.getMaxMemoryBytes(), nodeHost.getJavaVersion(), nodeHost.getJavaVendor(), nodeHost.getJdbcVersion(), nodeHost.getSymmetricVersion(), nodeHost.getTimezoneOffset(), nodeHost.getHeartbeatTime(), nodeHost.getLastRestartTime(), nodeHost.getNodeId(), nodeHost.getHostName()}) <= 0) {
            this.sqlTemplate.update(this.getSql("insertNodeHostSql"), new Object[]{nodeHost.getIpAddress(), nodeHost.getInstanceId(), nodeHost.getOsUser(), nodeHost.getOsName(), nodeHost.getOsArch(), nodeHost.getOsVersion(), nodeHost.getAvailableProcessors(), nodeHost.getFreeMemoryBytes(), nodeHost.getTotalMemoryBytes(), nodeHost.getMaxMemoryBytes(), nodeHost.getJavaVersion(), nodeHost.getJavaVendor(), nodeHost.getJdbcVersion(), nodeHost.getSymmetricVersion(), nodeHost.getTimezoneOffset(), nodeHost.getHeartbeatTime(), nodeHost.getLastRestartTime(), new Date(), nodeHost.getNodeId(), nodeHost.getHostName()});
        }
    }

    @Override
    public void updateNodeHostForCurrentNode() {
        if (this.nodeHostForCurrentNode == null) {
            this.nodeHostForCurrentNode = new NodeHost(this.findIdentityNodeId(), this.engine.getClusterService().getInstanceId());
        }
        this.nodeHostForCurrentNode.refresh(this.platform, this.engine.getClusterService().getInstanceId());
        this.updateNodeHost(this.nodeHostForCurrentNode);
    }

    @Override
    public void deleteNode(String nodeId, boolean syncChange) {
        this.deleteNode(nodeId, null, syncChange);
    }

    @Override
    public synchronized void deleteNode(String nodeId, String targetNodeId, boolean syncChange) {
        this.log.info("Unregistering node {} and removing it from database", (Object)nodeId);
        if (StringUtils.isNotBlank((CharSequence)nodeId)) {
            for (ProcessInfo info : this.engine.getStatisticManager().getProcessInfos()) {
                if ((info.getTargetNodeId() == null || !info.getTargetNodeId().equals(nodeId)) && (info.getSourceNodeId() == null || !info.getSourceNodeId().equals(nodeId))) continue;
                this.log.info("Sending interrupt to " + String.valueOf(info.getKey()) + ",batchId=" + info.getCurrentBatchId());
                info.getThread().interrupt();
            }
            ISqlTransaction transaction = null;
            try {
                String myNode;
                transaction = this.sqlTemplate.startSqlTransaction();
                if (!syncChange) {
                    this.symmetricDialect.disableSyncTriggers(transaction, nodeId);
                }
                if (StringUtils.isNotBlank((CharSequence)(myNode = this.findIdentityNodeId())) && myNode.equals(nodeId)) {
                    transaction.prepareAndExecute(this.getSql("deleteNodeIdentitySql"), new Object[0]);
                    this.cachedNodeIdentity = null;
                }
                transaction.prepareAndExecute(this.getSql("deleteNodeSecuritySql"), new Object[]{nodeId});
                transaction.prepareAndExecute(this.getSql("deleteNodeHostSql"), new Object[]{nodeId});
                transaction.prepareAndExecute(this.getSql("deleteNodeSql"), new Object[]{nodeId});
                transaction.prepareAndExecute(this.getSql("deleteNodeChannelCtlSql"), new Object[]{nodeId});
                transaction.prepareAndExecute(this.getSql("deleteIncomingErrorSql"), new Object[]{StringUtils.isNotBlank((CharSequence)targetNodeId) ? targetNodeId : nodeId});
                transaction.prepareAndExecute(this.getSql("deleteExtractRequestSql"), new Object[]{nodeId, nodeId});
                transaction.prepareAndExecute(this.getSql("deleteNodeCommunicationSql"), new Object[]{StringUtils.isNotBlank((CharSequence)targetNodeId) ? targetNodeId : nodeId});
                transaction.prepareAndExecute(this.getSql("deleteTableReloadRequestSql"), new Object[]{nodeId, nodeId});
                transaction.prepareAndExecute(this.getSql("cancelTableReloadStatusSql"), new Object[]{new Date(), new Date(), nodeId, nodeId});
                transaction.prepareAndExecute(this.getSql("setOutgoingBatchOkSql"), new Object[]{StringUtils.isNotBlank((CharSequence)targetNodeId) ? targetNodeId : nodeId});
                transaction.prepareAndExecute(this.getSql("deleteIncomingBatchSql"), new Object[]{StringUtils.isNotBlank((CharSequence)targetNodeId) ? targetNodeId : nodeId});
                transaction.commit();
            }
            catch (Error ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            catch (RuntimeException ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            finally {
                if (!syncChange) {
                    this.symmetricDialect.enableSyncTriggers(transaction);
                }
                this.close(transaction);
            }
        }
    }

    @Override
    public void insertNodeIdentity(String nodeId) {
        this.sqlTemplate.update(this.getSql("insertNodeIdentitySql"), new Object[]{nodeId});
    }

    @Override
    public boolean deleteIdentity() {
        boolean successful = false;
        try {
            this.sqlTemplate.update(this.getSql("deleteNodeIdentitySql"), new Object[0]);
            successful = true;
        }
        catch (SqlException ex) {
            this.log.debug(ex.getMessage());
        }
        finally {
            this.cachedNodeIdentity = null;
        }
        return successful;
    }

    @Override
    public void insertNodeGroup(String groupId, String description) {
        if (this.sqlTemplate.queryForInt(this.getSql("doesNodeGroupExistSql"), new Object[]{groupId}) == 0) {
            this.sqlTemplate.update(this.getSql("insertNodeGroupSql"), new Object[]{description, groupId});
        }
    }

    @Override
    public void save(Node node) {
        if (!this.updateNode(node)) {
            this.sqlTemplate.update(this.getSql("insertNodeSql"), new Object[]{node.getNodeGroupId(), node.getExternalId(), node.getDatabaseType(), node.getDatabaseVersion(), node.getDatabaseName(), node.getSchemaVersion(), node.getSymmetricVersion(), node.getSyncUrl(), node.isSyncEnabled() ? 1 : 0, node.getBatchToSendCount(), node.getBatchInErrorCount(), node.getLastSuccessfulSyncDate(), node.getMostRecentActiveTableSynced(), node.getPurgeOutgoingAverageMs(), node.getPurgeOutgoingLastMs(), node.getPurgeOutgoingLastRun(), node.getRoutingAverageMs(), node.getRoutingLastMs(), node.getRoutingLastRun(), node.getSymDataSize(), node.getCreatedAtNodeId(), node.getDeploymentType(), node.getDeploymentSubType(), node.getConfigVersion(), node.getDataRowsToSendCount(), node.getDataRowsLoadedCount(), node.getOldestLoadTime(), node.getNodeId()}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 4, 4, 4, 93, 12, -5, -5, 93, -5, -5, 93, -5, 12, 12, 12, 12, 4, 4, 93, 12});
        }
        this.flushNodeGroupCache();
        this.flushNodeCache();
        this.cacheManager.flushTargetNodesCache();
        this.cacheManager.flushSourceNodesCache();
    }

    public boolean updateNode(Node node) {
        boolean updated = this.sqlTemplate.update(this.getSql("updateNodeSql"), new Object[]{node.getNodeGroupId(), node.getExternalId(), node.getDatabaseType(), node.getDatabaseVersion(), node.getDatabaseName(), node.getSchemaVersion(), node.getSymmetricVersion(), node.getSyncUrl(), node.isSyncEnabled() ? 1 : 0, node.getBatchToSendCount(), node.getBatchInErrorCount(), node.getLastSuccessfulSyncDate(), node.getMostRecentActiveTableSynced(), node.getPurgeOutgoingAverageMs(), node.getPurgeOutgoingLastMs(), node.getPurgeOutgoingLastRun(), node.getRoutingAverageMs(), node.getRoutingLastMs(), node.getRoutingLastRun(), node.getSymDataSize(), node.getCreatedAtNodeId(), node.getDeploymentType(), node.getDeploymentSubType(), node.getConfigVersion(), node.getDataRowsToSendCount(), node.getDataRowsLoadedCount(), node.getOldestLoadTime(), node.getNodeId()}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 4, 4, 4, 93, 12, -5, -5, 93, -5, -5, 93, -5, 12, 12, 12, 12, 4, 4, 93, 12}) == 1;
        return updated;
    }

    protected <T> T getFirstEntry(List<T> list) {
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Node getCachedIdentity() {
        return this.cachedNodeIdentity;
    }

    @Override
    public Node findIdentity() {
        return this.findIdentity(true);
    }

    @Override
    public Node findIdentity(boolean useCache) {
        return this.findIdentity(useCache, true);
    }

    @Override
    public Node findIdentity(boolean useCache, boolean logSqlError) {
        block3: {
            if (this.cachedNodeIdentity == null || !useCache) {
                try {
                    List list = this.sqlTemplate.query(this.getSql("selectNodePrefixSql", "findNodeIdentitySql"), (ISqlRowMapper)new NodeRowMapper(), new Object[0]);
                    this.cachedNodeIdentity = (Node)this.getFirstEntry(list);
                }
                catch (SqlException ex) {
                    if (!logSqlError) break block3;
                    this.log.debug("Failed to load the node identity. Returning " + String.valueOf(this.cachedNodeIdentity), (Throwable)ex);
                }
            }
        }
        return this.cachedNodeIdentity;
    }

    @Override
    public List<Node> findNodesToPull() {
        return this.findSourceNodesFor(NodeGroupLinkAction.W);
    }

    @Override
    public List<Node> findNodesWhoPushToMe() {
        return this.findSourceNodesFor(NodeGroupLinkAction.P);
    }

    @Override
    public List<Node> findNodesToPushTo() {
        return this.findTargetNodesFor(NodeGroupLinkAction.P);
    }

    @Override
    public List<Node> findNodesWhoPullFromMe() {
        return this.findTargetNodesFor(NodeGroupLinkAction.W);
    }

    @Override
    public List<Node> findSourceNodesFor(NodeGroupLinkAction eventAction) {
        Node node = this.findIdentity();
        if (node != null) {
            return this.cacheManager.getSourceNodesCache(eventAction, node);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Node> getSourceNodesFromDatabase(NodeGroupLinkAction eventAction, Node node) {
        if (node != null) {
            return this.sqlTemplate.query(this.getSql("selectNodePrefixSql", "findNodesWhoTargetMeSql"), (ISqlRowMapper)new NodeRowMapper(), new Object[]{node.getNodeGroupId(), eventAction.name()});
        }
        return Collections.emptyList();
    }

    @Override
    public List<Node> findTargetNodesFor(NodeGroupLinkAction eventAction) {
        Node node = this.findIdentity();
        if (node != null) {
            return this.cacheManager.getTargetNodesCache(eventAction, node);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Node> getTargetNodesFromDatabase(NodeGroupLinkAction eventAction, Node node) {
        if (node != null) {
            return this.sqlTemplate.query(this.getSql("selectNodePrefixSql", "findNodesWhoITargetSql"), (ISqlRowMapper)new NodeRowMapper(), new Object[]{node.getNodeGroupId(), eventAction.name()});
        }
        return Collections.emptyList();
    }

    @Override
    public void flushNodeGroupCache() {
        this.cacheManager.flushSourceNodesCache();
        this.cacheManager.flushTargetNodesCache();
    }

    @Override
    public List<String> findAllExternalIds() {
        return this.sqlTemplate.query(this.getSql("selectExternalIdsSql"), (ISqlRowMapper)new StringMapper(), new Object[0]);
    }

    @Override
    public List<Node> findAllNodes() {
        List nodeList = this.sqlTemplate.query(this.getSql("selectNodePrefixSql"), (ISqlRowMapper)new NodeRowMapper(), new Object[0]);
        return nodeList;
    }

    @Override
    public List<Node> findAllNodes(boolean useCache) {
        if (useCache) {
            this.findNode(this.findIdentityNodeId(), true);
            return new ArrayList<Node>(this.nodeCache.values());
        }
        return this.findAllNodes();
    }

    @Override
    public Map<String, Node> findAllNodesAsMap() {
        List<Node> nodes = this.findAllNodes();
        HashMap<String, Node> nodeMap = new HashMap<String, Node>(nodes.size());
        for (Node node : nodes) {
            nodeMap.put(node.getNodeId(), node);
        }
        return nodeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Node> findFilteredNodesWithLimit(int offset, int limit, List<FilterCriterion> filter, String orderColumn, String orderDirection) {
        ArrayList<Node> nodeList;
        String where = filter != null ? this.buildWhere(filter) : null;
        Map<Object, Object> params = filter != null ? this.buildParams(filter) : new HashMap();
        String orderBy = this.buildOrderBy(orderColumn, orderDirection);
        String sql = this.getSql("selectNodePrefixSql", where, orderBy);
        if (this.platform.supportsLimitOffset()) {
            sql = this.platform.massageForLimitOffset(sql, limit, offset);
            nodeList = this.sqlTemplateDirty.query(sql, (ISqlRowMapper)new NodeRowMapper(), params);
        } else {
            try (ISqlReadCursor cursor = this.sqlTemplateDirty.queryForCursor(sql, (ISqlRowMapper)new NodeRowMapper(), params);){
                Node next = null;
                nodeList = new ArrayList<Node>();
                int rowCount = 0;
                do {
                    if ((next = (Node)cursor.next()) != null) {
                        if (offset <= rowCount && rowCount < limit + offset) {
                            nodeList.add(next);
                        }
                        ++rowCount;
                    }
                    if (rowCount < limit + offset) continue;
                    break;
                } while (next != null);
            }
        }
        return nodeList;
    }

    @Override
    public int countFilteredNodes(List<FilterCriterion> filter) {
        String where = filter != null ? this.buildWhere(filter) : null;
        Map<Object, Object> params = filter != null ? this.buildParams(filter) : new HashMap();
        String sql = "select count(*) from " + TableConstants.getTableName(this.parameterService.getTablePrefix(), "node") + where;
        int size = this.sqlTemplate.queryForInt(sql, params);
        return size;
    }

    protected String buildWhere(List<FilterCriterion> filter) {
        StringBuilder where = new StringBuilder();
        boolean needsAnd = false;
        int id = 0;
        for (FilterCriterion criterion : filter) {
            if (needsAnd) {
                where.append(" and ");
            } else {
                needsAnd = true;
            }
            FilterCriterion.FilterOption option = criterion.getOption();
            String optionSql = option.toSql();
            String prefix = criterion.getPropertyId().replaceAll("([a-z])([A-Z]+)", "$1_$2").toLowerCase() + " " + optionSql;
            where.append(prefix + " :" + id++);
        }
        if (where.length() > 0) {
            where.insert(0, " where ");
        }
        return where.toString();
    }

    protected Map<String, Object> buildParams(List<FilterCriterion> filter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        int id = 0;
        for (FilterCriterion criterion : filter) {
            Object value = criterion.getValues().get(0);
            FilterCriterion.FilterOption option = criterion.getOption();
            if (option.equals((Object)FilterCriterion.FilterOption.CONTAINS)) {
                value = "%" + String.valueOf(value) + "%";
            } else if (option.equals((Object)FilterCriterion.FilterOption.STARTS_WITH)) {
                value = String.valueOf(value) + "%";
            }
            params.put(String.valueOf(id++), value);
        }
        return params;
    }

    protected String buildOrderBy(String orderColumn, String orderDirection) {
        Object orderBy = " order by ";
        if (orderColumn == null) {
            orderBy = (String)orderBy + "node_id desc";
        } else {
            orderBy = (String)orderBy + orderColumn.replaceAll("([a-z])([A-Z]+)", "$1_$2").toLowerCase();
            if (orderDirection.equals("DESCENDING")) {
                orderBy = (String)orderBy + " desc";
            }
        }
        return orderBy;
    }

    @Override
    public NetworkedNode getRootNetworkedNode() {
        Map<String, Node> nodes = this.findAllNodesAsMap();
        HashMap<String, NetworkedNode> leaves = new HashMap<String, NetworkedNode>(nodes.size());
        NetworkedNode nodeLeaf = null;
        for (Node node : nodes.values()) {
            nodeLeaf = (NetworkedNode)leaves.get(node.getNodeId());
            if (nodeLeaf != null) continue;
            nodeLeaf = new NetworkedNode(node);
            nodeLeaf.addParents(nodes, leaves);
            leaves.put(node.getNodeId(), nodeLeaf);
        }
        nodeLeaf = (NetworkedNode)leaves.get(this.findIdentityNodeId());
        if (nodeLeaf != null) {
            NetworkedNode root = nodeLeaf.getRoot();
            root.setAllNetworkedNodes(leaves);
            return root;
        }
        return null;
    }

    @Override
    public Node findRootNode() {
        List nodeList = this.sqlTemplate.query(this.getSql("selectNodePrefixSql", "findRootNodeSql"), (ISqlRowMapper)new NodeRowMapper(), new Object[0]);
        if (nodeList.size() > 0) {
            return (Node)nodeList.get(0);
        }
        return null;
    }

    @Override
    public NodeSecurity findNodeSecurity(String id) {
        return this.findNodeSecurity(id, false);
    }

    @Override
    public NodeSecurity findNodeSecurity(String nodeId, boolean useCache) {
        if (!this.parameterService.is("cluster.lock.enabled") && useCache) {
            Map<String, NodeSecurity> nodeSecurities = this.findAllNodeSecurity(true);
            return nodeSecurities.get(nodeId);
        }
        List list = this.sqlTemplate.query(this.getSql("selectNodeSecuritySql", "findNodeSecurityByNodeIdSql"), (ISqlRowMapper)new NodeSecurityRowMapper(), new Object[]{nodeId}, new int[]{12});
        return (NodeSecurity)this.getFirstEntry(list);
    }

    @Override
    public NodeSecurity findOrCreateNodeSecurity(String nodeId) {
        try {
            if (nodeId != null) {
                NodeSecurity security = this.findNodeSecurity(nodeId, false);
                if (security == null) {
                    this.insertNodeSecurity(nodeId);
                    security = this.findNodeSecurity(nodeId, true);
                }
                return security;
            }
            this.log.debug("A 'null' node id was passed into findNodeSecurity");
            return null;
        }
        catch (UniqueKeyException ex) {
            this.log.error("Could not find a node security row for '{}'", (Object)nodeId);
            throw ex;
        }
    }

    @Override
    public boolean isRegistrationEnabled(String nodeId) {
        NodeSecurity nodeSecurity = this.findNodeSecurity(nodeId);
        if (nodeSecurity != null) {
            return nodeSecurity.isRegistrationEnabled();
        }
        return false;
    }

    public void insertNodeSecurity(String id) {
        String password = this.extensionService.getExtensionPoint(INodeIdCreator.class).generatePassword(new Node(id, null, null));
        password = this.filterPasswordOnSaveIfNeeded(password, id);
        this.sqlTemplate.update(this.getSql("insertNodeSecuritySql"), new Object[]{id, password, null});
        this.flushNodeAuthorizedCache();
    }

    @Override
    public void deleteNodeSecurity(String nodeId) {
        this.sqlTemplate.update(this.getSql("deleteNodeSecuritySql"), new Object[]{nodeId});
        this.flushNodeAuthorizedCache();
    }

    @Override
    public List<NodeSecurity> findNodeSecurityWithLoadEnabled() {
        if (this.parameterService.is("cluster.lock.enabled")) {
            return this.sqlTemplate.query(this.getSql("selectNodeSecuritySql", "findNodeSecurityWithLoadEnabledSql"), (ISqlRowMapper)new NodeSecurityRowMapper(), new Object[0]);
        }
        ArrayList<NodeSecurity> list = new ArrayList<NodeSecurity>();
        for (NodeSecurity nodeSecurity : this.findAllNodeSecurity(true).values()) {
            if (!nodeSecurity.isInitialLoadEnabled() && !nodeSecurity.isRevInitialLoadEnabled()) continue;
            list.add(nodeSecurity);
        }
        return list;
    }

    @Override
    public synchronized Map<String, NodeSecurity> findAllNodeSecurity(boolean useCache) {
        long maxSecurityCacheTime = this.parameterService.getLong("cache.node.security.time.ms");
        Map all = this.securityCache;
        if (all == null || System.currentTimeMillis() - this.securityCacheTime >= maxSecurityCacheTime || this.securityCacheTime == 0L || !useCache) {
            this.securityCache = all = this.sqlTemplate.queryForMap(this.getSql("selectNodeSecuritySql"), (ISqlRowMapper)new NodeSecurityRowMapper(), "node_id", new Object[0]);
            this.securityCacheTime = System.currentTimeMillis();
        }
        return all;
    }

    @Override
    public boolean isNodeAuthorized(String nodeId, String password) {
        int maxFailedLogins = this.parameterService.getInt("node.password.failed.attempts");
        Map<String, NodeSecurity> nodeSecurities = this.findAllNodeSecurity(true);
        NodeSecurity nodeSecurity = nodeSecurities.get(nodeId);
        return nodeSecurity != null && (!nodeId.equals(this.findIdentityNodeId()) && StringUtils.isNotBlank((CharSequence)nodeSecurity.getNodePassword()) && nodeSecurity.getNodePassword().equals(password) && (maxFailedLogins <= 0 || nodeSecurity.getFailedLogins() < maxFailedLogins) || nodeSecurity.isRegistrationEnabled());
    }

    protected boolean isNodeAuthorizationLocked(String nodeId) {
        int maxFailedLogins = this.parameterService.getInt("node.password.failed.attempts");
        if (maxFailedLogins > 0) {
            Map<String, NodeSecurity> nodeSecurities = this.findAllNodeSecurity(true);
            NodeSecurity nodeSecurity = nodeSecurities.get(nodeId);
            return nodeSecurity != null && nodeSecurity.getFailedLogins() >= maxFailedLogins;
        }
        return false;
    }

    protected boolean isNodePasswordFailedDecrypt(String nodeId) {
        Map<String, NodeSecurity> nodeSecurities = this.findAllNodeSecurity(true);
        NodeSecurity nodeSecurity = nodeSecurities.get(nodeId);
        return nodeSecurity != null && nodeSecurity.getNodePassword() == null;
    }

    @Override
    public void flushNodeAuthorizedCache() {
        this.securityCacheTime = 0L;
    }

    @Override
    public boolean updateNodeSecurity(NodeSecurity security) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            boolean updated = this.updateNodeSecurity(transaction, security);
            transaction.commit();
            boolean bl = updated;
            return bl;
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
    }

    @Override
    public boolean updateNodeSecurity(ISqlTransaction transaction, NodeSecurity security) {
        security.setNodePassword(this.filterPasswordOnSaveIfNeeded(security.getNodePassword(), security.getNodeId()));
        String sql = this.getSql("updateNodeSecuritySql");
        Object[] values = new Object[]{security.getNodePassword(), security.isRegistrationEnabled() ? 1 : 0, security.getRegistrationTime(), security.getRegistrationNotBefore(), security.getRegistrationNotAfter(), security.isInitialLoadEnabled() ? 1 : 0, security.getInitialLoadTime(), security.getInitialLoadEndTime(), security.getCreatedAtNodeId(), security.isRevInitialLoadEnabled() ? 1 : 0, security.getRevInitialLoadTime(), security.getInitialLoadId(), security.getInitialLoadCreateBy(), security.getRevInitialLoadId(), security.getRevInitialLoadCreateBy(), security.getFailedLogins(), security.getPartialLoadTime(), security.getPartialLoadEndTime(), security.getPartialLoadId(), security.getPartialLoadCreateBy(), security.getNodeId()};
        int[] types = new int[]{12, 4, 93, 93, 93, 4, 93, 93, 12, 4, 93, -5, 12, -5, 12, 4, 93, 93, this.symmetricDialect.getSqlTypeForIds(), 12, 12};
        if (StringUtils.isBlank((CharSequence)security.getNodePassword())) {
            sql = sql.replace("node_password = ?,", "");
            values = ArrayUtils.subarray((Object[])values, (int)1, (int)values.length);
            types = ArrayUtils.subarray((int[])types, (int)1, (int)types.length);
        }
        int updateCount = transaction.prepareAndExecute(sql, values, types);
        this.flushNodeAuthorizedCache();
        return updateCount == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setInitialLoadEnabled(ISqlTransaction transaction, String nodeId, boolean initialLoadEnabled, boolean syncChange, long loadId, String createBy) {
        try {
            NodeSecurity nodeSecurity;
            if (!syncChange) {
                this.symmetricDialect.disableSyncTriggers(transaction, nodeId);
            }
            if ((nodeSecurity = this.findOrCreateNodeSecurity(nodeId)) != null) {
                nodeSecurity.setInitialLoadEnabled(initialLoadEnabled);
                nodeSecurity.setInitialLoadId(loadId);
                nodeSecurity.setInitialLoadEndTime(null);
                nodeSecurity.setInitialLoadCreateBy(createBy);
                if (initialLoadEnabled) {
                    nodeSecurity.setInitialLoadTime(null);
                } else {
                    nodeSecurity.setInitialLoadTime(new Date());
                }
                boolean bl = this.updateNodeSecurity(transaction, nodeSecurity);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (!syncChange) {
                this.symmetricDialect.enableSyncTriggers(transaction);
            }
        }
    }

    @Override
    public boolean setInitialLoadEnabled(String nodeId, boolean initialLoadEnabled, boolean syncChange, long loadId, String createBy) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            boolean updated = this.setInitialLoadEnabled(transaction, nodeId, initialLoadEnabled, syncChange, loadId, createBy);
            transaction.commit();
            boolean bl = updated;
            return bl;
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
    }

    @Override
    public boolean setInitialLoadEnded(ISqlTransaction transaction, String nodeId) {
        boolean isAutoCommit = false;
        try {
            if (transaction == null) {
                transaction = this.sqlTemplate.startSqlTransaction();
                isAutoCommit = true;
            }
            NodeSecurity nodeSecurity = this.findOrCreateNodeSecurity(nodeId);
            boolean isUpdated = false;
            if (nodeSecurity != null) {
                nodeSecurity.setInitialLoadEndTime(new Date());
                isUpdated = this.updateNodeSecurity(transaction, nodeSecurity);
            }
            if (isAutoCommit) {
                transaction.commit();
            }
            boolean bl = isUpdated;
            return bl;
        }
        catch (Error ex) {
            if (isAutoCommit && transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (isAutoCommit && transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            if (isAutoCommit) {
                this.close(transaction);
            }
        }
    }

    @Override
    public boolean setPartialLoadStarted(ISqlTransaction transaction, String nodeId, long loadId, String createBy) {
        NodeSecurity nodeSecurity = this.findOrCreateNodeSecurity(nodeId);
        if (nodeSecurity != null) {
            nodeSecurity.setPartialLoadId(loadId);
            nodeSecurity.setPartialLoadTime(new Date());
            nodeSecurity.setPartialLoadEndTime(null);
            nodeSecurity.setPartialLoadCreateBy(createBy);
            return this.updateNodeSecurity(transaction, nodeSecurity);
        }
        return false;
    }

    @Override
    public boolean setPartialLoadEnded(ISqlTransaction transaction, String nodeId) {
        boolean isAutoCommit = false;
        try {
            if (transaction == null) {
                transaction = this.sqlTemplate.startSqlTransaction();
                isAutoCommit = true;
            }
            NodeSecurity nodeSecurity = this.findOrCreateNodeSecurity(nodeId);
            boolean isUpdated = false;
            if (nodeSecurity != null) {
                nodeSecurity.setPartialLoadEndTime(new Date());
                isUpdated = this.updateNodeSecurity(transaction, nodeSecurity);
            }
            if (isAutoCommit) {
                transaction.commit();
            }
            boolean bl = isUpdated;
            return bl;
        }
        catch (Error ex) {
            if (isAutoCommit && transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (isAutoCommit && transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            if (isAutoCommit) {
                this.close(transaction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setReverseInitialLoadEnabled(ISqlTransaction transaction, String nodeId, boolean initialLoadEnabled, boolean syncChange, long loadId, String createBy) {
        try {
            NodeSecurity nodeSecurity;
            if (!syncChange) {
                this.symmetricDialect.disableSyncTriggers(transaction, nodeId);
            }
            if ((nodeSecurity = this.findOrCreateNodeSecurity(nodeId)) != null) {
                nodeSecurity.setRevInitialLoadEnabled(initialLoadEnabled);
                nodeSecurity.setRevInitialLoadId(loadId);
                if (initialLoadEnabled) {
                    nodeSecurity.setRevInitialLoadTime(null);
                    nodeSecurity.setRevInitialLoadCreateBy(createBy);
                } else {
                    nodeSecurity.setRevInitialLoadTime(new Date());
                }
                boolean bl = this.updateNodeSecurity(transaction, nodeSecurity);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (!syncChange) {
                this.symmetricDialect.enableSyncTriggers(transaction);
            }
        }
    }

    @Override
    public boolean setReverseInitialLoadEnabled(String nodeId, boolean initialLoadEnabled, boolean syncChange, long loadId, String createBy) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            boolean updated = this.setReverseInitialLoadEnabled(transaction, nodeId, initialLoadEnabled, syncChange, loadId, createBy);
            transaction.commit();
            boolean bl = updated;
            return bl;
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
    }

    @Override
    public boolean isExternalIdRegistered(String nodeGroupId, String externalId) {
        return this.sqlTemplate.queryForInt(this.getSql("isNodeRegisteredSql"), new Object[]{nodeGroupId, externalId}) > 0;
    }

    @Override
    public boolean isDataLoadCompleted() {
        return this.getNodeStatus() == NodeStatus.DATA_LOAD_COMPLETED;
    }

    @Override
    public boolean isDataLoadCompleted(String nodeId) {
        return this.getNodeStatus(nodeId) == NodeStatus.DATA_LOAD_COMPLETED;
    }

    @Override
    public boolean isDataLoadStarted() {
        return this.getNodeStatus() == NodeStatus.DATA_LOAD_STARTED;
    }

    @Override
    public boolean isDataLoadStarted(String nodeId) {
        return this.getNodeStatus(nodeId) == NodeStatus.DATA_LOAD_STARTED;
    }

    @Override
    public boolean isRegistrationServer() {
        return this.parameterService.isRegistrationServer();
    }

    @Override
    public NodeStatus getNodeStatus() {
        return this.getNodeStatus(this.findIdentityNodeId());
    }

    @Override
    public NodeStatus getNodeStatus(String nodeId) {
        long ts = System.currentTimeMillis();
        try {
            NodeSecurity nodeSecurity = this.findNodeSecurity(nodeId, true);
            if (nodeSecurity != null) {
                if (nodeSecurity.isInitialLoadEnabled() || nodeSecurity.getInitialLoadTime() != null && nodeSecurity.getInitialLoadEndTime() == null) {
                    return NodeStatus.DATA_LOAD_STARTED;
                }
                if (nodeSecurity.getInitialLoadEndTime() != null) {
                    return NodeStatus.DATA_LOAD_COMPLETED;
                }
            }
            return NodeStatus.DATA_LOAD_NOT_STARTED;
        }
        catch (SqlException ex) {
            this.log.error("Could not query table after {} ms.  The status is unknown.", (Object)(System.currentTimeMillis() - ts), (Object)ex);
            return NodeStatus.STATUS_UNKNOWN;
        }
    }

    public void setNodePasswordFilter(INodePasswordFilter nodePasswordFilter) {
        this.nodePasswordFilter = nodePasswordFilter;
    }

    private String filterPasswordOnSaveIfNeeded(String password, String nodeId) {
        String s = password;
        if (this.nodePasswordFilter != null) {
            s = this.nodePasswordFilter.onNodeSecuritySave(password, nodeId);
        }
        return s;
    }

    private String filterPasswordOnRenderIfNeeded(String password, String nodeId) {
        String s = password;
        if (this.nodePasswordFilter != null) {
            s = this.nodePasswordFilter.onNodeSecurityRender(password, nodeId);
        }
        return s;
    }

    @Override
    public void checkForOfflineNodes() {
        List<Node> list;
        long offlineNodeDetectionMinutes = this.parameterService.getLong("offline.node.detection.period.minutes");
        List<IOfflineServerListener> offlineServerListeners = this.extensionService.getExtensionPointList(IOfflineServerListener.class);
        if (offlineServerListeners != null && offlineNodeDetectionMinutes > 0L && (list = this.findOfflineNodes()).size() > 0) {
            this.fireOffline(list);
        }
    }

    @Override
    public List<Node> findOfflineNodes() {
        return this.findOfflineNodes(this.parameterService.getLong("offline.node.detection.period.minutes"));
    }

    @Override
    public List<Node> findOfflineNodes(long minutesOffline) {
        Date lastRestartTime;
        ArrayList<Node> offlineNodeList = new ArrayList<Node>();
        Node myNode = this.findIdentity();
        long restartDelayMinutes = this.parameterService.getLong("offline.node.detection.restart.minutes");
        Date date = lastRestartTime = this.engine.getLastRestartTime() != null ? this.engine.getLastRestartTime() : new Date();
        if (myNode != null && System.currentTimeMillis() - lastRestartTime.getTime() > restartDelayMinutes * 60000L) {
            long offlineNodeDetectionMillis = minutesOffline * 60L * 1000L;
            List list = this.sqlTemplateDirty.query(this.getSql("findNodeHeartbeatsSql"));
            for (Row node : list) {
                String nodeId = node.getString("node_id");
                Date time = node.getDateTime("heartbeat_time");
                String offset = node.getString("timezone_offset");
                Date clientNodeCurrentTime = null;
                clientNodeCurrentTime = offset != null ? AppUtils.getLocalDateForOffset((String)offset) : new Date();
                long cutOffTimeMillis = clientNodeCurrentTime.getTime() - offlineNodeDetectionMillis;
                if (time != null && time.getTime() >= cutOffTimeMillis) continue;
                offlineNodeList.add(this.findNode(nodeId, true));
            }
        }
        return offlineNodeList;
    }

    @Override
    public Map<String, Date> findLastHeartbeats() {
        HashMap<String, Date> dates = new HashMap<String, Date>();
        Node myNode = this.findIdentity();
        if (myNode != null) {
            List list = this.sqlTemplateDirty.query(this.getSql("findNodeHeartbeatsSql"));
            for (Row node : list) {
                String nodeId = node.getString("node_id");
                Date time = node.getDateTime("heartbeat_time");
                dates.put(nodeId, time);
            }
        }
        return dates;
    }

    @Override
    public List<String> findOfflineNodeIds(long minutesOffline) {
        ArrayList<String> offlineNodeList = new ArrayList<String>();
        Node myNode = this.findIdentity();
        if (myNode != null) {
            long offlineNodeDetectionMillis = minutesOffline * 60L * 1000L;
            List list = this.sqlTemplateDirty.query(this.getSql("findNodeHeartbeatsSql"));
            for (Row node : list) {
                String nodeId = node.getString("node_id");
                Date time = node.getDateTime("heartbeat_time");
                String offset = node.getString("timezone_offset");
                Date clientNodeCurrentTime = null;
                clientNodeCurrentTime = offset != null ? AppUtils.getLocalDateForOffset((String)offset) : new Date();
                long cutOffTimeMillis = clientNodeCurrentTime.getTime() - offlineNodeDetectionMillis;
                if (time != null && time.getTime() >= cutOffTimeMillis) continue;
                offlineNodeList.add(nodeId);
            }
        }
        return offlineNodeList;
    }

    protected void fireOffline(List<Node> offlineClientNodeList) {
        Node myNode = this.findIdentity();
        for (IOfflineServerListener listener : this.extensionService.getExtensionPointList(IOfflineServerListener.class)) {
            for (Node node : offlineClientNodeList) {
                if (myNode == null || myNode.equals(node)) continue;
                String myNodeId = myNode.getNodeId();
                if (myNodeId.equals(node.getCreatedAtNodeId())) {
                    listener.clientNodeOffline(node);
                    continue;
                }
                NodeSecurity security = this.findNodeSecurity(node.getNodeId());
                if (security == null || !myNodeId.equals(security.getCreatedAtNodeId())) continue;
                listener.clientNodeOffline(node);
            }
        }
    }

    @Override
    public INodeService.AuthenticationStatus getAuthenticationStatus(String nodeId, String securityToken) {
        INodeService.AuthenticationStatus retVal = INodeService.AuthenticationStatus.ACCEPTED;
        Node node = this.findNode(nodeId, true);
        if (node == null) {
            node = this.findNode(nodeId, false);
        }
        if (node == null) {
            retVal = INodeService.AuthenticationStatus.REGISTRATION_REQUIRED;
        } else if (!this.syncEnabled(node)) {
            retVal = this.registrationOpen(node) ? INodeService.AuthenticationStatus.REGISTRATION_REQUIRED : INodeService.AuthenticationStatus.SYNC_DISABLED;
        } else if (!this.isNodeAuthorized(nodeId, securityToken)) {
            retVal = this.isNodePasswordFailedDecrypt(nodeId) ? INodeService.AuthenticationStatus.FAILED_DECRYPT : (this.isNodeAuthorizationLocked(nodeId) ? INodeService.AuthenticationStatus.LOCKED : INodeService.AuthenticationStatus.FORBIDDEN);
        }
        return retVal;
    }

    @Override
    public void resetNodeFailedLogins(String nodeId) {
        Map<String, NodeSecurity> nodeSecurities;
        NodeSecurity nodeSecurity;
        if (this.parameterService.getInt("node.password.failed.attempts") >= 0 && (nodeSecurity = (nodeSecurities = this.findAllNodeSecurity(true)).get(nodeId)) != null && nodeSecurity.getFailedLogins() > 0) {
            nodeSecurity.setFailedLogins(0);
            nodeSecurity = this.findNodeSecurity(nodeId);
            if (nodeSecurity != null && nodeSecurity.getFailedLogins() > 0) {
                nodeSecurity.setFailedLogins(0);
                this.updateNodeSecurity(nodeSecurity);
            }
        }
    }

    @Override
    public void incrementNodeFailedLogins(String nodeId) {
        NodeSecurity nodeSecurity;
        int maxFailedAttempts = this.parameterService.getInt("node.password.failed.attempts");
        if (maxFailedAttempts >= 0 && (nodeSecurity = this.findNodeSecurity(nodeId)) != null && nodeSecurity.getFailedLogins() < maxFailedAttempts) {
            nodeSecurity.setFailedLogins(nodeSecurity.getFailedLogins() + 1);
            this.updateNodeSecurity(nodeSecurity);
            Map<String, NodeSecurity> cache = this.findAllNodeSecurity(true);
            NodeSecurity cacheSecurity = cache.get(nodeId);
            if (cacheSecurity != null) {
                cacheSecurity.setFailedLogins(nodeSecurity.getFailedLogins());
            }
        }
    }

    protected boolean syncEnabled(Node node) {
        boolean syncEnabled = false;
        if (node != null) {
            syncEnabled = node.isSyncEnabled();
        }
        return syncEnabled;
    }

    protected boolean registrationOpen(Node node) {
        NodeSecurity security = this.findNodeSecurity(node.getNodeId());
        if (security != null) {
            return security.isRegistrationEnabled();
        }
        return false;
    }

    public static class NodeRowMapper
    implements ISqlRowMapper<Node> {
        public Node mapRow(Row rs) {
            Node node = new Node();
            node.setNodeId(rs.getString("node_id"));
            node.setNodeGroupId(rs.getString("node_group_id"));
            node.setExternalId(rs.getString("external_id"));
            node.setSyncEnabled(rs.getBoolean("sync_enabled"));
            node.setSyncUrl(rs.getString("sync_url"));
            node.setSchemaVersion(rs.getString("schema_version"));
            node.setDatabaseType(rs.getString("database_type"));
            node.setDatabaseVersion(rs.getString("database_version"));
            node.setDatabaseName(rs.getString("database_name"));
            node.setSymmetricVersion(rs.getString("symmetric_version"));
            node.setCreatedAtNodeId(rs.getString("created_at_node_id"));
            node.setBatchToSendCount(rs.getInt("batch_to_send_count"));
            node.setBatchInErrorCount(rs.getInt("batch_in_error_count"));
            node.setDeploymentType(rs.getString("deployment_type"));
            node.setDeploymentSubType(rs.getString("deployment_sub_type"));
            node.setConfigVersion(rs.getString("config_version"));
            node.setPurgeOutgoingAverageMs(rs.getLong("purge_outgoing_average_ms"));
            node.setPurgeOutgoingLastMs(rs.getLong("purge_outgoing_last_run_ms"));
            node.setPurgeOutgoingLastRun(rs.getDateTime("purge_outgoing_last_finish"));
            node.setRoutingAverageMs(rs.getLong("routing_average_run_ms"));
            node.setRoutingLastMs(rs.getLong("routing_last_run_ms"));
            node.setRoutingLastRun(rs.getDateTime("routing_last_finish"));
            node.setSymDataSize(rs.getLong("sym_data_size"));
            return node;
        }
    }

    static class NodeHostRowMapper
    implements ISqlRowMapper<NodeHost> {
        NodeHostRowMapper() {
        }

        public NodeHost mapRow(Row rs) {
            NodeHost nodeHost = new NodeHost();
            nodeHost.setNodeId(rs.getString("node_id"));
            nodeHost.setHostName(rs.getString("host_name"));
            nodeHost.setInstanceId(rs.getString("instance_id"));
            nodeHost.setIpAddress(rs.getString("ip_address"));
            nodeHost.setOsUser(rs.getString("os_user"));
            nodeHost.setOsName(rs.getString("os_name"));
            nodeHost.setOsArch(rs.getString("os_arch"));
            nodeHost.setOsVersion(rs.getString("os_version"));
            nodeHost.setAvailableProcessors(rs.getInt("available_processors"));
            nodeHost.setFreeMemoryBytes(rs.getLong("free_memory_bytes"));
            nodeHost.setTotalMemoryBytes(rs.getLong("total_memory_bytes"));
            nodeHost.setMaxMemoryBytes(rs.getLong("max_memory_bytes"));
            nodeHost.setJavaVersion(rs.getString("java_version"));
            nodeHost.setJavaVendor(rs.getString("java_vendor"));
            nodeHost.setJdbcVersion(rs.getString("jdbc_version"));
            nodeHost.setSymmetricVersion(rs.getString("symmetric_version"));
            nodeHost.setTimezoneOffset(rs.getString("timezone_offset"));
            nodeHost.setHeartbeatTime(rs.getDateTime("heartbeat_time"));
            nodeHost.setLastRestartTime(rs.getDateTime("last_restart_time"));
            nodeHost.setCreateTime(rs.getDateTime("create_time"));
            return nodeHost;
        }
    }

    class NodeSecurityRowMapper
    implements ISqlRowMapper<NodeSecurity> {
        NodeSecurityRowMapper() {
        }

        public NodeSecurity mapRow(Row rs) {
            NodeSecurity nodeSecurity = new NodeSecurity();
            nodeSecurity.setNodeId(rs.getString("node_id"));
            nodeSecurity.setNodePassword(NodeService.this.filterPasswordOnRenderIfNeeded(rs.getString("node_password"), nodeSecurity.getNodeId()));
            nodeSecurity.setRegistrationEnabled(rs.getBoolean("registration_enabled"));
            nodeSecurity.setRegistrationTime(rs.getDateTime("registration_time"));
            nodeSecurity.setRegistrationNotBefore(rs.getDateTime("registration_not_before"));
            nodeSecurity.setRegistrationNotAfter(rs.getDateTime("registration_not_after"));
            nodeSecurity.setInitialLoadEnabled(rs.getBoolean("initial_load_enabled"));
            nodeSecurity.setInitialLoadTime(rs.getDateTime("initial_load_time"));
            nodeSecurity.setInitialLoadEndTime(rs.getDateTime("initial_load_end_time"));
            nodeSecurity.setCreatedAtNodeId(rs.getString("created_at_node_id"));
            nodeSecurity.setRevInitialLoadEnabled(rs.getBoolean("rev_initial_load_enabled"));
            nodeSecurity.setRevInitialLoadTime(rs.getDateTime("rev_initial_load_time"));
            nodeSecurity.setInitialLoadId(rs.getLong("initial_load_id"));
            nodeSecurity.setInitialLoadCreateBy(rs.getString("initial_load_create_by"));
            nodeSecurity.setRevInitialLoadId(rs.getLong("rev_initial_load_id"));
            nodeSecurity.setRevInitialLoadCreateBy(rs.getString("rev_initial_load_create_by"));
            nodeSecurity.setFailedLogins(rs.getInt("failed_logins"));
            if (rs.containsKey((Object)"partial_load_id")) {
                nodeSecurity.setPartialLoadId(rs.getLong("partial_load_id"));
                nodeSecurity.setPartialLoadTime(rs.getDateTime("partial_load_time"));
                nodeSecurity.setPartialLoadEndTime(rs.getDateTime("partial_load_end_time"));
                nodeSecurity.setPartialLoadCreateBy(rs.getString("partial_load_create_by"));
            }
            return nodeSecurity;
        }
    }
}

