/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.SimpleRouterContext;
import org.jumpmind.symmetric.util.DataUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataRouter
implements IDataRouter {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void contextCommitted(SimpleRouterContext context) {
    }

    protected Map<String, String> getDataMap(DataMetaData dataMetaData, ISymmetricDialect symmetricDialect) {
        return DataUtils.getDataMap(dataMetaData);
    }

    protected Map<String, String> getNewDataAsString(String prefix, DataMetaData dataMetaData, ISymmetricDialect symmetricDialect) {
        return DataUtils.getNewDataAsString(prefix, dataMetaData);
    }

    protected Map<String, String> getOldDataAsString(String prefix, DataMetaData dataMetaData, ISymmetricDialect symmetricDialect) {
        return DataUtils.getOldDataAsString(prefix, dataMetaData);
    }

    protected Map<String, String> getDataAsString(String prefix, DataMetaData dataMetaData, ISymmetricDialect symmetricDialect, String[] rowData) {
        return DataUtils.getDataAsString(prefix, dataMetaData, rowData);
    }

    protected Map<String, String> getPkDataAsString(DataMetaData dataMetaData, ISymmetricDialect symmetricDialect) {
        return DataUtils.getPkDataAsString(dataMetaData);
    }

    protected Map<String, Object> getDataObjectMap(DataMetaData dataMetaData, ISymmetricDialect symmetricDialect, boolean upperCase) {
        return DataUtils.getDataObjectMap(dataMetaData, symmetricDialect, upperCase);
    }

    protected Map<String, Object> getNewDataAsObject(String prefix, DataMetaData dataMetaData, ISymmetricDialect symmetricDialect, boolean upperCase) {
        return DataUtils.getNewDataAsObject(prefix, dataMetaData, symmetricDialect, upperCase);
    }

    protected Map<String, Object> getOldDataAsObject(String prefix, DataMetaData dataMetaData, ISymmetricDialect symmetricDialect, boolean upperCase) {
        return DataUtils.getOldDataAsObject(prefix, dataMetaData, symmetricDialect, upperCase);
    }

    protected <T> Map<String, T> getNullData(String prefix, DataMetaData dataMetaData) {
        return DataUtils.getNullData(prefix, dataMetaData);
    }

    protected Map<String, Object> getDataAsObject(String prefix, DataMetaData dataMetaData, ISymmetricDialect symmetricDialect, String[] rowData, boolean upperCase) {
        return DataUtils.getDataAsObject(prefix, dataMetaData, symmetricDialect, rowData, upperCase);
    }

    protected void testColumnNamesMatchValues(DataMetaData dataMetaData, String[] columnNames, Object[] values) {
        DataUtils.testColumnNamesMatchValues(dataMetaData, columnNames, values);
    }

    protected Map<String, Object> getPkDataAsObject(DataMetaData dataMetaData, ISymmetricDialect symmetricDialect) {
        return DataUtils.getPkDataAsObject(dataMetaData, symmetricDialect);
    }

    protected Set<String> addNodeId(String nodeId, Set<String> nodeIds, Set<Node> nodes) {
        nodeIds = nodeIds == null ? new HashSet<String>(1) : nodeIds;
        for (Node node : nodes) {
            if (!node.getNodeId().equals(nodeId)) continue;
            nodeIds.add(nodeId);
            break;
        }
        return nodeIds;
    }

    protected Set<String> toNodeIds(Set<Node> nodes, Set<String> nodeIds) {
        nodeIds = nodeIds == null ? new HashSet<String>(nodes.size()) : nodeIds;
        for (Node node : nodes) {
            nodeIds.add(node.getNodeId());
        }
        return nodeIds;
    }

    protected Set<String> toExternalIds(Set<Node> nodes) {
        HashSet<String> externalIds = new HashSet<String>();
        for (Node node : nodes) {
            externalIds.add(node.getExternalId());
        }
        return externalIds;
    }

    @Override
    public void completeBatch(SimpleRouterContext context, OutgoingBatch batch) {
        this.log.debug("Completing batch {}", (Object)batch.getBatchId());
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public boolean isDmlOnly() {
        return true;
    }
}

