/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.Comparator;
import java.util.List;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataGap;
import org.jumpmind.symmetric.route.ChannelRouterContext;
import org.jumpmind.symmetric.route.DataMemoryCursor;
import org.jumpmind.symmetric.route.IDataGapRouteCursor;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.util.AppUtils;
import org.jumpmind.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataGapRouteCursor
implements IDataGapRouteCursor {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ISymmetricEngine engine;
    protected IParameterService parameterService;
    protected ChannelRouterContext context;
    protected List<DataGap> dataGaps;
    protected ISqlReadCursor<Data> cursor;
    protected boolean isOracleNoOrder;
    protected boolean isSortInMemory;
    protected boolean isEachGapQueried;

    public AbstractDataGapRouteCursor(ChannelRouterContext context, ISymmetricEngine engine) {
        this.engine = engine;
        this.context = context;
        this.parameterService = engine.getParameterService();
        this.isOracleNoOrder = this.parameterService.is("oracle.sequence.noorder", false);
        this.isSortInMemory = this.parameterService.is("routing.data.reader.into.memory.enabled", false);
        this.dataGaps = context.getDataGaps();
    }

    public Data next() {
        return (Data)this.cursor.next();
    }

    public void close() {
        this.cursor.close();
    }

    protected ISqlReadCursor<Data> executeCursor(String sql, Object[] args, int[] types) {
        ISqlTemplate sqlTemplate = this.engine.getSymmetricDialect().getPlatform().getSqlTemplate();
        ISqlRowMapper<Data> dataMapper = this.engine.getDataService().getDataMapper();
        ISqlReadCursor cursor = null;
        long ts = System.currentTimeMillis();
        try {
            cursor = sqlTemplate.queryForCursor(sql, dataMapper, args, types);
        }
        catch (RuntimeException e) {
            this.log.info("Failed to execute query, but will try again,", (Throwable)e);
            AppUtils.sleep((long)1000L);
            cursor = sqlTemplate.queryForCursor(sql, dataMapper, args, types);
        }
        if (this.isSortInMemory) {
            cursor = this.getDataMemoryCursor((ISqlReadCursor<Data>)cursor);
        }
        this.context.incrementStat(System.currentTimeMillis() - ts, "query.exec.time.ms");
        return cursor;
    }

    protected ISqlReadCursor<Data> getDataMemoryCursor(ISqlReadCursor<Data> cursor) {
        Comparator<Data> comparator = null;
        if (this.isOracleNoOrder) {
            comparator = DataMemoryCursor.SORT_BY_TIME;
        } else if (this.parameterService.is("routing.data.reader.order.by.gap.id.enabled", true)) {
            comparator = DataMemoryCursor.SORT_BY_ID;
        }
        return new DataMemoryCursor(cursor, this.context, comparator);
    }

    protected String getSql(String sqlName) {
        String select = this.engine.getRouterService().getSql(sqlName);
        Channel channel = this.context.getChannel().getChannel();
        if (!channel.isUseOldDataToRoute() || this.context.isOnlyDefaultRoutersAssigned()) {
            select = select.replace("d.old_data", "''");
        }
        if (!channel.isUseRowDataToRoute() || this.context.isOnlyDefaultRoutersAssigned() && !channel.isFileSyncFlag()) {
            select = select.replace("d.row_data", "''");
        }
        if (!channel.isUsePkDataToRoute() || this.context.isOnlyDefaultRoutersAssigned()) {
            select = select.replace("d.pk_data", "''");
        }
        return this.engine.getSymmetricDialect().massageDataExtractionSql(select, this.context.isOverrideContainsBigLob() || channel.isContainsBigLob());
    }

    protected String qualifyUsingDataGaps(List<DataGap> dataGaps, int numberOfGapsToQualify, String sql) {
        StringBuilder gapClause = new StringBuilder();
        for (int i = 0; i < numberOfGapsToQualify && i < dataGaps.size(); ++i) {
            if (i == 0) {
                gapClause.append(" and (");
            } else {
                gapClause.append(" or ");
            }
            gapClause.append("(d.data_id between ? and ?)");
        }
        gapClause.append(")");
        return FormatUtils.replace((String)"dataRange", (String)gapClause.toString(), (String)sql);
    }

    protected String qualifyForOrder(String sql) {
        if (!this.isSortInMemory) {
            if (this.isOracleNoOrder) {
                sql = String.format("%s %s", sql, this.engine.getRouterService().getSql("orderByCreateTime"));
            } else if (this.parameterService.is("routing.data.reader.order.by.gap.id.enabled", true)) {
                sql = String.format("%s %s", sql, this.engine.getRouterService().getSql("orderByDataId"));
            }
        }
        return sql;
    }

    @Override
    public boolean isEachGapQueried() {
        return this.isEachGapQueried;
    }

    @Override
    public boolean isOracleNoOrder() {
        return this.isOracleNoOrder;
    }
}

