/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.writer.NestedDataWriter;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessType;

public class ProcessInfoDataWriter
extends NestedDataWriter {
    private ProcessInfo processInfo;
    private static Class<?> abstractBulkDatabaseWriter;

    public ProcessInfoDataWriter(IDataWriter targetWriter, ProcessInfo processInfo) {
        super(targetWriter);
        this.processInfo = processInfo;
    }

    public void open(DataContext context) {
        super.open(context);
        this.processInfo.setTotalBatchCount(0L);
    }

    public void start(Batch batch) {
        if (batch != null) {
            ProcessType type = this.processInfo.getProcessType();
            if (type == ProcessType.PULL_HANDLER_EXTRACT || type == ProcessType.PUSH_JOB_EXTRACT || type == ProcessType.INITIAL_LOAD_EXTRACT_JOB) {
                this.processInfo.setStatus(ProcessInfo.ProcessStatus.EXTRACTING);
            } else {
                this.processInfo.setStatus(ProcessInfo.ProcessStatus.LOADING);
            }
            this.processInfo.setCurrentBatchId(batch.getBatchId());
            this.processInfo.setCurrentChannelId(batch.getChannelId());
            this.processInfo.incrementBatchCount();
            this.processInfo.setCurrentDataCount(0L);
            if (abstractBulkDatabaseWriter != null && abstractBulkDatabaseWriter.isAssignableFrom(this.nestedWriter.getClass())) {
                this.processInfo.setBulkLoadFlag(true);
            } else {
                this.processInfo.setBulkLoadFlag(false);
            }
        }
        super.start(batch);
    }

    public boolean start(Table table) {
        if (table != null) {
            this.processInfo.setCurrentTableName(table.getFullyQualifiedTableName());
        }
        return super.start(table);
    }

    public void end(Batch batch, boolean inError) {
        this.processInfo.setStatus(!inError ? ProcessInfo.ProcessStatus.OK : ProcessInfo.ProcessStatus.ERROR);
        super.end(batch, inError);
    }

    public void write(CsvData data) {
        if (data != null) {
            this.processInfo.incrementCurrentDataCount();
        }
        super.write(data);
    }

    static {
        try {
            abstractBulkDatabaseWriter = Class.forName("org.jumpmind.symmetric.io.AbstractBulkDatabaseWriter");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

