/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.math.BigDecimal;
import java.util.Date;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.IModelObject;
import org.jumpmind.symmetric.model.NodeChannelControl;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;

public class NodeChannel
implements IModelObject {
    private static final long serialVersionUID = 1L;
    private Channel channel;
    private NodeChannelControl nodeChannelControl;

    public NodeChannel() {
        this(new Channel());
    }

    public NodeChannel(Channel channel) {
        this.channel = channel;
        this.nodeChannelControl = new NodeChannelControl();
        this.nodeChannelControl.setChannelId(channel.getChannelId());
    }

    public NodeChannel(String channelId) {
        this.channel = new Channel();
        this.nodeChannelControl = new NodeChannelControl();
        this.nodeChannelControl.setChannelId(channelId);
        this.channel.setChannelId(channelId);
    }

    public String getChannelId() {
        return this.channel.getChannelId();
    }

    public void setDataEventActionShortName(String dataEventAction) {
        this.setDataEventAction(NodeGroupLinkAction.fromShortName(dataEventAction));
    }

    public String getDataEventActionShortName() {
        return this.channel.getDataEventAction() == null ? "" : this.channel.getDataEventAction().getShortName();
    }

    public void setDataEventAction(NodeGroupLinkAction dataEventAction) {
        this.channel.setDataEventAction(dataEventAction);
    }

    public NodeGroupLinkAction getDataEventAction() {
        return this.channel.getDataEventAction();
    }

    public int getMaxBatchSize() {
        return this.channel.getMaxBatchSize();
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.channel.setMaxBatchSize(maxBatchSize);
    }

    public int getMaxBatchToSend() {
        return this.channel.getMaxBatchToSend();
    }

    public void setMaxBatchToSend(int maxBatchToSend) {
        this.channel.setMaxBatchToSend(maxBatchToSend);
    }

    public void setMaxDataToRoute(int maxDataToRoute) {
        this.channel.setMaxDataToRoute(maxDataToRoute);
    }

    public int getMaxDataToRoute() {
        return this.channel.getMaxDataToRoute();
    }

    public void setUseOldDataToRoute(boolean useOldDataToRoute) {
        this.channel.setUseOldDataToRoute(useOldDataToRoute);
    }

    public boolean isUseOldDataToRoute() {
        return this.channel.isUseOldDataToRoute();
    }

    public void setUseRowDataToRoute(boolean useRowDataToRoute) {
        this.channel.setUseRowDataToRoute(useRowDataToRoute);
    }

    public boolean isUseRowDataToRoute() {
        return this.channel.isUseRowDataToRoute();
    }

    public void setUsePkDataToRoute(boolean usePkDataToRoute) {
        this.channel.setUsePkDataToRoute(usePkDataToRoute);
    }

    public boolean isUsePkDataToRoute() {
        return this.channel.isUsePkDataToRoute();
    }

    public int getProcessingOrder() {
        return this.channel.getProcessingOrder();
    }

    public String getBatchAlgorithm() {
        return this.channel.getBatchAlgorithm();
    }

    public void setBatchAlgorithm(String batchAlgorithm) {
        this.channel.setBatchAlgorithm(batchAlgorithm);
    }

    public void setEnabled(boolean enabled) {
        this.channel.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.channel.isEnabled();
    }

    public boolean isSuspendEnabled() {
        return this.nodeChannelControl.isSuspendEnabled();
    }

    public boolean isIgnoreEnabled() {
        return this.nodeChannelControl.isIgnoreEnabled();
    }

    public String getNodeId() {
        return this.nodeChannelControl.getNodeId();
    }

    public void setNodeId(String nodeId) {
        this.nodeChannelControl.setNodeId(nodeId);
    }

    public void setLastExtractTime(Date lastExtractedTime) {
        this.nodeChannelControl.setLastExtractTime(lastExtractedTime);
    }

    public Date getLastExtractTime() {
        return this.nodeChannelControl.getLastExtractTime();
    }

    public void setIgnoreEnabled(boolean ignored) {
        this.nodeChannelControl.setIgnoreEnabled(ignored);
    }

    public void setProcessingOrder(int priority) {
        this.channel.setProcessingOrder(priority);
    }

    public void setChannelId(String id) {
        this.channel.setChannelId(id);
        this.nodeChannelControl.setChannelId(id);
    }

    @Override
    public void setLastUpdateTime(Date date) {
        this.channel.setLastUpdateTime(date);
    }

    @Override
    public void setCreateTime(Date date) {
        this.channel.setCreateTime(date);
    }

    @Override
    public void setLastUpdateBy(String lastUpdateBy) {
        this.channel.setLastUpdateBy(lastUpdateBy);
    }

    public void setSuspendEnabled(boolean suspended) {
        this.nodeChannelControl.setSuspendEnabled(suspended);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public NodeChannelControl getNodeChannelControl() {
        return this.nodeChannelControl;
    }

    public long getExtractPeriodMillis() {
        return this.channel.getExtractPeriodMillis();
    }

    public void setExtractPeriodMillis(long extractPeriodMillis) {
        this.channel.setExtractPeriodMillis(extractPeriodMillis);
    }

    public void setContainsBigLob(boolean containsBigLobs) {
        this.channel.setContainsBigLob(containsBigLobs);
    }

    public boolean isContainsBigLob() {
        return this.channel.isContainsBigLob();
    }

    public void setDataLoaderType(String type) {
        this.channel.setDataLoaderType(type);
    }

    public String getDataLoaderType() {
        return this.channel.getDataLoaderType();
    }

    public void setReloadFlag(boolean value) {
        this.channel.setReloadFlag(value);
    }

    public boolean isReloadFlag() {
        return this.channel.isReloadFlag();
    }

    public void setFileSyncFlag(boolean value) {
        this.channel.setFileSyncFlag(value);
    }

    public boolean isFileSyncFlag() {
        return this.channel.isFileSyncFlag();
    }

    @Override
    public Date getCreateTime() {
        return this.channel.getCreateTime();
    }

    @Override
    public String getLastUpdateBy() {
        return this.channel.getLastUpdateBy();
    }

    @Override
    public Date getLastUpdateTime() {
        return this.channel.getLastUpdateTime();
    }

    public void setQueue(String queue) {
        this.channel.setQueue(queue);
    }

    public String getQueue() {
        return this.channel.getQueue();
    }

    public BigDecimal getMaxKBytesPerSecond() {
        return this.channel.getMaxKBytesPerSecond();
    }

    public void setMaxKBytesPerSecond(BigDecimal maxKBytesPerSecond) {
        this.channel.setMaxKBytesPerSecond(maxKBytesPerSecond);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.channel == null ? 0 : this.channel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeChannel other = (NodeChannel)obj;
        return !(this.channel == null ? other.channel != null : !this.channel.equals(other.channel));
    }

    public String toString() {
        return "Channel: '" + this.getChannelId() + "' Node: '" + this.getNodeId() + "' " + super.toString();
    }
}

