/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.util.Date;
import org.jumpmind.symmetric.model.IModelObject;

public class LoadFilter
implements IModelObject {
    private static final long serialVersionUID = 1L;
    private String loadFilterId;
    private LoadFilterType loadFilterType = LoadFilterType.BSH;
    private String targetCatalogName;
    private String targetSchemaName;
    private String targetTableName;
    private boolean filterOnUpdate = true;
    private boolean filterOnInsert = true;
    private boolean filterOnDelete = true;
    private String beforeWriteScript;
    private String afterWriteScript;
    private String batchCompleteScript;
    private String batchCommitScript;
    private String batchRollbackScript;
    private String handleErrorScript;
    private Date createTime = new Date();
    private String lastUpdateBy = "symmetricds";
    private Date lastUpdateTime = new Date();
    private int loadFilterOrder;
    private boolean failOnError = true;

    public int getLoadFilterOrder() {
        return this.loadFilterOrder;
    }

    public void setLoadFilterOrder(int loadFilterOrder) {
        this.loadFilterOrder = loadFilterOrder;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public String getLoadFilterId() {
        return this.loadFilterId;
    }

    public void setLoadFilterId(String loadFilterId) {
        this.loadFilterId = loadFilterId;
    }

    public String getTargetCatalogName() {
        return this.targetCatalogName;
    }

    public void setTargetCatalogName(String targetCatalogName) {
        this.targetCatalogName = targetCatalogName;
    }

    public String getTargetSchemaName() {
        return this.targetSchemaName;
    }

    public void setTargetSchemaName(String targetSchemaName) {
        this.targetSchemaName = targetSchemaName;
    }

    public String getTargetTableName() {
        return this.targetTableName;
    }

    public void setTargetTableName(String targetTableName) {
        this.targetTableName = targetTableName;
    }

    public boolean isFilterOnUpdate() {
        return this.filterOnUpdate;
    }

    public void setFilterOnUpdate(boolean filterOnUpdate) {
        this.filterOnUpdate = filterOnUpdate;
    }

    public boolean isFilterOnInsert() {
        return this.filterOnInsert;
    }

    public void setFilterOnInsert(boolean filterOnInsert) {
        this.filterOnInsert = filterOnInsert;
    }

    public boolean isFilterOnDelete() {
        return this.filterOnDelete;
    }

    public void setFilterOnDelete(boolean filterOnDelete) {
        this.filterOnDelete = filterOnDelete;
    }

    public String getBeforeWriteScript() {
        return this.beforeWriteScript;
    }

    public void setBeforeWriteScript(String beforeWriteScript) {
        this.beforeWriteScript = beforeWriteScript;
    }

    public String getAfterWriteScript() {
        return this.afterWriteScript;
    }

    public void setAfterWriteScript(String afterWriteScript) {
        this.afterWriteScript = afterWriteScript;
    }

    public String getBatchCompleteScript() {
        return this.batchCompleteScript;
    }

    public void setBatchCompleteScript(String batchCompleteScript) {
        this.batchCompleteScript = batchCompleteScript;
    }

    public String getBatchCommitScript() {
        return this.batchCommitScript;
    }

    public void setBatchCommitScript(String batchCommitScript) {
        this.batchCommitScript = batchCommitScript;
    }

    public String getBatchRollbackScript() {
        return this.batchRollbackScript;
    }

    public void setBatchRollbackScript(String batchRollbackScript) {
        this.batchRollbackScript = batchRollbackScript;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    @Override
    public void setLastUpdateBy(String lastUpdateBy) {
        this.lastUpdateBy = lastUpdateBy;
    }

    @Override
    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public LoadFilterType getLoadFilterType() {
        return this.loadFilterType;
    }

    public void setLoadFilterType(LoadFilterType loadFilterType) {
        this.loadFilterType = loadFilterType;
    }

    public void setHandleErrorScript(String handleErrorScript) {
        this.handleErrorScript = handleErrorScript;
    }

    public String getHandleErrorScript() {
        return this.handleErrorScript;
    }

    public String getEvents() {
        StringBuilder events = new StringBuilder();
        this.buildStringBasedList(this.getBeforeWriteScript(), events, "Before Write");
        this.buildStringBasedList(this.getAfterWriteScript(), events, "After Write");
        this.buildStringBasedList(this.getBatchCompleteScript(), events, "Batch Complete");
        this.buildStringBasedList(this.getBatchCommitScript(), events, "Batch Commit");
        this.buildStringBasedList(this.getBatchRollbackScript(), events, "Batch Rollback");
        this.buildStringBasedList(this.getHandleErrorScript(), events, "Handle Error");
        return events.toString();
    }

    private void buildStringBasedList(String source, StringBuilder target, String value) {
        if (source != null && !source.equals("")) {
            if (target.length() > 0) {
                target.append(", ");
            }
            target.append(value);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof LoadFilter && this.loadFilterId != null) {
            return this.loadFilterId.equals(((LoadFilter)obj).loadFilterId);
        }
        return false;
    }

    public int hashCode() {
        return this.loadFilterId != null ? this.loadFilterId.hashCode() : super.hashCode();
    }

    public String toString() {
        if (this.loadFilterId != null) {
            return this.loadFilterId;
        }
        return super.toString();
    }

    public static enum LoadFilterType {
        BSH,
        JAVA,
        SQL;

    }
}

