/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IAlterDatabaseInterceptor;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.sql.ISqlResultsListener;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.LogSqlResultsListener;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlScript;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.db.AbstractTriggerTemplate;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.LogSqlResultsInstallListener;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.ext.IDatabaseInstallStatementListener;
import org.jumpmind.symmetric.ext.IDatabaseUpgradeListener;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.TransformService;
import org.jumpmind.util.AppUtils;
import org.jumpmind.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSymmetricDialect
implements ISymmetricDialect {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final int MAX_SYMMETRIC_SUPPORTED_TRIGGER_SIZE = 50;
    protected IDatabasePlatform platform;
    protected ISymmetricDialect targetDialect = this;
    protected AbstractTriggerTemplate triggerTemplate;
    protected IParameterService parameterService;
    protected IExtensionService extensionService;
    protected Boolean supportsGetGeneratedKeys;
    protected String databaseName;
    protected String driverVersion;
    protected String driverName;
    protected int databaseMajorVersion;
    protected int databaseMinorVersion;
    protected String databaseProductVersion;
    protected Set<String> sqlKeywords;
    protected boolean supportsTransactionViews = false;
    protected boolean supportsSubselectsInDelete = true;
    protected boolean supportsSubselectsInUpdate = true;
    protected boolean supportsDdlTriggers = false;
    protected Map<String, String> sqlReplacementTokens = new HashMap<String, String>();
    protected String tablePrefixLowerCase;
    protected boolean isSpatialTypesEnabled = true;

    public AbstractSymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        this.parameterService = parameterService;
        this.platform = platform;
        this.log.info("The DbDialect being used is {}", (Object)this.getClass().getName());
        this.buildSqlReplacementTokens();
        ISqlTemplate sqlTemplate = this.platform.getSqlTemplate();
        this.databaseMajorVersion = sqlTemplate.getDatabaseMajorVersion();
        this.databaseMinorVersion = sqlTemplate.getDatabaseMinorVersion();
        this.databaseName = sqlTemplate.getDatabaseProductName();
        this.databaseProductVersion = sqlTemplate.getDatabaseProductVersion();
        this.driverName = sqlTemplate.getDriverName();
        this.driverVersion = sqlTemplate.getDriverVersion();
        this.tablePrefixLowerCase = parameterService.getTablePrefix().toLowerCase();
        this.isSpatialTypesEnabled = parameterService.is("spatial.data.types.enabled");
        DatabaseInfo ddlBuilderDbInfo = this.platform.getDdlBuilder().getDatabaseInfo();
        ddlBuilderDbInfo.setDefaultValuesToLeaveUnquotedSupplier(() -> {
            String[] values;
            String defaultValuesToLeaveUnquoted = parameterService.getString("default.values.to.leave.unquoted");
            if (StringUtils.isNotBlank((CharSequence)defaultValuesToLeaveUnquoted) && (values = CsvUtils.tokenizeCsvData((String)defaultValuesToLeaveUnquoted)) != null && values.length > 0) {
                return Arrays.stream(values).collect(Collectors.toSet());
            }
            return new HashSet();
        });
        ddlBuilderDbInfo.setDefaultValuesToTranslateSupplier(() -> {
            String[] pairs;
            String defaultValuesToTranslate = parameterService.getString("default.values.to.translate");
            HashMap<String, String> valueMap = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)defaultValuesToTranslate) && (pairs = CsvUtils.tokenizeCsvData((String)defaultValuesToTranslate)) != null && pairs.length > 0) {
                for (String pair : pairs) {
                    String[] values = pair.split("=");
                    if (values.length != 2) continue;
                    valueMap.put(values[0], values[1]);
                }
            }
            return valueMap;
        });
    }

    @Override
    public String getSymmetricDdlChanges() {
        Database modelFromXml = this.readSymmetricSchemaFromXml();
        Database modelFromDatabase = this.readSymmetricSchemaFromDatabase();
        List<IAlterDatabaseInterceptor> alterDatabaseInterceptors = this.extensionService.getExtensionPointList(IAlterDatabaseInterceptor.class);
        IAlterDatabaseInterceptor[] interceptors = alterDatabaseInterceptors.toArray(new IAlterDatabaseInterceptor[alterDatabaseInterceptors.size()]);
        IDdlBuilder builder = this.platform.getDdlBuilder();
        String alterSql = builder.alterDatabase(modelFromDatabase, modelFromXml, interceptors);
        return alterSql;
    }

    public boolean requiresAutoCommitFalseToSetFetchSize() {
        return false;
    }

    protected void buildSqlReplacementTokens() {
        this.sqlReplacementTokens.put("selectDataUsingGapsSqlHint", "");
        this.sqlReplacementTokens.put("selectDataUsingStartDataIdHint", "");
    }

    @Override
    public Map<String, String> getSqlReplacementTokens() {
        return this.sqlReplacementTokens;
    }

    @Override
    public int getMaxTriggerNameLength() {
        int max = this.getPlatform().getDatabaseInfo().getMaxColumnNameLength();
        return max < 50 && max > 0 ? max : 50;
    }

    @Override
    public void verifyDatabaseIsCompatible() {
    }

    @Override
    public void initTablesAndDatabaseObjects() {
        this.createRequiredDatabaseObjects();
        this.createOrAlterTablesIfNecessary(new String[0]);
        this.platform.resetCachedTableModel();
    }

    protected String replaceTokens(String sql, String objectName) {
        String ddl = FormatUtils.replace((String)"functionName", (String)objectName, (String)sql);
        ddl = FormatUtils.replace((String)"version", (String)Version.versionWithUnderscores(), (String)ddl);
        ddl = FormatUtils.replace((String)"defaultSchema", (String)this.platform.getDefaultSchema(), (String)ddl);
        ddl = FormatUtils.replace((String)"prefixName", (String)this.parameterService.getTablePrefix(), (String)ddl);
        return ddl;
    }

    protected boolean installed(String sql, String objectName) {
        return this.platform.getSqlTemplate().queryForInt(this.replaceTokens(sql, objectName), new Object[0]) > 0;
    }

    protected void install(String sql, String objectName, StringBuilder ddl) {
        sql = this.replaceTokens(sql, objectName);
        this.logSql(sql, ddl);
        if (ddl == null) {
            this.log.info("Installing SymmetricDS database object:\n{}", (Object)sql);
            this.platform.getSqlTemplate().update(sql, new Object[0]);
            this.log.info("Just installed {}", (Object)objectName);
        }
    }

    protected void uninstall(String sql, String objectName) {
        this.uninstall(sql, objectName, null);
    }

    protected void uninstall(String sql, String objectName, StringBuilder ddl) {
        sql = this.replaceTokens(sql, objectName);
        this.logSql(sql, ddl);
        if (ddl == null) {
            this.platform.getSqlTemplate().update(sql, new Object[0]);
            this.log.info("Just uninstalled {}", (Object)objectName);
        }
    }

    @Override
    public void dropTablesAndDatabaseObjects() {
        Database modelFromDatabase = this.readSymmetricSchemaFromDatabase();
        this.platform.dropDatabase(modelFromDatabase, true);
        this.dropRequiredDatabaseObjects();
    }

    @Override
    public final boolean doesTriggerExist(StringBuilder sqlBuffer, String catalogName, String schema, String tableName, String triggerName) {
        if (StringUtils.isNotBlank((CharSequence)triggerName)) {
            try {
                return this.doesTriggerExistOnPlatform(sqlBuffer, catalogName, schema, tableName, triggerName);
            }
            catch (Exception ex) {
                this.log.warn("Could not figure out if the trigger exists.  Assuming that it does not", (Throwable)ex);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean doesDdlTriggerExist(String catalogName, String schema, String triggerName) {
        return false;
    }

    @Override
    public abstract void dropRequiredDatabaseObjects();

    @Override
    public void createRequiredDatabaseObjects() {
        this.createRequiredDatabaseObjectsImpl(null);
    }

    @Override
    public String getCreateRequiredDatabaseObjectsDDL() {
        StringBuilder ddl = new StringBuilder();
        this.createRequiredDatabaseObjectsImpl(ddl);
        return ddl.toString();
    }

    protected void createRequiredDatabaseObjectsImpl(StringBuilder ddl) {
    }

    @Override
    public abstract BinaryEncoding getBinaryEncoding();

    protected abstract boolean doesTriggerExistOnPlatform(StringBuilder var1, String var2, String var3, String var4, String var5);

    @Override
    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return "null";
    }

    @Override
    public String getTransactionId(ISqlTransaction transaction) {
        return null;
    }

    @Override
    public String createInitialLoadSqlFor(Node node, TriggerRouter trigger, Table table, TriggerHistory triggerHistory, Channel channel, String overrideSelectSql) {
        return this.triggerTemplate.createInitalLoadSql(node, trigger, table, triggerHistory, channel, overrideSelectSql).trim();
    }

    @Override
    public boolean[] getColumnPositionUsingTemplate(Table originalTable, TriggerHistory triggerHistory) {
        return this.triggerTemplate.getColumnPositionUsingTemplate(originalTable, triggerHistory);
    }

    @Override
    public String createPurgeSqlFor(Node node, TriggerRouter triggerRouter, TriggerHistory triggerHistory) {
        return this.createPurgeSqlFor(node, triggerRouter, triggerHistory, null);
    }

    @Override
    public String createPurgeSqlFor(Node node, TriggerRouter triggerRouter, TriggerHistory triggerHistory, List<TransformService.TransformTableNodeGroupLink> transforms) {
        return this.createPurgeSqlFor(node, triggerRouter, triggerHistory, transforms, null);
    }

    @Override
    public String createPurgeSqlFor(Node node, TriggerRouter triggerRouter, TriggerHistory triggerHistory, List<TransformService.TransformTableNodeGroupLink> transforms, String deleteSql) {
        List<String> sqlStatements = this.createPurgeSqlForMultipleTables(node, triggerRouter, triggerHistory, transforms, deleteSql);
        return sqlStatements.size() == 1 ? sqlStatements.get(0) : "";
    }

    @Override
    public List<String> createPurgeSqlForMultipleTables(Node node, TriggerRouter triggerRouter, TriggerHistory triggerHistory, List<TransformService.TransformTableNodeGroupLink> transforms, String deleteSql) {
        ArrayList<String> sqlStatements = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)triggerRouter.getInitialLoadDeleteStmt())) {
            HashSet<String> tableNames = new HashSet<String>();
            if (transforms != null) {
                for (TransformService.TransformTableNodeGroupLink transform : transforms) {
                    tableNames.add(transform.getFullyQualifiedTargetTableName());
                }
            } else {
                tableNames.add(triggerRouter.qualifiedTargetTableName(triggerHistory));
            }
            for (String tableName : tableNames) {
                if (deleteSql == null) {
                    deleteSql = tableName.startsWith(this.parameterService.getTablePrefix()) ? "delete from %s" : this.parameterService.getString("initial.load.delete.first.sql");
                }
                sqlStatements.add(String.format(deleteSql, tableName));
            }
        } else {
            sqlStatements.add(triggerRouter.getInitialLoadDeleteStmt());
        }
        return sqlStatements;
    }

    @Override
    public String createCsvDataSql(Trigger trigger, TriggerHistory triggerHistory, Channel channel, String whereClause) {
        return this.createCsvDataSql(trigger, triggerHistory, channel, whereClause, this.platform.getTableFromCache(trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName(), false));
    }

    @Override
    public String createCsvDataSql(Trigger trigger, TriggerHistory triggerHistory, Channel channel, String whereClause, Table table) {
        return this.triggerTemplate.createCsvDataSql(trigger, triggerHistory, table, channel, whereClause).trim();
    }

    @Override
    public String createCsvPrimaryKeySql(Trigger trigger, TriggerHistory triggerHistory, Channel channel, String whereClause) {
        return this.triggerTemplate.createCsvPrimaryKeySql(trigger, triggerHistory, this.platform.getTableFromCache(trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName(), false), channel, whereClause).trim();
    }

    @Override
    public String createCsvPrimaryKeySql(Trigger trigger, TriggerHistory triggerHistory, Channel channel, String whereClause, Table table) {
        return this.triggerTemplate.createCsvPrimaryKeySql(trigger, triggerHistory, table, channel, whereClause).trim();
    }

    @Override
    public Set<String> getSqlKeywords() {
        if (this.sqlKeywords == null) {
            this.sqlKeywords = this.platform.getSqlTemplate().getSqlKeywords();
        }
        return this.sqlKeywords;
    }

    protected String getDropTriggerSql(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName) {
        schemaName = StringUtils.isBlank((CharSequence)schemaName) ? "" : (String)schemaName + ".";
        return "drop trigger " + (String)schemaName + triggerName;
    }

    @Override
    public void removeTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.platform.getSqlTemplate().startSqlTransaction(this.platform.getDatabaseInfo().isRequiresAutoCommitForDdl());
            this.removeTrigger(sqlBuffer, catalogName, schemaName, triggerName, tableName, transaction);
            transaction.commit();
            this.close(transaction);
        }
        catch (Exception ex) {
            try {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.close(transaction);
                throw throwable;
            }
        }
    }

    @Override
    public void removeTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName, ISqlTransaction transaction) {
        String sql = this.getDropTriggerSql(sqlBuffer, catalogName, schemaName, triggerName, tableName);
        this.logSql(sql, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers") && sqlBuffer == null) {
            this.log.info("Dropping {} trigger for {}", (Object)triggerName, (Object)Table.getFullyQualifiedTableName((String)catalogName, (String)schemaName, (String)tableName));
            transaction.execute(sql);
        }
    }

    @Override
    public void removeDdlTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName) {
    }

    protected final void logSql(String sql, StringBuilder sqlBuffer) {
        if (sqlBuffer != null && StringUtils.isNotBlank((CharSequence)sql)) {
            sqlBuffer.append(sql);
            sqlBuffer.append(System.getProperty("line.separator"));
            sqlBuffer.append(System.getProperty("line.separator"));
        }
    }

    @Override
    public void createTrigger(StringBuilder sqlBuffer, DataEventType dml, Trigger trigger, TriggerHistory hist, Channel channel, String tablePrefix, Table table) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.platform.getSqlTemplate().startSqlTransaction(this.platform.getDatabaseInfo().isRequiresAutoCommitForDdl());
            this.createTrigger(sqlBuffer, dml, trigger, hist, channel, tablePrefix, table, transaction);
            transaction.commit();
            this.close(transaction);
        }
        catch (Exception ex) {
            try {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.close(transaction);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTrigger(StringBuilder sqlBuffer, DataEventType dml, Trigger trigger, TriggerHistory hist, Channel channel, String tablePrefix, Table table, ISqlTransaction transaction) {
        String previousCatalog = null;
        String sourceCatalogName = table.getCatalog();
        String defaultCatalog = this.platform.getDefaultCatalog();
        String defaultSchema = this.platform.getDefaultSchema();
        String triggerSql = this.triggerTemplate.createTriggerDDL(dml, trigger, hist, channel, tablePrefix, table, defaultCatalog, defaultSchema);
        if (this.parameterService.is("auto.sync.triggers")) {
            try {
                previousCatalog = this.switchCatalogForTriggerInstall(sourceCatalogName, transaction);
                try {
                    this.logSql(triggerSql, sqlBuffer);
                    if (sqlBuffer == null) {
                        this.log.info("Creating {} trigger for {}", (Object)hist.getTriggerNameForDmlType(dml), (Object)table.getFullyQualifiedTableName());
                        this.log.debug("Running: {}", (Object)triggerSql);
                        transaction.execute(triggerSql);
                    }
                }
                catch (SqlException ex) {
                    this.log.info("Failed to create trigger: {}", (Object)triggerSql);
                    throw ex;
                }
                this.postCreateTrigger(transaction, sqlBuffer, dml, trigger, hist, channel, tablePrefix, table);
            }
            finally {
                if (sourceCatalogName != null && !sourceCatalogName.equalsIgnoreCase(previousCatalog)) {
                    this.switchCatalogForTriggerInstall(previousCatalog, transaction);
                }
            }
        }
    }

    protected void postCreateTrigger(ISqlTransaction transaction, StringBuilder sqlBuffer, DataEventType dml, Trigger trigger, TriggerHistory hist, Channel channel, String tablePrefix, Table table) {
        String postTriggerDml = this.createPostTriggerDDL(dml, trigger, hist, channel, tablePrefix, table);
        if (StringUtils.isNotBlank((CharSequence)postTriggerDml)) {
            try {
                this.logSql(postTriggerDml, sqlBuffer);
                if (sqlBuffer == null) {
                    this.log.debug("Running: {}", (Object)postTriggerDml);
                    transaction.execute(postTriggerDml);
                }
            }
            catch (SqlException ex) {
                this.log.info("Failed to create post trigger: {}", (Object)postTriggerDml);
                throw ex;
            }
        }
    }

    protected String switchCatalogForTriggerInstall(String catalog, ISqlTransaction transaction) {
        return null;
    }

    protected String createPostTriggerDDL(DataEventType dml, Trigger trigger, TriggerHistory hist, Channel channel, String tablePrefix, Table table) {
        return this.triggerTemplate.createPostTriggerDDL(dml, trigger, hist, channel, tablePrefix, table, this.platform.getDefaultCatalog(), this.platform.getDefaultSchema());
    }

    @Override
    public void createDdlTrigger(String tablePrefix, StringBuilder sqlBuffer, String triggerName, String runtimeCatalog, String runtimeSchema) {
        String triggerSql;
        if (this.parameterService.is("auto.sync.triggers") && (triggerSql = this.triggerTemplate.createDdlTrigger(tablePrefix, runtimeCatalog, runtimeSchema, triggerName)) != null) {
            try (ISqlTransaction transaction = null;){
                transaction = this.platform.getSqlTemplate().startSqlTransaction(this.platform.getDatabaseInfo().isRequiresAutoCommitForDdl());
                try {
                    this.logSql(triggerSql, sqlBuffer);
                    if (sqlBuffer == null) {
                        this.log.info("Creating DDL trigger " + triggerName);
                        this.log.debug("Running: {}", (Object)triggerSql);
                        transaction.execute(triggerSql);
                    }
                }
                catch (SqlException ex) {
                    this.log.info("Failed to create DDL trigger: {}", (Object)triggerSql);
                    throw ex;
                }
                this.postCreateDdlTrigger(transaction, tablePrefix, sqlBuffer, triggerName);
                transaction.commit();
            }
        }
    }

    protected void postCreateDdlTrigger(ISqlTransaction transaction, String tablePrefix, StringBuilder sqlBuffer, String triggerName) {
        String postTriggerDdl = this.createPostDdlTriggerDDL(tablePrefix, triggerName);
        if (StringUtils.isNotBlank((CharSequence)postTriggerDdl)) {
            try {
                this.logSql(postTriggerDdl, sqlBuffer);
                if (sqlBuffer == null) {
                    this.log.debug("Running: {}", (Object)postTriggerDdl);
                    transaction.execute(postTriggerDdl);
                }
            }
            catch (SqlException ex) {
                this.log.info("Failed to create post DDL trigger: {}", (Object)postTriggerDdl);
                throw ex;
            }
        }
    }

    protected String createPostDdlTriggerDDL(String tablePrefix, String triggerName) {
        return this.triggerTemplate.createPostDdlTriggerDDL(tablePrefix, triggerName);
    }

    @Override
    public String getCreateSymmetricDDL() {
        Database database = this.readSymmetricSchemaFromXml();
        IDdlBuilder builder = this.platform.getDdlBuilder();
        return builder.createTables(database, true);
    }

    protected void prefixConfigDatabase(Database targetTables) {
        this.platform.prefixDatabase(this.parameterService.getTablePrefix(), targetTables);
    }

    @Override
    public boolean createOrAlterTablesIfNecessary(String ... tableNames) {
        try {
            List<IAlterDatabaseInterceptor> alterDatabaseInterceptors;
            IAlterDatabaseInterceptor[] interceptors;
            IDdlBuilder builder;
            this.log.info("Checking if SymmetricDS tables need created or altered");
            Database modelFromXml = this.readSymmetricSchemaFromXml();
            Database modelFromDatabase = this.readSymmetricSchemaFromDatabase();
            if (tableNames != null && tableNames.length > 0) {
                tableNames = this.platform.alterCaseToMatchDatabaseDefaultCase(tableNames);
                modelFromXml.removeAllTablesExcept(tableNames);
                modelFromDatabase.removeAllTablesExcept(tableNames);
            }
            if ((builder = this.platform.getDdlBuilder()).isAlterDatabase(modelFromDatabase, modelFromXml, interceptors = (alterDatabaseInterceptors = this.extensionService.getExtensionPointList(IAlterDatabaseInterceptor.class)).toArray(new IAlterDatabaseInterceptor[alterDatabaseInterceptors.size()]))) {
                String delimiter = this.platform.getDatabaseInfo().getSqlCommandDelimiter();
                LogSqlResultsListener resultsListener = new LogSqlResultsListener();
                List<IDatabaseUpgradeListener> databaseUpgradeListeners = this.extensionService.getExtensionPointList(IDatabaseUpgradeListener.class);
                for (IDatabaseUpgradeListener listener : databaseUpgradeListeners) {
                    String sql = listener.beforeUpgrade(this, this.parameterService.getTablePrefix(), modelFromDatabase, modelFromXml);
                    SqlScript script = new SqlScript(sql, this.getPlatform().getSqlTemplate(), true, false, false, delimiter, null);
                    script.setListener((ISqlResultsListener)resultsListener);
                    script.execute(this.platform.getDatabaseInfo().isRequiresAutoCommitForDdl());
                }
                modelFromDatabase = this.readSymmetricSchemaFromDatabase();
                String alterSql = builder.alterDatabase(modelFromDatabase, modelFromXml, interceptors);
                if (StringUtils.isNotBlank((CharSequence)alterSql)) {
                    this.log.info("There are SymmetricDS tables that needed altered");
                    this.log.debug("Alter SQL generated: {}", (Object)alterSql);
                    LogSqlResultsListener resultsInstallListener = resultsListener;
                    List<IDatabaseInstallStatementListener> installListeners = this.extensionService.getExtensionPointList(IDatabaseInstallStatementListener.class);
                    boolean triggersContainJava = this.platform.getDatabaseInfo().isTriggersContainJava();
                    if (installListeners != null && installListeners.size() > 0) {
                        int totalStatements = SqlScript.calculateTotalStatements((String)alterSql, (String)delimiter, (boolean)triggersContainJava);
                        resultsInstallListener = new LogSqlResultsInstallListener(this.parameterService.getEngineName(), totalStatements, this.extensionService.getExtensionPointList(IDatabaseInstallStatementListener.class));
                    }
                    SqlScript script = new SqlScript(alterSql, this.getPlatform().getSqlTemplate(), true, false, false, triggersContainJava, delimiter, null);
                    script.setListener((ISqlResultsListener)resultsInstallListener);
                    script.execute(this.platform.getDatabaseInfo().isRequiresAutoCommitForDdl());
                    for (IDatabaseUpgradeListener listener : databaseUpgradeListeners) {
                        String sql = listener.afterUpgrade(this, this.parameterService.getTablePrefix(), modelFromXml);
                        script = new SqlScript(sql, this.getPlatform().getSqlTemplate(), true, false, false, delimiter, null);
                        script.setListener((ISqlResultsListener)resultsListener);
                        script.execute(this.platform.getDatabaseInfo().isRequiresAutoCommitForDdl());
                    }
                    this.log.info("Done with auto update of SymmetricDS tables");
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Database readSymmetricSchemaFromXml() {
        try {
            Database database = this.merge(this.readDatabaseFromXml("/symmetric-schema.xml"), this.readDatabaseFromXml("/console-schema.xml"));
            this.prefixConfigDatabase(database);
            String extraTablesXml = this.parameterService.getString("auto.config.extra.tables.ddlutil.xml");
            if (StringUtils.isNotBlank((CharSequence)extraTablesXml)) {
                try {
                    database = this.merge(database, this.readDatabaseFromXml(extraTablesXml));
                }
                catch (Exception ex) {
                    this.log.error("", (Throwable)ex);
                }
            }
            return database;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Database readSymmetricSchemaFromDatabase() {
        return this.platform.readFromDatabase(this.readSymmetricSchemaFromXml().getTables());
    }

    protected Database readDatabaseFromXml(String resourceName) throws IOException {
        try {
            return this.platform.readDatabaseFromXml(resourceName, true);
        }
        catch (IoException ex) {
            return new Database();
        }
    }

    protected Database merge(Database ... databases) {
        Database database = new Database();
        if (databases != null) {
            for (Database db : databases) {
                Table[] tables;
                for (Table table : tables = db.getTables()) {
                    database.addTable(table);
                }
            }
        }
        return database;
    }

    @Override
    public IDatabasePlatform getPlatform() {
        return this.platform;
    }

    @Override
    public IDatabasePlatform getTargetPlatform() {
        return this.targetDialect.getPlatform();
    }

    @Override
    public IDatabasePlatform getTargetPlatform(String tableName) {
        if (tableName.toLowerCase().startsWith(this.tablePrefixLowerCase)) {
            return this.platform;
        }
        return this.targetDialect.getPlatform();
    }

    @Override
    public String getName() {
        if (!this.equals(this.targetDialect)) {
            return this.targetDialect.getName();
        }
        return this.databaseName;
    }

    @Override
    public String getVersion() {
        if (!this.equals(this.targetDialect)) {
            return this.targetDialect.getVersion();
        }
        return this.databaseMajorVersion + "." + this.databaseMinorVersion;
    }

    @Override
    public int getMajorVersion() {
        if (!this.equals(this.targetDialect)) {
            return this.targetDialect.getMajorVersion();
        }
        return this.databaseMajorVersion;
    }

    @Override
    public int getMinorVersion() {
        if (!this.equals(this.targetDialect)) {
            return this.targetDialect.getMinorVersion();
        }
        return this.databaseMinorVersion;
    }

    @Override
    public String getProductVersion() {
        if (!this.equals(this.targetDialect)) {
            return this.targetDialect.getProductVersion();
        }
        return this.databaseProductVersion;
    }

    @Override
    public boolean supportsTransactionViews() {
        return this.supportsTransactionViews;
    }

    @Override
    public boolean supportsSubselectsInDelete() {
        return this.supportsSubselectsInDelete;
    }

    @Override
    public boolean supportsSubselectsInUpdate() {
        return this.supportsSubselectsInUpdate;
    }

    @Override
    public boolean supportsDdlTriggers() {
        return this.supportsDdlTriggers;
    }

    @Override
    public long insertWithGeneratedKey(String sql, SequenceIdentifier sequenceId) {
        return this.insertWithGeneratedKey(sql, sequenceId, null, null);
    }

    @Override
    public long insertWithGeneratedKey(String sql, SequenceIdentifier identifier, Object ... args) {
        return this.platform.getSqlTemplate().insertWithGeneratedKey(sql, this.getSequenceKeyName(identifier), this.getSequenceKeyName(identifier), args, null);
    }

    @Override
    public String getSequenceName(SequenceIdentifier identifier) {
        switch (identifier) {
            case REQUEST: {
                return this.parameterService.getTablePrefix() + "_extract_r_st_request_id";
            }
            case DATA: {
                return this.parameterService.getTablePrefix() + "_data_data_id";
            }
            case TRIGGER_HIST: {
                return this.parameterService.getTablePrefix() + "_trigger_his_ger_hist_id";
            }
        }
        return null;
    }

    @Override
    public String getSequenceKeyName(SequenceIdentifier identifier) {
        switch (identifier) {
            case REQUEST: {
                return "request_id";
            }
            case DATA: {
                return "data_id";
            }
            case TRIGGER_HIST: {
                return "trigger_hist_id";
            }
        }
        return null;
    }

    @Override
    public long getCurrentSequenceValue(SequenceIdentifier identifier) {
        return -1L;
    }

    @Override
    @Deprecated
    public Column[] orderColumns(String[] columnNames, Table table) {
        Column[] unorderedColumns = table.getColumns();
        Column[] orderedColumns = new Column[columnNames.length];
        block0: for (int i = 0; i < columnNames.length; ++i) {
            String name = columnNames[i];
            for (Column column : unorderedColumns) {
                if (!column.getName().equalsIgnoreCase(name)) continue;
                orderedColumns[i] = column;
                continue block0;
            }
        }
        return orderedColumns;
    }

    @Override
    @Deprecated
    public void disableSyncTriggers(ISqlTransaction transaction) {
        this.disableSyncTriggers(transaction, null);
    }

    @Override
    public boolean supportsTransactionId() {
        return false;
    }

    @Override
    public boolean isBlobSyncSupported() {
        return true;
    }

    @Override
    public boolean isClobSyncSupported() {
        return true;
    }

    @Override
    public boolean isTransactionIdOverrideSupported() {
        return true;
    }

    @Override
    public String getEngineName() {
        return this.parameterService.getEngineName();
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return true;
    }

    @Override
    public String getInitialLoadTableAlias() {
        return "t";
    }

    @Override
    public String preProcessTriggerSqlClause(String sqlClause) {
        return sqlClause;
    }

    @Override
    public void truncateTable(String tableName) {
        String quote = this.platform.getDdlBuilder().isDelimitedIdentifierModeOn() ? this.platform.getDatabaseInfo().getDelimiterToken() : "";
        boolean success = false;
        int tryCount = 5;
        while (!success && tryCount > 0) {
            try {
                Table table = this.platform.getTableFromCache(tableName, false);
                if (table != null) {
                    this.platform.getSqlTemplate().update(String.format("truncate table %s%s%s", quote, table.getName(), quote), new Object[0]);
                    success = true;
                    continue;
                }
                throw new RuntimeException(String.format("Could not find %s to trunate", tableName));
            }
            catch (SqlException ex) {
                this.log.warn("", (Throwable)ex);
                AppUtils.sleep((long)5000L);
                --tryCount;
            }
        }
    }

    @Override
    public boolean areDatabaseTransactionsPendingSince(long time) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getEarliestTransactionStartTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDatabaseTimeSQL() {
        return this.platform.scrubSql("select current_timestamp");
    }

    @Override
    public long getDatabaseTime() {
        try {
            Date dateTime = (Date)this.platform.getSqlTemplate().queryForObject(this.getDatabaseTimeSQL(), Date.class, new Object[0]);
            if (dateTime != null) {
                return dateTime.getTime();
            }
            return System.currentTimeMillis();
        }
        catch (Exception ex) {
            this.log.error("", (Throwable)ex);
            return System.currentTimeMillis();
        }
    }

    @Override
    public String getSourceNodeExpression() {
        return null;
    }

    @Override
    public final String getDataHasChangedCondition(Trigger trigger) {
        if (this.parameterService.is("trigger.update.capture.changed.data.only.enabled")) {
            return this.getDbSpecificDataHasChangedCondition(trigger);
        }
        return "1=1";
    }

    protected String getDbSpecificDataHasChangedCondition(Trigger trigger) {
        return "1=1";
    }

    @Override
    public boolean needsToSelectLobData() {
        return false;
    }

    @Override
    public boolean canGapsOccurInCapturedDataIds() {
        return true;
    }

    @Override
    public String massageDataExtractionSql(String sql, boolean isContainsBigLob) {
        String textColumnExpression = this.parameterService.getString("dataextractor.text.column.expression");
        if (StringUtils.isNotBlank((CharSequence)textColumnExpression)) {
            sql = sql.replace("d.old_data", textColumnExpression.replace("$(columnName)", "d.old_data"));
            sql = sql.replace("d.row_data", textColumnExpression.replace("$(columnName)", "d.row_data"));
            sql = sql.replace("d.pk_data", textColumnExpression.replace("$(columnName)", "d.pk_data"));
        }
        return sql;
    }

    @Override
    public String getDriverName() {
        if (this.targetDialect != this) {
            return this.targetDialect.getDriverName();
        }
        return this.driverName;
    }

    @Override
    public String getDriverVersion() {
        if (this.targetDialect != this) {
            return this.targetDialect.getDriverVersion();
        }
        return this.driverVersion;
    }

    @Override
    public String massageForLob(String sql, boolean isContainsBigLob) {
        return sql;
    }

    @Override
    public boolean isInitialLoadTwoPassLob(Table table) {
        return false;
    }

    @Override
    public String getInitialLoadTwoPassLobSql(String sql, Table table, boolean isFirstPass) {
        List columns = table.getLobColumns(this.platform);
        boolean isFirstColumn = true;
        sql = sql == null ? "" : sql;
        Object orderBySql = "";
        int index = ((String)sql).toUpperCase().indexOf("ORDER BY");
        if (index != -1) {
            orderBySql = " " + ((String)sql).substring(index);
            sql = ((String)sql).substring(0, index);
        }
        if (columns.size() > 0) {
            if (!((String)sql).equals("")) {
                sql = (String)sql + " and ";
            }
            sql = (String)sql + "(";
        }
        for (Column column : table.getLobColumns(this.platform)) {
            String columnSql = this.getInitialLoadTwoPassLobLengthSql(column, isFirstPass);
            if (columnSql == null || columnSql.trim().equals("")) continue;
            if (isFirstColumn) {
                isFirstColumn = false;
            } else {
                sql = isFirstPass ? (String)sql + " and " : (String)sql + " or ";
            }
            sql = (String)sql + columnSql;
        }
        if (columns.size() > 0) {
            sql = (String)sql + ")";
        }
        sql = (String)sql + (String)orderBySql;
        return sql;
    }

    public String getInitialLoadTwoPassLobLengthSql(Column column, boolean isFirstPass) {
        return null;
    }

    @Override
    public boolean escapesTemplatesForDatabaseInserts() {
        return false;
    }

    @Override
    public String getMasterCollation() {
        return this.parameterService.getString("db.master.collation", "");
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public void cleanupTriggers() {
    }

    @Override
    public AbstractTriggerTemplate getTriggerTemplate() {
        return this.triggerTemplate;
    }

    protected void close(ISqlTransaction transaction) {
        if (transaction != null) {
            transaction.close();
        }
    }

    @Override
    public String getTablePrefix() {
        return this.parameterService.getTablePrefix();
    }

    @Override
    public String getTemplateNumberPrecisionSpec() {
        return null;
    }

    @Override
    public int getSqlTypeForIds() {
        return 2;
    }

    @Override
    public IParameterService getParameterService() {
        return this.parameterService;
    }

    @Override
    public void setExtensionService(IExtensionService extensionService) {
        this.extensionService = extensionService;
    }

    @Override
    public PermissionType[] getSymTablePermissions() {
        PermissionType[] permissions = new PermissionType[]{PermissionType.CREATE_TABLE, PermissionType.DROP_TABLE, PermissionType.CREATE_TRIGGER, PermissionType.DROP_TRIGGER};
        return permissions;
    }

    @Override
    public ISymmetricDialect getTargetDialect() {
        return this.targetDialect;
    }

    @Override
    public ISymmetricDialect getTargetDialect(String tableName) {
        if (tableName.toLowerCase().startsWith(this.tablePrefixLowerCase)) {
            return this;
        }
        return this.targetDialect;
    }

    @Override
    public void setTargetDialect(ISymmetricDialect targetDialect) {
        this.targetDialect = targetDialect;
    }

    @Override
    public String getSyncTriggersOnIncomingExpression() {
        return "1=1";
    }
}

