/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.common;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.SqlScriptReader;
import org.jumpmind.properties.DefaultParameterParser;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.common.ConfigurationVersionHelper;
import org.jumpmind.symmetric.common.ParameterConstants;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.ext.IConfigurationChangedListener;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.job.IJobManager;
import org.jumpmind.symmetric.model.JobDefinition;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.util.AppUtils;
import org.jumpmind.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationChangedHelper {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationChangedHelper.class);
    private static final String SUFFIX = ConfigurationChangedHelper.class.getSimpleName();
    private static final String CTX_KEY_FLUSH_CHANNELS_NEEDED = "FlushChannels." + SUFFIX;
    private static final String CTX_KEY_FLUSH_CONFLICTS_NEEDED = "FlushConflicts." + SUFFIX;
    private static final String CTX_KEY_FLUSH_EXTENSIONS_NEEDED = "FlushExtensions." + SUFFIX;
    private static final String CTX_KEY_FLUSH_GROUPLETS_NEEDED = "FlushGrouplets." + SUFFIX;
    private static final String CTX_KEY_FLUSH_LOADFILTERS_NEEDED = "FlushLoadFilters." + SUFFIX;
    private static final String CTX_KEY_FLUSH_NODES_NEEDED = "FlushNodes." + SUFFIX;
    private static final String CTX_KEY_FLUSH_NODE_GROUP_LINKS_NEEDED = "FlushNodeGroups." + SUFFIX;
    private static final String CTX_KEY_FLUSH_NODE_SECURITY_NEEDED = "FlushNodeSecurity." + SUFFIX;
    private static final String CTX_KEY_FLUSH_ROUTERS_NEEDED = "FlushRouters." + SUFFIX;
    private static final String CTX_KEY_FLUSH_PARAMETERS_NEEDED = "FlushParameters." + SUFFIX;
    private static final String CTX_KEY_FLUSH_TRANSFORMS_NEEDED = "FlushTransforms." + SUFFIX;
    private static final String CTX_KEY_RESYNC_NEEDED = "Resync." + SUFFIX;
    private static final String CTX_KEY_RESYNC_ALLOWED = "ResyncAllowed." + SUFFIX;
    private static final String CTX_KEY_CHANGED_TRIGGER_IDS = "ChangedTriggerIds." + SUFFIX;
    private static final String CTX_KEY_CHANGED_JOB_IDS = "ChangedJobIds." + SUFFIX;
    private static final String CTX_KEY_RESTART_JOB_MANAGER_NEEDED = "RestartJobManager." + SUFFIX;
    private static final String CTX_KEY_FILE_SYNC_NEEDED = "FileSyncEnable." + SUFFIX;
    private static final String CTX_KEY_CLUSTER_NEEDED = "ClusterEnable." + SUFFIX;
    private ISymmetricEngine engine;
    private String tablePrefix;
    private ConfigurationVersionHelper versionHelper;
    private IConfigurationChangedListener listener;

    public ConfigurationChangedHelper(ISymmetricEngine engine) {
        this.engine = engine;
        this.tablePrefix = engine.getTablePrefix();
        this.versionHelper = new ConfigurationVersionHelper(this.tablePrefix);
        this.listener = (IConfigurationChangedListener)AppUtils.newInstance(IConfigurationChangedListener.class, null, (Object[])new Object[]{engine}, (Class[])new Class[]{ISymmetricEngine.class});
    }

    public void handleChange(Context context, Table table, CsvData data) {
        this.updateContext("node", table, context, CTX_KEY_FLUSH_NODES_NEEDED);
        this.updateContext("node_security", table, context, CTX_KEY_FLUSH_NODE_SECURITY_NEEDED);
        if (context.get("targetNode") == null && StringUtils.isNotBlank((CharSequence)((CharSequence)data.getAttribute("sourceNodeId")))) {
            return;
        }
        this.updateContext("channel", table, context, CTX_KEY_FLUSH_CHANNELS_NEEDED);
        this.updateContext("conflict", table, context, CTX_KEY_FLUSH_CONFLICTS_NEEDED);
        this.updateContext("extension", table, context, CTX_KEY_FLUSH_EXTENSIONS_NEEDED);
        this.updateContext("grouplet", table, context, CTX_KEY_FLUSH_GROUPLETS_NEEDED, CTX_KEY_RESYNC_NEEDED);
        this.updateContext("grouplet_link", table, context, CTX_KEY_FLUSH_GROUPLETS_NEEDED, CTX_KEY_RESYNC_NEEDED);
        this.updateContext("job", table, context, CTX_KEY_RESTART_JOB_MANAGER_NEEDED);
        this.updateContext("load_filter", table, context, CTX_KEY_FLUSH_LOADFILTERS_NEEDED);
        this.updateContext("node_group_link", table, context, CTX_KEY_FLUSH_NODE_GROUP_LINKS_NEEDED, CTX_KEY_FLUSH_TRANSFORMS_NEEDED, CTX_KEY_RESYNC_NEEDED);
        this.updateContext("parameter", table, context, CTX_KEY_FLUSH_PARAMETERS_NEEDED);
        this.updateContext("router", table, context, CTX_KEY_RESYNC_NEEDED, CTX_KEY_FLUSH_ROUTERS_NEEDED);
        this.updateContext("transform_table", table, context, CTX_KEY_FLUSH_TRANSFORMS_NEEDED);
        this.updateContext("transform_column", table, context, CTX_KEY_FLUSH_TRANSFORMS_NEEDED);
        this.updateContext("trigger_router_grouplet", table, context, CTX_KEY_FLUSH_GROUPLETS_NEEDED, CTX_KEY_RESYNC_NEEDED);
        if (this.matchesTable(table, "parameter") && this.matchesDmlEventType(data) && this.matchesExternalId(table, data, "external_id") && this.matchesNodeGroupId(table, data, "node_group_id")) {
            String paramKey;
            String jobName = JobDefinition.getJobNameFromData(data);
            if (jobName != null) {
                this.getHashSet(context, CTX_KEY_CHANGED_JOB_IDS).add(jobName);
            }
            if ("file.sync.enable".equals(paramKey = ConfigurationChangedHelper.getColumnValue(table, data, "param_key"))) {
                context.put(CTX_KEY_FILE_SYNC_NEEDED, (Object)true);
            } else if ("cluster.lock.enabled".equals(paramKey)) {
                context.put(CTX_KEY_CLUSTER_NEEDED, (Object)true);
            }
            Map<String, DefaultParameterParser.ParameterMetaData> parameters = ParameterConstants.getParameterMetaData();
            DefaultParameterParser.ParameterMetaData pmd = parameters.get(paramKey);
            if (pmd != null && pmd.getTags().contains("trigger")) {
                context.put(CTX_KEY_RESYNC_NEEDED, (Object)true);
            }
        }
        if ((this.matchesTable(table, "trigger") || this.matchesTable(table, "trigger_router")) && this.isSyncTriggersAllowed(context) && context.get(CTX_KEY_RESYNC_NEEDED) == null) {
            if (data.getDataEventType().equals((Object)DataEventType.DELETE)) {
                context.put(CTX_KEY_RESYNC_NEEDED, (Object)true);
            } else {
                Set<String> triggers = this.getHashSet(context, CTX_KEY_CHANGED_TRIGGER_IDS);
                String triggerId = ConfigurationChangedHelper.getColumnValue(table, data, "trigger_id");
                if (triggerId != null) {
                    triggers.add(triggerId);
                }
            }
        }
        if (this.listener != null) {
            this.listener.handleChange(context, table, data);
        }
    }

    private boolean matchesDmlEventType(CsvData data) {
        boolean ret = false;
        if (data.getDataEventType().equals((Object)DataEventType.INSERT) || data.getDataEventType().equals((Object)DataEventType.UPDATE) || data.getDataEventType().equals((Object)DataEventType.DELETE)) {
            ret = true;
        }
        return ret;
    }

    public void contextCommitted(Context context) {
        if (context.remove(CTX_KEY_FLUSH_CHANNELS_NEEDED) != null) {
            log.info("Clearing cache for channels");
            this.engine.getConfigurationService().clearCache();
        }
        if (context.remove(CTX_KEY_FLUSH_CONFLICTS_NEEDED) != null) {
            log.info("Clearing cache for conflicts");
            this.engine.getDataLoaderService().clearCache();
        }
        if (context.remove(CTX_KEY_FLUSH_EXTENSIONS_NEEDED) != null) {
            log.info("Clearing cache for extensions");
            this.engine.getExtensionService().refresh();
        }
        if (context.remove(CTX_KEY_FLUSH_GROUPLETS_NEEDED) != null) {
            log.info("Clearing cache for grouplets");
            this.engine.getGroupletService().clearCache();
        }
        if (context.remove(CTX_KEY_FLUSH_LOADFILTERS_NEEDED) != null) {
            log.info("Clearing cache for load filters");
            this.engine.getLoadFilterService().clearCache();
        }
        if (context.remove(CTX_KEY_FLUSH_NODES_NEEDED) != null) {
            log.info("Clearing cache for nodes");
            this.engine.getNodeService().flushNodeCache();
            this.engine.getNodeService().flushNodeGroupCache();
        }
        if (context.remove(CTX_KEY_FLUSH_NODE_GROUP_LINKS_NEEDED) != null) {
            log.info("Clearing cache for node groups");
            this.engine.getConfigurationService().clearCache();
            this.engine.getNodeService().flushNodeGroupCache();
        }
        if (context.remove(CTX_KEY_FLUSH_NODE_SECURITY_NEEDED) != null) {
            log.info("Clearing cache for node security");
            this.engine.getNodeService().flushNodeAuthorizedCache();
        }
        if (context.remove(CTX_KEY_FLUSH_PARAMETERS_NEEDED) != null) {
            log.info("Clearing cache for parameters");
            this.engine.getParameterService().rereadParameters();
        }
        if (context.remove(CTX_KEY_FLUSH_ROUTERS_NEEDED) != null) {
            log.info("Clearing cache for routers");
            this.engine.getCacheManager().flushAllWithRouters();
            this.engine.getRouterService().flushCache();
        }
        if (context.remove(CTX_KEY_CLUSTER_NEEDED) != null) {
            this.engine.getClusterService().refreshLockEntries();
        }
        if (this.listener != null) {
            this.listener.contextCommitted(context);
        }
    }

    public void contextComplete(Context context) {
        if (context.remove(CTX_KEY_FLUSH_TRANSFORMS_NEEDED) != null) {
            this.flushTransforms();
        }
        if (context.remove(CTX_KEY_RESTART_JOB_MANAGER_NEEDED) != null && this.engine.isStarted()) {
            log.info("Clearing cache for jobs and restarting jobs");
            this.engine.getJobManager().init();
            this.engine.getJobManager().startJobs();
            context.remove(CTX_KEY_CHANGED_JOB_IDS);
        }
        if (context.get(CTX_KEY_CHANGED_JOB_IDS) != null && this.engine.isStarted()) {
            this.restartJobs(context);
        }
        if (context.remove(CTX_KEY_RESYNC_NEEDED) != null && this.isSyncTriggersAllowed(context)) {
            log.info("Syncing all triggers because of configuration change");
            this.engine.getTriggerRouterService().syncTriggers();
            this.engine.getRegistrationService().setAllowClientRegistration(true);
            context.remove(CTX_KEY_CHANGED_TRIGGER_IDS);
        }
        if (context.get(CTX_KEY_CHANGED_TRIGGER_IDS) != null && this.isSyncTriggersAllowed(context)) {
            this.syncTriggers(context);
        }
        if (context.remove(CTX_KEY_FILE_SYNC_NEEDED) != null) {
            this.enableDisableFileSync(context);
        }
        if (this.listener != null) {
            this.listener.contextComplete(context);
        }
    }

    public void contextCommittedAndComplete(Context context) {
        this.contextCommitted(context);
        this.contextComplete(context);
    }

    private void syncTriggers(Context context) {
        Set triggerIds = (Set)context.remove(CTX_KEY_CHANGED_TRIGGER_IDS);
        log.info("Syncing {} triggers because of configuration change", (Object)triggerIds.size());
        HashSet<Trigger> triggers = new HashSet<Trigger>();
        ITriggerRouterService triggerRouterService = this.engine.getTriggerRouterService();
        triggerRouterService.clearCache();
        for (String triggerId : triggerIds) {
            Trigger trigger = triggerRouterService.getTriggerById(triggerId, false);
            if (trigger == null) continue;
            triggers.add(trigger);
        }
        this.engine.getTriggerRouterService().syncTriggers(new ArrayList<Trigger>(triggers), null, false, true);
    }

    private void flushTransforms() {
        log.info("Clearing cache for transforms");
        this.engine.getTransformService().clearCache();
        List<OutgoingBatch> batches = this.engine.getOutgoingBatchService().getBatchesInProgress();
        if (batches.size() > 0) {
            log.info("Clearing staging for {} batches", (Object)batches.size());
            for (OutgoingBatch batch : batches) {
                IStagedResource resource = this.engine.getStagingManager().find(new Object[]{"outgoing", batch.getStagedLocation(), batch.getBatchId()});
                if (resource == null) continue;
                log.debug("Deleting {}", (Object)resource.getPath());
                boolean success = resource.delete();
                if (success) continue;
                log.warn("Failed to delete the '{}' staging resource", (Object)resource.getPath());
            }
        }
    }

    private void restartJobs(Context context) {
        Set jobNames = (Set)context.remove(CTX_KEY_CHANGED_JOB_IDS);
        IJobManager jobManager = this.engine.getJobManager();
        if (jobManager != null) {
            log.info("Restarting jobs to match schedule change");
            for (String jobName : jobNames) {
                jobManager.restartJob(jobName);
            }
        }
    }

    private void enableDisableFileSync(Context context) {
        log.info("Changing file sync to match parameter change");
        this.engine.getParameterService().rereadParameters();
        this.engine.getConfigurationService().initDefaultChannels();
        this.engine.getFileSyncService().clearCache();
        IJobManager jobManager = this.engine.getJobManager();
        if (jobManager != null && this.engine.isStarted()) {
            jobManager.restartJob("File Sync Tracker");
            jobManager.restartJob("File Sync Pull");
            jobManager.restartJob("File Sync Push");
        }
        if (this.engine.getParameterService().is("auto.sync.triggers")) {
            log.info("Syncing triggers for file snapshot");
            this.engine.getTriggerRouterService().clearCache();
            Table fileSnapshotTable = this.engine.getDatabasePlatform().getTableFromCache(TableConstants.getTableName(this.engine.getTablePrefix(), "file_snapshot"), false);
            this.engine.getTriggerRouterService().syncTriggers(fileSnapshotTable, false);
        }
    }

    private boolean matchesTable(Table table, String tableSuffix) {
        if (table != null && table.getName() != null) {
            return table.getName().equalsIgnoreCase(TableConstants.getTableName(this.tablePrefix, tableSuffix));
        }
        return false;
    }

    private boolean matchesExternalId(Table table, CsvData data, String columnName) {
        String externalId = this.engine.getParameterService().getExternalId();
        String columnValue = ConfigurationChangedHelper.getColumnValue(table, data, columnName);
        return columnValue == null || externalId.equals(columnValue) || columnValue.equals("ALL");
    }

    private boolean matchesNodeGroupId(Table table, CsvData data, String columnName) {
        String nodeGroupId = this.engine.getParameterService().getNodeGroupId();
        String columnValue = ConfigurationChangedHelper.getColumnValue(table, data, columnName);
        return columnValue == null || nodeGroupId.equals(columnValue) || columnValue.equals("ALL");
    }

    private void updateContext(String tableSuffix, Table table, Context context, String ... constants) {
        if (this.matchesTable(table, tableSuffix)) {
            for (String constant : constants) {
                context.put(constant, (Object)true);
            }
        }
    }

    private Set<String> getHashSet(Context context, String name) {
        HashSet set = (HashSet)context.get(name);
        if (set == null) {
            set = new HashSet();
            context.put(name, set);
        }
        return set;
    }

    public static String getColumnValue(Table table, CsvData data, String name) {
        int index;
        String[] values = data.getParsedData("rowData");
        if (values == null) {
            values = data.getParsedData("pkData");
        }
        if ((index = table.getColumnIndex(name)) >= 0 && values != null && index < values.length) {
            return values[index];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSqlStatements(String script) {
        ArrayList<String> sqlStatements = new ArrayList<String>();
        SqlScriptReader scriptReader = new SqlScriptReader((Reader)new StringReader(script));
        scriptReader.setStripOutComments(true);
        try {
            String sql = scriptReader.readSqlStatement();
            while (sql != null) {
                if (Strings.CI.startsWith((CharSequence)sql, (CharSequence)"delimiter")) {
                    String delimiter = StringUtils.trimToNull((String)sql.substring("delimiter".length()));
                    if (delimiter != null) {
                        scriptReader.setDelimiter(delimiter);
                    }
                } else {
                    sqlStatements.add(sql);
                }
                sql = scriptReader.readSqlStatement();
            }
            ArrayList<String> arrayList = sqlStatements;
            return arrayList;
        }
        finally {
            try {
                if (scriptReader != null) {
                    scriptReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isNewContext(Context context) {
        return context.get(CTX_KEY_RESYNC_ALLOWED) == null;
    }

    public void setSyncTriggersAllowed(Context context, boolean syncTriggersAllowed) {
        context.put(CTX_KEY_RESYNC_ALLOWED, (Object)syncTriggersAllowed);
    }

    public boolean isSyncTriggersAllowed(Context context) {
        return context.get(CTX_KEY_RESYNC_ALLOWED) == Boolean.TRUE;
    }

    public void setSyncTriggersNeeded(Context context) {
        context.put(CTX_KEY_RESYNC_NEEDED, (Object)true);
    }

    public Set<Node> filterNodes(Set<Node> nodes, String tableName, Map<String, String> columnValues) {
        return this.versionHelper.filterNodes(nodes, tableName, columnValues);
    }
}

