/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;

public class NodeCache {
    private IParameterService parameterService;
    private INodeService nodeService;
    private Object nodeCacheLock = new Object();
    private volatile Map<String, List<Node>> sourceNodesCache = new HashMap<String, List<Node>>();
    private volatile Map<String, List<Node>> targetNodesCache = new HashMap<String, List<Node>>();
    private volatile Map<String, Long> sourceNodeLinkCacheTime = new HashMap<String, Long>();
    private volatile Map<String, Long> targetNodeLinkCacheTime = new HashMap<String, Long>();
    private volatile Map<String, List<Node>> nodesByGroupCache;
    private long nodesByGroupCacheTime;

    public NodeCache(ISymmetricEngine engine) {
        this.parameterService = engine.getParameterService();
        this.nodeService = engine.getNodeService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> getNodesByGroup(String nodeGroupId) {
        long cacheTimeoutInMs = this.parameterService.getLong("cache.node.group.link.time.ms");
        Object object = this.nodeCacheLock;
        synchronized (object) {
            Collection<Node> nodes;
            if (this.nodesByGroupCache == null || System.currentTimeMillis() - this.nodesByGroupCacheTime >= cacheTimeoutInMs) {
                this.nodesByGroupCache = new HashMap<String, List<Node>>();
                nodes = this.nodeService.getEnabledNodesFromDatabase();
                for (Node node : nodes) {
                    List<Node> list = this.nodesByGroupCache.get(node.getNodeGroupId());
                    if (list == null) {
                        list = new ArrayList<Node>();
                        this.nodesByGroupCache.put(node.getNodeGroupId(), list);
                    }
                    list.add(node);
                }
                this.nodesByGroupCacheTime = System.currentTimeMillis();
            }
            if ((nodes = this.nodesByGroupCache.get(nodeGroupId)) == null) {
                nodes = new ArrayList<Node>();
                this.nodesByGroupCache.put(nodeGroupId, (List<Node>)nodes);
            }
            return nodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> getSourceNodesCache(NodeGroupLinkAction eventAction, Node node) {
        long cacheTimeoutInMs = this.parameterService.getLong("cache.node.group.link.time.ms");
        if (node != null) {
            List<Node> list;
            Object object = this.nodeCacheLock;
            synchronized (object) {
                list = this.sourceNodesCache.get(eventAction.name());
                if (list == null || System.currentTimeMillis() - this.sourceNodeLinkCacheTime.get(eventAction.toString()) >= cacheTimeoutInMs) {
                    list = this.nodeService.getSourceNodesFromDatabase(eventAction, node);
                    this.sourceNodesCache.put(eventAction.name(), list);
                    this.sourceNodeLinkCacheTime.put(eventAction.toString(), System.currentTimeMillis());
                }
            }
            return list;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushSourceNodesCache() {
        Object object = this.nodeCacheLock;
        synchronized (object) {
            this.sourceNodeLinkCacheTime.entrySet().stream().forEach(e -> e.setValue(0L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushTargetNodesCache() {
        Object object = this.nodeCacheLock;
        synchronized (object) {
            this.targetNodeLinkCacheTime.entrySet().stream().forEach(e -> e.setValue(0L));
            this.nodesByGroupCacheTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> getTargetNodesCache(NodeGroupLinkAction eventAction, Node node) {
        long cacheTimeoutInMs = this.parameterService.getLong("cache.node.group.link.time.ms");
        if (node != null) {
            List<Node> list;
            Object object = this.nodeCacheLock;
            synchronized (object) {
                list = this.targetNodesCache.get(eventAction.name());
                if (list == null || System.currentTimeMillis() - this.targetNodeLinkCacheTime.get(eventAction.toString()) >= cacheTimeoutInMs) {
                    list = this.nodeService.getTargetNodesFromDatabase(eventAction, node);
                    this.targetNodesCache.put(eventAction.name(), list);
                    this.targetNodeLinkCacheTime.put(eventAction.toString(), System.currentTimeMillis());
                }
            }
            return list;
        }
        return Collections.emptyList();
    }
}

